/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.servicehelper.ErPermissionServiceHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class DetailReportQueryUtil {
    @Deprecated
    public static String getAppId() {
        return "em";
    }

    @Deprecated
    public static void setAppId(String appId) {
    }

    @Deprecated
    public static void removeAppId() {
    }

    private static Map<String, String> getFilterMap() {
        HashMap<String, String> filterToFieldMap = new HashMap<String, String>(16);
        filterToFieldMap.put("pbizdate", "bizdate");
        filterToFieldMap.put("phappendate", "happendate");
        filterToFieldMap.put("pcompany", "company");
        filterToFieldMap.put("pcurrency", "currency");
        filterToFieldMap.put("pcostcompany", "costcompany");
        filterToFieldMap.put("pcostdept", "costdept");
        filterToFieldMap.put("pexpenseitem", "expenseitem");
        filterToFieldMap.put("pbilltype", "billtype");
        filterToFieldMap.put("ptravelitem", "travelitem");
        filterToFieldMap.put("pstdproject", "stdproject");
        filterToFieldMap.put("papplier", "applier");
        return filterToFieldMap;
    }

    private static List<FilterItemInfo> getFilterItemInfos(FilterInfo filterInfo, String key) {
        List ids;
        List filterItemInfos = filterInfo.getFilterItems(key);
        List names = filterInfo.getFilterItems(key + ".name");
        if (names != null) {
            filterItemInfos = names;
        }
        if ((ids = filterInfo.getFilterItems(key + ".id")) != null) {
            filterItemInfos = ids;
        }
        return filterItemInfos;
    }

    public static List<QFilter> getQfilter(FilterInfo filterInfo) {
        Map<String, String> filterMap = DetailReportQueryUtil.getFilterMap();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)10);
        for (Map.Entry<String, String> entry : filterMap.entrySet()) {
            List<FilterItemInfo> filterItemInfos = DetailReportQueryUtil.getFilterItemInfos(filterInfo, entry.getKey());
            if (filterItemInfos == null || filterItemInfos.size() <= 0) continue;
            Iterator<FilterItemInfo> iterator = filterItemInfos.iterator();
            List qFilters = filterInfo.getQFilters();
            Boolean isOr = false;
            for (QFilter qFilter : qFilters) {
                if (qFilter.getProperty() == null || !qFilter.getProperty().equals(entry.getKey()) || (qFilter.getNests(false) == null || qFilter.getNests(false).size() <= 0 || !"OR".equals(((QFilter.QFilterNest)qFilter.getNests(false).get(0)).getOp())) && !"OR".equals(qFilter.getCP())) continue;
                isOr = true;
            }
            QFilter qFilter = null;
            while (iterator.hasNext()) {
                FilterItemInfo filterItemInfo = iterator.next();
                if (isOr.booleanValue() && qFilter != null) {
                    qFilter.or(new QFilter(filterItemInfo.getPropName().replace(entry.getKey(), entry.getValue()), filterItemInfo.getCompareType(), filterItemInfo.getValue()));
                } else {
                    qFilter = new QFilter(filterItemInfo.getPropName().replace(entry.getKey(), entry.getValue()), filterItemInfo.getCompareType(), filterItemInfo.getValue());
                }
                if (isOr.booleanValue()) continue;
                list.add(qFilter);
            }
            if (!isOr.booleanValue() || qFilter == null) continue;
            list.add(qFilter);
        }
        return list;
    }

    public static Map<String, List> getQfilterMap(FilterInfo filterInfo) {
        List<QFilter> list = DetailReportQueryUtil.getQfilter(filterInfo);
        HashMap<String, List> map = new HashMap<String, List>(4);
        ArrayList<String> happendateList = new ArrayList<String>(2);
        for (QFilter q : list) {
            if ("happendate".equals(q.getProperty())) {
                happendateList.add(DateFormatUtils.format((Date)((Date)q.getValue()), (String)"yyyy-MM-dd"));
                continue;
            }
            if ("bizdate".equals(q.getProperty())) continue;
            List<String> l = new ArrayList<String>(1);
            if (q.getValue() instanceof List) {
                l = ((List)q.getValue()).stream().map(e -> e.toString()).collect(Collectors.toList());
            } else {
                l.add(q.getValue().toString());
            }
            map.put(q.getProperty(), l);
        }
        if (happendateList.size() > 0) {
            Collections.sort(happendateList);
            map.put("happendate", happendateList);
        }
        if (((FilterItemInfo)filterInfo.getFilterItems("pstatisticaldimension").get(0)).getValue() instanceof List) {
            map.put("statisticaldimension", (List)((FilterItemInfo)filterInfo.getFilterItems("pstatisticaldimension").get(0)).getValue());
        } else if (((FilterItemInfo)filterInfo.getFilterItems("pstatisticaldimension").get(0)).getValue() instanceof String) {
            map.put("statisticaldimension", Collections.singletonList(((FilterItemInfo)filterInfo.getFilterItems("pstatisticaldimension").get(0)).getValue()));
        }
        return map;
    }

    public static QFilter getFinishedStatus() {
        QFilter qFilter = new QFilter("billstatus", "in", Arrays.asList("G", "I")).and("encashamount", ">", (Object)BigDecimal.ZERO);
        QFilter q = new QFilter("billstatus", "in", Arrays.asList("E", "I")).and("encashamount", "=", (Object)BigDecimal.ZERO);
        return qFilter.or(q);
    }

    public static QFilter getCurrApproveStatus() {
        QFilter qFilter = new QFilter("curprice", ">", (Object)BigDecimal.ZERO).and("billstatus", "in", Arrays.asList("B", "C", "E", "F", "G"));
        return qFilter;
    }

    public static QFilter getTaxStatus() {
        QFilter qFilter = new QFilter("deductibletax", ">", (Object)BigDecimal.ZERO).and("billstatus", "in", Arrays.asList("B", "C", "E", "F", "G"));
        return qFilter;
    }

    public static QFilter getInOrderStatus() {
        QFilter qFilter = new QFilter("billstatus", "in", Arrays.asList("E", "F")).and("encashamount", ">", (Object)BigDecimal.ZERO);
        QFilter q = new QFilter("billstatus", "in", Arrays.asList("B", "C")).and("encashamount", ">=", (Object)BigDecimal.ZERO);
        qFilter.or(q);
        return qFilter;
    }

    @Deprecated
    public static List<Long> getCompanysWithQueryPerm() {
        return ErPermissionServiceHelper.getCompanyListByPerm((String)"em", (String)"er_expense_detail_query", (String)"47150e89000000ac");
    }

    public static List<String> printDataSet(DataSet dataSet) {
        return DetailReportQueryUtil.printDataSet(dataSet, null);
    }

    public static List<String> printDataSet(DataSet dataSet, List<String> printCols) {
        return DetailReportQueryUtil.printDataSet(dataSet, null, printCols);
    }

    public static List<String> printDataSet(DataSet dataSet, Integer maxRows, List<String> oriPrintCols) {
        Iterator iter;
        int rowIndex;
        Field[] printFieldArr;
        List<String> printCols;
        if (Objects.isNull(dataSet)) {
            return Collections.singletonList("null");
        }
        if (Objects.isNull(maxRows)) {
            maxRows = 100;
        }
        int[] colWidths = null;
        int[] charMaxSizes = null;
        int colCount = 0;
        try (DataSet dataSetCopy = dataSet.copy();){
            int i;
            RowMeta rowType = dataSetCopy.getRowMeta();
            printCols = Objects.isNull(oriPrintCols) ? Arrays.asList(rowType.getFieldNames()) : new ArrayList<String>(oriPrintCols);
            Iterator<String> it = printCols.iterator();
            while (it.hasNext()) {
                if (Arrays.asList(rowType.getFieldNames()).contains(it.next())) continue;
                it.remove();
            }
            colCount = printCols.size();
            printFieldArr = new Field[colCount];
            for (i = 0; i < printFieldArr.length; ++i) {
                printFieldArr[i] = rowType.getField(printCols.get(i));
            }
            colWidths = new int[colCount];
            charMaxSizes = new int[colCount];
            for (i = 0; i < colCount; ++i) {
                String colAlias = printFieldArr[i].getAlias();
                int colWidth = colAlias.length() > 4 ? colAlias.length() : 4;
                colWidths[i] = StringUtils.isEmpty((String)colAlias) ? 10 : colWidth;
                charMaxSizes[i] = StringUtils.isEmpty((String)colAlias) ? 10 : colWidth;
            }
            rowIndex = 0;
            iter = dataSetCopy.iterator();
            while (iter.hasNext()) {
                if (++rowIndex > maxRows) {
                    break;
                }
                Row row = (Row)iter.next();
                for (int i2 = 0; i2 < colCount; ++i2) {
                    Object value = row.get(printFieldArr[i2].getAlias());
                    if (!Objects.nonNull(value)) continue;
                    String valueStr = String.valueOf(value);
                    int length = 0;
                    if (!StringUtils.isEmpty((String)valueStr)) {
                        for (char c : valueStr.toCharArray()) {
                            if (!DetailReportQueryUtil.isChinese(c)) {
                                ++length;
                                continue;
                            }
                            length += 2;
                        }
                    }
                    if (length > colWidths[i2]) {
                        colWidths[i2] = length;
                    }
                    if (valueStr.length() <= charMaxSizes[i2]) continue;
                    charMaxSizes[i2] = valueStr.length();
                }
            }
        }
        StringBuilder formatBuilder = new StringBuilder();
        for (int i = 0; i < colWidths.length; ++i) {
            formatBuilder.append('%').append(colWidths[i]).append("s|");
        }
        ArrayList<String> lines = new ArrayList<String>(maxRows);
        try (DataSet dataSetCopy = dataSet.copy();){
            lines.add(String.format(formatBuilder.toString(), printCols.toArray()));
            rowIndex = 0;
            iter = dataSetCopy.iterator();
            while (iter.hasNext()) {
                if (++rowIndex > maxRows) {
                    break;
                }
                Row row = (Row)iter.next();
                Object[] rowValues = new Object[colCount];
                int[] nonEngCharCnts = new int[colCount];
                for (int i = 0; i < colCount; ++i) {
                    Object value = row.get(printFieldArr[i].getAlias());
                    rowValues[i] = Objects.isNull(value) ? "null" : String.valueOf(value);
                    int nonEngCharCnt = 0;
                    for (char c : String.valueOf(rowValues[i]).toCharArray()) {
                        if (!DetailReportQueryUtil.isChinese(c)) continue;
                        ++nonEngCharCnt;
                    }
                    nonEngCharCnts[i] = nonEngCharCnt;
                }
                StringBuilder rowFormatBuilder = new StringBuilder();
                for (int i = 0; i < colWidths.length; ++i) {
                    rowFormatBuilder.append('%').append(colWidths[i] - nonEngCharCnts[i]).append("s|");
                }
                lines.add(String.format(rowFormatBuilder.toString(), rowValues));
            }
        }
        return lines;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }
}

