/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import org.apache.commons.lang.StringUtils;

public class ReportUtil {
    private static final Log logger = LogFactory.getLog(ReportUtil.class);
    public static final String classname = "ReportUtil";
    protected static String[] mainSelect = new String[]{"id", "bizdate", "billno", "currency", "detailcurrency", "loanamountori", "loanamountacc", "clearamountori", "clearamountacc", "repayamountori", "repayamountacc", "norepayamountori", "norepayamountacc", "repaydate", "repaystatus", "description", "billtype", "reportformid", "loanpayerdept", "loanpayercomp", "loanpayercostcompany", "loanpayercostdept", "loanpayerid", "0 as summarytype", "loanpayer", "head_paydate", "loandays", "bookeddate", "hasvoucher", "isadvance"};
    protected static StringBuilder tripReqSelect = new StringBuilder().append("id,bizdate as bizdate,").append("applier.id as loanpayerid,").append("billno as billno,currency as currency,").append("tripentry.tripcurrency as detailcurrency,").append("tripentry.triporiaccappamount as loanamountori,tripentry.tripaccappamount as loanamountacc,").append("tripentry.oriaccusedamount as clearamountori,").append("tripentry.accusedamount as clearamountacc,").append("tripentry.expeorirepayamount as repayamountori,tripentry.experepayamount  as repayamountacc,").append("tripentry.oriaccbalanceamount as norepayamountori,").append("tripentry.accbalanceamount as norepayamountacc,").append("repaymentdate as repaydate,").append("case when tripentry.oriaccbalanceamount >0 then 0 else 1 end as repaystatus,").append("description as description,'1' as billtype, formid as reportformid,").append("org.name as loanpayerdept,company.name as loanpayercomp,applier.name as loanpayer, 0 as summarytype,").append("tripentry.entrycostdept.name as loanpayercostdept,tripentry.entrycostcompany.name as loanpayercostcompany,").append("head_paydate,").append("0 as loandays,").append("bookeddate as bookeddate,").append("hasvoucher as hasvoucher");
    protected static StringBuilder dailyLoanSelect = new StringBuilder().append("id,bizdate as bizdate,").append("applier.id as loanpayerid,").append("billno as billno,currency as currency,").append("expenseentryentity.entrycurrency as detailcurrency,").append("expenseentryentity.expeapproveamount as loanamountori,expenseentryentity.expeapprovecurramount as loanamountacc,").append("expenseentryentity.exporiusedamount as clearamountori,").append("expenseentryentity.expusedamount as clearamountacc,").append("expenseentryentity.expeorirepayamount as repayamountori,expenseentryentity.experepayamount as repayamountacc,").append("expenseentryentity.orgiexpebalanceamount as norepayamountori,").append("expenseentryentity.expebalanceamount as norepayamountacc,").append("repaymentdate as repaydate,").append("case when expenseentryentity.orgiexpebalanceamount >0 then 0 else 1 end as repaystatus,").append("description as description,'2' as billtype, formid as reportformid,").append("org.name as loanpayerdept,company.name as loanpayercomp,applier.name as loanpayer,0 as summarytype,").append("expenseentryentity.entrycostdept.name as loanpayercostdept,expenseentryentity.entrycostcompany.name as loanpayercostcompany,").append("head_paydate,").append("0 as loandays,").append("bookeddate as bookeddate,").append("hasvoucher as hasvoucher,").append("isadvance as isadvance");
    protected static StringBuilder planeBillSelect = new StringBuilder().append("id,orderdate as bizdate,").append("ordernum as billno,currency as currency, currency as detailcurrency,").append("totalamount as loanamountori,totalamount as loanamountacc,").append("0.00 as clearamountori,").append("0.00 as clearamountacc,").append("0.00 as repayamountori,0.00 as repayamountacc,").append("totalamount as norepayamountori,").append("totalamount as norepayamountacc,").append("orderdate as repaydate,").append("0 as repaystatus,'' as description,").append("'3' as billtype, 'er_planebill' as reportformid,").append("bookeddept.name as loanpayerdept,company.name as loanpayercomp,bookedname as loanpayer,sourcebookedid as loanpayerid,0 as summarytype,").append("expcommitdepnum.name as loanpayercostdept,expcommitcomnum.name as loanpayercostcompany,").append("CURDATE() as head_paydate,").append("0 as loandays,").append("NULL as bookeddate");
    protected static StringBuilder hotelBillSelect = new StringBuilder().append("id,orderdate as bizdate,").append("ordernum as billno,currency as currency, currency as detailcurrency,").append("totalamount as loanamountori,totalamount as loanamountacc,").append("0.00 as clearamountori,").append("0.00 as clearamountacc,").append("0.00 as repayamountori,0.00 as repayamountacc,").append("totalamount as norepayamountori,").append("totalamount as norepayamountacc,").append("orderdate as repaydate,").append("0 as repaystatus,'' as description,").append("'4' as billtype,'er_hotelbill' as reportformid,").append("bookeddept.name as loanpayerdept,company.name as loanpayercomp,bookedname as loanpayer,sourcebookedid as loanpayerid,0 as summarytype,").append("expcommitdepnum.name as loanpayercostdept,expcommitcomnum.name as loanpayercostcompany,").append("CURDATE() as head_paydate,").append("0 as loandays,").append("NULL as bookeddate");
    protected static StringBuilder carBillSelect = new StringBuilder().append("id,orderdate as bizdate,").append("ordernum as billno,currency as currency, currency as detailcurrency,").append("totalamount as loanamountori,totalamount as loanamountacc,").append("0.00 as clearamountori,").append("0.00 as clearamountacc,").append("0.00 as repayamountori,0.00 as repayamountacc,").append("totalamount as norepayamountori,").append("totalamount as norepayamountacc,").append("orderdate as repaydate,").append("0 as repaystatus,'' as description,").append("'4' as billtype,'er_hotelbill' as reportformid,").append("bookeddept.name as loanpayerdept,company.name as loanpayercomp,bookedname as loanpayer,sourcebookedid as loanpayerid,0 as summarytype,").append("expcommitdepnum.name as loanpayercostdept,expcommitcomnum.name as loanpayercostcompany,").append("CURDATE() as head_paydate,").append("0 as loandays,").append("NULL as bookeddate");
    private static String[] orderSelect = new String[]{"id", "bizdate", "billno", "currency", "detailcurrency", "loanamountori", "loanamountacc", "clearamountori", "clearamountacc", "repayamountori", "repayamountacc", "norepayamountori", "norepayamountacc", "DATEADD('Day',30,repaydate) as repaydate", "repaystatus", "description", "billtype", "reportformid", "loanpayerdept", "loanpayercomp", "loanpayercostdept", "loanpayercostcompany", "loanpayerid", "0 as summarytype", "loanpayer", "head_paydate", "0 as loandays", "bookeddate", "hasvoucher", "isadvance"};
    private static List list = Arrays.asList("pentrycostdept.id", "porg.id", "pentrycostdept.name", "porg.name", "pbillno", "pdescription", "papplier.id", "papplier.name");

    public static void setReportFilter(ReportQueryParam queryParam, List<QFilter> tripReqFilterList, List<QFilter> dailyLoanFilterList, List<QFilter> orderBillFilterList, List<QFilter> dataSetFilterList, boolean isForFi) {
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        Long applier = queryParam.getFilter().getLong("applier");
        if (applier != null && applier != 0L) {
            userId = applier;
        }
        orderBillFilterList.add(QFilter.of((String)"isreimburse=?", (Object[])new Object[]{Boolean.FALSE}));
        FilterInfo commonFilterInfo = queryParam.getFilter();
        ReportUtil.excludeOrder(commonFilterInfo, orderBillFilterList);
        commonFilterInfo.getFilterItems().forEach(filterItem -> {
            String propName = filterItem.getPropName();
            Object value = filterItem.getValue();
            String compareType = filterItem.getCompareType();
            String[] splitQueryEle = propName.split("\\.");
            if ("paramdate".equals(propName)) {
                QFilter bizdateFilter = new QFilter("bizdate", compareType, value);
                QFilter orderdateFilter = new QFilter("orderdate", compareType, value);
                tripReqFilterList.add(bizdateFilter);
                dailyLoanFilterList.add(bizdateFilter);
                orderBillFilterList.add(orderdateFilter);
                return;
            } else if ("costcompanyfilter".equals(splitQueryEle[0])) {
                if (splitQueryEle.length != 2) return;
                QFilter tripDataFilter = new QFilter("tripentry.entrycostcompany." + splitQueryEle[1], compareType, value);
                QFilter dailyDataFilter = new QFilter("expenseentryentity.entrycostcompany." + splitQueryEle[1], compareType, value);
                QFilter orderdateFilter = new QFilter("expcommitcomnum." + splitQueryEle[1], compareType, value);
                tripReqFilterList.add(tripDataFilter);
                dailyLoanFilterList.add(dailyDataFilter);
                orderBillFilterList.add(orderdateFilter);
                return;
            } else if ("currencytype".equals(splitQueryEle[0])) {
                QFilter currencyFilter = new QFilter(splitQueryEle.length > 1 ? "currency." + splitQueryEle[1] : "currency", compareType, value);
                tripReqFilterList.add(currencyFilter);
                dailyLoanFilterList.add(currencyFilter);
                orderBillFilterList.add(currencyFilter);
                return;
            } else if ("paramstatus".equals(propName)) {
                FilterInfo filter = null;
                String billtype = null;
                if (value == null) return;
                switch (value.toString()) {
                    case "0": {
                        filter = queryParam.getFilter();
                        billtype = filter.getString("billtype");
                        if (billtype != null) {
                            if ("er_dailyloanbill".equals(billtype)) {
                                QFilter notRePayFilter = new QFilter("expenseentryentity.orgiexpebalanceamount", ">", (Object)0);
                                dailyLoanFilterList.add(notRePayFilter);
                                return;
                            }
                            QFilter notRePayFilter = new QFilter("tripentry.oriaccbalanceamount", ">", (Object)0);
                            tripReqFilterList.add(notRePayFilter);
                            return;
                        }
                        QFilter notLoanRePayFilter = new QFilter("expenseentryentity.orgiexpebalanceamount", ">", (Object)0);
                        dailyLoanFilterList.add(notLoanRePayFilter);
                        QFilter notRePayFilter = new QFilter("tripentry.oriaccbalanceamount", ">", (Object)0);
                        tripReqFilterList.add(notRePayFilter);
                        return;
                    }
                    case "1": {
                        filter = queryParam.getFilter();
                        billtype = filter.getString("billtype");
                        if (billtype != null) {
                            if ("er_dailyloanbill".equals(billtype)) {
                                QFilter notRePayFilter = new QFilter("expenseentryentity.orgiexpebalanceamount", "<=", (Object)0);
                                dailyLoanFilterList.add(notRePayFilter);
                            } else {
                                QFilter notRePayFilter = new QFilter("tripentry.oriaccbalanceamount", "<=", (Object)0);
                                tripReqFilterList.add(notRePayFilter);
                            }
                        } else {
                            QFilter notLoanRePayFilter = new QFilter("expenseentryentity.orgiexpebalanceamount", "<=", (Object)0);
                            dailyLoanFilterList.add(notLoanRePayFilter);
                            QFilter notTripRePayFilter = new QFilter("tripentry.oriaccbalanceamount", "<=", (Object)0);
                            tripReqFilterList.add(notTripRePayFilter);
                        }
                        orderBillFilterList.add(new QFilter("isapprove", "=", (Object)"1"));
                        return;
                    }
                    case "2": {
                        return;
                    }
                }
                return;
            } else if ("paramcompany".equals(splitQueryEle[0])) {
                QFilter companyFilter = new QFilter(splitQueryEle.length > 1 ? "company." + splitQueryEle[1] : "company", compareType, value);
                tripReqFilterList.add(companyFilter);
                dailyLoanFilterList.add(companyFilter);
                orderBillFilterList.add(companyFilter);
                return;
            } else if ("parambilltype".equals(propName)) {
                dataSetFilterList.add(new QFilter("billtype", compareType, value));
                return;
            } else if ("loanpayer".equals(propName) || "loanpayerfiltercolumnap.id".equals(propName)) {
                tripReqFilterList.add(new QFilter("applier", compareType, value));
                dailyLoanFilterList.add(new QFilter("applier", compareType, value));
                orderBillFilterList.add(new QFilter("sourcebookedid", compareType, value));
                return;
            } else if ("loanpayerfiltercolumnap.name".equals(propName)) {
                tripReqFilterList.add(new QFilter("applier.name", compareType, value));
                dailyLoanFilterList.add(new QFilter("applier.name", compareType, value));
                orderBillFilterList.add(new QFilter("sourcebookedid.name", compareType, value));
                return;
            } else if ("isadvancefilter".equals(propName)) {
                if ((!"=".equals(compareType) || "EMPTY".equals(value.toString())) && !"!=".equals(compareType)) throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u201c\u9884\u4ed8\u201d\u67e5\u8be2\u6761\u4ef6\uff0c\u4ec5\u652f\u6301\u201c\u7b49\u4e8e\u201d\u6216\u201c\u4e0d\u7b49\u4e8e\u201d\u3002", (String)"EmployeeLoanRepayReportForFI_2", (String)"fi-er-report", (Object[])new Object[0]));
                dataSetFilterList.add(new QFilter("isadvance", compareType, (Object)value.toString().equals("1")));
                return;
            } else if ("ishasvoucher".equals(propName)) {
                if (!"=".equals(compareType) && !"!=".equals(compareType)) throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u201c\u751f\u6210\u51ed\u8bc1\u201d\u67e5\u8be2\u6761\u4ef6\uff0c\u4ec5\u652f\u6301\u201c\u7b49\u4e8e\u201d\u6216\u201c\u4e0d\u7b49\u4e8e\u201d\u3002", (String)"EmployeeLoanRepayReportForFI_3", (String)"fi-er-report", (Object[])new Object[0]));
                tripReqFilterList.add(new QFilter("hasvoucher", compareType, (Object)value.toString().equals("1")));
                dailyLoanFilterList.add(new QFilter("hasvoucher", compareType, (Object)value.toString().equals("1")));
                return;
            } else if ("parambookdate".equals(propName)) {
                QFilter bookeddateFilter = new QFilter("bookeddate", compareType, value);
                tripReqFilterList.add(bookeddateFilter);
                dailyLoanFilterList.add(bookeddateFilter);
                return;
            } else {
                if (!ReportUtil.getList().contains(propName)) return;
                ReportUtil.setLoanReqFilter(filterItem, tripReqFilterList, dailyLoanFilterList);
            }
        });
        tripReqFilterList.add(new QFilter("isloan", "=", (Object)"1"));
        QFilter stateFilter = new QFilter("billstatus", "in", Arrays.asList("G", "I"));
        tripReqFilterList.add(stateFilter);
        dailyLoanFilterList.add(stateFilter);
        orderBillFilterList.add(new QFilter("isapprove", "=", (Object)"0"));
        orderBillFilterList.add(new QFilter("orderdate", "is not null", null));
        if (isForFi) {
            List filterItems = commonFilterInfo.getFilterItems("paramcompany");
            if (filterItems == null || filterItems.size() == 0) {
                HasPermOrgResult adminorgsResult;
                String appId = "em";
                FilterItemInfo appFilter = commonFilterInfo.getFilterItem("appId");
                if (appFilter != null) {
                    appId = (String)appFilter.getValue();
                }
                appId = StringUtils.defaultIfBlank((String)appId, (String)"em");
                List orgsList = null;
                HasPermOrgResult orgsResult = PermissionServiceHelper.getAllPermOrgs((Long)CommonServiceHelper.getCurrentUserID(), (String)appId, (String)"er_employee_loan_repay_fi", (String)"47150e89000000ac");
                if (!orgsResult.hasAllOrgPerm()) {
                    orgsList = orgsResult.getHasPermOrgs();
                }
                if (!(adminorgsResult = PermissionServiceHelper.getAllPermOrgs((long)CommonServiceHelper.getCurrentUserID(), (String)"01", (String)appId, (String)"er_employee_loan_repay_fi", (String)"47150e89000000ac")).hasAllOrgPerm()) {
                    List adminorgsList = adminorgsResult.getHasPermOrgs();
                    if (orgsList != null) {
                        orgsList.addAll(adminorgsList);
                    } else {
                        orgsList = adminorgsList;
                    }
                }
                if (orgsList != null) {
                    tripReqFilterList.add(new QFilter(((BillEntityType)EntityMetadataCache.getDataEntityType((String)"er_tripreqbill")).getMainOrgProperty().getName() + ".id", "in", (Object)orgsList));
                    dailyLoanFilterList.add(new QFilter(((BillEntityType)EntityMetadataCache.getDataEntityType((String)"er_dailyloanbill")).getMainOrgProperty().getName() + ".id", "in", (Object)orgsList));
                    orderBillFilterList.add(new QFilter(((BillEntityType)EntityMetadataCache.getDataEntityType((String)"er_hotelbill")).getMainOrgProperty().getName() + ".id", "in", (Object)orgsList));
                }
            }
        } else {
            QFilter applierFilter = new QFilter("applier", "=", (Object)userId);
            List<Object> depts = ReportUtil.getManagerDept(userId);
            if (depts != null) {
                tripReqFilterList.add(applierFilter.or(new QFilter("tripentry.entrycostdept", "in", depts)));
                dailyLoanFilterList.add(new QFilter("applier", "=", (Object)userId).or(new QFilter("expenseentryentity.entrycostdept", "in", depts)));
            } else {
                tripReqFilterList.add(applierFilter);
                dailyLoanFilterList.add(applierFilter);
            }
            orderBillFilterList.add(new QFilter("sourcebookedid.id", "=", (Object)userId));
        }
        logger.info("\u8d22\u52a1\u501f\u8fd8\u6b3e\u62a5\u8868\u67e5\u8be2\u6761\u4ef6\uff1atripReqFilterList\uff1a" + tripReqFilterList + "  ,dailyLoanFilterList:" + dailyLoanFilterList + "  ,orderBillFilterList:" + orderBillFilterList);
    }

    private static List<Object> getManagerDept(Long userId) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_user", (String)"entryentity.dpt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId), new QFilter("entryentity.isincharge", "=", (Object)Boolean.TRUE)});
        if (!collection.isEmpty()) {
            return collection.stream().map(v -> v.get("entryentity.dpt")).collect(Collectors.toList());
        }
        return null;
    }

    private static DataSet handleDataSetAfterQuery(DataSet dataSet) {
        return dataSet.addField("false", "isadvance");
    }

    public static DataSet queryReportDataSet(List<QFilter> tripReqFilterList, List<QFilter> dailyLoanFilterList, List<QFilter> orderBillFilterList, List<QFilter> dataSetFilterList) {
        IErDao tripReqBillDao = ErDaoFactory.getInstance((String)"er_tripreqbill");
        DataSet tripReqDataSet = tripReqBillDao.queryDataSet(classname, tripReqSelect.toString(), tripReqFilterList.toArray(new QFilter[tripReqFilterList.size()]));
        tripReqDataSet = ReportUtil.handleDataSetAfterQuery(tripReqDataSet);
        IErDao dailyLoanBillDao = ErDaoFactory.getInstance((String)"er_dailyloanbill");
        DataSet dailyLoanDataSet = dailyLoanBillDao.queryDataSet(classname, dailyLoanSelect.toString(), dailyLoanFilterList.toArray(new QFilter[dailyLoanFilterList.size()]));
        IErDao planeBillDao = ErDaoFactory.getInstance((String)"er_planebill");
        DataSet planeBillDataSet = planeBillDao.queryDataSet(classname, planeBillSelect.toString(), orderBillFilterList.toArray(new QFilter[orderBillFilterList.size()]));
        planeBillDataSet = planeBillDataSet.addField("false", "hasvoucher");
        planeBillDataSet = ReportUtil.handleDataSetAfterQuery(planeBillDataSet);
        IErDao hotelBillDao = ErDaoFactory.getInstance((String)"er_hotelbill");
        DataSet hotelBillDataSet = hotelBillDao.queryDataSet(classname, hotelBillSelect.toString(), orderBillFilterList.toArray(new QFilter[orderBillFilterList.size()]));
        hotelBillDataSet = hotelBillDataSet.addField("false", "hasvoucher");
        hotelBillDataSet = ReportUtil.handleDataSetAfterQuery(hotelBillDataSet);
        IErDao carBillDao = ErDaoFactory.getInstance((String)"er_vehiclebill");
        DataSet carBillDataSet = carBillDao.queryDataSet(classname, carBillSelect.toString(), orderBillFilterList.toArray(new QFilter[orderBillFilterList.size()]));
        carBillDataSet = carBillDataSet.addField("false", "hasvoucher");
        carBillDataSet = ReportUtil.handleDataSetAfterQuery(carBillDataSet);
        DataSet orderBillDataSet = ReportUtil.handleOrderDataSet(planeBillDataSet.union(hotelBillDataSet).union(carBillDataSet));
        DataSet tripAndDailyDataSet = tripReqDataSet.union(dailyLoanDataSet);
        long tripAndDailyCount = Streams.stream((Iterator)(tripAndDailyDataSet = tripAndDailyDataSet.select(mainSelect)).copy().iterator()).count();
        if (tripAndDailyCount > 0L) {
            return ReportUtil.handleDataSet(tripAndDailyDataSet.union(orderBillDataSet), dataSetFilterList);
        }
        return ReportUtil.handleDataSet(orderBillDataSet, dataSetFilterList);
    }

    private static DataSet handleOrderDataSet(DataSet orderDataSet) {
        orderDataSet = orderDataSet.select(orderSelect);
        return orderDataSet;
    }

    private static DataSet handleDataSet(DataSet mainDataSet, List<QFilter> dataSetFilterList) {
        StringBuilder dataSetFilter = new StringBuilder();
        dataSetFilterList.forEach(v -> {
            dataSetFilter.append(" and ");
            dataSetFilter.append(v);
        });
        mainDataSet = mainDataSet.copy();
        if (!dataSetFilterList.isEmpty()) {
            mainDataSet = mainDataSet.filter(dataSetFilter.toString().replaceFirst(" and ", ""));
        }
        DataSet groupDataSet = ReportUtil.handleGroupDataSet(mainDataSet);
        DataSet totalDataSet = ReportUtil.handleTotalDataSet(groupDataSet);
        DataSet resultDataSet = ReportUtil.handleCollection(mainDataSet = mainDataSet.orderBy(new String[]{"loanpayerid", "bizdate desc"}), groupDataSet);
        if (resultDataSet == null) {
            return null;
        }
        return resultDataSet.union(totalDataSet);
    }

    private static DataSet handleGroupDataSet(DataSet mainDataSet) {
        DataSet groupDataSet = mainDataSet.copy();
        groupDataSet = groupDataSet.groupBy(new String[]{"loanpayerid", "currency"}).sum("loanamountacc").sum("clearamountacc").sum("repayamountacc").sum("norepayamountacc").finish();
        Field[] groupFields = groupDataSet.getRowMeta().getFields();
        HashSet groupFieldsSet = new HashSet();
        Stream.of(groupFields).forEach(record -> groupFieldsSet.add(record.getAlias().toUpperCase()));
        Field[] reportAllFields = mainDataSet.getRowMeta().getFields();
        ArrayList groupSelectFields = Lists.newArrayListWithExpectedSize((int)32);
        for (Field field : reportAllFields) {
            String fieldName;
            String emptyField = fieldName = field.getAlias().toUpperCase();
            if (!groupFieldsSet.contains(fieldName)) {
                emptyField = "null as " + fieldName;
                if ("loanpayer".equalsIgnoreCase(fieldName)) {
                    emptyField = String.format("'%s' as %s", ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ReportUtil_0", (String)"fi-er-report", (Object[])new Object[0]), fieldName);
                }
                if ("summarytype".equalsIgnoreCase(fieldName)) {
                    emptyField = "2 as " + fieldName;
                }
            }
            groupSelectFields.add(emptyField);
        }
        groupDataSet = groupDataSet.select(groupSelectFields.toArray(new String[groupSelectFields.size()]));
        return groupDataSet.orderBy(new String[]{"loanpayerid"});
    }

    private static DataSet handleTotalDataSet(DataSet dataSet) {
        DataSet totakDataSet = dataSet.copy();
        totakDataSet = totakDataSet.groupBy(new String[]{"currency"}).sum("loanamountacc").sum("clearamountacc").sum("repayamountacc").sum("norepayamountacc").finish();
        Field[] groupFields = totakDataSet.getRowMeta().getFields();
        HashSet groupFieldsSet = new HashSet();
        Stream.of(groupFields).forEach(record -> groupFieldsSet.add(record.getAlias().toUpperCase()));
        Field[] reportAllFields = dataSet.getRowMeta().getFields();
        ArrayList groupSelectFields = Lists.newArrayListWithExpectedSize((int)32);
        for (Field field : reportAllFields) {
            String fieldName;
            String emptyField = fieldName = field.getAlias().toUpperCase();
            if (!groupFieldsSet.contains(fieldName)) {
                emptyField = "null as " + fieldName;
                if ("loanpayer".equalsIgnoreCase(fieldName)) {
                    emptyField = String.format("'%s' as %s", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ReportUtil_1", (String)"fi-er-report", (Object[])new Object[0]), fieldName);
                }
                if ("summarytype".equalsIgnoreCase(fieldName)) {
                    emptyField = String.format("%s as %s", "1", fieldName);
                }
            }
            groupSelectFields.add(emptyField);
        }
        totakDataSet = totakDataSet.select(groupSelectFields.toArray(new String[groupSelectFields.size()]));
        return totakDataSet;
    }

    private static DataSet handleCollection(DataSet mainDataSet, DataSet groupDataSet) {
        Algo algo = Algo.create((String)classname);
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(mainDataSet.getRowMeta());
        String prevRecordName = "";
        Map<String, Object> smallRecordRow = null;
        Map<String, Object> currentGroupRecord = null;
        DataSet groupDataSet1 = groupDataSet.copy();
        RowMeta rowMeta = groupDataSet1.getRowMeta();
        List<Map<String, Object>> groupDataLists = ReportUtil.transToList(groupDataSet1);
        for (Row mainRecord : mainDataSet) {
            String currentMainRecordLoanpayer = mainRecord.getString("loanpayerid");
            for (Map<String, Object> groupRow : groupDataLists) {
                String groupRowLoanpayerName = String.valueOf(groupRow.get("loanpayerid"));
                if (currentMainRecordLoanpayer == null || !currentMainRecordLoanpayer.equals(groupRowLoanpayerName)) continue;
                currentGroupRecord = groupRow;
                break;
            }
            if (currentGroupRecord != null && "".equals(prevRecordName)) {
                prevRecordName = String.valueOf(currentGroupRecord.get("loanpayerid"));
            }
            if (prevRecordName == null || currentMainRecordLoanpayer == null || currentGroupRecord == null) continue;
            if (currentMainRecordLoanpayer.equals(prevRecordName)) {
                datasetBuilder.append(mainRecord);
            } else {
                for (Map<String, Object> groupRow : groupDataLists) {
                    String groupLoanpayerName = String.valueOf(groupRow.get("loanpayerid"));
                    if (!prevRecordName.equals(groupLoanpayerName)) continue;
                    smallRecordRow = groupRow;
                    break;
                }
                if (smallRecordRow != null) {
                    datasetBuilder.append(ReportUtil.transToRow(rowMeta, smallRecordRow));
                }
                datasetBuilder.append(mainRecord);
            }
            prevRecordName = currentMainRecordLoanpayer;
        }
        if (null != currentGroupRecord) {
            datasetBuilder.append(ReportUtil.transToRow(rowMeta, currentGroupRecord));
        }
        return datasetBuilder.build();
    }

    private static Object[] transToRow(RowMeta rowMeta, Map<String, Object> smallRecordRow) {
        Field[] fields = rowMeta.getFields();
        Object[] obj = new Object[fields.length];
        int i = 0;
        for (Field field : fields) {
            obj[i++] = smallRecordRow.get(field.getName().toLowerCase());
        }
        return obj;
    }

    private static List<Map<String, Object>> transToList(DataSet dataSet) {
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        Field[] fields = dataSet.getRowMeta().getFields();
        for (Row row : dataSet) {
            LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)fields.length);
            for (Field field : fields) {
                map.put(field.getName().toLowerCase(), row.get(field.getName()));
            }
            list.add(map);
        }
        dataSet.close();
        return list;
    }

    public static List getList() {
        return list;
    }

    public static void excludeOrder(FilterInfo commonFilterInfo, List<QFilter> orderBillFilterList) {
        boolean excludeOrders = commonFilterInfo.getFilterItems().stream().anyMatch(filterItem -> ReportUtil.getList().stream().anyMatch(e -> filterItem.getPropName().startsWith(e.toString())));
        if (excludeOrders) {
            orderBillFilterList.add(new QFilter("1", "!=", (Object)1));
        }
    }

    public static void setLoanReqFilter(FilterItemInfo filterItem, List<QFilter> tripReqFilterList, List<QFilter> dailyLoanFilterList) {
        String propName = filterItem.getPropName();
        Object value = filterItem.getValue();
        String compareType = filterItem.getCompareType();
        if (propName.startsWith("pentrycostdept")) {
            String idOrName = propName.split("\\.")[1];
            tripReqFilterList.add(new QFilter("tripentry.entrycostdept." + idOrName, compareType, value));
            dailyLoanFilterList.add(new QFilter("expenseentryentity.entrycostdept." + idOrName, compareType, value));
        } else {
            String prop = propName.substring(1);
            tripReqFilterList.add(new QFilter(prop, compareType, value));
            dailyLoanFilterList.add(new QFilter(prop, compareType, value));
        }
    }
}

