/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.amount.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.model.ReimAmountQuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import kd.fi.er.report.amount.service.EmployeeAmountQueryService;
import kd.fi.er.report.amount.service.FinanceAmountQueryService;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractAmountQueryService {
    private void transferQFilterName(List<QFilter> qFilters) {
        if (qFilters == null || qFilters.isEmpty()) {
            return;
        }
        Iterator<QFilter> qFilterIterator = qFilters.iterator();
        while (qFilterIterator.hasNext()) {
            QFilter qFilter = qFilterIterator.next();
            String property = qFilter.getProperty();
            if (StringUtils.isNotBlank((String)property) && property.contains("employeenumberfilter")) {
                qFilter.__setProperty(property.replaceAll("employeenumberfilter", "employee"));
            }
            if (StringUtils.isNotBlank((String)property) && property.contains("employeenamefilter")) {
                qFilter.__setProperty(property.replaceAll("employeenamefilter", "employee"));
            }
            if (StringUtils.isNotBlank((String)property) && !StringUtils.equals((String)property, (String)"formid") && property.contains("_filter")) {
                qFilter.__setProperty(property.replaceAll("_filter", ""));
                if (property.contains("dateyear")) {
                    String yearValue = String.valueOf(qFilter.getValue());
                    qFilter.__setValue((Object)yearValue.substring(0, 4));
                    if (StringUtils.isNotBlank((String)yearValue) && yearValue.contains("LM")) {
                        qFilter.__setValue((Object)(YearMonth.now().minusMonths(1L).getYear() + ""));
                    }
                    if ("this_year".equals(yearValue)) {
                        qFilter.__setValue((Object)(Year.now().getValue() + ""));
                    }
                    if ("last_year".equals(yearValue)) {
                        qFilter.__setValue((Object)(Year.now().minusYears(1L).getValue() + ""));
                    }
                }
                if (property.contains("billkind")) {
                    qFilterIterator.remove();
                }
            }
            List nests = qFilter.getNests(false);
            qFilter.clearNests();
            for (QFilter.QFilterNest qFilterNest : nests) {
                QFilter nestFilter = qFilterNest.getFilter();
                ArrayList<QFilter> _lst = new ArrayList<QFilter>();
                _lst.add(nestFilter);
                this.transferQFilterName(_lst);
                if (_lst.isEmpty()) continue;
                boolean isAnd = qFilterNest.isAnd();
                if (isAnd) {
                    qFilter = qFilter.and(nestFilter);
                    continue;
                }
                qFilter = qFilter.or(nestFilter);
            }
        }
    }

    public List<QFilter> getQFilters(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        List qFilters = filterInfo.getQFilters();
        this.transferQFilterName(qFilters);
        qFilters.add(new QFilter("auditstatus", "=", (Object)"1"));
        return qFilters;
    }

    protected void processRowDataForPersonal(DynamicObject row, ReportQueryParam queryParam) {
        DynamicObject expenseItem = row.getDynamicObject("expenseitem");
        if (expenseItem != null) {
            BigDecimal termAmount;
            String value;
            Object dateYearFilterOptional;
            FilterItemInfo filterItem;
            int reimburseAmountCtlCount = expenseItem.getInt("reimburseamountctlcount");
            row.set("controlcount", (Object)reimburseAmountCtlCount);
            QuotaAmountBO reimAmountBO = new QuotaAmountBO();
            reimAmountBO.setCompanyId(ErCommonUtils.getPk((Object)row.getDynamicObject("company")));
            reimAmountBO.setUserOrDeptId(ErCommonUtils.getPk((Object)row.getDynamicObject("employee")));
            String empCltBillStr = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)row.getDynamicObject("company")), (String)"empquotaapplicablebill");
            List<String> empCltBillList = Arrays.asList(empCltBillStr.split(","));
            reimAmountBO.setEmpCtlBill(empCltBillList);
            reimAmountBO.setExpenseItemId(ErCommonUtils.getPk((Object)expenseItem));
            reimAmountBO.setCtrlMode("1");
            String controlMethod = expenseItem.get("reimburseamountctlmethod").toString();
            reimAmountBO.setCtrlMethod(controlMethod);
            reimAmountBO.setItem(row);
            String personCtrlCurrency = SystemParamterUtil.getPersonCtlCurrency((Long)ErCommonUtils.getPk((Object)row.getDynamicObject("company")));
            QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)personCtrlCurrency, (Long)ErCommonUtils.getPk((Object)row.getDynamicObject("currency")), (Long)ErCommonUtils.getPk((Object)row.getDynamicObject("currency")));
            int year = Integer.parseInt(row.get("year").toString());
            YearMonth yearMonth = YearMonth.now();
            if (year != yearMonth.getYear()) {
                yearMonth = YearMonth.of(year, 12);
            }
            if ((filterItem = queryParam.getFilter().getFilterItem("dateyear_filter")) != null && (dateYearFilterOptional = filterItem.getValue()) != null && StringUtils.isNotBlank((String)(value = String.valueOf(dateYearFilterOptional))) && value.contains("LM")) {
                yearMonth = yearMonth.minusMonths(1L);
            }
            LocalDate start = LocalDate.of(yearMonth.getYear(), 1, 1);
            LocalDate end = LocalDate.now();
            if (year != Year.now().getValue()) {
                end = LocalDate.of(year, 12, 31);
            }
            QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBO);
            reimAmountBO.setHappenDatePeriod(new LocalDate[]{start, end});
            BigDecimal thisYearUsedAmount = quotaCtrlMode.getReimedAmount(reimAmountBO);
            row.set("thisyearusedamount", (Object)thisYearUsedAmount);
            reimAmountBO.setHappenDatePeriod(new HashMap());
            reimAmountBO.setHappenDate(yearMonth);
            BigDecimal thisTermAmount = quotaCtrlMode.getQuotaAmount(reimAmountBO);
            row.set("thistermamount", (Object)thisTermAmount);
            BigDecimal thisTermUsedAmount = quotaCtrlMode.getReimedAmount(reimAmountBO);
            BigDecimal thisTermBalanceAmount = BigDecimal.ZERO;
            if (thisTermAmount != null) {
                thisTermBalanceAmount = thisTermAmount.subtract(thisTermUsedAmount);
            }
            if (BigDecimal.ZERO.compareTo(thisTermBalanceAmount) > 0) {
                thisTermBalanceAmount = BigDecimal.ZERO;
            }
            row.set("thistermbalanceamount", (Object)thisTermBalanceAmount);
            BigDecimal thisTermUnFreedAmount = BigDecimal.ZERO;
            if (StringUtils.equals((String)controlMethod, (String)ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue())) {
                reimAmountBO.setIsByFreedRatio(false);
                termAmount = quotaCtrlMode.getQuotaAmount(reimAmountBO);
                thisTermUnFreedAmount = termAmount.subtract(thisTermAmount);
            }
            if (StringUtils.equals((String)controlMethod, (String)ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue())) {
                reimAmountBO.setIsByFreedRatio(false);
                termAmount = quotaCtrlMode.getQuotaAmount(reimAmountBO);
                if (termAmount != null) {
                    thisTermUnFreedAmount = termAmount.subtract(thisTermAmount);
                }
            }
            row.set("thistermunfreedamount", (Object)thisTermUnFreedAmount);
        }
    }

    public void processRowDatasForPersonal(DynamicObjectCollection rowDatas, ReportQueryParam queryParam) {
        DynamicObject expenseItem;
        DynamicObject row;
        int i;
        String value;
        Object dateYearFilterOptional;
        FilterItemInfo filterItem;
        YearMonth yearMonth;
        int year;
        if (rowDatas == null || rowDatas.size() <= 0) {
            return;
        }
        int rowDataSize = rowDatas.size();
        List<QuotaAmountBO> quotaAmountBOList = this.buildQuotaAmountBOList(rowDataSize);
        ThreadCache.put((Object)"fromreport", (Object)"fromreport");
        HashMap<Long, List<String>> companyCltBillStr = new HashMap<Long, List<String>>(16);
        HashMap<Long, String> companyCtrlCurrencyMap = new HashMap<Long, String>(16);
        for (int i2 = 0; i2 < rowDataSize; ++i2) {
            DynamicObject row2 = (DynamicObject)rowDatas.get(i2);
            DynamicObject expenseItem2 = row2.getDynamicObject("expenseitem");
            if (expenseItem2 == null) continue;
            int reimburseAmountCtlCount = expenseItem2.getInt("reimburseamountctlcount");
            row2.set("controlcount", (Object)reimburseAmountCtlCount);
            QuotaAmountBO reimAmountBO = quotaAmountBOList.get(i2);
            reimAmountBO.setReimburseamountrowID(row2.getLong("id"));
            reimAmountBO.setCompanyId(ErCommonUtils.getPk((Object)row2.getDynamicObject("company")));
            reimAmountBO.setUserOrDeptId(ErCommonUtils.getPk((Object)row2.getDynamicObject("employee")));
            Long companyId = ErCommonUtils.getPk((Object)row2.getDynamicObject("company"));
            List<String> ctrlBills = (List<String>)companyCltBillStr.get(companyId);
            if (ctrlBills == null) {
                String empCltBillStr = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"empquotaapplicablebill");
                ctrlBills = Arrays.asList(empCltBillStr.split(","));
                companyCltBillStr.put(companyId, ctrlBills);
            }
            reimAmountBO.setEmpCtlBill((List)ctrlBills);
            reimAmountBO.setExpenseItemId(ErCommonUtils.getPk((Object)expenseItem2));
            reimAmountBO.setCtrlMode("1");
            String controlMethod = expenseItem2.get("reimburseamountctlmethod").toString();
            reimAmountBO.setCtrlMethod(controlMethod);
            reimAmountBO.setItem(row2);
            String personCtrlCurrency = (String)companyCtrlCurrencyMap.get(companyId);
            if (personCtrlCurrency == null) {
                personCtrlCurrency = SystemParamterUtil.getPersonCtlCurrency((Long)companyId);
                companyCtrlCurrencyMap.put(companyId, personCtrlCurrency);
            }
            QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)personCtrlCurrency, (Long)ErCommonUtils.getPk((Object)row2.getDynamicObject("currency")), (Long)ErCommonUtils.getPk((Object)row2.getDynamicObject("currency")));
            year = Integer.parseInt(row2.get("year").toString());
            yearMonth = YearMonth.now();
            if (year != yearMonth.getYear()) {
                yearMonth = YearMonth.of(year, 12);
            }
            if ((filterItem = queryParam.getFilter().getFilterItem("dateyear_filter")) != null && (dateYearFilterOptional = filterItem.getValue()) != null && StringUtils.isNotBlank((String)(value = String.valueOf(dateYearFilterOptional))) && value.contains("LM")) {
                yearMonth = yearMonth.minusMonths(1L);
            }
            LocalDate start = LocalDate.of(yearMonth.getYear(), 1, 1);
            LocalDate end = LocalDate.now();
            if (year != Year.now().getValue()) {
                end = LocalDate.of(year, 12, 31);
            }
            reimAmountBO.setHappenDatePeriod(new LocalDate[]{start, end});
        }
        Optional<QuotaAmountBO> reulstOpt = quotaAmountBOList.stream().filter(e -> e.getCtrlMode() != null).findAny();
        if (!reulstOpt.isPresent()) {
            return;
        }
        QuotaAmountBO reimAmountBOGlb = reulstOpt.get();
        QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBOGlb);
        List reimAmountQuotaAmountBOList = quotaCtrlMode.getReimedAmount(quotaAmountBOList);
        for (i = 0; i < rowDataSize; ++i) {
            row = (DynamicObject)rowDatas.get(i);
            expenseItem = row.getDynamicObject("expenseitem");
            if (expenseItem == null) continue;
            ReimAmountQuotaAmountBO reimAmountQuotaAmountBO = (ReimAmountQuotaAmountBO)reimAmountQuotaAmountBOList.get(i);
            row.set("thisyearusedamount", (Object)reimAmountQuotaAmountBO.getReimAmount());
            QuotaAmountBO reimAmountBO = quotaAmountBOList.get(i);
            year = Integer.parseInt(row.get("year").toString());
            yearMonth = YearMonth.now();
            if (year != yearMonth.getYear()) {
                yearMonth = YearMonth.of(year, 12);
            }
            if ((filterItem = queryParam.getFilter().getFilterItem("dateyear_filter")) != null && (dateYearFilterOptional = filterItem.getValue()) != null && StringUtils.isNotBlank((String)(value = String.valueOf(dateYearFilterOptional))) && value.contains("LM")) {
                yearMonth = yearMonth.minusMonths(1L);
            }
            reimAmountBO.setHappenDatePeriod(new HashMap());
            reimAmountBO.setHappenDate(yearMonth);
            BigDecimal thisTermAmount = quotaCtrlMode.getQuotaAmount(reimAmountBO);
            row.set("thistermamount", (Object)thisTermAmount);
        }
        reimAmountQuotaAmountBOList = quotaCtrlMode.getReimedAmount(quotaAmountBOList);
        for (i = 0; i < rowDataSize; ++i) {
            BigDecimal termAmount;
            row = (DynamicObject)rowDatas.get(i);
            expenseItem = row.getDynamicObject("expenseitem");
            if (expenseItem == null) continue;
            QuotaAmountBO reimAmountBO = quotaAmountBOList.get(i);
            ReimAmountQuotaAmountBO reimAmountQuotaAmountBO = (ReimAmountQuotaAmountBO)reimAmountQuotaAmountBOList.get(i);
            BigDecimal thisTermAmount = quotaCtrlMode.getQuotaAmount(reimAmountBO);
            BigDecimal thisTermUsedAmount = reimAmountQuotaAmountBO.getReimAmount();
            BigDecimal thisTermBalanceAmount = BigDecimal.ZERO;
            if (thisTermAmount != null) {
                thisTermBalanceAmount = thisTermAmount.subtract(thisTermUsedAmount);
            }
            if (BigDecimal.ZERO.compareTo(thisTermBalanceAmount) > 0) {
                thisTermBalanceAmount = BigDecimal.ZERO;
            }
            row.set("thistermbalanceamount", (Object)thisTermBalanceAmount);
            BigDecimal thisTermUnFreedAmount = BigDecimal.ZERO;
            String controlMethod = expenseItem.get("reimburseamountctlmethod").toString();
            if (StringUtils.equals((String)controlMethod, (String)ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue())) {
                reimAmountBO.setIsByFreedRatio(false);
                termAmount = quotaCtrlMode.getQuotaAmount(reimAmountBO);
                thisTermUnFreedAmount = termAmount.subtract(thisTermAmount);
            }
            if (StringUtils.equals((String)controlMethod, (String)ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue())) {
                reimAmountBO.setIsByFreedRatio(false);
                termAmount = quotaCtrlMode.getQuotaAmount(reimAmountBO);
                if (termAmount != null) {
                    thisTermUnFreedAmount = termAmount.subtract(thisTermAmount);
                }
            }
            row.set("thistermunfreedamount", (Object)thisTermUnFreedAmount);
        }
    }

    private List<QuotaAmountBO> buildQuotaAmountBOList(int rowDataSize) {
        ArrayList<QuotaAmountBO> quotaAmountBOList = new ArrayList<QuotaAmountBO>(rowDataSize);
        for (int i = 0; i < rowDataSize; ++i) {
            QuotaAmountBO reimAmountBO = new QuotaAmountBO();
            quotaAmountBOList.add(reimAmountBO);
        }
        return quotaAmountBOList;
    }

    protected void processRowDataForDepartmental(DynamicObject row, ReportQueryParam queryParam) {
        DynamicObject expenseItem = row.getDynamicObject("expenseitem");
        if (expenseItem != null) {
            String value;
            Object dateYearFilterOptional;
            FilterItemInfo filterItem;
            int reimburseAmountCtlCount = expenseItem.getInt("reimburseamountctlcount");
            row.set("controlcount", (Object)reimburseAmountCtlCount);
            QuotaAmountBO reimAmountBO = new QuotaAmountBO();
            reimAmountBO.setCompanyId(ErCommonUtils.getPk((Object)row.getDynamicObject("company")));
            reimAmountBO.setUserOrDeptId(ErCommonUtils.getPk((Object)row.getDynamicObject("dept")));
            String deptCltBillStr = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)row.getDynamicObject("company")), (String)"deptquotaapplicablebill");
            List<String> deptCltBillList = Arrays.asList(deptCltBillStr.split(","));
            reimAmountBO.setDeptCtlBill(deptCltBillList);
            reimAmountBO.setExpenseItemId(ErCommonUtils.getPk((Object)expenseItem));
            reimAmountBO.setCtrlMode("2");
            String controlMethod = expenseItem.get("reimburseamountctlmethod").toString();
            reimAmountBO.setCtrlMethod(controlMethod);
            String deptCtrlCurrency = SystemParamterUtil.getDeptCtlCurrency((Long)ErCommonUtils.getPk((Object)row.getDynamicObject("company")));
            QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)deptCtrlCurrency, (Long)ErCommonUtils.getPk((Object)row.getDynamicObject("currency")), (Long)ErCommonUtils.getPk((Object)row.getDynamicObject("currency")));
            int year = Integer.parseInt(row.get("year").toString());
            YearMonth yearMonth = YearMonth.now();
            if (year != yearMonth.getYear()) {
                yearMonth = YearMonth.of(year, 12);
            }
            if ((filterItem = queryParam.getFilter().getFilterItem("dateyear_filter")) != null && (dateYearFilterOptional = filterItem.getValue()) != null && StringUtils.isNotBlank((String)(value = String.valueOf(dateYearFilterOptional))) && value.contains("LM")) {
                yearMonth = yearMonth.minusMonths(1L);
            }
            LocalDate start = LocalDate.of(yearMonth.getYear(), 1, 1);
            LocalDate end = LocalDate.now();
            if (year != Year.now().getValue()) {
                end = LocalDate.of(year, 12, 31);
            }
            QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBO);
            reimAmountBO.setHappenDatePeriod(new LocalDate[]{start, end});
            BigDecimal thisYearUsedAmount = quotaCtrlMode.getReimedAmount(reimAmountBO);
            thisYearUsedAmount = thisYearUsedAmount == null ? BigDecimal.ZERO : thisYearUsedAmount;
            row.set("thisyearusedamount", (Object)thisYearUsedAmount);
            reimAmountBO.setHappenDatePeriod(new HashMap());
            reimAmountBO.setHappenDate(yearMonth);
            BigDecimal thisTermAmount = quotaCtrlMode.getQuotaAmount(reimAmountBO);
            thisTermAmount = thisTermAmount == null ? BigDecimal.ZERO : thisTermAmount;
            row.set("thistermamount", (Object)thisTermAmount);
            BigDecimal thisTermUsedAmount = quotaCtrlMode.getReimedAmount(reimAmountBO);
            thisTermUsedAmount = thisTermUsedAmount == null ? BigDecimal.ZERO : thisTermUsedAmount;
            BigDecimal thisTermBalanceAmount = thisTermAmount.subtract(thisTermUsedAmount);
            if (BigDecimal.ZERO.compareTo(thisTermBalanceAmount) > 0) {
                thisTermBalanceAmount = BigDecimal.ZERO;
            }
            row.set("thistermbalanceamount", (Object)thisTermBalanceAmount);
        }
    }

    public void processRowData(DynamicObject v, ReportQueryParam queryParam) {
    }

    public static AbstractAmountQueryService getImplService(String entityId) {
        if (StringUtils.equals((String)"er_employee_amount_query", (String)entityId)) {
            return new EmployeeAmountQueryService();
        }
        if (StringUtils.equals((String)"er_finance_amount_query", (String)entityId)) {
            return new FinanceAmountQueryService();
        }
        return new FinanceAmountQueryService();
    }
}

