/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.amount.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.er.business.servicehelper.ErPermissionServiceHelper;
import kd.fi.er.report.amount.service.AbstractAmountQueryService;
import org.apache.commons.lang3.StringUtils;

public class DeptAmountQueryService
extends AbstractAmountQueryService {
    @Override
    public void processRowData(DynamicObject v, ReportQueryParam queryParam) {
        super.processRowDataForDepartmental(v, queryParam);
    }

    @Override
    public List<QFilter> getQFilters(ReportQueryParam queryParam) {
        List<QFilter> qFilters = super.getQFilters(queryParam);
        if (!qFilters.stream().anyMatch(filter -> "company.id".equals(filter.getProperty()))) {
            String appId = "em";
            FilterItemInfo appFilter = queryParam.getFilter().getFilterItem("appId");
            if (appFilter != null) {
                appId = (String)appFilter.getValue();
            }
            appId = (String)StringUtils.defaultIfBlank((CharSequence)appId, (CharSequence)"em");
            ErPermissionServiceHelper.setOrgFilterByPerm(qFilters, null, (String)appId, (String)"er_dept_reimctl_query", null);
        }
        List deptNameFilterInfos = queryParam.getFilter().getFilterItems("deptnamefilter.name");
        List deptNumberFilterInfos = queryParam.getFilter().getFilterItems("deptnumberfilter.number");
        ArrayList deptNameQFilters = Lists.newArrayList();
        if (deptNameFilterInfos != null) {
            for (int i = 0; i < deptNameFilterInfos.size(); ++i) {
                FilterItemInfo filter2 = (FilterItemInfo)deptNameFilterInfos.get(i);
                String propName = "dept.name";
                String compareType = filter2.getCompareType();
                Object value = filter2.getValue();
                deptNameQFilters.add(new QFilter(propName, compareType, value));
            }
        }
        ArrayList deptNumberQFilters = Lists.newArrayList();
        if (deptNumberFilterInfos != null) {
            for (int i = 0; i < deptNumberFilterInfos.size(); ++i) {
                FilterItemInfo filter3 = (FilterItemInfo)deptNumberFilterInfos.get(i);
                String propName = "dept.number";
                String compareType = filter3.getCompareType();
                Object value = filter3.getValue();
                deptNumberQFilters.add(new QFilter(propName, compareType, value));
            }
        }
        qFilters.addAll(deptNameQFilters);
        qFilters.addAll(deptNumberQFilters);
        if (qFilters != null && qFilters.size() > 0) {
            for (int i = 0; i < qFilters.size(); ++i) {
                QFilter qFilter = qFilters.get(i);
                if (!"deptnamefilter.name".equals(qFilter.getProperty()) && !"deptnumberfilter.number".equals(qFilter.getProperty())) continue;
                qFilters.remove(qFilter);
            }
        }
        qFilters.add(new QFilter("expenseitem.isreimburseamountctl", "=", (Object)"2"));
        return qFilters;
    }

    public List<Long> allCanShowCompanyList() {
        String permItemId = "47150e89000000ac";
        String userId = RequestContext.getOrCreate().getUserId();
        return PermissionServiceHelper.getAllPermissionOrgs((Long)Long.valueOf(userId), (String)"er_finance_amount_query", (String)permItemId);
    }
}

