/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.amount.service;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.report.amount.service.AbstractAmountQueryService;

public class DeptEmployeeQueryService
extends AbstractAmountQueryService {
    @Override
    public List<QFilter> getQFilters(ReportQueryParam queryParam) {
        List<QFilter> qFilters = super.getQFilters(queryParam);
        qFilters.add(new QFilter("dept", "in", this.getOrgList()));
        return qFilters;
    }

    @Override
    public void processRowData(DynamicObject v, ReportQueryParam queryParam) {
        super.processRowDataForDepartmental(v, queryParam);
    }

    private List<Long> getOrgList() {
        DynamicObject user = CommonServiceHelper.getUser((Long)CommonServiceHelper.getCurrentUserID());
        List<Object> allOrgList = Lists.newArrayList();
        if (user != null) {
            DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
            allOrgList = userEntrys.stream().map(userEntry -> (Long)userEntry.getDynamicObject("dpt").getPkValue()).collect(Collectors.toList());
        }
        return allOrgList;
    }
}

