/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.amount.service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.report.amount.service.AbstractAmountQueryService;

public class EmployeeAmountQueryService
extends AbstractAmountQueryService {
    @Override
    public List<QFilter> getQFilters(ReportQueryParam queryParam) {
        List<QFilter> qFilters = super.getQFilters(queryParam);
        String userId = RequestContext.getOrCreate().getUserId();
        if (userId == null) {
            userId = "0";
        }
        qFilters.add(new QFilter("employee", "=", (Object)Long.valueOf(userId)));
        return qFilters;
    }

    @Override
    public void processRowData(DynamicObject v, ReportQueryParam queryParam) {
        super.processRowDataForPersonal(v, queryParam);
    }

    public Set<Long> addConsignor(Long applierId, String billtype) {
        QFilter qFilter = new QFilter("trustee", "=", (Object)applierId);
        QFilter pFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilter, pFilter};
        DynamicObjectCollection result = QueryServiceHelper.query((String)"er_entrustreimburse", (String)"id,consignor,rentrustedscope,entrustedscope.FBaseDataId.number", (QFilter[])qFilters);
        HashSet<Long> applierIds = new HashSet<Long>();
        applierIds.add(applierId);
        for (DynamicObject entry : result) {
            EmployeeAmountQueryService.addConsignor(applierIds, billtype, entry);
        }
        return applierIds;
    }

    private static void addConsignor(Set<Long> applierIds, String billtype, DynamicObject entrustReimburse) {
        String rentrustedscope = (String)entrustReimburse.get("rentrustedscope");
        Map billTypes = BusinessDataServiceHelper.loadFromCache((String)"er_billtype", (String)"number,name", null);
        String[] rentrustedscopeArray = rentrustedscope.split(";");
        List<String> rentrustedscopeList = Arrays.asList(rentrustedscopeArray);
        for (Map.Entry billType : billTypes.entrySet()) {
            Long consignor;
            if (!StringUtils.equals((CharSequence)((DynamicObject)billType.getValue()).getString("number"), (CharSequence)billtype) || !rentrustedscopeList.contains(((DynamicObject)billType.getValue()).getLocaleString("name").getLocaleValue_zh_CN()) || (consignor = Long.valueOf(entrustReimburse.getLong("consignor"))) == null) continue;
            applierIds.add(consignor);
        }
    }
}

