/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.plugin;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.CustomOrgFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.OrgServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.util.AmountQueryAndReimburseUtils;
import kd.fi.er.report.amount.service.DeptAmountQueryService;

public class DeptAmountQueryReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(DeptAmountQueryReportPlugin.class);
    private FilterContainerInitEvent contInitEvent = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName;
        int rowIndex = event.getRowIndex();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        switch (fieldName = event.getFieldName()) {
            case "yeartotalamount": {
                this.showDeptAmountPage(rowData);
                break;
            }
            case "thisyearusedamount": {
                Optional<QFilter> billKindFilterOptional = reportModel.getReportQueryParam().getFilter().getQFilters().stream().filter(q -> "billkind_filter".equals(q.getProperty())).findAny();
                this.showReimburseAmountUseDetail(rowData, billKindFilterOptional);
                break;
            }
            case "thistermbalanceamount": {
                this.showDailyReimburseBillPage(rowData);
                break;
            }
        }
    }

    private void showReimburseAmountUseDetail(DynamicObject rowData, Optional<QFilter> billKindFilterOptional) {
        IReportView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u90e8\u95e8\u989d\u5ea6", (String)"DeptAmountQueryReportPlugin_0", (String)"fi-er-report", (Object[])new Object[0]));
        showParameter.setFormId("er_reimctl_usedetail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setHasRight(true);
        QuotaAmountBO reimAmountBO = new QuotaAmountBO();
        reimAmountBO.setCompanyId(ErCommonUtils.getPk((Object)rowData.getDynamicObject("company")));
        reimAmountBO.setUserOrDeptId(ErCommonUtils.getPk((Object)rowData.getDynamicObject("dept")));
        String deptCtrlCurrency = SystemParamterUtil.getDeptCtlCurrency((Long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("company")));
        QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)deptCtrlCurrency, (Long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("currency")), (Long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("currency")));
        QuotaCtrlUtil.genQuotaExpItem((QuotaAmountBO)reimAmountBO, (Long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("expenseitem")));
        String deptCltBillStr = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)rowData.getDynamicObject("company")), (String)"deptquotaapplicablebill");
        List<String> deptCltList = Arrays.asList(deptCltBillStr.split(","));
        reimAmountBO.setDeptCtlBill(deptCltList);
        reimAmountBO.setHappenYear(Integer.valueOf(rowData.getString("year")));
        showParameter.setCustomParam("reimAmountQueryBean", (Object)reimAmountBO);
        showParameter.setCustomParam("isDeptAmount", (Object)true);
        view.showForm(showParameter);
    }

    private void showDeptAmountPage(DynamicObject rowData) {
        Object pkValue = rowData.get("id");
        IReportView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setPkId(pkValue);
        parameter.setCaption(ResManager.loadKDString((String)"\u90e8\u95e8\u989d\u5ea6", (String)"DeptAmountQueryReportPlugin_0", (String)"fi-er-report", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("er_dept_reimctl");
        parameter.setStatus(OperationStatus.VIEW);
        view.showForm((FormShowParameter)parameter);
    }

    private void showDailyReimburseBillPage(DynamicObject rowData) {
        Boolean isBizUnit;
        DynamicObject expenseItem = rowData.getDynamicObject("expenseitem");
        BigDecimal balanceamount = rowData.getBigDecimal("thistermbalanceamount");
        DynamicObject companyDO = rowData.getDynamicObject("company");
        DynamicObject deptDO = rowData.getDynamicObject("dept");
        DynamicObject currencyDO = rowData.getDynamicObject("currency");
        Long deptId = (Long)deptDO.getPkValue();
        Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId((Long)deptId, (Boolean)(isBizUnit = Boolean.valueOf(true)));
        if (accountOrgId == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d39\u7528\u627f\u62c5\u516c\u53f8\u3002\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DeptAmountQueryReportPlugin_1", (String)"fi-er-report", (Object[])new Object[0]));
            return;
        }
        AmountQueryAndReimburseUtils.CreateDailyReimburseByDeptReimParam param = new AmountQueryAndReimburseUtils.CreateDailyReimburseByDeptReimParam();
        param.setFormPlugin((AbstractFormPlugin)this);
        param.setBalanceAmount(balanceamount);
        param.setCompanyId(companyDO.getPkValue());
        param.setCurrencyId(currencyDO.getPkValue());
        param.setExpenseItemId(expenseItem.getPkValue());
        param.setHappendDate(AmountQueryAndReimburseUtils.getHappendDateInReimCtlReport((ReportQueryParam)this.getQueryParam()));
        param.setUserId((Object)CommonServiceHelper.getCurrentUserID());
        param.setDeptId(deptDO.getPkValue());
        AmountQueryAndReimburseUtils.createDailyReimburseByDeptReim((AmountQueryAndReimburseUtils.CreateDailyReimburseByDeptReimParam)param);
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        this.contInitEvent = contInitEvent;
        List filterColumnList = contInitEvent.getCommonFilterColumns();
        IPageCache pCache = this.getPageCache();
        super.filterContainerInit(contInitEvent, queryParam);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.setPageRows(40);
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        commonFilterColumns.forEach(v -> {
            String isFirstLoad;
            if (StringUtils.equals((CharSequence)v.getFieldName(), (CharSequence)"dateyear_filter")) {
                CommonFilterColumn c = (CommonFilterColumn)v;
                ArrayList comboItems = Lists.newArrayListWithExpectedSize((int)4);
                for (int i = 0; i <= 2; ++i) {
                    ComboItem comboItem = new ComboItem();
                    LocaleString caption = null;
                    String value = null;
                    if (i == 0) {
                        caption = new LocaleString(ResManager.loadKDString((String)"\u4eca\u5e74(\u4e0a\u6708)", (String)"DeptAmountQueryReportPlugin_5", (String)"fi-er-report", (Object[])new Object[0]));
                        value = Year.now().getValue() + "_LM";
                    }
                    if (i == 1) {
                        caption = new LocaleString(ResManager.loadKDString((String)"\u4eca\u5e74(\u672c\u6708)", (String)"DeptAmountQueryReportPlugin_6", (String)"fi-er-report", (Object[])new Object[0]));
                        value = Year.now().getValue() + "_TM";
                    }
                    if (i == 2) {
                        caption = new LocaleString(ResManager.loadKDString((String)"\u53bb\u5e74", (String)"DeptAmountQueryReportPlugin_7", (String)"fi-er-report", (Object[])new Object[0]));
                        value = Year.now().minusYears(1L).getValue() + "";
                    }
                    comboItem.setCaption(caption);
                    comboItem.setValue(value);
                    comboItem.setId(i + "");
                    comboItems.add(comboItem);
                }
                c.setComboItems((List)comboItems);
                v.setDefaultValue(Year.now().getValue() + "_LM");
                c.setMulti(false);
            }
            if (StringUtils.equals((CharSequence)v.getFieldName(), (CharSequence)"company_filter") && v instanceof CustomOrgFilterColumn) {
                CustomOrgFilterColumn orgFC = (CustomOrgFilterColumn)v;
                orgFC.setMulti(false);
                String isFirstLoad2 = pCache.get("isFirstLoadPage");
                if (StringUtils.isBlank((CharSequence)isFirstLoad2)) {
                    FilterColumn companyFilterCol = filterColumnList.stream().filter(fc -> fc.getFieldName().equals("company_filter")).findFirst().get();
                    List comboItems = ((CustomOrgFilterColumn)companyFilterCol).getComboItems();
                    long orgId = RequestContext.get().getOrgId();
                    String orgIdStr = orgId + "";
                    boolean anyMatch = comboItems.stream().anyMatch(u -> u.getValue().equals(orgIdStr));
                    String defaultCompanyId = "";
                    if (anyMatch) {
                        defaultCompanyId = orgIdStr;
                    } else if (comboItems.size() > 0) {
                        defaultCompanyId = ((ComboItem)comboItems.get(0)).getValue();
                    }
                    if (!StringUtils.isEmpty((CharSequence)defaultCompanyId)) {
                        orgFC.setDefaultValue(defaultCompanyId);
                    }
                    this.putDeptCache(defaultCompanyId);
                }
            }
            if (StringUtils.equals((CharSequence)v.getFieldName(), (CharSequence)"dept_filter") && v instanceof CustomOrgFilterColumn && StringUtils.isBlank((CharSequence)(isFirstLoad = pCache.get("isFirstLoadPage")))) {
                this.setDeptFilterItem();
                pCache.put("isFirstLoadPage", "false");
            }
        });
    }

    private void putDeptCache(String companyIdStr) {
        IPageCache pCache = this.getPageCache();
        long companyId = OrgUnitServiceHelper.getRootOrgId();
        if (StringUtils.isNotBlank((CharSequence)companyIdStr)) {
            companyId = Long.parseLong(companyIdStr);
        }
        List allOrgList = OrgServiceHelper.getAllSubOrgWithoutCompany((Long)companyId);
        allOrgList.add(companyId);
        List<Object> oldAllOrgList = Lists.newArrayList();
        String deptIds = this.getPageCache().get("deptIds");
        oldAllOrgList = StringUtils.isNotBlank((CharSequence)deptIds) ? JSON.parseArray((String)deptIds, Long.class) : this.getOrgList();
        if (oldAllOrgList.size() != allOrgList.size() || !oldAllOrgList.equals(allOrgList)) {
            pCache.put("deptIds", JSON.toJSONString((Object)allOrgList));
        }
    }

    private void setDeptFilterItem() {
        List filterColumnList = this.contInitEvent.getCommonFilterColumns();
        if (filterColumnList == null || filterColumnList.isEmpty()) {
            return;
        }
        StringBuilder loginfo = new StringBuilder("filterColumnLists:");
        loginfo.append(filterColumnList.toString());
        log.info(loginfo.toString());
        CustomOrgFilterColumn deptFilterCol = filterColumnList.stream().filter(filterCol -> StringUtils.equals((CharSequence)filterCol.getFieldName(), (CharSequence)"dept_filter")).findFirst().orElse(null);
        if (deptFilterCol == null) {
            return;
        }
        List<ComboItem> deptComboItems = this.getDeptComboItems();
        deptFilterCol.setComboItems(deptComboItems);
        deptFilterCol.setDefaultValue("");
        deptFilterCol.setMulti(false);
    }

    private List<ComboItem> getDeptComboItems() {
        List<Object> allOrgList = Collections.emptyList();
        String deptIds = this.getPageCache().get("deptIds");
        allOrgList = StringUtils.isNotBlank((CharSequence)deptIds) ? JSON.parseArray((String)deptIds, Long.class) : this.getOrgList();
        DynamicObjectCollection orgDOs = QueryServiceHelper.query((String)"bos_org", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)allOrgList)});
        HashMap<Long, String> orgIdToName = new HashMap<Long, String>();
        if (orgDOs != null && orgDOs.size() > 0) {
            for (DynamicObject obj : orgDOs) {
                orgIdToName.put(obj.getLong("id"), obj.getString("name"));
            }
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(allOrgList.size());
        ComboItem empty = new ComboItem();
        empty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"DeptAmountQueryReportPlugin_4", (String)"fi-er-report", (Object[])new Object[0])));
        empty.setValue("");
        combos.add(empty);
        for (Long l : allOrgList) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString((String)orgIdToName.get(l)));
            item.setValue(String.valueOf(l));
            combos.add(item);
        }
        return combos;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List customFiterList = (List)args.getSearchClickEvent().getFilterValues().get("customfilter");
        if (customFiterList == null) {
            return;
        }
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        List fieldNames = (List)searchClickEvent.getCurrentCommonFilter().get("FieldName");
        List values = (List)searchClickEvent.getCurrentCommonFilter().get("Value");
        String fieldName = (String)fieldNames.get(0);
        String value = (String)values.get(0);
        for (Map map : customFiterList) {
            if (!StringUtils.equals((CharSequence)((List)map.get("FieldName")).get(0).toString(), (CharSequence)"company_filter.id")) continue;
            this.putDeptCache(((List)map.get("Value")).get(0).toString());
        }
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"company_filter.id")) {
            this.putDeptCache(value);
        }
        this.setDeptFilterItem();
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"dept_filter.id")) {
            List allOrgList = Collections.emptyList();
            String deptIds = this.getPageCache().get("deptIds");
            if (StringUtils.isNotBlank((CharSequence)deptIds)) {
                allOrgList = JSON.parseArray((String)deptIds, Long.class);
            }
            if (!allOrgList.isEmpty()) {
                args.getQfilters().add(new QFilter("id", "in", (Object)allOrgList));
            }
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"company_filter.id")) {
            List allOrgList = Collections.emptyList();
            String companyIds = this.getPageCache().get("companyIds");
            if (StringUtils.isNotBlank((CharSequence)companyIds)) {
                allOrgList = JSON.parseArray((String)companyIds, Long.class);
            }
            if (!allOrgList.isEmpty()) {
                args.getQfilters().add(new QFilter("id", "in", (Object)allOrgList));
            }
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        DeptAmountQueryService service = new DeptAmountQueryService();
        rowData.forEach(v -> service.processRowData((DynamicObject)v, queryParam));
    }

    private List<Long> getOrgList() {
        DynamicObject user = CommonServiceHelper.getUser((Long)CommonServiceHelper.getCurrentUserID());
        List<Object> allOrgList = Lists.newArrayList();
        if (user != null) {
            DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
            allOrgList = userEntrys.stream().map(userEntry -> (Long)userEntry.getDynamicObject("dpt").getPkValue()).collect(Collectors.toList());
        }
        return allOrgList;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        queryParam.getFilter().addFilterItem("appId", (Object)this.getView().getFormShowParameter().getAppId(), "=");
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("tra".equals(appId) || "cexp".equals(appId)) {
            for (AbstractReportColumn column : event.getColumns()) {
                if (!"thistermbalanceamount".equals(((ReportColumn)column).getFieldKey())) continue;
                ((ReportColumn)column).setHyperlink(false);
            }
        }
    }
}

