/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CustomOrgFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;

public class ErUnReimbursementOrderPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"configurereport"});
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        Object orderNumber = rowData.get("ordernum");
        Object orderType = rowData.get("operationtypecol");
        if (orderNumber != null) {
            String FormId = "";
            IErDao dao = null;
            if ("1".equals(orderType) || "4".equals(orderType)) {
                FormId = "er_hotelbill";
            } else if ("2".equals(orderType) || "5".equals(orderType)) {
                FormId = "er_planebill";
            } else if ("3".equals(orderType)) {
                FormId = "er_vehiclebill";
            } else if ("6".equals(orderType)) {
                FormId = "er_trainbill";
            } else if ("8".equals(orderType)) {
                FormId = "er_mealbill";
            }
            dao = ErDaoFactory.getInstance((String)FormId);
            DynamicObject order = dao.queryOne("id", new QFilter("orderNum", "=", orderNumber));
            if (order != null) {
                this.openLinkedForm(order.getPkValue(), FormId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u64cd\u4f5c\u3002", (String)"ErUnReimbursementOrderPlugin_0", (String)"fi-er-report", (Object[])new Object[0]));
            }
        }
    }

    private void openLinkedForm(Object pkValue, String FormId) {
        IReportView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(FormId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        commonFilterColumns.forEach(v -> {
            if (StringUtils.equals((CharSequence)v.getFieldName(), (CharSequence)"company")) {
                CustomOrgFilterColumn orgFC = (CustomOrgFilterColumn)v;
                List filterColumnList = contInitEvent.getCommonFilterColumns();
                FilterColumn companyFilterCol = filterColumnList.stream().filter(fc -> fc.getFieldName().equals("company")).findFirst().get();
                List comboItems = ((CustomOrgFilterColumn)companyFilterCol).getComboItems();
                long orgId = RequestContext.get().getOrgId();
                String orgIdStr = orgId + "";
                boolean anyMatch = comboItems.stream().anyMatch(u -> u.getValue().equals(orgIdStr));
                String defaultCompanyId = "";
                if (anyMatch) {
                    defaultCompanyId = orgIdStr;
                } else if (comboItems.size() > 0) {
                    defaultCompanyId = ((ComboItem)comboItems.get(0)).getValue();
                }
                if (!StringUtils.isEmpty((CharSequence)defaultCompanyId)) {
                    orgFC.setDefaultValue(defaultCompanyId);
                }
            }
        });
    }
}

