/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.CustomOrgFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.SummaryEvent;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.er.business.isc.IscHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.task.report.SyncReimburseExpense;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;
import kd.fi.er.report.DetailReportQueryUtil;
import kd.fi.er.report.treerpt.TreeQueryParam;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

public class ExpenseDetailReportPlugin
extends AbstractReportFormPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(ExpenseDetailReportPlugin.class);
    private static final Set<String> EQUAL_QUERY_ELE = Collections.unmodifiableSet(Stream.of("showtype", "pcurrency", "pstatisticalperiod").collect(Collectors.toSet()));

    public void initialize() {
        super.initialize();
        DetailReportQueryUtil.setAppId(this.getView().getFormShowParameter().getAppId());
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        List filterItems = filterInfo.getFilterItems();
        Function<FilterItemInfo, String> getPropNameFun = item -> item.getPropName().split("\\.")[0];
        String errMsg = filterInfo.getFilterItems().stream().filter(item -> EQUAL_QUERY_ELE.contains(getPropNameFun.apply((FilterItemInfo)item)) && (!org.apache.commons.lang3.StringUtils.equals((CharSequence)"=", (CharSequence)item.getCompareType()) || !(item.getValue() instanceof String) && !(item.getValue() instanceof Long))).map(item -> ((SchemeFilterColumn)this.getView().getControl((String)getPropNameFun.apply((FilterItemInfo)item))).getCaption().getLocaleValue()).distinct().collect(Collectors.joining(","));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errMsg)) {
            errMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u5f55\u5165\uff0c%1$s\u67e5\u8be2\u63a7\u4ef6\u4ec5\u652f\u6301\"\u7b49\u4e8e\"\u6761\u4ef6\u67e5\u8be2\u3002", (String)"ExpenseDetailReportPlugin_9", (String)"fi-er-report", (Object[])new Object[0]), errMsg);
            throw new KDBizException(errMsg);
        }
        Map<String, Long> repeatFillterMap = filterItems.stream().filter(item -> EQUAL_QUERY_ELE.contains(getPropNameFun.apply((FilterItemInfo)item))).collect(Collectors.groupingBy(getPropNameFun::apply, Collectors.counting()));
        errMsg = repeatFillterMap.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(entry -> ((SchemeFilterColumn)this.getView().getControl((String)entry.getKey())).getCaption().getLocaleValue()).collect(Collectors.joining(","));
        if (StringUtils.isNotBlank((String)errMsg)) {
            errMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u5220\u9664\u591a\u4f59\u7684\u67e5\u8be2\u6761\u4ef6\uff0c%1$s\u67e5\u8be2\u63a7\u4ef6\u4e0d\u652f\u6301\u91cd\u590d\u6dfb\u52a0\u3002", (String)"ExpenseDetailReportPlugin_8", (String)"fi-er-report", (Object[])new Object[0]), errMsg);
            throw new KDBizException(errMsg);
        }
        queryParam.getFilter().addFilterItem("appId", (Object)this.getView().getFormShowParameter().getAppId(), "=");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "syncupdate"});
        AbstractGrid abstractGrid = (AbstractGrid)this.getView().getControl("reportlistap");
        abstractGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        this.initfilterContainerParam(contInitEvent);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get("afterinit"))) {
            this.getView().getPageCache().put("afterinit", "true");
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        this.resolvestatisticalAmt(event);
        FilterItemInfo dimension = event.getQueryParam().getFilter().getFilterItem("pstatisticaldimension");
        ArrayList<Object> groupbys = new ArrayList<Object>(2);
        if (dimension != null) {
            if (dimension.getValue() instanceof String) {
                groupbys.add(dimension.getValue());
            } else if (dimension.getValue() instanceof List) {
                groupbys.addAll((List)dimension.getValue());
            }
        }
        ArrayList<String> list = new ArrayList<String>(8);
        list.addAll(Arrays.asList("expenseitem", "travelitem", "stdproject", "org", "company", "costdept", "costcompany", "applier", "expenseitemnumber", "travelitemnumber", "stdprojectnumber", "orgnumber", "companynumber", "costdeptnumber", "costcompanynumber", "appliernumber"));
        ArrayList groupbyNumber = new ArrayList(1);
        groupbys.forEach(e -> groupbyNumber.add(e + "number"));
        groupbys.addAll(groupbyNumber);
        list.removeAll(groupbys);
        Iterator iterator = event.getColumns().iterator();
        while (iterator.hasNext()) {
            AbstractReportColumn column = (AbstractReportColumn)iterator.next();
            if (!list.contains(((ReportColumn)column).getFieldKey())) continue;
            iterator.remove();
        }
    }

    private void resolvestatisticalAmt(CreateColumnEvent event) {
        FilterItemInfo item = event.getQueryParam().getFilter().getFilterItem("pstatisticamt");
        if (item == null) {
            return;
        }
        ArrayList fieldsList = null;
        fieldsList = item.getValue() instanceof String ? Lists.newArrayList((Object[])new String[]{item.getValue().toString()}) : (ArrayList)item.getValue();
        HashSet fieldSet = Sets.newHashSet((Object[])new String[]{"entryamount", "currapprove", "inorder", "finished", "currapprovenotax", "currtaxamt"});
        fieldSet.removeAll(fieldsList);
        Iterator iterator = event.getColumns().iterator();
        while (iterator.hasNext()) {
            AbstractReportColumn column = (AbstractReportColumn)iterator.next();
            if (!fieldSet.contains(((ReportColumn)column).getFieldKey())) continue;
            iterator.remove();
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        block13: {
            String pstatisticalperiod;
            block14: {
                String four;
                String three;
                String two;
                String one;
                String year;
                block12: {
                    super.processRowData(gridPK, rowData, queryParam);
                    year = ResManager.loadKDString((String)"\u5e74", (String)"ExpenseDetailReportPlugin_2", (String)"fi-er-report", (Object[])new Object[0]);
                    one = ResManager.loadKDString((String)"\u7b2c\u4e00\u5b63\u5ea6", (String)"ExpenseDetailReportPlugin_3", (String)"fi-er-report", (Object[])new Object[0]);
                    two = ResManager.loadKDString((String)"\u7b2c\u4e8c\u5b63\u5ea6", (String)"ExpenseDetailReportPlugin_4", (String)"fi-er-report", (Object[])new Object[0]);
                    three = ResManager.loadKDString((String)"\u7b2c\u4e09\u5b63\u5ea6", (String)"ExpenseDetailReportPlugin_5", (String)"fi-er-report", (Object[])new Object[0]);
                    four = ResManager.loadKDString((String)"\u7b2c\u56db\u5b63\u5ea6", (String)"ExpenseDetailReportPlugin_6", (String)"fi-er-report", (Object[])new Object[0]);
                    if (!(queryParam.getFilter().getFilterItem("pstatisticalperiod").getValue() instanceof String)) {
                        return;
                    }
                    pstatisticalperiod = (String)queryParam.getFilter().getFilterItem("pstatisticalperiod").getValue();
                    if (!"1".equals(pstatisticalperiod)) break block12;
                    for (DynamicObject rowDatum : rowData) {
                        String statisticalperiod = rowDatum.getString("statisticalperiod");
                        if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)statisticalperiod)) continue;
                        statisticalperiod = statisticalperiod + year;
                        rowDatum.set("statisticalperiodv", (Object)statisticalperiod);
                    }
                    break block13;
                }
                if (!"2".equals(pstatisticalperiod)) break block14;
                for (DynamicObject rowDatum : rowData) {
                    String statisticalperiod = rowDatum.getString("statisticalperiod");
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)statisticalperiod)) {
                        StringBuilder sb = new StringBuilder(statisticalperiod.substring(0, 4)).append(year);
                        if (statisticalperiod.endsWith("1")) {
                            statisticalperiod = sb.append(one).toString();
                        } else if (statisticalperiod.endsWith("2")) {
                            statisticalperiod = sb.append(two).toString();
                        } else if (statisticalperiod.endsWith("3")) {
                            statisticalperiod = sb.append(three).toString();
                        } else if (statisticalperiod.endsWith("4")) {
                            statisticalperiod = sb.append(four).toString();
                        }
                    }
                    rowDatum.set("statisticalperiodv", (Object)statisticalperiod);
                }
                break block13;
            }
            if (!"3".equals(pstatisticalperiod)) break block13;
            for (DynamicObject rowDatum : rowData) {
                String statisticalperiod = rowDatum.getString("statisticalperiod");
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)statisticalperiod)) continue;
                statisticalperiod = statisticalperiod.substring(0, 4) + "-" + statisticalperiod.substring(4);
                rowDatum.set("statisticalperiodv", (Object)statisticalperiod);
            }
        }
    }

    private void open(DynamicObject currentRow, QFilter statsQfilter) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setBillFormId("er_expense_detaildata");
        formShowParameter.setFormId("bos_list");
        List<QFilter> qFilterList = DetailReportQueryUtil.getQfilter(this.getQueryParam().getFilter());
        qFilterList.add(statsQfilter);
        if (currentRow != null) {
            if (Boolean.TRUE.equals(currentRow.get("isgroupnode"))) {
                DynamicObject costcompany = currentRow.getDynamicObject("costcompany");
                if (costcompany != null) {
                    List allSubordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((String)"10", (List)Lists.newArrayList((Object[])new Long[]{(Long)costcompany.getPkValue()}), (boolean)true);
                    qFilterList.add(new QFilter("costcompany", "in", (Object)allSubordinateOrgs));
                }
            } else {
                FilterItemInfo filterItemInfo = this.getQueryParam().getFilter().getFilterItem("pstatisticaldimension");
                String[] groups = new String[]{};
                if (filterItemInfo != null) {
                    if (filterItemInfo.getValue() instanceof String) {
                        groups = new String[]{filterItemInfo.getValue().toString()};
                    } else if (filterItemInfo.getValue() instanceof List) {
                        groups = ((List)filterItemInfo.getValue()).toArray(new String[0]);
                    }
                }
                qFilterList.addAll(this.resolveCurrentRow(currentRow, Arrays.asList(groups)));
            }
        }
        formShowParameter.setHasRight(true);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("fromReport", "true");
        formShowParameter.setCustomParams(map);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u6570\u636e", (String)"ExpenseDetailReportPlugin_7", (String)"fi-er-report", (Object[])new Object[0]));
        formShowParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.getListFilterParameter().getQFilters().addAll(qFilterList);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private List<QFilter> resolveCurrentRow(DynamicObject currentRow, List list) {
        List<Date> l;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        for (Object s : list) {
            String key = s + "_id";
            Object value = currentRow.get(key);
            qFilterList.add(new QFilter(s + ".id", "=", value));
        }
        Integer value = currentRow.getInt("statisticalperiod");
        if (value != null && (l = this.resolveStatisticalperiod(String.valueOf(value))).size() > 0) {
            Map<String, Date> mapDate = this.getConditionDate();
            for (int i = 0; i < 2; ++i) {
                Date d = l.get(i);
                if (i == 0) {
                    qFilterList.add(new QFilter("bizdate", ">=", (Object)d));
                }
                if (i != 1) continue;
                qFilterList.add(new QFilter("bizdate", "<=", (Object)d));
            }
        }
        return qFilterList;
    }

    private List<Date> resolveStatisticalperiod(String value) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
            return new ArrayList<Date>();
        }
        Date begin = null;
        Date end = null;
        try {
            if (value != null && value.length() == 4) {
                begin = DateUtils.parseDate((String)(value + "0101"), (String[])new String[]{"yyyyMMdd"});
                end = DateUtils.parseDate((String)(value + "1231"), (String[])new String[]{"yyyyMMdd"});
            } else if (value != null && value.length() == 5) {
                Integer quarter = Integer.valueOf(value.substring(4));
                String year = value.substring(0, 4);
                if (quarter == 1) {
                    begin = DateUtils.parseDate((String)(year + "0101"), (String[])new String[]{"yyyyMMdd"});
                    end = DateUtils.parseDate((String)(year + "0331"), (String[])new String[]{"yyyyMMdd"});
                } else if (quarter == 2) {
                    begin = DateUtils.parseDate((String)(year + "0401"), (String[])new String[]{"yyyyMMdd"});
                    end = DateUtils.parseDate((String)(year + "0630"), (String[])new String[]{"yyyyMMdd"});
                } else if (quarter == 3) {
                    begin = DateUtils.parseDate((String)(year + "0701"), (String[])new String[]{"yyyyMMdd"});
                    end = DateUtils.parseDate((String)(year + "0930"), (String[])new String[]{"yyyyMMdd"});
                } else if (quarter == 4) {
                    begin = DateUtils.parseDate((String)(year + "1001"), (String[])new String[]{"yyyyMMdd"});
                    end = DateUtils.parseDate((String)(year + "1230"), (String[])new String[]{"yyyyMMdd"});
                }
            } else if (value != null && value.length() == 6) {
                begin = DateUtils.parseDate((String)(value + "01"), (String[])new String[]{"yyyyMMdd"});
                end = this.getLastDayOfMonth(value + "01");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u7edf\u8ba1\u5468\u671f\u5b57\u6bb5\u8f6c\u6362\u4e3a\u65f6\u95f4\u8303\u56f4\u5931\u8d25\u3002", (String)"ExpenseDetailReportPlugin_11", (String)"fi-er-report", (Object[])new Object[0]));
        }
        ArrayList<Date> list = new ArrayList<Date>(2);
        list.add(begin);
        list.add(end);
        return list;
    }

    private boolean isEmptyDefValue(FilterColumn commonFilterColumn) {
        CommonFilterColumn filterColumn = (CommonFilterColumn)commonFilterColumn;
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)filterColumn.getDefValue());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("syncupdate".equals(itemKey)) {
            if (SyncReimburseExpense.existSyncTask()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u6267\u884c\u540c\u6b65\u4efb\u52a1\uff0c\u524d\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AbstrackSyncData_1", (String)"fi-er-business", (Object[])new Object[0]));
                return;
            }
            FormModel formModel = new FormModel("er_expense_data_upsync", null, "14", true, new HashMap(4));
            ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
        } else if ("exportdetail".equals(itemKey)) {
            this.open(null, DetailReportQueryUtil.getInOrderStatus().or(DetailReportQueryUtil.getFinishedStatus()));
        } else if ("importdts".equals(itemKey)) {
            try {
                IscHelper.checkExistBefore((IFormView)this.getView(), (boolean)true);
            }
            catch (Exception e) {
                logger.error("ExpenseDetailReportPlugin>>>beforeItemClick:\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a", (Throwable)e);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        try {
            IscHelper.importConfirmCallBack((MessageBoxClosedEvent)evt, (IFormView)this.getView());
        }
        catch (IOException e) {
            logger.error("ExpenseDetailReportPlugin>>>confirmCallBack:\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a", (Throwable)e);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object value;
        super.closedCallBack(closedCallBackEvent);
        if ("er_expense_data_upsync".equals(closedCallBackEvent.getActionId()) && (value = closedCallBackEvent.getReturnData()) != null && ((Boolean)value).booleanValue()) {
            FormModel formModel = new FormModel("er_progressbar_inh", null, "14", true, new HashMap(4));
            ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName;
        int rowIndex = event.getRowIndex();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        rowData = event.getRowData();
        switch (fieldName = event.getFieldName()) {
            case "inorder": 
            case "inorder_notax": {
                this.open(rowData, DetailReportQueryUtil.getInOrderStatus());
                break;
            }
            case "finished": 
            case "finished_notax": {
                this.open(rowData, DetailReportQueryUtil.getFinishedStatus());
                break;
            }
            case "currapprovenotax": {
                this.open(rowData, DetailReportQueryUtil.getCurrApproveStatus());
                break;
            }
            case "currtaxamt": {
                this.open(rowData, DetailReportQueryUtil.getTaxStatus());
                break;
            }
            case "currapprove": 
            case "entryamount": {
                this.open(rowData, DetailReportQueryUtil.getInOrderStatus().or(DetailReportQueryUtil.getFinishedStatus()));
                break;
            }
        }
    }

    private Map<String, Date> getConditionDate() {
        HashMap<String, Date> map = new HashMap<String, Date>(2);
        List<QFilter> qFilterList = DetailReportQueryUtil.getQfilter(this.getQueryParam().getFilter());
        Optional<QFilter> qFilter = qFilterList.stream().filter(e -> e.getProperty().equals("bizdate") && e.getCP().contains(">")).findFirst();
        Optional<QFilter> endQFilter = qFilterList.stream().filter(e -> e.getProperty().equals("bizdate") && e.getCP().contains("<")).findFirst();
        if (qFilter.isPresent()) {
            map.put("begin", (Date)qFilter.get().getValue());
        }
        if (endQFilter.isPresent()) {
            map.put("end", (Date)endQFilter.get().getValue());
        }
        return map;
    }

    private void initCompanyComboitem(FilterColumn filterColumn, List<Long> companyIds) {
        if (companyIds == null || companyIds.size() == 0) {
            return;
        }
        logger.info("\u7ec4\u7ec7\u96c6\u5408\uff1a {}", companyIds);
        DynamicObjectCollection orgDOs = QueryServiceHelper.query((String)"bos_org", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", companyIds)});
        HashMap orgIdToName = Maps.newHashMapWithExpectedSize((int)companyIds.size());
        orgDOs.forEach(e -> {
            Long orgid = e.getLong("id");
            String orgName = e.getString("name");
            if (orgid != null) {
                orgIdToName.put(orgid, orgName == null ? String.valueOf(orgid) : orgName);
            }
        });
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(companyIds.size() + 1);
        ComboItem empty = new ComboItem();
        empty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"ShowCompanyListPlugin_0", (String)"fi-er-report", (Object[])new Object[0])));
        empty.setValue("");
        combos.add(empty);
        for (Long orgId : companyIds) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString((String)orgIdToName.get(orgId)));
            item.setValue(String.valueOf(orgId));
            combos.add(item);
        }
        if (filterColumn instanceof CustomOrgFilterColumn) {
            ((CustomOrgFilterColumn)filterColumn).setComboItems(combos);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        String permissionField = MetadataServiceHelper.getDataEntityType((String)this.getView().getEntityId()).getPermissionControlType().getDataDimensionField();
        if (fieldName.startsWith("p" + permissionField) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.getView().getFormShowParameter().getAppId())) {
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = StringUtils.isNotEmpty((String)appId) ? appId : "em";
            String orgViewType = StringUtils.equals((String)permissionField, (String)"costcompany") ? "10" : "01";
            List ids = PermissionServiceHelper.getAllPermOrgs((long)CommonServiceHelper.getCurrentUserID(), (String)orgViewType, (String)appId, (String)this.getView().getFormShowParameter().getFormId(), (String)"47150e89000000ac", (boolean)true).getHasPermOrgs();
            if (ids != null && ids.size() > 0) {
                args.getQfilters().add(new QFilter("id", "in", (Object)ids));
            }
        }
    }

    private void initfilterContainerParam(FilterContainerInitEvent contInitEvent) {
        Long accountOrgOfLoginOrg;
        Long loginOrg;
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        DynamicObject user = CommonServiceHelper.getUser((Long)Long.parseLong(RequestContext.get().getUserId()));
        DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
        List masterJobs = userEntrys.stream().filter(e -> (Boolean)e.get("ispartjob") == false).collect(Collectors.toList());
        Long deptId = null;
        if (masterJobs != null && masterJobs.size() > 0 && ((DynamicObject)masterJobs.get(0)).get("dpt") != null) {
            deptId = ErCommonUtils.getPk((Object)((DynamicObject)masterJobs.get(0)).get("dpt"));
        }
        Long company = null;
        Long costCompany = null;
        Long currencyId = null;
        if (!(deptId == null || (currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)(company = CoreBaseBillServiceHelper.initCompanyByDept(deptId)), (Object)(costCompany = CoreBaseBillServiceHelper.getAccountOrgId((boolean)false, deptId)))) != null && currencyId != 0L || (currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)(loginOrg = Long.valueOf(RequestContext.get().getOrgId())), (Object)(accountOrgOfLoginOrg = CoreBaseBillServiceHelper.getAccountOrgId((boolean)false, (Long)loginOrg)))) != null && currencyId != 0L)) {
            DynamicObject CNYCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1L), new QFilter("enable", "=", (Object)true)});
            if (CNYCurrency != null) {
                currencyId = CNYCurrency.getLong("id");
            } else {
                DynamicObject enableCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)});
                currencyId = enableCurrency.getLong("id");
            }
        }
        String permissionField = MetadataServiceHelper.getDataEntityType((String)this.getView().getEntityId()).getPermissionControlType().getDataDimensionField();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            if (this.isEmptyDefValue(commonFilterColumn) && commonFilterColumn.getDefaultValues().size() == 0) {
                if ("pcostcompany".equalsIgnoreCase(fieldName) && costCompany != null) {
                    this.initCostCompanyComboitem(commonFilterColumn);
                    commonFilterColumn.setDefaultValue(String.valueOf(costCompany));
                }
                if ("pcurrency".equalsIgnoreCase(fieldName)) {
                    if (currencyId == null || currencyId == 0L) {
                        currencyId = 1L;
                    }
                    commonFilterColumn.setDefaultValue(String.valueOf(currencyId));
                }
                if ("pcostdept".equalsIgnoreCase(fieldName) && deptId != null) {
                    commonFilterColumn.setDefaultValue(String.valueOf(deptId));
                }
                if ("pstatisticaldimension".equals(fieldName)) {
                    commonFilterColumn.setDefaultValues(Arrays.asList("costcompany", "costdept", "expenseitem"));
                }
                if ("orgview".equals(fieldName)) {
                    commonFilterColumn.setDefaultValue("10");
                }
                if ("pcompany".equals(fieldName) && this.isEmptyDefValue(commonFilterColumn) && company != null) {
                    commonFilterColumn.setDefaultValues(new Object[]{String.valueOf(company)});
                }
            }
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)permissionField) || !fieldName.equals("p" + permissionField)) continue;
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)appId) ? appId : "em";
            String orgViewType = StringUtils.equals((String)permissionField, (String)"costcompany") ? "10" : "01";
            List permOrgs = PermissionServiceHelper.getAllPermOrgs((long)CommonServiceHelper.getCurrentUserID(), (String)orgViewType, (String)appId, (String)this.getView().getFormShowParameter().getFormId(), (String)"47150e89000000ac", (boolean)true).getHasPermOrgs();
            this.initCompanyComboitem(commonFilterColumn, permOrgs);
            switch (permissionField) {
                case "company": {
                    this.setPermOrgDefaultValue(company, commonFilterColumn, permOrgs);
                    break;
                }
                case "costcompany": {
                    this.setPermOrgDefaultValue(costCompany, commonFilterColumn, permOrgs);
                    break;
                }
                case "org": 
                case "costdept": {
                    this.setPermOrgDefaultValue(deptId, commonFilterColumn, permOrgs);
                    break;
                }
            }
        }
    }

    private void setPermOrgDefaultValue(Long orgId, FilterColumn column, List<Long> permOrgs) {
        if (orgId != null) {
            if (!permOrgs.isEmpty() && !permOrgs.contains(orgId)) {
                column.setDefaultValue("");
            } else {
                column.setDefaultValue(String.valueOf(orgId));
            }
        }
    }

    private void initCostCompanyComboitem(FilterColumn commonFilterColumn) {
        String selectFields = "org orgid , org.name orgname";
        Object orgview = this.getQueryParam().getFilter().getValue("orgview.id");
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"TreeReportHelper.appendOrgInfo", (String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("view", "=", orgview == null ? Integer.valueOf(10) : orgview)}, (String)"level asc");){
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>(256);
            ComboItem empty = new ComboItem();
            empty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"ShowCompanyListPlugin_0", (String)"fi-er-report", (Object[])new Object[0])));
            empty.setValue("");
            combos.add(empty);
            while (orgDataSet.hasNext()) {
                Row row = orgDataSet.next();
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(row.getString("orgname")));
                item.setValue(String.valueOf(row.get("orgid")));
                combos.add(item);
            }
            ((CustomOrgFilterColumn)commonFilterColumn).setComboItems(combos);
        }
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
        event.setTreeExpandColId("costcompany");
    }

    public void setFloatButtomData(List<SummaryEvent> summaryEvents) {
        super.setFloatButtomData(summaryEvents);
        TreeQueryParam treeQueryParam = new TreeQueryParam(this.getQueryParam());
        if (treeQueryParam.isLevelShow().booleanValue()) {
            summaryEvents.stream().forEach(v -> v.setFormatSummaryValue(null));
        }
    }

    private Date getLastDayOfMonth(String dateStr) throws ParseException {
        Date d = DateUtils.parseDate((String)dateStr, (String[])new String[]{"yyyyMMdd"});
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }
}

