/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.reimctl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.TemporalAdjusters;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.daily.service.model.ReimburseAmountDetailBean;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.formplugin.daily.mobile.common.CommonUtilHelper;
import kd.fi.er.report.reimctl.ErAbstractReimCtlUseDetailPlugin;
import org.apache.commons.lang3.StringUtils;

public class ErReimCtlUseDetailPlugin
extends ErAbstractReimCtlUseDetailPlugin
implements HyperLinkClickListener {
    private static final String treeRootId = "0";

    public void registerListener(EventObject e) {
        TreeView monthTree = (TreeView)this.getControl("monthtree");
        monthTree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                ErReimCtlUseDetailPlugin.this.genEntry(evt);
            }
        });
        EntryGrid entryGrid = (EntryGrid)this.getControl("usedetailentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void genEntry(TreeNodeEvent evt) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object userQueryParam = formShowParameter.getCustomParam("reimAmountQueryBean");
        QuotaAmountBO quotaAmountBO = (QuotaAmountBO)((JSONObject)userQueryParam).toJavaObject(QuotaAmountBO.class);
        Long currencyId = quotaAmountBO.getCurrencyId();
        Integer year = quotaAmountBO.getHappenYear();
        LocalDate startDate = LocalDate.of((int)year, 1, 1);
        LocalDate endDate = LocalDate.of((int)year, 12, 31);
        int nodeId = Integer.parseInt(evt.getNodeId().toString());
        if (1 <= nodeId && nodeId <= 12) {
            startDate = LocalDate.of((int)year, nodeId, 1);
            endDate = startDate.with(TemporalAdjusters.lastDayOfMonth());
        }
        quotaAmountBO.setHappenDatePeriod(new LocalDate[]{startDate, endDate});
        QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)quotaAmountBO);
        List reimedDetails = quotaCtrlMode.getReimbursedBills(quotaAmountBO);
        Boolean isDeptAmount = (Boolean)formShowParameter.getCustomParam("isDeptAmount");
        if (isDeptAmount.booleanValue()) {
            this.updateDeptDetailEntity(currencyId, reimedDetails);
        } else {
            this.updateUseDetailEntity(currencyId, reimedDetails);
        }
    }

    @Override
    protected void buildUseSummaryByMonthControl(List<ReimburseAmountDetailBean> amountDetails, Map<Month, BigDecimal> amountLimitedMontyly, int year, Long currencyId) {
        TreeView monthTree = (TreeView)this.getControl("monthtree");
        TreeNode rootNode = null;
        BigDecimal totalUsedAmount = amountDetails.stream().map(detail -> detail.getReimburseAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        rootNode = new TreeNode(null, treeRootId, String.format(ResManager.loadKDString((String)"%1$d\u5e74\uff08%2$s\uff09", (String)"ErReimCtlUseDetailPlugin_0", (String)"fi-er-report", (Object[])new Object[0]), year, AmountUtils.getFormattedAmount((Long)currencyId, (BigDecimal)totalUsedAmount)));
        monthTree.addNode(rootNode);
        Map<Month, List<ReimburseAmountDetailBean>> amountDetailByMonth = amountDetails.stream().collect(Collectors.groupingBy(k -> k.getHappenedDate().getMonth()));
        for (int i = 1; i <= 12; ++i) {
            Month month = Month.of(i);
            BigDecimal usedAmountMonth = BigDecimal.ZERO;
            if (amountDetailByMonth.get(month) != null) {
                usedAmountMonth = amountDetailByMonth.get(month).stream().map(detail -> detail.getReimburseAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            BigDecimal limitedAmountMonth = amountLimitedMontyly.getOrDefault(month, BigDecimal.ZERO);
            monthTree.addNode(new TreeNode(treeRootId, String.valueOf(i), String.format(ResManager.loadKDString((String)"%1$d\u6708\uff08%2$s/%3$s\uff09", (String)"ErReimCtlUseDetailPlugin_1", (String)"fi-er-report", (Object[])new Object[0]), i, AmountUtils.getFormattedAmount((Long)currencyId, (BigDecimal)usedAmountMonth), AmountUtils.getFormattedAmount((Long)currencyId, (BigDecimal)limitedAmountMonth))));
        }
        monthTree.expand(treeRootId);
    }

    @Override
    protected void buildUseSummaryByYearControl(List<ReimburseAmountDetailBean> amountDetails, BigDecimal totalLimitedAmount, int year, Long currencyId) {
        TreeView monthTree = (TreeView)this.getControl("monthtree");
        TreeNode rootNode = null;
        BigDecimal totalUsedAmount = amountDetails.stream().map(detail -> detail.getReimburseAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        rootNode = new TreeNode(null, treeRootId, String.format(ResManager.loadKDString((String)"%1$s\u5e74\uff08%2$s/%3$s\uff09", (String)"ErReimCtlUseDetailPlugin_2", (String)"fi-er-report", (Object[])new Object[0]), year, AmountUtils.getFormattedAmount((Long)currencyId, (BigDecimal)totalUsedAmount), AmountUtils.getFormattedAmount((Long)currencyId, (BigDecimal)totalLimitedAmount)));
        monthTree.addNode(rootNode);
        Map<Month, List<ReimburseAmountDetailBean>> amountDetailByMonth = amountDetails.stream().collect(Collectors.groupingBy(k -> k.getHappenedDate().getMonth()));
        for (int i = 1; i <= 12; ++i) {
            Month month = Month.of(i);
            BigDecimal usedAmountMonth = BigDecimal.ZERO;
            if (amountDetailByMonth.get(month) != null) {
                usedAmountMonth = amountDetailByMonth.get(month).stream().map(detail -> detail.getReimburseAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            monthTree.addNode(new TreeNode(treeRootId, String.valueOf(i), String.format(ResManager.loadKDString((String)"%d\u6708\uff08%s\uff09", (String)"ErReimCtlUseDetailPlugin_3", (String)"fi-er-report", (Object[])new Object[0]), i, AmountUtils.getFormattedAmount((Long)currencyId, (BigDecimal)usedAmountMonth))));
        }
        monthTree.expand(treeRootId);
    }

    @Override
    protected void updateUseDetailEntity(Long currencyId, List<ReimburseAmountDetailBean> reimedDetails) {
        Map<ErAbstractReimCtlUseDetailPlugin.GroupListKey, List<ReimburseAmountDetailBean>> groupedLists = reimedDetails.stream().collect(Collectors.groupingBy(k -> new ErAbstractReimCtlUseDetailPlugin.GroupListKey(k.getMetaKey(), k.getBillName(), k.getBillId(), k.getBillno())));
        this.getModel().deleteEntryData("usedetailentity");
        this.createEntry(currencyId, groupedLists);
    }

    @Override
    protected void updateDeptDetailEntity(Long currencyId, List<ReimburseAmountDetailBean> reimedDetails) {
        Map<ErAbstractReimCtlUseDetailPlugin.GroupListKey, List<ReimburseAmountDetailBean>> groupedLists = reimedDetails.stream().collect(Collectors.groupingBy(k -> new ErAbstractReimCtlUseDetailPlugin.GroupListKey(k.getMetaKey(), k.getBillName(), k.getBillId(), k.getBillno())));
        this.getModel().deleteEntryData("usedetailentity");
        Object userQueryParam = this.getView().getFormShowParameter().getCustomParam("reimAmountQueryBean");
        QuotaAmountBO quotaAmountBO = (QuotaAmountBO)((JSONObject)userQueryParam).toJavaObject(QuotaAmountBO.class);
        boolean isNeedFilter = CommonServiceHelper.isFullApp((String)this.getView().getFormShowParameter().getAppId()) && !CommonUtilHelper.isDeptAdmin((Long)quotaAmountBO.getUserOrDeptId(), (Long)Long.valueOf(RequestContext.getOrCreate().getUserId()));
        HashMap specialDataPermissionFilters = Maps.newHashMapWithExpectedSize((int)groupedLists.size());
        if (isNeedFilter) {
            Set entityKeys = groupedLists.keySet().stream().map(ErAbstractReimCtlUseDetailPlugin.GroupListKey::getMetaKey).collect(Collectors.toSet());
            for (String entityKey : entityKeys) {
                QFilter specialDataPermissionFilter = null;
                specialDataPermissionFilter = entityKey.equals("er_tripreimbursebill") ? PermissionFilterUtil.getSpecialDataPermissionFilter((String)"tra", (String)entityKey, (String)"view", (ITimeService)((ITimeService)this.getView().getService(ITimeService.class)), (IUserService)((IUserService)this.getView().getService(IUserService.class))) : (entityKey.equals("er_dailyreimbursebill") ? PermissionFilterUtil.getSpecialDataPermissionFilter((String)"tra", (String)entityKey, (String)"view", (ITimeService)((ITimeService)this.getView().getService(ITimeService.class)), (IUserService)((IUserService)this.getView().getService(IUserService.class))) : (entityKey.equals("er_publicreimbursebill") ? PermissionFilterUtil.getSpecialDataPermissionFilter((String)"tra", (String)entityKey, (String)"view", (ITimeService)((ITimeService)this.getView().getService(ITimeService.class)), (IUserService)((IUserService)this.getView().getService(IUserService.class))) : CommonUtilHelper.getSpecialDataPermissionFilter((IFormView)this.getView(), (String)entityKey)));
                specialDataPermissionFilters.put(entityKey, specialDataPermissionFilter);
            }
            groupedLists = groupedLists.entrySet().stream().filter(entry -> {
                ErAbstractReimCtlUseDetailPlugin.GroupListKey groupKey = (ErAbstractReimCtlUseDetailPlugin.GroupListKey)entry.getKey();
                QFilter speicalDataPermQFilter = (QFilter)specialDataPermissionFilters.get(groupKey.getMetaKey());
                if (speicalDataPermQFilter == null) {
                    return true;
                }
                return QueryServiceHelper.exists((String)groupKey.getMetaKey(), (QFilter[])new QFilter[]{speicalDataPermQFilter, QFilter.of((String)"id=?", (Object[])new Object[]{groupKey.getBillId()})});
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        this.createEntry(currencyId, groupedLists);
    }

    private void createEntry(Long currencyId, Map<ErAbstractReimCtlUseDetailPlugin.GroupListKey, List<ReimburseAmountDetailBean>> groupedLists) {
        if (groupedLists.isEmpty()) {
            return;
        }
        IDataModel model = this.getView().getModel();
        int[] indexs = model.batchCreateNewEntryRow("usedetailentity", groupedLists.size());
        int i = 0;
        for (Map.Entry<ErAbstractReimCtlUseDetailPlugin.GroupListKey, List<ReimburseAmountDetailBean>> pair : groupedLists.entrySet()) {
            ErAbstractReimCtlUseDetailPlugin.GroupListKey groupKey = pair.getKey();
            List<ReimburseAmountDetailBean> value = pair.getValue();
            int index = indexs[i++];
            model.setValue("billname", (Object)groupKey.getBillName(), index);
            model.setValue("metakey", (Object)groupKey.getMetaKey(), index);
            model.setValue("billno", (Object)groupKey.getBillno(), index);
            model.setValue("billid", (Object)groupKey.getBillId(), index);
            model.setValue("currencyid", (Object)currencyId, index);
            BigDecimal usedAmount = value.stream().map(bean -> bean.getReimburseAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            model.setValue("usedamount", (Object)usedAmount, index);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        int rowIndex = event.getRowIndex();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"billno")) {
            IFormView view = this.getView();
            IDataModel model = view.getModel();
            String metaKey = (String)model.getValue("metakey", rowIndex);
            Long billId = (Long)model.getValue("billid", rowIndex);
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(metaKey);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setPkId((Object)billId);
            view.showForm((FormShowParameter)showParameter);
        }
    }
}

