/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.reimctl.mob;

import java.math.BigDecimal;
import java.time.Month;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.fi.er.business.daily.service.model.ReimburseAmountDetailBean;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.report.reimctl.ErAbstractReimCtlUseDetailPlugin;
import org.apache.commons.lang3.StringUtils;

public class ErReimCtlUseDetailMobPlugin
extends ErAbstractReimCtlUseDetailPlugin {
    public void registerListener(EventObject e) {
        CardEntry cardEntry = (CardEntry)this.getControl("usedsummaryentry");
        cardEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                BigDecimal usedamount;
                int clickRowIndex = evt.getRow();
                if (ErReimCtlUseDetailMobPlugin.this.getModel().getProperty("usedamount") != null && BigDecimal.ZERO.compareTo(usedamount = (BigDecimal)ErReimCtlUseDetailMobPlugin.this.getModel().getValue("usedamount", clickRowIndex)) >= 0) {
                    return;
                }
                Integer month = (Integer)ErReimCtlUseDetailMobPlugin.this.getModel().getValue("month", clickRowIndex);
                ErReimCtlUseDetailMobPlugin.this.showUsedAmountBillList(month);
            }
        });
        this.addClickListeners(new String[]{"summary_flex"});
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Container) {
            Container container = (Container)source;
            BigDecimal totalUsedAmount = (BigDecimal)this.getModel().getValue("totalusedamount");
            if (StringUtils.equals((CharSequence)container.getKey(), (CharSequence)"summary_flex") && totalUsedAmount != null && totalUsedAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.showUsedAmountBillList(null);
            }
        }
    }

    private void showUsedAmountBillList(Integer month) {
        FormShowParameter thisPageShowParam = this.getView().getFormShowParameter();
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u989d\u5ea6\u4f7f\u7528\u8be6\u60c5", (String)"ErReimCtlUseDetailMobPlugin_0", (String)"fi-er-report", (Object[])new Object[0]));
        showParameter.setFormId("er_reimctl_usedbillist_mb");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setHasRight(true);
        showParameter.setCustomParam("reimAmountQueryBean", thisPageShowParam.getCustomParam("reimAmountQueryBean"));
        showParameter.setCustomParam("isDeptAmount", thisPageShowParam.getCustomParam("isDeptAmount"));
        showParameter.setCustomParam("reimAmountQueryMonth", (Object)month);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    protected void buildUseSummaryByMonthControl(List<ReimburseAmountDetailBean> amountDetails, Map<Month, BigDecimal> amountLimitedMontyly, int year, Long currencyId) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (amountLimitedMontyly == null || amountLimitedMontyly.isEmpty()) {
            return;
        }
        BigDecimal totalUsedAmount = amountDetails.stream().map(detail -> detail.getReimburseAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        ((Label)view.getControl("summaryname")).setText(String.format(ResManager.loadKDString((String)"%d\u5168\u5e74\u5df2\u7528\u989d\u5ea6", (String)"ErReimCtlUseDetailMobPlugin_1", (String)"fi-er-report", (Object[])new Object[0]), year));
        ((Label)view.getControl("amountshow_head")).setText(String.format("%s", AmountUtils.getFormattedAmountWithSymbol((Long)currencyId, (BigDecimal)totalUsedAmount)));
        this.getModel().setValue("totalusedamount", (Object)totalUsedAmount);
        Map<Month, List<ReimburseAmountDetailBean>> amountDetailByMonth = amountDetails.stream().collect(Collectors.groupingBy(k -> k.getHappenedDate().getMonth()));
        int[] indexs = model.batchCreateNewEntryRow("usedsummaryentry", 12);
        for (int i = 1; i <= 12; ++i) {
            int rowIndex = indexs[i - 1];
            Month month = Month.of(i);
            BigDecimal amountLimit = amountLimitedMontyly.getOrDefault(month, BigDecimal.ZERO);
            BigDecimal usedAmountMonth = BigDecimal.ZERO;
            if (amountDetailByMonth.get(month) != null) {
                usedAmountMonth = amountDetailByMonth.get(month).stream().map(bean -> bean.getReimburseAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            model.setValue("monthname", (Object)String.format(ResManager.loadKDString((String)"%d\u6708", (String)"ErReimCtlUseDetailMobPlugin_2", (String)"fi-er-report", (Object[])new Object[0]), i), rowIndex);
            model.setValue("amountshow", (Object)String.format("%s/%s", AmountUtils.getFormattedAmountWithSymbol((Long)currencyId, (BigDecimal)usedAmountMonth), AmountUtils.getFormattedAmountWithSymbol((Long)currencyId, (BigDecimal)amountLimit)), rowIndex);
            model.setValue("usedamount", (Object)usedAmountMonth, rowIndex);
            model.setValue("month", (Object)i, rowIndex);
        }
    }

    @Override
    protected void buildUseSummaryByYearControl(List<ReimburseAmountDetailBean> amountDetails, BigDecimal totalLimitedAmount, int year, Long currencyId) {
        if (totalLimitedAmount == null) {
            totalLimitedAmount = BigDecimal.ZERO;
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        BigDecimal totalUsedAmount = amountDetails.stream().map(detail -> detail.getReimburseAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (totalUsedAmount == null) {
            totalUsedAmount = BigDecimal.ZERO;
        }
        ((Label)view.getControl("summaryname")).setText(String.format(ResManager.loadKDString((String)"%d\u5168\u5e74\u5df2\u7528\u989d\u5ea6", (String)"ErReimCtlUseDetailMobPlugin_1", (String)"fi-er-report", (Object[])new Object[0]), year));
        ((Label)view.getControl("amountshow_head")).setText(String.format("%s/%s", AmountUtils.getFormattedAmountWithSymbol((Long)currencyId, (BigDecimal)totalUsedAmount), AmountUtils.getFormattedAmountWithSymbol((Long)currencyId, (BigDecimal)totalLimitedAmount)));
        this.getModel().setValue("totalusedamount", (Object)totalUsedAmount);
        if (amountDetails.isEmpty()) {
            return;
        }
        Map<Month, List<ReimburseAmountDetailBean>> amountDetailByMonth = amountDetails.stream().collect(Collectors.groupingBy(k -> k.getHappenedDate().getMonth()));
        int[] indexs = model.batchCreateNewEntryRow("usedsummaryentry", amountDetailByMonth.size());
        List sortedAmountDetailByMonth = amountDetailByMonth.entrySet().stream().sorted((entry1, entry2) -> ((Month)entry1.getKey()).compareTo((Enum)entry2.getKey())).collect(Collectors.toList());
        int i = 0;
        for (Map.Entry pair : sortedAmountDetailByMonth) {
            BigDecimal usedAmountMonthly = ((List)pair.getValue()).stream().map(detail -> detail.getReimburseAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            int rowIndex = indexs[i++];
            model.setValue("monthname", (Object)String.format(ResManager.loadKDString((String)"%d\u6708", (String)"ErReimCtlUseDetailMobPlugin_2", (String)"fi-er-report", (Object[])new Object[0]), ((Month)pair.getKey()).getValue()), rowIndex);
            model.setValue("amountshow", (Object)AmountUtils.getFormattedAmountWithSymbol((Long)currencyId, (BigDecimal)usedAmountMonthly), rowIndex);
            model.setValue("usedamount", (Object)usedAmountMonthly, rowIndex);
            model.setValue("month", (Object)((Month)pair.getKey()).getValue(), rowIndex);
        }
    }
}

