/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.botp;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;
import kd.fi.er.business.bean.ReimburseWriteTravelOrder;
import kd.fi.er.business.trip.dailybiz.TripReimWriteBackOrderUtil;
import kd.fi.er.common.enums.PayLogEnum;
import kd.fi.er.common.enums.PayTargeBillType;
import kd.fi.er.common.exception.CasWbErException;
import kd.fi.er.common.model.PayLogBo;
import kd.fi.er.mservice.botp.AbstractPayBillSynService;
import kd.fi.er.mservice.botp.RefundRenoteOrCancelServiceImpl;
import kd.fi.er.mservice.botp.factory.WriteBackServiceFactory;
import kd.fi.er.mservice.botp.writeback.AbstractWriteBackServcie;

public class AgentpayBillSyncServiceImpl
extends AbstractPayBillSynService {
    protected static final String TARGET_BILL_LIST = "info";
    private static Log logger = LogFactory.getLog(AgentpayBillSyncServiceImpl.class);

    public Object execute(Object synParam) {
        if (synParam instanceof RefundRenoteOrCancelParam) {
            return new RefundRenoteOrCancelServiceImpl().execute(synParam);
        }
        Map agentPayWbParam = (Map)synParam;
        if (agentPayWbParam == null || agentPayWbParam.size() < 1) {
            logger.info("\u51fa\u7eb3\u96c6\u6210,\u4ee3\u53d1\u5355\u53cd\u5199\u63a5\u53e3\u4f20\u53c2\u4e3a\u7a7a!");
            return null;
        }
        String json = SerializationUtils.toJsonString((Object)agentPayWbParam);
        logger.info("\u51fa\u7eb3\u96c6\u6210,cas\u4ee3\u53d1\u5355\u8c03\u7528\u53cd\u5199\u63a5\u53e3\u4f20\u53c2\uff1a" + json);
        String operate = (String)agentPayWbParam.get("operate");
        String operation = this.getCasOpration(operate);
        ArrayList<Object> agentBillList = new ArrayList<Object>(Arrays.asList((Object[])agentPayWbParam.get(TARGET_BILL_LIST)));
        if (operation == null) {
            logger.info("\u51fa\u7eb3\u96c6\u6210,\u51fa\u7eb3\u53cd\u5199\u8d39\u7528\u4e0a\u6e38\u5355\u636e\u5931\u8d25\uff0c\u539f\u56e0\u662f\u6ca1\u6709\u5bf9\u7528\u64cd\u4f5c:-->" + operate);
            return null;
        }
        PayLogBo logBo = PayLogBo.build().traceId(RequestContext.get().getTraceId()).sourceId((Object)0L).targetId(((DynamicObject)agentBillList.get(0)).getPkValue()).op(operation).payTargeBillType(PayTargeBillType.CAS_AGENTPAYBILL).setp(PayLogEnum.INPUT).msg(json);
        AgentpayBillSyncServiceImpl.writeLog(logBo);
        return this.writeBack(agentBillList, operation);
    }

    @Override
    protected OperationResult writeBack(List<?> payBillList, String operateName) {
        RefObject wbSuccess = new RefObject((Object)Boolean.TRUE);
        HashMap<String, Object> errorCodeCollection = new HashMap<String, Object>();
        HashSet<ReimburseWriteTravelOrder> writeBackReimburseList = new HashSet<ReimburseWriteTravelOrder>(16);
        payBillList.stream().forEach(v -> {
            DynamicObject agentBill = (DynamicObject)v;
            String entityNumber = agentBill.getString("sourcebilltype");
            Map sourceBillMap = BFTrackerServiceHelper.findSourceBills((String)"cas_agentpaybill", (Long[])new Long[]{Long.valueOf(agentBill.getPkValue().toString())});
            Set sourceBillIds = (Set)sourceBillMap.get(entityNumber);
            if (sourceBillIds != null && sourceBillIds.size() > 0) {
                AbstractWriteBackServcie synBackService = WriteBackServiceFactory.getInstance(entityNumber);
                if (synBackService == null) {
                    return;
                }
                synBackService.setOperateName(operateName);
                synBackService.setSrcEntityName(entityNumber);
                for (Long id : sourceBillIds) {
                    QFilter filter = new QFilter("id", "=", (Object)id);
                    try {
                        DLock lock = DLock.create((String)("fi_er_cas_wb_" + id));
                        Throwable throwable = null;
                        try {
                            boolean lockFlag = lock.tryLock(10000L);
                            if (lockFlag) {
                                TXHandle h1 = TX.requiresNew();
                                Throwable throwable2 = null;
                                try {
                                    try {
                                        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityNumber);
                                        DynamicObject[] sourceBills = new DynamicObject[]{sourceBill};
                                        DynamicObjectCollection entryCollection = agentBill.getDynamicObjectCollection("entry");
                                        boolean isSynWriteBack = synBackService.getValidateResult(sourceBills, (Collection)entryCollection, agentBill.getPkValue());
                                        logger.info("\u53cd\u5199\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)isSynWriteBack);
                                        PayLogBo logBo = PayLogBo.build().traceId(RequestContext.get().getTraceId()).sourceId((Object)id).targetId(agentBill.getPkValue()).op(operateName).payTargeBillType(PayTargeBillType.CAS_AGENTPAYBILL).setp(PayLogEnum.CHECK_AND_ASSIGN).msg(String.valueOf(isSynWriteBack));
                                        AgentpayBillSyncServiceImpl.writeLog(logBo);
                                        this.saveWriteBackResult(isSynWriteBack, synBackService, sourceBills, errorCodeCollection, PayTargeBillType.CAS_AGENTPAYBILL, agentBill.getPkValue());
                                        if (isSynWriteBack && !TripReimWriteBackOrderUtil.onlyValidate((String)operateName)) {
                                            for (DynamicObject d : sourceBills) {
                                                writeBackReimburseList.add(new ReimburseWriteTravelOrder(d, entityNumber, Long.valueOf(d.getLong("id")), d.getString("billstatus")));
                                            }
                                        }
                                        if (((Boolean)wbSuccess.getValue()).booleanValue()) {
                                            wbSuccess.setValue((Object)isSynWriteBack);
                                        }
                                        if (isSynWriteBack) continue;
                                        throw new CasWbErException(new ErrorCode("TXException", ResManager.getLocaleString((String)"\u540c\u4e00\u4e8b\u52a1\u4e2d\u5b58\u5728\u53cd\u5199\u5931\u8d25\u7684\u5355\u636e\u3002", (String)"AgentpayBillSyncServiceImpl_2", (String)"fi-er-mservice").getLocaleValue()), new Object[0]);
                                    }
                                    catch (Exception e) {
                                        wbSuccess.setValue((Object)Boolean.FALSE);
                                        logger.error(e.getMessage(), (Throwable)e);
                                        h1.markRollback();
                                        if (e instanceof CasWbErException) continue;
                                        errorCodeCollection.put(String.valueOf(agentBill.getPkValue()), e.getMessage());
                                        PayLogBo logBo = PayLogBo.build().traceId(RequestContext.get().getTraceId()).sourceId((Object)id).targetId(agentBill.getPkValue()).op(operateName).payTargeBillType(PayTargeBillType.CAS_AGENTPAYBILL).setp(PayLogEnum.EXCEPTION).msg(this.printStack(e));
                                        AgentpayBillSyncServiceImpl.writeLog(logBo);
                                        continue;
                                    }
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (h1 == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            h1.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    h1.close();
                                    continue;
                                }
                            }
                            wbSuccess.setValue((Object)Boolean.FALSE);
                            String errorCode = ResManager.loadKDString((String)"\u83b7\u53d6\u9501\u5931\u8d25", (String)"AgentpayBillSyncServiceImpl_1", (String)"fi-er-mservice", (Object[])new Object[0]);
                            errorCode = errorCodeCollection.get(agentBill.getPkValue()) == null ? errorCode : errorCodeCollection.get(agentBill.getPkValue()) + ";" + errorCode;
                            errorCodeCollection.put(String.valueOf(agentBill.getPkValue()), errorCode);
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (lock == null) continue;
                            if (throwable != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            lock.close();
                        }
                    }
                    catch (Exception e) {
                        wbSuccess.setValue((Object)Boolean.FALSE);
                        logger.error(e.getMessage(), (Throwable)e);
                        errorCodeCollection.put(String.valueOf(agentBill.getPkValue()), e.getMessage());
                    }
                }
            }
        });
        logger.info("\u51fa\u7eb3\u96c6\u6210\uff0c\u53cd\u5199\u7ed3\u679c\uff1awbSuccess\uff1a {}\uff0c {}", wbSuccess.getValue(), (Object)SerializationUtils.toJsonString(errorCodeCollection));
        OperationResult operationResult = this.getOperationResult((Boolean)wbSuccess.getValue(), errorCodeCollection);
        String result = JSONObject.toJSONString((Object)operationResult);
        PayLogBo logBo = PayLogBo.build().traceId(RequestContext.get().getTraceId()).sourceId((Object)0L).targetId(((DynamicObject)payBillList.get(0)).getPkValue()).op(operateName).payTargeBillType(PayTargeBillType.CAS_AGENTPAYBILL).setp(PayLogEnum.OUTPUT).msg(result);
        AgentpayBillSyncServiceImpl.writeLog(logBo);
        if (((Boolean)wbSuccess.getValue()).booleanValue()) {
            this.afterOperate(writeBackReimburseList);
        }
        logger.info("\u51fa\u7eb3\u96c6\u6210,\u8c03\u7528\u53cd\u5199\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a:\n->" + result);
        return operationResult;
    }
}

