/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.botp;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;
import kd.fi.er.business.bean.ReimburseWriteTravelOrder;
import kd.fi.er.business.trip.dailybiz.TripReimWriteBackOrderUtil;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.enums.PayLogEnum;
import kd.fi.er.common.enums.PayTargeBillType;
import kd.fi.er.common.exception.CasWbErException;
import kd.fi.er.common.model.PayLogBo;
import kd.fi.er.mservice.botp.AbstractPayBillSynService;
import kd.fi.er.mservice.botp.RefundRenoteOrCancelServiceImpl;
import kd.fi.er.mservice.botp.factory.WriteBackServiceFactory;
import kd.fi.er.mservice.botp.writeback.AbstractWriteBackServcie;

public class CasPayBillSynServiceImpl
extends AbstractPayBillSynService {
    private static Log logger = LogFactory.getLog(CasPayBillSynServiceImpl.class);
    private static final String SOURCEENTITY = "sourceentity";

    public Object execute(Object synParam) {
        if (synParam instanceof RefundRenoteOrCancelParam) {
            return new RefundRenoteOrCancelServiceImpl().execute(synParam);
        }
        List payBillList = (List)synParam;
        if (payBillList == null || payBillList.size() < 1) {
            logger.info("\u51fa\u7eb3\u96c6\u6210,\u4ed8\u6b3e\u5355\u53cd\u5199\u63a5\u53e3\u4f20\u53c2\u4e3a\u7a7a!");
            return null;
        }
        String json = SerializationUtils.toJsonString((Object)payBillList);
        logger.info("\u51fa\u7eb3\u96c6\u6210,cas\u4ed8\u6b3e\u5355\u8c03\u7528\u53cd\u5199\u63a5\u53e3\u4f20\u53c2\uff1a" + json);
        Map firstPayBill = (Map)payBillList.get(0);
        String operate = (String)firstPayBill.get("operate");
        String operation = this.getCasOpration(operate);
        PayLogBo logBo = PayLogBo.build().traceId(RequestContext.get().getTraceId()).sourceId(firstPayBill.get("sourcepk")).targetId(firstPayBill.get("targetpk")).op(operation).payTargeBillType(PayTargeBillType.CAS_PAYBILL).setp(PayLogEnum.INPUT).msg(json);
        CasPayBillSynServiceImpl.writeLog(logBo);
        if (operation == null) {
            logger.info("\u51fa\u7eb3\u96c6\u6210,\u51fa\u7eb3\u53cd\u5199\u8d39\u7528\u4e0a\u6e38\u5355\u636e\u5931\u8d25\uff0c\u539f\u56e0\u662f\u6ca1\u6709\u5bf9\u7528\u64cd\u4f5c:-->" + operate);
            return null;
        }
        return this.writeBack(payBillList, operation);
    }

    @Override
    protected OperationResult writeBack(List<?> payBillList, String operateName) {
        Map<String, List<Map>> entryGroupOfEntityName = payBillList.stream().collect(Collectors.groupingBy(t -> String.valueOf(t.get(SOURCEENTITY))));
        boolean isWbSuccess = true;
        HashMap<String, Object> errorCodeCollection = new HashMap<String, Object>();
        String srcBillCacheTitle = "fi_er_cas_writeback_cache::";
        String srcBillLockTitle = "fi_er_cas_writeback_";
        HashSet<ReimburseWriteTravelOrder> writeBackReimburseList = new HashSet<ReimburseWriteTravelOrder>(16);
        for (Map.Entry<String, List<Map>> entry : entryGroupOfEntityName.entrySet()) {
            String entityNumber = entry.getKey();
            AbstractWriteBackServcie synBackService = WriteBackServiceFactory.getInstance(entityNumber);
            if (synBackService == null) continue;
            synBackService.setSrcEntityName(entityNumber);
            synBackService.setOperateName(operateName);
            Map<Long, List<Map>> entryGroupOfTargetBill = entry.getValue().stream().filter(v -> v.get("targetpk") != null).collect(Collectors.groupingBy(t -> (Long)t.get("targetpk")));
            for (Map.Entry<Long, List<Map>> paramOfTargetBill : entryGroupOfTargetBill.entrySet()) {
                List<Map> writeBackParamList = paramOfTargetBill.getValue();
                Long targetPk = paramOfTargetBill.getKey();
                HashSet<Long> billIds = new HashSet<Long>();
                for (Map paramMap : writeBackParamList) {
                    Object sourceBillId = paramMap.get("sourcepk");
                    if (sourceBillId == null) continue;
                    billIds.add((Long)sourceBillId);
                }
                if (billIds.isEmpty()) continue;
                boolean isSynWriteBack = true;
                for (Long billId : billIds) {
                    String lockKey = srcBillLockTitle + billId;
                    try {
                        DLock dLock = DLock.create((String)lockKey);
                        Throwable throwable = null;
                        try {
                            boolean lock = dLock.tryLock(30000L);
                            if (lock) {
                                TXHandle h1 = TX.requiresNew();
                                Throwable throwable2 = null;
                                try {
                                    PayLogBo logBo;
                                    try {
                                        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityNumber);
                                        if (sourceBill == null) continue;
                                        isSynWriteBack = isSynWriteBack && synBackService.getValidateResult(new DynamicObject[]{sourceBill}, writeBackParamList, paramOfTargetBill.getKey());
                                        logBo = PayLogBo.build().traceId(RequestContext.get().getTraceId()).sourceId((Object)billId).targetId((Object)targetPk).op(operateName).payTargeBillType(PayTargeBillType.CAS_PAYBILL).setp(PayLogEnum.CHECK_AND_ASSIGN).msg(String.valueOf(isSynWriteBack));
                                        CasPayBillSynServiceImpl.writeLog(logBo);
                                        if (isWbSuccess) {
                                            isWbSuccess = isWbSuccess && isSynWriteBack;
                                        }
                                        this.saveWriteBackResult(isSynWriteBack, synBackService, new DynamicObject[]{sourceBill}, errorCodeCollection, PayTargeBillType.CAS_PAYBILL, targetPk);
                                        if (!isSynWriteBack) {
                                            throw new CasWbErException(new ErrorCode("TXException", ResManager.getLocaleString((String)"\u540c\u4e00\u4e8b\u52a1\u4e2d\u5b58\u5728\u53cd\u5199\u5931\u8d25\u7684\u5355\u636e\u3002", (String)"CasPayBillSynServiceImpl_1", (String)"fi-er-mservice").getLocaleValue()), new Object[0]);
                                        }
                                        if (!isSynWriteBack || TripReimWriteBackOrderUtil.onlyValidate((String)operateName)) continue;
                                        writeBackReimburseList.add(new ReimburseWriteTravelOrder(sourceBill, entityNumber, Long.valueOf(sourceBill.getLong("id")), sourceBill.getString("billstatus")));
                                    }
                                    catch (Exception e) {
                                        h1.markRollback();
                                        logger.error(e.getMessage(), (Throwable)e);
                                        isWbSuccess = false;
                                        if (e instanceof CasWbErException) continue;
                                        errorCodeCollection.put(String.valueOf(targetPk), e.getMessage());
                                        logBo = PayLogBo.build().traceId(RequestContext.get().getTraceId()).sourceId((Object)billId).targetId((Object)targetPk).op(operateName).payTargeBillType(PayTargeBillType.CAS_PAYBILL).setp(PayLogEnum.EXCEPTION).msg(this.printStack(e));
                                        CasPayBillSynServiceImpl.writeLog(logBo);
                                    }
                                    continue;
                                }
                                catch (Throwable e) {
                                    throwable2 = e;
                                    throw e;
                                }
                                finally {
                                    if (h1 == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            h1.close();
                                        }
                                        catch (Throwable e) {
                                            throwable2.addSuppressed(e);
                                        }
                                        continue;
                                    }
                                    h1.close();
                                    continue;
                                }
                            }
                            isWbSuccess = false;
                            logger.error("\u83b7\u53d6\u9501\u5931\u8d25\uff1a \u76ee\u6807\u5355id: {}, \u6e90\u5355id: {}", (Object)targetPk, (Object)billId);
                            QFilter qFilter = new QFilter("id", "=", (Object)billId);
                            DynamicObject source = QueryServiceHelper.queryOne((String)entityNumber, (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
                            String billno = "";
                            if (source != null) {
                                billno = source.getString("billno");
                            }
                            String errorInfo = String.format(ResManager.getLocaleString((String)"\u591a\u5f20\u4ed8\u6b3e\u5355\u636e\u540c\u65f6\u53cd\u5199\u4e0a\u6e38\u5355\u636e\uff1a%s\uff0c\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CasPayBillSynServiceImpl_0", (String)"fi-er-mservice").getLocaleValue(), billno);
                            errorCodeCollection.put(String.valueOf(targetPk), errorInfo);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (dLock == null) continue;
                            if (throwable != null) {
                                try {
                                    dLock.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            dLock.close();
                        }
                    }
                    catch (Exception e) {
                        isWbSuccess = false;
                        logger.info("\u51fa\u7eb3\u53cd\u5199\u5f02\u5e38,\u6570\u636e\u8fdb\u884c\u56de\u6eda\u5904\u7406\uff1a", (Object)e);
                        errorCodeCollection.put(String.valueOf(targetPk), e.getMessage());
                    }
                }
            }
        }
        OperationResult operationResult = this.getOperationResult(isWbSuccess, errorCodeCollection);
        String result = JSONObject.toJSONString((Object)operationResult);
        logger.info("\u51fa\u7eb3\u96c6\u6210,\u8c03\u7528\u53cd\u5199\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a:\n->" + result);
        Map map = (Map)payBillList.get(0);
        PayLogBo logBo = PayLogBo.build().traceId(RequestContext.get().getTraceId()).sourceId(map.get("sourcepk")).targetId(map.get("targetpk")).op(operateName).payTargeBillType(PayTargeBillType.CAS_PAYBILL).setp(PayLogEnum.OUTPUT).msg(result);
        CasPayBillSynServiceImpl.writeLog(logBo);
        if (isWbSuccess) {
            this.afterOperate(writeBackReimburseList);
        }
        return operationResult;
    }

    @Override
    public DtxResponse execute(Object o, Object o1) {
        logger.info("invoke cas writeback er");
        if (!(o instanceof CommonParam)) {
            return null;
        }
        Object param = ((CommonParam)o).get((Object)"param");
        if ("true".equals(ErStdConfig.get((String)"testwbscene"))) {
            throw new KdtxException("custom exception");
        }
        Object result = this.execute(param);
        if (result instanceof Map) {
            Map map = (Map)result;
            if (!"0".equals(map.get("code"))) {
                throw new KdtxException((String)map.get("errorInfo"));
            }
        } else if (result instanceof OperationResult && !((OperationResult)result).isSuccess()) {
            String msg = "";
            List list = ((OperationResult)result).getValidateResult().getValidateErrors();
            if (list.size() > 0) {
                msg = ((ValidateResult)list.get(0)).getMessage();
            }
            throw new KdtxException(msg);
        }
        return null;
    }
}

