/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.botp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.refund.RefundEntryInfo;
import kd.fi.cas.refund.RefundPayBillInfo;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;
import kd.fi.cas.refund.SourceBillInfo;
import kd.fi.er.business.bean.ReimburseWriteTravelOrder;
import kd.fi.er.business.trip.dailybiz.TripReimWriteBackOrderUtil;
import kd.fi.er.common.enums.PayLogEnum;
import kd.fi.er.common.enums.PayTargeBillType;
import kd.fi.er.common.exception.CasWbErException;
import kd.fi.er.common.model.PayLogBo;
import kd.fi.er.mservice.botp.AbstractPayBillSynService;
import kd.fi.er.mservice.botp.RedisMultiLock;
import kd.fi.er.mservice.botp.factory.WriteBackServiceFactory;
import kd.fi.er.mservice.botp.writeback.AbstractWriteBackServcie;
import kd.fi.er.mservice.param.ErRefundEntryInfo;
import kd.fi.er.mservice.util.LogUtil;

public class RefundRenoteOrCancelServiceImpl
extends AbstractPayBillSynService {
    private static Log logger = LogFactory.getLog(RefundRenoteOrCancelServiceImpl.class);

    public Object execute(Object synParam) {
        RefundRenoteOrCancelParam param = (RefundRenoteOrCancelParam)synParam;
        if (param == null || param.getRefundPayInfos() == null || param.getRefundPayInfos().size() == 0) {
            logger.info("\u51fa\u7eb3\u96c6\u6210,\u4ed8\u6b3e\u5355\u53cd\u5199\u63a5\u53e3\u4f20\u53c2\u4e3a\u7a7a!");
            return this.buildResult(false, ResManager.loadKDString((String)"\u8d44\u91d1\u53cd\u5199\u8d39\u7528\u5165\u53c2\u683c\u5f0f\u6709\u8bef\u3002", (String)"RefundRenoteOrCancelServiceImpl_0", (String)"fi-er-mservice", (Object[])new Object[0]));
        }
        String json = JSON.toJSONString((Object)param);
        logger.info("\u51fa\u7eb3\u96c6\u6210,cas\u4ed8\u6b3e\u5355\u8c03\u7528\u53cd\u5199\u63a5\u53e3\u4f20\u53c2\uff1a" + json);
        String operate = param.getOperate();
        String operation = this.getCasOpration(operate);
        PayLogBo logBo = PayLogBo.build().traceId(RequestContext.get().getTraceId()).sourceId((Object)0L).op(operation).payTargeBillType(this.getBillType(param)).setp(PayLogEnum.INPUT).msg(json);
        if (param.getRefundPayInfos().size() == 1) {
            logBo.targetId((Object)((RefundPayBillInfo)param.getRefundPayInfos().get(0)).getTargetPk());
            HashSet sourceIds = new HashSet(10);
            param.getRefundPayInfos().stream().forEach(m -> m.getEntryInfos().forEach(n -> n.getSourceInfos().stream().forEach(x -> sourceIds.add(x.getSourcePk()))));
            if (sourceIds.size() == 1) {
                logBo.sourceId((Object)sourceIds.toArray(new Long[0])[0]);
            }
        }
        AbstractPayBillSynService.writeLog(logBo);
        if (operation == null) {
            logger.info("\u51fa\u7eb3\u96c6\u6210,\u51fa\u7eb3\u53cd\u5199\u8d39\u7528\u4e0a\u6e38\u5355\u636e\u5931\u8d25\uff0c\u539f\u56e0\u662f\u6ca1\u6709\u5bf9\u7528\u64cd\u4f5c:-->" + operate);
            return this.buildResult(false, ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4e0d\u652f\u6301\u53cd\u5199\u3002", (String)"RefundRenoteOrCancelServiceImpl_1", (String)"fi-er-mservice", (Object[])new Object[0]));
        }
        try {
            String msg = "";
            OperationResult result = this.writeBack(param, operation);
            if (!result.isSuccess() && result.getValidateResult().getValidateErrors().size() > 0) {
                msg = ((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getMessage();
                logger.error("\u9000\u6b3e\u9000\u7968\u5f02\u5e38\uff1a {}", (Object)msg);
            } else if (!result.isSuccess()) {
                msg = ResManager.loadKDString((String)"\u53cd\u5199\u8d39\u7528\u5355\u636e\u51fa\u73b0\u5f02\u5e38\u3002", (String)"RefundRenoteOrCancelServiceImpl_2", (String)"fi-er-mservice", (Object[])new Object[0]);
            }
            return this.buildResult(result.isSuccess(), msg);
        }
        catch (KDBizException ex) {
            return this.buildResult(false, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OperationResult writeBack(RefundRenoteOrCancelParam param, String operateName) {
        Map<String, Set<Long>> sourceIds = this.getIdMap(param);
        RedisMultiLock multiLock = new RedisMultiLock();
        if (!TripReimWriteBackOrderUtil.onlyValidate((String)operateName)) {
            multiLock.lock(sourceIds);
        }
        boolean isWbSuccess = true;
        HashMap<String, Object> errorCodeCollection = new HashMap<String, Object>();
        HashSet<ReimburseWriteTravelOrder> writeBackReimburseList = new HashSet<ReimburseWriteTravelOrder>(16);
        try (TXHandle h1 = TX.requiresNew();){
            try {
                for (RefundPayBillInfo refund : param.getRefundPayInfos()) {
                    Long targetId = refund.getTargetPk();
                    Map<Long, List<RefundEntryInfo>> groupBySourceBill = refund.getEntryInfos().stream().collect(Collectors.groupingBy(t -> ((SourceBillInfo)t.getSourceInfos().get(0)).getSourcePk()));
                    for (Map.Entry<Long, List<RefundEntryInfo>> entry : groupBySourceBill.entrySet()) {
                        String entityNumber = ((SourceBillInfo)entry.getValue().get(0).getSourceInfos().get(0)).getSourceEntity();
                        Long billId = entry.getKey();
                        AbstractWriteBackServcie synBackService = WriteBackServiceFactory.getInstance(entityNumber);
                        synBackService.setSrcEntityName(entityNumber);
                        synBackService.setOperateName(operateName);
                        if (synBackService == null) {
                            logger.error("\u5355\u636e\uff1a {}\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u53cd\u5199\u5b9e\u73b0\u7c7b", (Object)entityNumber);
                            continue;
                        }
                        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityNumber);
                        ArrayList<ErRefundEntryInfo> erRefundEntryInfos = new ArrayList<ErRefundEntryInfo>(entry.getValue().size());
                        for (RefundEntryInfo refundEntryInfo : entry.getValue()) {
                            erRefundEntryInfos.add(new ErRefundEntryInfo(refundEntryInfo, param));
                        }
                        if (sourceBill == null) continue;
                        boolean isSynWriteBack = synBackService.getValidateResult(new DynamicObject[]{sourceBill}, erRefundEntryInfos, targetId);
                        LogUtil.writeLog(billId, targetId, this.getBillType(param), operateName, PayLogEnum.CHECK_AND_ASSIGN, String.valueOf(isSynWriteBack));
                        if (isWbSuccess) {
                            isWbSuccess = isWbSuccess && isSynWriteBack;
                        }
                        this.saveWriteBackResult(isWbSuccess, synBackService, new DynamicObject[]{sourceBill}, errorCodeCollection, ((ErRefundEntryInfo)erRefundEntryInfos.get(0)).isCasPay() ? PayTargeBillType.CAS_PAYBILL : PayTargeBillType.CAS_AGENTPAYBILL, targetId);
                        if (!isWbSuccess) {
                            throw new CasWbErException(new ErrorCode("TXException", ResManager.getLocaleString((String)"\u540c\u4e00\u4e8b\u52a1\u4e2d\u5b58\u5728\u53cd\u5199\u5931\u8d25\u7684\u5355\u636e\u3002", (String)"CasPayBillSynServiceImpl_1", (String)"fi-er-mservice").getLocaleValue()), new Object[0]);
                        }
                        if (!isWbSuccess || TripReimWriteBackOrderUtil.onlyValidate((String)operateName)) continue;
                        writeBackReimburseList.add(new ReimburseWriteTravelOrder(sourceBill, entityNumber, Long.valueOf(sourceBill.getLong("id")), sourceBill.getString("billstatus")));
                    }
                }
            }
            catch (Exception e) {
                h1.markRollback();
                logger.error(e.getMessage(), (Throwable)e);
                isWbSuccess = false;
                if (!(e instanceof CasWbErException)) {
                    errorCodeCollection.put("0", e.getMessage());
                    LogUtil.writeLog(0L, 0L, this.getBillType(param), operateName, PayLogEnum.EXCEPTION, this.printStack(e));
                }
            }
        }
        finally {
            if (!TripReimWriteBackOrderUtil.onlyValidate((String)operateName)) {
                multiLock.unlock(sourceIds);
            }
        }
        OperationResult operationResult = this.getOperationResult(isWbSuccess, errorCodeCollection);
        String result = JSONObject.toJSONString((Object)operationResult);
        logger.info("\u51fa\u7eb3\u96c6\u6210,\u8c03\u7528\u53cd\u5199\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a:\n->" + result);
        LogUtil.writeLog(0L, 0L, this.getBillType(param), operateName, PayLogEnum.OUTPUT, result);
        if (isWbSuccess) {
            this.afterOperate(writeBackReimburseList);
        }
        return operationResult;
    }

    private PayTargeBillType getBillType(RefundRenoteOrCancelParam param) {
        if (param.getRefundPayInfos().size() > 0) {
            return "cas_paybill".equals(((RefundPayBillInfo)param.getRefundPayInfos().get(0)).getTargetBillType()) ? PayTargeBillType.CAS_PAYBILL : PayTargeBillType.CAS_AGENTPAYBILL;
        }
        return PayTargeBillType.CAS_AGENTPAYBILL;
    }

    @Override
    protected OperationResult writeBack(List<?> payBillList, String operateName) {
        return null;
    }

    private Map buildResult(boolean success, String msg) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("code", success ? "0" : "1");
        map.put("errorInfo", msg);
        return map;
    }
}

