/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.botp.ap_payable;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.mservice.bill.BusinessBillSynService;
import org.apache.commons.lang3.StringUtils;

public class ApPayableBillSynServiceImpl
implements BusinessBillSynService {
    private static Log logger = LogFactory.getLog(ApPayableBillSynServiceImpl.class);

    public OperationResult execute(Object synParam) {
        Map apPayableSynParam = (Map)synParam;
        OperationResult operationResult = new OperationResult();
        if (apPayableSynParam == null || apPayableSynParam.size() < 1) {
            logger.info("\u5e94\u4ed8\u96c6\u6210,\u5e94\u4ed8\u5355\u53cd\u5199\u63a5\u53e3\u4f20\u53c2\u4e3a\u7a7a!");
            operationResult.setSuccess(false);
            operationResult.setMessage(ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u53cd\u5199\u63a5\u53e3\u4f20\u53c2\u4e3a\u7a7a\u3002", (String)"ApPayableBillSynServiceImpl_0", (String)"fi-er-mservice", (Object[])new Object[0]));
            return operationResult;
        }
        logger.info("\u5e94\u4ed8\u96c6\u6210,\u5e94\u4ed8\u5355\u8c03\u7528\u53cd\u5199\u63a5\u53e3\u4f20\u53c2\uff1a{}", (Object)SerializationUtils.toJsonString((Object)apPayableSynParam));
        String srcEntityName = (String)apPayableSynParam.get("sourceEntityName");
        List billObjList = (List)apPayableSynParam.get("billObject");
        Map<Long, List<Map<String, Object>>> entryListGroupByBillId = billObjList.stream().filter(v -> v.get("billId") != null).collect(Collectors.groupingBy(t -> (Long)t.get("billId")));
        this.writeBack(srcEntityName, entryListGroupByBillId);
        operationResult.setSuccess(true);
        return operationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeBack(String srcEntityName, Map<Long, List<Map<String, Object>>> entryListGroupByBillId) {
        if (entryListGroupByBillId.size() > 0) {
            DynamicObject[] srcBillObjArray;
            MainEntityType billEntityType = MetadataServiceHelper.getDataEntityType((String)srcEntityName);
            for (DynamicObject billObj : srcBillObjArray = BusinessDataServiceHelper.load((Object[])entryListGroupByBillId.keySet().toArray(), (DynamicObjectType)billEntityType)) {
                DynamicObjectCollection accEntryCollection;
                long billObjId = (Long)billObj.getPkValue();
                DynamicObjectCollection expEntryCollection = billObj.getDynamicObjectCollection("expenseentryentity");
                List<Map<String, Object>> entryList = entryListGroupByBillId.get(billObjId);
                for (Map<String, Object> oneEntryMap : entryList) {
                    Object entryId = oneEntryMap.get("billEntryId");
                    for (DynamicObject expEntry : expEntryCollection) {
                        if (!entryId.equals(expEntry.getPkValue())) continue;
                        expEntry.set("settlestatus", oneEntryMap.get("settleStatus"));
                    }
                }
                String oldStatus = billObj.getString("billstatus");
                this.setBillStatus(billObj);
                String newStatus = billObj.getString("billstatus");
                if (StringUtils.equals((CharSequence)newStatus, (CharSequence)"G") && ErEntityTypeUtils.isPublicReimburseBill((String)srcEntityName)) {
                    accEntryCollection = billObj.getDynamicObjectCollection("accountentry");
                    billObj.set("payedamount", (Object)billObj.getBigDecimal("notpayamount"));
                    billObj.set("notpayamount", (Object)BigDecimal.ZERO);
                    if (accEntryCollection == null || accEntryCollection.size() <= 0) continue;
                    for (DynamicObject accEntry : accEntryCollection) {
                        accEntry.set("oriaccpayedamount", (Object)accEntry.getBigDecimal("orireceiveamount"));
                        accEntry.set("accpayedamount", (Object)accEntry.getBigDecimal("receiveamount"));
                        accEntry.set("oriaccnotpayamount", (Object)BigDecimal.ZERO);
                        accEntry.set("accnotpayamount", (Object)BigDecimal.ZERO);
                        accEntry.set("billstatusfield", (Object)"G");
                    }
                    continue;
                }
                if (!StringUtils.equals((CharSequence)oldStatus, (CharSequence)"G") || !StringUtils.equals((CharSequence)newStatus, (CharSequence)"F") || !ErEntityTypeUtils.isPublicReimburseBill((String)srcEntityName)) continue;
                accEntryCollection = billObj.getDynamicObjectCollection("accountentry");
                billObj.set("notpayamount", (Object)billObj.getBigDecimal("payedamount"));
                billObj.set("payedamount", (Object)BigDecimal.ZERO);
                if (accEntryCollection == null || accEntryCollection.size() <= 0) continue;
                for (DynamicObject accEntry : accEntryCollection) {
                    accEntry.set("oriaccpayedamount", (Object)BigDecimal.ZERO);
                    accEntry.set("accpayedamount", (Object)BigDecimal.ZERO);
                    accEntry.set("oriaccnotpayamount", (Object)accEntry.getBigDecimal("orireceiveamount"));
                    accEntry.set("accnotpayamount", (Object)accEntry.getBigDecimal("receiveamount"));
                    accEntry.set("billstatusfield", (Object)"F");
                }
            }
            SaveServiceHelper.save((DynamicObject[])srcBillObjArray);
            if (ErEntityTypeUtils.isPublicReimburseBill((String)srcEntityName)) {
                try {
                    this.afterSaveWriteBackResult(srcBillObjArray);
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    logger.error("---\u5e94\u4ed8\u96c6\u6210---", (Object)msg);
                }
                finally {
                    logger.info("---\u5e94\u4ed8\u96c6\u6210,\u6267\u884cafterSaveWriteBackResult\u64cd\u4f5c\u540e---");
                }
            }
        }
        return true;
    }

    private void setBillStatus(DynamicObject billObj) {
        DynamicObjectCollection expEntryCollection = billObj.getDynamicObjectCollection("expenseentryentity");
        HashSet<String> settleStatusSet = new HashSet<String>();
        for (DynamicObject expEntry : expEntryCollection) {
            settleStatusSet.add(expEntry.getString("settleStatus").trim());
        }
        logger.info("\u5e94\u4ed8\u96c6\u6210,\u5e94\u4ed8\u5355\u4ed8\u6b3e\u540e\u7ed3\u7b97\u72b6\u6001\u4e3a" + settleStatusSet.size());
        if (settleStatusSet.size() == 1 && !settleStatusSet.add("settled")) {
            billObj.set("billstatus", (Object)"G");
        } else {
            billObj.set("billstatus", (Object)"F");
        }
    }

    private void afterSaveWriteBackResult(DynamicObject[] sourceBills) {
        logger.info("\u5e94\u4ed8\u96c6\u6210,\u5bf9\u516c\u5f00\u59cb\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\uff1a {}", (Object)Thread.currentThread().getId());
        OperateOption operateOption = OperateOption.create();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)"er_publicreimbursebill", (DynamicObject[])sourceBills, (OperateOption)operateOption);
        if (!operationResult.isSuccess()) {
            ValidateResultCollection validateResult = operationResult.getValidateResult();
            logger.info("\u5e94\u4ed8\u96c6\u6210,\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5931\u8d25,\u539f\u56e0:{}", (Object)validateResult.getMessage());
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            StringBuilder stringBuffer = new StringBuilder();
            allErrorOrValidateInfo.forEach(error -> stringBuffer.append(error.getMessage()).append("\n"));
            logger.info("\u5e94\u4ed8\u96c6\u6210,\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5931\u8d25,\u8be6\u7ec6\u539f\u56e0:{}", (Object)stringBuffer);
            String msg = ResManager.loadKDString((String)"\u5e94\u4ed8\u96c6\u6210\uff0c\u53cd\u5199\u4e0a\u6e38\u5355\u636e\u5931\u8d25\uff1a", (String)"PublicReimBillWriteBackService_1", (String)"fi-er-mservice", (Object[])new Object[0]);
            throw new KDBizException(msg + SerializationUtils.toJsonString((Object)operationResult));
        }
        logger.info("\u5e94\u4ed8\u96c6\u6210,\u5bf9\u516c\u5f00\u59cb\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5df2\u5b8c\u6210");
        logger.info("\u5e94\u4ed8\u6267\u884c\u53cd\u5199\u6267\u884c\u5b8c\u6210");
    }
}

