/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.botp.factory;

import java.util.Arrays;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.mservice.botp.writeback.AbstractWriteBackServcie;
import kd.fi.er.mservice.botp.writeback.ApplyPayBillWriteBackService;
import kd.fi.er.mservice.botp.writeback.DailyLoanBillWriteBackService;
import kd.fi.er.mservice.botp.writeback.DailyReimBillWriteBackService;
import kd.fi.er.mservice.botp.writeback.ErCheckingpaybillWriteBackService;
import kd.fi.er.mservice.botp.writeback.PrePayBillWriteBackService;
import kd.fi.er.mservice.botp.writeback.PublicReimBillWriteBackService;
import kd.fi.er.mservice.botp.writeback.TripBusinessBillWriteBackService;
import kd.fi.er.mservice.botp.writeback.TripReimWriteBackService;
import kd.fi.er.mservice.botp.writeback.TripReqBillWriteBackService;
import org.apache.commons.lang3.StringUtils;

public class WriteBackServiceFactory {
    private static final String[] tripBusinessBill = new String[]{"er_planecheckingbill", "er_vehiclecheckingbill", "er_hotelcheckingbill"};
    private static final String EXT_SUBFIX = "er.writeback.";
    private static Log logger = LogFactory.getLog(WriteBackServiceFactory.class);

    public static AbstractWriteBackServcie getInstance(String entityName) {
        AbstractWriteBackServcie service = null;
        if (entityName.equals("er_dailyloanbill")) {
            service = new DailyLoanBillWriteBackService();
        } else if ("er_dailyreimbursebill".equals(entityName)) {
            service = new DailyReimBillWriteBackService();
        } else if (entityName.equals("er_tripreqbill")) {
            service = new TripReqBillWriteBackService();
        } else if (entityName.equals("er_tripreimbursebill")) {
            service = new TripReimWriteBackService();
        } else if (entityName.equals("er_publicreimbursebill")) {
            service = new PublicReimBillWriteBackService();
        } else if (Arrays.asList(tripBusinessBill).contains(entityName)) {
            service = new TripBusinessBillWriteBackService();
        } else if ("er_checkingpaybill".equals(entityName)) {
            service = new ErCheckingpaybillWriteBackService();
        } else if ("er_prepaybill".equals(entityName)) {
            service = new PrePayBillWriteBackService();
        } else if ("er_applypaybill".equals(entityName)) {
            service = new ApplyPayBillWriteBackService();
        }
        String extService = ErStdConfig.get((String)EXT_SUBFIX.concat(entityName));
        if (StringUtils.isNotBlank((CharSequence)extService)) {
            try {
                service = (AbstractWriteBackServcie)Class.forName(extService).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(String.format("%s init faild", extService), (Throwable)e);
            }
        }
        List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_WRITEBACkSERVICE, (Object[])new Object[0]);
        for (Object item : result) {
            if (!(item instanceof AbstractWriteBackServcie)) continue;
            service = (AbstractWriteBackServcie)item;
        }
        return service;
    }
}

