/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.botp.writeback;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripReimWriteBackOrderUtil;
import kd.fi.er.common.enums.PayTargeBillType;
import kd.fi.er.mservice.param.ErRefundEntryInfo;

public abstract class AbstractWriteBackServcie {
    private static Log logger = LogFactory.getLog(AbstractWriteBackServcie.class);
    private String operateName;
    private String srcEntityName;
    private Map<String, Object> errorCollection;
    protected static final String SOURCEPK = "sourcepk";
    protected static final String SOURCEBILLID = "sourcebillid";
    protected static final String ISSUCCESS_AGENT = "e_issuccess";
    protected static final String ISSUCCESS = "issuccess";
    public static final String operate_payOrSync = "payOrSync";
    public static final String operate_cancelPay = "cancelPay";
    public static final String operate_payValidate = "payValidate";
    public static final String operate_cancelPayValidate = "cancelPayValidate";
    public static final String operate_renote = "renote";
    public static final String operate_renoteValidate = "renoteValidate";
    public static final String operate_refund = "refund";
    public static final String operate_refundValidate = "refundValidate";
    protected static final String IS_REFUND = "e_isrefund";
    public static final String operate_cancelRefund = "cancelRefund";
    public static final String operate_cancelRefundValidate = "cancelRefundValidate";
    public static final String operate_cancelRenote = "cancelRenote";
    public static final String operate_cancelRnoteValidate = "cancelRenoteValidate";
    protected static final String casPayBill = "cas_paybill";
    protected static final String casAgentPayBill = "cas_agentpaybill";

    public String getSrcEntityName() {
        return this.srcEntityName;
    }

    public void setSrcEntityName(String entryName) {
        this.srcEntityName = entryName;
    }

    protected void addErrorCode(String targetBillId, Object errorCode) {
        if (this.errorCollection == null) {
            this.errorCollection = new HashMap<String, Object>();
        }
        errorCode = this.errorCollection.get(targetBillId) == null ? errorCode : this.errorCollection.get(targetBillId) + ";" + errorCode;
        this.errorCollection.put(targetBillId, errorCode);
    }

    public Map<String, Object> getErrorCollection() {
        return this.errorCollection;
    }

    public String getOperateName() {
        return this.operateName;
    }

    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }

    public boolean getValidateResult(DynamicObject[] sourceBills, Collection tarBillEntryCollction, Object targetPkId) {
        if (sourceBills.length <= 0 || tarBillEntryCollction.size() <= 0) {
            this.addErrorCode(String.valueOf(targetPkId), ResManager.loadKDString((String)"\u672a\u627e\u5230\u6e90\u5355\uff0c\u6216\u4f20\u9012\u53c2\u6570\u5bf9\u5e94\u7684\u4e0b\u6e38\u5206\u5f55\u4e0d\u6b63\u786e\u3002", (String)"AbstractWriteBackServcie_0", (String)"fi-er-mservice", (Object[])new Object[0]));
            return false;
        }
        if (tarBillEntryCollction instanceof DynamicObjectCollection) {
            ((DynamicObjectCollection)tarBillEntryCollction).sort((Comparator)new ComparatorByAmount());
            for (DynamicObject tarBillEntry : tarBillEntryCollction) {
                for (DynamicObject sourceBill : sourceBills) {
                    if (this.writeBack(sourceBill, tarBillEntry, targetPkId)) continue;
                    return false;
                }
            }
        } else if (tarBillEntryCollction instanceof List) {
            ((List)tarBillEntryCollction).sort(new ComparatorByAmount());
            for (Object tarBillEntry : tarBillEntryCollction) {
                for (DynamicObject sourceBill : sourceBills) {
                    if (this.writeBack(sourceBill, tarBillEntry, targetPkId)) continue;
                    return false;
                }
            }
        } else {
            this.addErrorCode(String.valueOf(targetPkId), ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u4e0d\u6b63\u786e\u3002", (String)"AbstractWriteBackServcie_1", (String)"fi-er-mservice", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected abstract boolean writeBack(DynamicObject var1, Object var2, Object var3);

    public abstract String getSelectFileds();

    public void beforeSaveWriteBackResult(DynamicObject[] sourceBills) {
    }

    public void afterSaveWriteBackResult(DynamicObject[] sourceBills) {
    }

    void saveWriteBackRecord(String targetBillType, Long targetBillId, Long entryId, Long recid) {
        DynamicObject[] objects = this.getIdempotent(targetBillType, targetBillId, entryId, recid);
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"er_caswriteback");
        DynamicObject object = new DynamicObject((DynamicObjectType)dynamicObjectType);
        object.set("operatetype", (Object)this.getOperateName());
        object.set("billtype", (Object)targetBillType);
        object.set("targetbillid", (Object)targetBillId);
        object.set("targetentryid", (Object)entryId);
        object.set("recid", (Object)recid);
        object.set("createtime", (Object)new Date());
        logger.info("operatetype : {}, billtype:  {}, targetbillid:  {}, targetentryid:  {}, recid: {}", new Object[]{this.getOperateName(), targetBillType, targetBillId, entryId, recid});
        DynamicObject[] nrecords = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        DynamicObject n = nrecords[0];
        this.unvalid(objects, n);
    }

    boolean checkCanWriteBack(String targetBillType, Long targetBillId, Long entryId, Long recid) {
        if (TripReimWriteBackOrderUtil.onlyValidate((String)this.getOperateName())) {
            return true;
        }
        DynamicObject[] dynamicObject = this.getIdempotent(targetBillType, targetBillId, entryId, recid);
        if (dynamicObject == null) {
            return true;
        }
        boolean match = Arrays.stream(dynamicObject).anyMatch(m -> this.getOperateName().equals(m.getString("operatetype")));
        if (match) {
            return false;
        }
        logger.error(String.format("operatetype: %s, targetbillid: %s, targetentryid: %s ,recid: %s, \u5df2\u53cd\u5199", this.getOperateName(), targetBillId, entryId, recid));
        return true;
    }

    private DynamicObject[] getIdempotent(String targetBillType, Long targetBillId, Long entryId, Long recid) {
        QFilter[] qFilters = new QFilter[]{new QFilter("targetbillid", "=", (Object)targetBillId), new QFilter("targetentryid", "=", (Object)entryId), new QFilter("billtype", "=", (Object)targetBillType), new QFilter("recid", "=", (Object)recid), new QFilter("valid", "=", (Object)"1")};
        Map map = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_caswriteback"), (QFilter[])qFilters);
        DynamicObject[] dynamicObject = null;
        if (map != null) {
            dynamicObject = map.values().toArray(new DynamicObject[0]);
        }
        return dynamicObject;
    }

    String getBillType(Object tarBillEntryInfo) {
        if (tarBillEntryInfo instanceof DynamicObject) {
            return casAgentPayBill;
        }
        if (tarBillEntryInfo instanceof ErRefundEntryInfo) {
            return ((ErRefundEntryInfo)tarBillEntryInfo).isCasPay() ? casPayBill : casAgentPayBill;
        }
        return casPayBill;
    }

    PayTargeBillType getBillTypeEnum(Object tarBillEntryInfo) {
        if (casPayBill.equals(this.getBillType(tarBillEntryInfo))) {
            return PayTargeBillType.CAS_PAYBILL;
        }
        return PayTargeBillType.CAS_AGENTPAYBILL;
    }

    Long getEntryId(Object tarBillEntryInfo) {
        if (tarBillEntryInfo instanceof DynamicObject) {
            return (Long)((DynamicObject)tarBillEntryInfo).getPkValue();
        }
        if (tarBillEntryInfo instanceof ErRefundEntryInfo) {
            return ((ErRefundEntryInfo)tarBillEntryInfo).getRefundEntryInfo().getTargetEntryPk();
        }
        return (Long)((Map)tarBillEntryInfo).get("targetentrypk");
    }

    Long getRecId(Object tarBillEntryInfo) {
        if (tarBillEntryInfo instanceof ErRefundEntryInfo) {
            return ((ErRefundEntryInfo)tarBillEntryInfo).getRecId();
        }
        return 0L;
    }

    public boolean needOverrideAfterSaveWriteBackResult() {
        return false;
    }

    private void unvalid(DynamicObject[] objects, DynamicObject n) {
        if (objects == null) {
            return;
        }
        DynamicObject o = null;
        String matchOperate = "";
        if (operate_payOrSync.equals(this.getOperateName())) {
            matchOperate = operate_cancelPay;
        } else if (operate_cancelPay.equals(this.getOperateName())) {
            matchOperate = operate_payOrSync;
        } else if (operate_renote.equals(this.getOperateName())) {
            matchOperate = operate_cancelRenote;
        } else if (operate_cancelRenote.equals(this.getOperateName())) {
            matchOperate = operate_renote;
        } else if (operate_refund.equals(this.getOperateName())) {
            matchOperate = operate_cancelRefund;
        } else if (operate_cancelRefund.equals(this.getOperateName())) {
            matchOperate = operate_refund;
        }
        String finalMatchOperate = matchOperate;
        o = Arrays.stream(objects).filter(m -> finalMatchOperate.equals(m.getString("operatetype"))).findFirst().orElse(null);
        if (o != null) {
            o.set("valid", (Object)"0");
            n.set("valid", (Object)"0");
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{o, n});
        }
    }

    class ComparatorByAmount
    implements Comparator {
        ComparatorByAmount() {
        }

        public int compare(Object o1, Object o2) {
            BigDecimal b1 = null;
            BigDecimal b2 = null;
            if (o1 instanceof Map) {
                b1 = (BigDecimal)((Map)o1).get("amount");
                b2 = (BigDecimal)((Map)o2).get("amount");
            } else if (o1 instanceof DynamicObject) {
                b1 = ((DynamicObject)o1).getBigDecimal("e_amount");
                b2 = ((DynamicObject)o2).getBigDecimal("e_amount");
            }
            if (b1 != null && b2 != null) {
                if (AbstractWriteBackServcie.this.operateName.equals(AbstractWriteBackServcie.operate_payOrSync) || AbstractWriteBackServcie.this.operateName.equals(AbstractWriteBackServcie.operate_payValidate)) {
                    return b1.compareTo(b2);
                }
                return b1.compareTo(b2);
            }
            return 0;
        }
    }
}

