/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.invoice;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.common.model.invoice.Invoice;
import kd.fi.er.common.model.invoice.InvoiceOCRVO;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.mservice.bill.InvoiceService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceServiceImpl
implements InvoiceService {
    private static final String DEFAULT_INVOICE_NO = "-";
    private static final String DEFAULT_INVOICE_CODE = "-";
    private static Log logger = LogFactory.getLog(InvoiceServiceImpl.class);

    public void addInvoiceIntoBill(String entityName, String billid) {
        String fmt = ResManager.loadKDString((String)"\u5bfc\u5165OCR\u53d1\u7968\u3002entityName: %1$s, billid: %2$s, msg: %3$s\u3002", (String)"InvoiceServiceImpl_0", (String)"fi-er-mservice", (Object[])new Object[0]);
        logger.info(String.format(fmt, entityName, billid, "\u8c03\u7528\u5f00\u59cb"));
        long _billid = Long.parseLong(billid);
        List<Invoice> invoices = this.getInvoiceForBos(billid);
        if (invoices == null || invoices.size() == 0) {
            logger.info(String.format(fmt, entityName, billid, "\u67e5\u65e0\u53d1\u7968\uff0c\u76f4\u63a5\u8fd4\u56de"));
            return;
        }
        DynamicObject bill = this.queryBill(entityName, _billid);
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("invoiceentry");
        if ((invoices = this.distinctByCodeNo(invoices, bill)).size() == 0) {
            return;
        }
        DynamicObjectType entryType = entries.getDynamicObjectType();
        for (Invoice invoice : invoices) {
            DynamicObject entry = this.convertToEntry(invoice, entryType);
            entries.add((Object)entry);
        }
        for (int i = 0; i < entries.size(); ++i) {
            ((DynamicObject)entries.get(i)).set("seq", (Object)(i + 1));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
    }

    private List<Invoice> distinctByCodeNo(List<Invoice> invoices, DynamicObject bill) {
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("invoiceentry");
        Set serialnoSet = entries.stream().map(v -> v.getString("serialno")).collect(Collectors.toSet());
        return invoices.stream().filter(v -> !serialnoSet.contains(v.getSerialNo()) && !StringUtils.equals((CharSequence)InvoiceTypeEnum.key_11.getValue(), (CharSequence)v.getInvoiceVO().getInvoiceType()) && StringUtils.isNotBlank((CharSequence)v.getInvoiceVO().getInvoiceType())).collect(Collectors.toList());
    }

    private DynamicObject queryBill(String entityName, long _billid) {
        String selectFields = "id,invoiceentry.seq,invoiceentry.invoicetype,invoiceentry.invoicecode,invoiceentry.invoiceno,invoiceentry.invoicedate,invoiceentry.totalamount,invoiceentry.taxrate_invoice,invoiceentry.taxamount_invoice,invoiceentry.passengername,invoiceentry.buyerorgname,invoiceentry.makeoutcompname,invoiceentry.count,invoiceentry.remark_invoice,invoiceentry.frominvoicecloud,invoiceentry.serialno,invoiceentry.invoiceairportconstfee,invoiceentry.alltaxrate,invoiceentry.invoicefrom,invoiceentry.ismapexpense,invoiceentry.invoicefromcity,invoiceentry.invoicetocity,invoiceentry.istartcity,invoiceentry.idestcity,invoiceentry.istartprovince,invoiceentry.idestprovince,invoiceentry.seatgrade,invoiceentry.transportnote,invoiceentry.invoicenotaxamount,invoiceentry.buyertaxno,invoiceentry.ticketchanges,invoiceentry.flighttrainnums";
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)_billid)};
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)entityName, (String)selectFields, (QFilter[])filters);
        return bill;
    }

    private DynamicObject convertToEntry(Invoice invoice, DynamicObjectType entryType) {
        DynamicObject entry = (DynamicObject)entryType.createInstance();
        InvoiceEntryBO invoiceEntryBO = this.generateInvoiceEntryBO(invoice);
        this.createInvoiceHeadEntry(invoiceEntryBO, entry);
        return entry;
    }

    private List<Invoice> getInvoiceForBos(String billid) {
        String selectFields = "invoicedate,billid,invoicecode,invoicetype,invoiceno,entrykeyvalue.invoicekey,entrykeyvalue.invoicevalue,entryentity.invoiceentrykey,entryentity.invoiceentryvalue";
        QFilter[] filters = new QFilter[]{new QFilter("billid", "=", (Object)billid)};
        DynamicObject[] col = BusinessDataServiceHelper.load((String)"bos_invoice", (String)selectFields, (QFilter[])filters);
        ArrayList invocies = Lists.newArrayListWithExpectedSize((int)col.length);
        for (DynamicObject bill : col) {
            Invoice invocie = new Invoice(bill);
            invocies.add(invocie);
        }
        return invocies;
    }

    private void createInvoiceHeadEntry(InvoiceEntryBO invoiceEntryBO, DynamicObject entry) {
        entry.set("invoicetype", (Object)invoiceEntryBO.getInvoiceType());
        entry.set("invoicecode", (Object)invoiceEntryBO.getInvoiceCode());
        entry.set("invoiceno", (Object)invoiceEntryBO.getInvoiceNo());
        entry.set("invoicedate", (Object)invoiceEntryBO.getInvoiceDate());
        entry.set("totalamount", (Object)invoiceEntryBO.getTotalAmount());
        entry.set("taxrate_invoice", (Object)invoiceEntryBO.getTaxRate().multiply(BigDecimal.valueOf(100L)));
        entry.set("taxamount_invoice", (Object)invoiceEntryBO.getTaxAmount());
        entry.set("passengername", (Object)invoiceEntryBO.getPassengerName());
        entry.set("buyerorgname", (Object)invoiceEntryBO.getBuyerOrgName());
        entry.set("makeoutcompname", (Object)invoiceEntryBO.getMakeOutCompanyName());
        entry.set("count", (Object)1);
        String remarkInvoice = StringUtils.abbreviate((String)invoiceEntryBO.getRemark_Invoice(), (int)1024);
        entry.set("remark_invoice", (Object)remarkInvoice);
        entry.set("serialno", (Object)invoiceEntryBO.getSerialNo());
        entry.set("invoiceairportconstfee", (Object)invoiceEntryBO.getAirportConstructionFee());
        entry.set("alltaxrate", (Object)invoiceEntryBO.getAllTaxRate());
        entry.set("invoicefrom", (Object)InvoiceFrom.ORC.getValue());
        entry.set("ismapexpense", (Object)"0");
        if (entry.getDynamicObjectType().getProperty("invoicefromcity") != null) {
            entry.set("invoicefromcity", (Object)invoiceEntryBO.getFrom());
        }
        if (entry.getDynamicObjectType().getProperty("invoicetocity") != null) {
            entry.set("invoicetocity", (Object)invoiceEntryBO.getTo());
        }
        if (entry.getDynamicObjectType().getProperty("istartcity") != null) {
            entry.set("istartcity", (Object)invoiceEntryBO.getStartCity());
        }
        if (entry.getDynamicObjectType().getProperty("idestcity") != null) {
            entry.set("idestcity", (Object)invoiceEntryBO.getDestCity());
        }
        if (entry.getDynamicObjectType().getProperty("istartprovince") != null) {
            entry.set("istartprovince", (Object)invoiceEntryBO.getStartProvince());
        }
        if (entry.getDynamicObjectType().getProperty("idestprovince") != null) {
            entry.set("idestprovince", (Object)invoiceEntryBO.getDestProvince());
        }
        if (entry.getDynamicObjectType().getProperty("seatgrade") != null) {
            entry.set("seatgrade", (Object)invoiceEntryBO.getSeatGrade());
        }
        if (entry.getDynamicObjectType().getProperty("transportnote") != null) {
            entry.set("transportnote", (Object)invoiceEntryBO.getTransportNote());
        }
        if (entry.getDynamicObjectType().getProperty("invoicenotaxamount") != null) {
            entry.set("invoicenotaxamount", (Object)invoiceEntryBO.getInvoiceNoTaxAmount());
        }
        if (entry.getDynamicObjectType().getProperty("buyertaxno") != null) {
            entry.set("buyertaxno", (Object)invoiceEntryBO.getBuyerTaxNo());
        }
        if (entry.getDynamicObjectType().getProperty("salertaxno_h") != null) {
            entry.set("salertaxno_h", (Object)invoiceEntryBO.getSalerTaxNo());
        }
        if (entry.getDynamicObjectType().getProperty("ticketchanges") != null) {
            entry.set("ticketchanges", (Object)invoiceEntryBO.getTicketChanges());
        }
        if (entry.getDynamicObjectType().getProperty("flighttrainnums") != null) {
            entry.set("flighttrainnums", (Object)invoiceEntryBO.getFlightTrainNums());
        }
    }

    private InvoiceEntryBO generateInvoiceEntryBO(Invoice invoice) {
        String ticketChanges;
        InvoiceOCRVO invoiceVO = invoice.getInvoiceVO();
        InvoiceEntryBO invoiceEntryBO = new InvoiceEntryBO();
        invoiceEntryBO.setInvoiceType(invoiceVO.getInvoiceType());
        invoiceEntryBO.setInvoiceCode((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getInvoiceCode(), (CharSequence)"-"));
        invoiceEntryBO.setInvoiceNo((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getInvoiceNo(), (CharSequence)"-"));
        invoiceEntryBO.setInvoiceDate(invoiceVO.getInvoiceDate());
        invoiceEntryBO.setTotalAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getTotalAmount(), (Object)BigDecimal.ZERO));
        invoiceEntryBO.setTaxAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getTaxAmount(), (Object)BigDecimal.ZERO));
        BigDecimal taxRate = BigDecimal.ZERO;
        BigDecimal excludeTaxAmount = invoiceEntryBO.getTotalAmount().subtract(invoiceEntryBO.getTaxAmount());
        if (excludeTaxAmount.abs().compareTo(BigDecimal.valueOf(1.0E-6)) > 0) {
            if (StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_10.getValue())) {
                BigDecimal airExcludeTaxAmount = ((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getAmount(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getFuelSurcharge(), (Object)BigDecimal.ZERO)).subtract(invoiceEntryBO.getTaxAmount());
                if (airExcludeTaxAmount.abs().compareTo(BigDecimal.valueOf(1.0E-6)) > 0) {
                    taxRate = invoiceEntryBO.getTaxAmount().divide(airExcludeTaxAmount, 3, RoundingMode.HALF_EVEN);
                }
            } else {
                taxRate = invoiceEntryBO.getTaxAmount().divide(excludeTaxAmount, 3, RoundingMode.HALF_EVEN);
            }
        }
        invoiceEntryBO.setTaxRate(taxRate);
        if (StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_10.getValue())) {
            invoiceEntryBO.setPassengerName((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getCustomerName(), (CharSequence)""));
        } else {
            invoiceEntryBO.setPassengerName((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getPassengerName(), (CharSequence)""));
        }
        invoiceEntryBO.setBuyerOrgName((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getBuyerName(), (CharSequence)""));
        invoiceEntryBO.setMakeOutCompanyName((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getSalerName(), (CharSequence)""));
        invoiceEntryBO.setInvoiceCount(Integer.valueOf(1));
        StringBuilder remarkSb = new StringBuilder((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getRemark(), (CharSequence)""));
        if (invoiceVO.getTimeGetOn() != null) {
            remarkSb.append(String.format(ResManager.loadKDString((String)"; \u4e0a\u8f66\u65f6\u95f4: %s", (String)"CopyInvoiceVOToInvoiceEntrBOServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), invoiceVO.getTimeGetOn()));
        }
        if (invoiceVO.getTimeGetOff() != null) {
            remarkSb.append(String.format(ResManager.loadKDString((String)"; \u4e0b\u8f66\u65f6\u95f4: %s", (String)"CopyInvoiceVOToInvoiceEntrBOServiceImpl_1", (String)"fi-er-business", (Object[])new Object[0]), invoiceVO.getTimeGetOff()));
        }
        if (invoiceVO.getMileage() != null) {
            remarkSb.append(String.format(ResManager.loadKDString((String)"; \u91cc\u7a0b: %skm", (String)"CopyInvoiceVOToInvoiceEntrBOServiceImpl_2", (String)"fi-er-business", (Object[])new Object[0]), invoiceVO.getMileage()));
        }
        invoiceEntryBO.setRemarkInvoice(remarkSb.length() > 0 && remarkSb.charAt(0) == ';' ? remarkSb.substring(1, remarkSb.length()) : remarkSb.toString());
        invoiceEntryBO.setRemark_Invoice(remarkSb.length() > 0 && remarkSb.charAt(0) == ';' ? remarkSb.substring(1, remarkSb.length()) : remarkSb.toString());
        invoiceEntryBO.setSerialNo((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getSerialNo(), (CharSequence)""));
        BigDecimal newAirPortConstruFee = ((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getAirportConstructionFee(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getOtherTotalTaxAmount(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getInsurancePremium(), (Object)BigDecimal.ZERO));
        invoiceEntryBO.setAirportConstructionFee((BigDecimal)ObjectUtils.defaultIfNull((Object)newAirPortConstruFee, (Object)BigDecimal.ZERO));
        invoiceEntryBO.setBuyerTaxNo((String)StringUtils.defaultIfEmpty((CharSequence)invoiceVO.getBuyerTaxNo(), (CharSequence)""));
        invoiceEntryBO.setSalerTaxNo((String)StringUtils.defaultIfEmpty((CharSequence)invoiceVO.getSalerTaxNo(), (CharSequence)""));
        this.setAllTax(invoice, invoiceEntryBO);
        String seatGrade = "";
        seatGrade = StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_10.getValue()) ? (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getSeatGrade(), (CharSequence)"") : (StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_9.getValue()) ? (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getSeat(), (CharSequence)"") : (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getSeatGrade(), (CharSequence)""));
        invoiceEntryBO.setSeatGrade(seatGrade);
        String from = "";
        String to = "";
        if (StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_10.getValue())) {
            to = (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getDestination(), (CharSequence)"");
            from = (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getPlaceOfDeparture(), (CharSequence)"");
        } else if (StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_9.getValue()) || StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_16.getValue())) {
            to = (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getStationGetoff(), (CharSequence)"");
            from = (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getStationGeton(), (CharSequence)"");
        } else {
            String trip = invoiceVO.getTrip();
            if (StringUtils.isNotBlank((CharSequence)trip) && trip.indexOf("-") != -1) {
                String[] trips = trip.split("-");
                from = trips[0].trim();
                to = trips[1].trim();
            }
        }
        invoiceEntryBO.setFrom(from);
        invoiceEntryBO.setStartCity(from);
        invoiceEntryBO.setTo(to);
        invoiceEntryBO.setDestCity(to);
        if (StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_10.getValue())) {
            invoiceEntryBO.setFlightTrainNums((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getFlightNum(), (CharSequence)""));
        } else if (StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_9.getValue())) {
            invoiceEntryBO.setFlightTrainNums((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getTrainNum(), (CharSequence)""));
        }
        invoiceEntryBO.setDestProvince("");
        invoiceEntryBO.setDestCity("");
        invoiceEntryBO.setInvoiceNoTaxAmount(invoiceEntryBO.getTotalAmount().subtract(invoiceEntryBO.getTaxAmount()));
        Set vehicleInvoiceTypes = InvoiceTypeUtils.loadVehicleInvoiceTypes();
        String invoiceType = invoiceVO.getInvoiceType();
        boolean isTranNote = false;
        if (vehicleInvoiceTypes.contains(invoiceType)) {
            isTranNote = true;
        }
        invoiceEntryBO.setTransportNote(isTranNote ? "1" : "0");
        if (StringUtils.equals((CharSequence)InvoiceTypeEnum.key_10.getValue(), (CharSequence)invoiceType) && StringUtils.equals((CharSequence)"2", (CharSequence)(ticketChanges = invoiceVO.getTicketChanges()))) {
            BigDecimal airportConstructionFee = invoiceVO.getOtherTotalTaxAmount();
            invoiceEntryBO.setAirportConstructionFee(airportConstructionFee);
            invoiceEntryBO.setTicketChanges("2");
        }
        return invoiceEntryBO;
    }

    private void setAllTax(Invoice invoice, InvoiceEntryBO invoiceEntryBO) {
        InvoiceOCRVO invoiceVO = invoice.getInvoiceVO();
        Map itemMap = invoice.getInvoiceItemMap();
        if (itemMap != null && StringUtils.isNotBlank((CharSequence)((CharSequence)itemMap.get("taxRate")))) {
            invoiceEntryBO.setAllTaxRate((String)itemMap.get("taxRate"));
        } else {
            BigDecimal taxRateAll = invoiceVO.getTaxRate();
            if (taxRateAll == null) {
                invoiceEntryBO.setAllTaxRate("");
            } else {
                invoiceEntryBO.setAllTaxRate(StringUtils.defaultString((String)String.valueOf(taxRateAll.multiply(BigDecimal.valueOf(100L))), (String)""));
            }
        }
    }
}

