/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.tripstd.model.TripStandardDetail;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripHighSeasonStandardUtil;
import kd.fi.er.common.ControlMethodEnum;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import kd.fi.er.formplugin.web.tripstandard.util.TripStandardUtils;
import org.apache.commons.lang3.StringUtils;

public class CalculateTripSum {
    private static HashSet<String> vehicleAttributes = Sets.newHashSet((Object[])new String[]{"2", "4", "7", "3"});
    private static HashSet<String> accommodationAttributes = Sets.newHashSet((Object[])new String[]{"5"});
    private static HashSet<String> allowanceAttributes = Sets.newHashSet((Object[])new String[]{"1"});
    private static HashSet<String> notOthers = Sets.newHashSet((Object[])new String[]{"2", "4", "7", "5", "1", "3"});

    public static Map<Long, List> calculate(DynamicObject bill) {
        Long companyId = ErCommonUtils.getPk((Object)bill.get("company"));
        companyId = companyId == null ? Long.valueOf(0L) : companyId;
        boolean sumcheck = SystemParamterUtil.getTripStdNeedSumCheck((long)companyId);
        boolean enableAccdAllowanceStd = CalculateTripSum.isEnableStandard(companyId) && CalculateTripSum.isEnableAccdAllowance(companyId);
        boolean enableVehicleStd = CalculateTripSum.isEnableStandard(companyId) && CalculateTripSum.isEnableVehicle(companyId);
        CurrencyBO currencyBO = new CurrencyBO(ErCommonUtils.getPk((Object)bill.get("currency")));
        String billKind = bill.getString("billkind");
        DynamicObjectCollection tripEntryCollction = bill.getDynamicObjectCollection("tripentry");
        HashMap<Long, List> map = new HashMap<Long, List>(4);
        for (int tripEntryIndex = 0; tripEntryIndex < tripEntryCollction.size(); ++tripEntryIndex) {
            DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(tripEntryIndex);
            BigDecimal tripvehicleamount = BigDecimal.ZERO;
            BigDecimal tripaccommodationamount = BigDecimal.ZERO;
            BigDecimal tripallowanceamount = BigDecimal.ZERO;
            BigDecimal tripotheramount = BigDecimal.ZERO;
            BigDecimal tripaccommodationover = BigDecimal.ZERO;
            BigDecimal tripallowanceover = BigDecimal.ZERO;
            String tripvehicleover = "0";
            ArrayList<String> groupby = new ArrayList<String>(4);
            DynamicObjectCollection detailEntryCollction = tripEntry.getDynamicObjectCollection("entryentity");
            for (int detailEntryIndex = 0; detailEntryIndex < detailEntryCollction.size(); ++detailEntryIndex) {
                String attribute;
                DynamicObject detailEntry = (DynamicObject)detailEntryCollction.get(detailEntryIndex);
                DynamicObject expenseItem = (DynamicObject)detailEntry.get("expenseitem");
                String string = attribute = expenseItem == null ? "" : expenseItem.getString("attribute");
                if (expenseItem != null && vehicleAttributes.contains(attribute)) {
                    tripvehicleamount = tripvehicleamount.add(detailEntry.getBigDecimal("entryappamount"));
                    if (!Arrays.asList("2", "4", "7").contains(attribute) || !enableVehicleStd || !"1".equals(detailEntry.getString("isover"))) continue;
                    tripvehicleover = "1";
                    continue;
                }
                RefObject refObject = new RefObject((Object)BigDecimal.ZERO);
                boolean isover = false;
                boolean over = false;
                if (enableAccdAllowanceStd && (accommodationAttributes.contains(attribute) || allowanceAttributes.contains(attribute))) {
                    isover = CalculateTripSum.checkAccdAllowanceEntryStdIsOver(companyId, detailEntry, tripEntryIndex, detailEntryIndex, currencyBO.getPrecision(), (RefObject<BigDecimal>)refObject);
                    if (sumcheck && !"1".equals(billKind) && !groupby.contains(TripStandardUtils.fetchGroupKey((DynamicObject)detailEntry, (String[])new String[]{"expenseitem", "entrycurrency"}))) {
                        if (!detailEntry.getBoolean("useroutstdctrl")) {
                            over = CalculateTripSum.checkSumGroupStdIsOver(bill, detailEntry, detailEntryCollction, tripEntryIndex, detailEntryIndex, currencyBO.getPrecision(), (RefObject<BigDecimal>)refObject, "expenseitem", "entrycurrency");
                        }
                        if (over) {
                            groupby.add(TripStandardUtils.fetchGroupKey((DynamicObject)detailEntry, (String[])new String[]{"expenseitem", "entrycurrency"}));
                        }
                    }
                }
                if (expenseItem == null || !notOthers.contains(attribute)) {
                    tripotheramount = tripotheramount.add(detailEntry.getBigDecimal("entryappamount"));
                    continue;
                }
                if (accommodationAttributes.contains(attribute)) {
                    tripaccommodationamount = tripaccommodationamount.add(detailEntry.getBigDecimal("entryappamount"));
                    if (!isover && !over) continue;
                    tripaccommodationover = tripaccommodationover.add((BigDecimal)refObject.getValue());
                    continue;
                }
                if (!allowanceAttributes.contains(attribute)) continue;
                tripallowanceamount = tripallowanceamount.add(detailEntry.getBigDecimal("entryappamount"));
                if (!isover && !over) continue;
                tripallowanceover = tripallowanceover.add((BigDecimal)refObject.getValue());
            }
            map.put((Long)tripEntry.getPkValue(), Arrays.asList(tripvehicleamount, tripvehicleover, tripaccommodationamount, tripaccommodationover, tripallowanceamount, tripallowanceover, tripotheramount));
        }
        return map;
    }

    private static boolean checkAccdAllowanceEntryStdIsOver(Long companyId, DynamicObject entry, int parentEntryIndex, int curEntryIndex, int amtprecision, RefObject<BigDecimal> refObject) {
        boolean isOverStd = false;
        boolean isCancelOrder = entry.getBoolean("iscancelorder");
        BigDecimal oriEntryAmount = entry.getBigDecimal("entryappamount");
        boolean userOutStdCtrl = entry.getBoolean("useroutstdctrl");
        BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((CalculateTripSum.isEnableStandard(companyId) && CalculateTripSum.isEnableAccdAllowance(companyId) && CalculateTripSum.isOpenHighSeasonStd(companyId) ? 1 : 0) != 0, (DynamicObject)entry);
        oriMaxStdAmount = CalculateTripSum.getCurrencyAmount(entry, amtprecision, oriMaxStdAmount);
        if (!userOutStdCtrl && !isCancelOrder && oriEntryAmount.compareTo(oriMaxStdAmount) > 0) {
            isOverStd = true;
            refObject.setValue((Object)oriEntryAmount.subtract(oriMaxStdAmount));
        }
        return isOverStd;
    }

    private static BigDecimal getCurrencyAmount(DynamicObject entry, int precision, BigDecimal oriMaxStdAmount) {
        BigDecimal stdexchangerate = entry.getBigDecimal("exchangerate");
        if (stdexchangerate == null) {
            stdexchangerate = BigDecimal.ONE;
        }
        if (precision < 0 || precision > 10) {
            precision = 2;
        }
        if ("0".equals(entry.getString("detailquotetype"))) {
            oriMaxStdAmount = oriMaxStdAmount.multiply(stdexchangerate).setScale(precision, RoundingMode.HALF_UP);
        } else if (stdexchangerate.compareTo(BigDecimal.ZERO) != 0) {
            oriMaxStdAmount = oriMaxStdAmount.divide(stdexchangerate, precision, RoundingMode.HALF_UP);
        }
        return oriMaxStdAmount;
    }

    private static boolean checkSumGroupStdIsOver(DynamicObject tripObject, DynamicObject entryObject, DynamicObjectCollection entryColl, int cardIndex, int rowIndex, int amtprecision, RefObject<BigDecimal> refObject, String ... groupPrppertyName) {
        boolean isOver = false;
        if (entryObject == null || entryColl == null || entryColl.isEmpty() || ArrayUtils.isEmpty((Object[])groupPrppertyName)) {
            return isOver;
        }
        Map<String, List<DynamicObject>> sumGroupEntry = entryColl.stream().collect(Collectors.groupingBy(entry -> TripStandardUtils.fetchGroupKey((DynamicObject)entry, (String[])groupPrppertyName)));
        List entryOfGroup = sumGroupEntry.getOrDefault(TripStandardUtils.fetchGroupKey((DynamicObject)entryObject, (String[])groupPrppertyName), new ArrayList());
        BigDecimal sumStdAmount = BigDecimal.ZERO;
        BigDecimal sumReimAmount = BigDecimal.ZERO;
        DynamicObject tripExp = entryObject.getDynamicObject("expenseitem");
        if (tripExp != null) {
            BigDecimal daycount = BigDecimal.valueOf(entryObject.getInt("daycount"));
            String attributeType = tripExp.getString("attribute");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)attributeType)) {
                daycount = daycount.add(CalculateTripSum.getTripDelayDay(cardIndex, rowIndex, tripObject));
            }
            Long companyId = ErCommonUtils.getPk((Object)tripObject.get("company"));
            BigDecimal highSeasonDays = CalculateTripSum.getTripHighDays(entryObject, companyId);
            if (!entryOfGroup.isEmpty()) {
                String mulTraStdCtrType;
                DynamicObjectCollection travelers = ((DynamicObject)entryObject.getParent()).getDynamicObjectCollection("travelers");
                List<Long> userIds = travelers.stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toList());
                TripStandardDetail tripStdDetail = CalculateTripSum.getSumGroupStd(userIds, entryObject, mulTraStdCtrType = SystemParamterUtil.getMultiTravelerStdControlType((long)companyId));
                if (tripStdDetail != null) {
                    BigDecimal tripSTDAmount = tripStdDetail.getStandardamount();
                    BigDecimal highSeasonTripSTDAmount = tripStdDetail.getHighSeasonStandardamount();
                    String attribute = entryObject.getDynamicObject("expenseitem").getString("attribute");
                    if ("5".equals(attribute) && "max".equals(mulTraStdCtrType)) {
                        tripSTDAmount = tripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
                        highSeasonTripSTDAmount = highSeasonTripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
                    }
                    sumStdAmount = sumStdAmount.add(tripSTDAmount.multiply(daycount.subtract(highSeasonDays))).add(highSeasonTripSTDAmount.multiply(highSeasonDays));
                }
                for (DynamicObject entry2 : entryOfGroup) {
                    sumReimAmount = sumReimAmount.add(entry2.getBigDecimal("entryappamount"));
                }
            }
            if (sumReimAmount.compareTo(sumStdAmount = CalculateTripSum.getCurrencyAmount(entryObject, amtprecision, sumStdAmount)) > 0) {
                isOver = true;
                refObject.setValue((Object)sumReimAmount.subtract(sumStdAmount));
            }
        }
        return isOver;
    }

    private static BigDecimal getTripDelayDay(int cardIndex, int rowIndex, DynamicObject tripObject) {
        Long companyId = ErCommonUtils.getPk((Object)tripObject.get("company"));
        String billKind = tripObject.getString("billkind");
        DynamicObjectCollection mainPageTripEntry = tripObject.getDynamicObjectCollection("tripentry");
        DynamicObjectCollection tripEntry = tripObject.getDynamicObjectCollection("tripentry");
        DynamicObjectCollection detailEntry = ((DynamicObject)tripEntry.get(cardIndex)).getDynamicObjectCollection("entryentity");
        DynamicObject curRow = (DynamicObject)detailEntry.get(rowIndex);
        if (curRow.getDynamicObject("expenseitem") == null || !StringUtils.equals((CharSequence)ErTripExpenseItemConstant.Attribute.Subsidy.getValue(), (CharSequence)curRow.getDynamicObject("expenseitem").getString("attribute"))) {
            return BigDecimal.ZERO;
        }
        if (!SystemParamterUtil.isOpenTripDateControl((Long)ErCommonUtils.getPk((Object)tripObject.get("company"))) || tripObject.getBoolean("istravelers") || !SystemParamterUtil.isEnableTripStandard((Long)companyId)) {
            return TripHighSeasonStandardUtil.getDelayDay((Long)companyId);
        }
        switch (billKind) {
            case "0": {
                if (cardIndex == 0) {
                    return BigDecimal.ONE;
                }
                Date preTripEndDay = ((DynamicObject)mainPageTripEntry.get(cardIndex - 1)).getDate("enddate");
                Date curTripStartDay = ((DynamicObject)tripEntry.get(cardIndex)).getDate("startdate");
                if (preTripEndDay != null && curTripStartDay != null && preTripEndDay.getTime() != curTripStartDay.getTime()) {
                    return BigDecimal.ONE;
                }
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    private static BigDecimal getTripHighDays(DynamicObject entry, Long companyId) {
        if (!SystemParamterUtil.isEnableTripStandard((Long)companyId) || !SystemParamterUtil.isEnableHighSeasonTripStandard((Long)companyId) || SystemParamterUtil.getTripStandardControlLevel((long)companyId) == ControlMethodEnum.NO_CONTROL) {
            return BigDecimal.ZERO;
        }
        return entry.getBigDecimal("originhighseasondays");
    }

    private static TripStandardDetail getSumGroupStd(List<Long> userIds, DynamicObject entryObject, String mulTraStdCtrType) {
        if (userIds == null || userIds.size() == 0) {
            return null;
        }
        DynamicObject entryCurrency = entryObject.getDynamicObject("entrycurrency");
        DynamicObject tripArea = entryObject.getDynamicObject("triparea");
        DynamicObject expenseItem = entryObject.getDynamicObject("expenseitem");
        TripStandardDetail tripStdDetail = null;
        if (entryCurrency != null && tripArea != null) {
            List tripStdDetailList = TripStandardUtils.getAccmodationStdFromPageCache(userIds, null, (String)mulTraStdCtrType, (Object)entryCurrency.getPkValue(), (Object)tripArea.getPkValue(), (DynamicObject)expenseItem, null);
            tripStdDetail = tripStdDetailList == null || tripStdDetailList.isEmpty() ? null : (TripStandardDetail)tripStdDetailList.get(0);
        }
        return tripStdDetail;
    }

    private static boolean isEnableStandard(Long companyId) {
        return SystemParamterUtil.isEnableHighSeasonTripStandard((Long)companyId);
    }

    private static boolean isEnableAccdAllowance(Long companyId) {
        return SystemParamterUtil.getTripStandardControlLevel((long)companyId) != ControlMethodEnum.NO_CONTROL;
    }

    private static boolean isEnableVehicle(Long companyId) {
        return SystemParamterUtil.getVehicleStdControlLevel((long)companyId) != ControlMethodEnum.NO_CONTROL;
    }

    private static boolean isOpenHighSeasonStd(Long companyId) {
        return SystemParamterUtil.isEnableHighSeasonTripStandard((Long)companyId);
    }
}

