/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import com.google.common.collect.Sets;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import org.apache.commons.lang3.StringUtils;

public class DeleteBotpRuleUtil {
    public static void deleteRules(String[] newRules, String[] deleteRules) {
        if (DeleteBotpRuleUtil.rulesEnable(newRules)) {
            DeleteBotpRuleUtil.deleteRules(DeleteBotpRuleUtil.notExistDep(deleteRules));
        }
    }

    private static void deleteRules(String[] deleteRules) {
        if (deleteRules.length > 0) {
            String rules = StringUtils.join((Object[])deleteRules, (String)"','");
            try (TXHandle h = TX.requiresNew();){
                DB.execute((DBRoute)DBRoute.meta, (String)String.format("DELETE FROM T_BOTP_WriteBackRule_S WHERE FID IN ('%s')", rules));
                DB.execute((DBRoute)DBRoute.meta, (String)String.format("DELETE FROM T_BOTP_WriteBackRule_L WHERE FID IN ('%s')", rules));
                DB.execute((DBRoute)DBRoute.meta, (String)String.format("DELETE FROM T_BOTP_WriteBackRule WHERE FID IN ('%s')", rules));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String[] notExistDep(String[] ruleIds) {
        HashSet set = Sets.newHashSetWithExpectedSize((int)ruleIds.length);
        String rules = StringUtils.join((Object[])ruleIds, (String)"','");
        String sql = "select fid,fmasterid,fparentid from T_BOTP_WriteBackRule where fmasterId in ('%s') or fparentid in ('%s')";
        DataSet queryDataSet = DB.queryDataSet((String)"er.notexistdep", (DBRoute)DBRoute.meta, (String)String.format(sql, rules, rules, rules));
        while (queryDataSet.hasNext()) {
            String parentid;
            Row row = queryDataSet.next();
            String masterid = row.getString("fmasterid");
            if (StringUtils.isNotBlank((CharSequence)masterid)) {
                set.add(masterid);
            }
            if (!StringUtils.isNotBlank((CharSequence)(parentid = row.getString("fparentid")))) continue;
            set.add(parentid);
        }
        HashSet newHashSet = Sets.newHashSet((Object[])ruleIds);
        if (!set.isEmpty()) {
            newHashSet.removeAll(set);
        }
        return newHashSet.toArray(new String[0]);
    }

    private static boolean rulesEnable(String[] ruleIds) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select FID,FCustStatus from T_BOTP_WriteBackRule_S where", new Object[0]).appendIn("fid", (Object[])ruleIds);
        boolean enable = DeleteBotpRuleUtil.queryEnable(sb);
        if (!enable) {
            sb = new SqlBuilder();
            sb.append("select FID,FCustStatus from T_BOTP_WriteBackRule where", new Object[0]).appendIn("fid", (Object[])ruleIds);
            enable = DeleteBotpRuleUtil.queryEnable(sb);
        }
        return enable;
    }

    private static boolean queryEnable(SqlBuilder sb) {
        DataSet queryDataSet = DB.queryDataSet((String)"er.rulesenable", (DBRoute)DBRoute.meta, (SqlBuilder)sb);
        boolean enable = false;
        while (queryDataSet.hasNext()) {
            enable = true;
            Row row = queryDataSet.next();
            row.get("fid");
            if ("1".equals(row.get("FCustStatus"))) continue;
            enable = false;
            break;
        }
        return enable;
    }
}

