/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class UpgradeApplyProjectPayAmountServiceImpl
implements IUpgradeService {
    private static final int MAX_SIZE = 5000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog("UpgradeApplyProjectPayAmountServiceImpl begin");
        Long start = System.currentTimeMillis();
        final HashSet fidSet = new HashSet();
        final HashMap updateExpenseMap = new HashMap();
        LinkedList<Object[]> updateList = new LinkedList<Object[]>();
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)"select t.fid,t.facapproveamount,t.fapproveamount,t.fbillstatus,b.fcontractamount from t_er_applyprojectbill t, t_er_applyprojectbill_s b where  b.fid = t.fid and t.fbillstatus in ('A','B','C','D','E','I')", (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    LinkedList<Object[]> updateAmountList = new LinkedList<Object[]>();
                    Long billid = resultSet.getLong("fid");
                    BigDecimal facapproveamount = resultSet.getBigDecimal("facapproveamount");
                    BigDecimal approveamount = resultSet.getBigDecimal("fapproveamount");
                    String fbillstatus = resultSet.getString("fbillstatus");
                    fidSet.add(billid);
                    BigDecimal nonpayamount = BigDecimal.ZERO;
                    BigDecimal payamount = BigDecimal.ZERO;
                    BigDecimal notpayamount = facapproveamount;
                    BigDecimal availableamount = facapproveamount;
                    BigDecimal costimateamount = BigDecimal.ZERO;
                    BigDecimal contractamount = resultSet.getBigDecimal("fcontractamount");
                    if ("I".equals(fbillstatus)) {
                        notpayamount = BigDecimal.ZERO;
                        availableamount = BigDecimal.ZERO;
                    } else if ("E".equals(fbillstatus)) {
                        if (contractamount != null) {
                            notpayamount = notpayamount.subtract(contractamount);
                            availableamount = availableamount.subtract(contractamount);
                        }
                    } else if ("A".equals(fbillstatus)) {
                        notpayamount = approveamount;
                        availableamount = approveamount;
                    }
                    updateAmountList.add(new Object[]{nonpayamount, payamount, notpayamount, availableamount, costimateamount, billid, fbillstatus});
                    updateExpenseMap.put(billid, updateAmountList);
                }
                return null;
            }
        });
        if (!fidSet.isEmpty()) {
            String params = Stream.generate(() -> "?").limit(fidSet.size()).collect(Collectors.joining(","));
            String sql = String.format("select a.fsourcebillid,sum(a.fexpeapprovecurramount) fexpeapprovecurramount from t_er_prepaybillentry a inner join t_er_prepaybill b on a.fid = b.fid where b.fbillstatus in ('G', 'I') and a.fsourcebillid in (%s) group by a.fsourcebillid;", params);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])fidSet.toArray(), (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long fsourcebillid = resultSet.getLong("fsourcebillid");
                        BigDecimal fexpeapprovecurramount = resultSet.getBigDecimal("fexpeapprovecurramount");
                        List amountList = (List)updateExpenseMap.get(fsourcebillid);
                        if (amountList == null || amountList.size() <= 0) continue;
                        Object[] amountObject = (Object[])amountList.get(0);
                        String billstatus = (String)amountObject[6];
                        BigDecimal payAmount = (BigDecimal)amountObject[1];
                        BigDecimal notPayAmount = (BigDecimal)amountObject[2];
                        BigDecimal availableamount = (BigDecimal)amountObject[3];
                        if (!"E".equals(billstatus) && !"I".equals(billstatus)) continue;
                        amountObject[1] = payAmount.add(fexpeapprovecurramount);
                        if (!"E".equals(billstatus)) continue;
                        amountObject[2] = notPayAmount.subtract(fexpeapprovecurramount);
                        amountObject[3] = availableamount.subtract(fexpeapprovecurramount);
                    }
                    return null;
                }
            });
            sql = String.format("select a.fsourcebillid,sum(a.fexpeapprovecurramount) fexpeapprovecurramount from t_er_prepaybillentry a inner join t_er_prepaybill b on a.fid = b.fid where b.fbillstatus in ('B','C','E','F') and a.fsourcebillid in (%s) group by a.fsourcebillid;", params);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])fidSet.toArray(), (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long fsourcebillid = resultSet.getLong("fsourcebillid");
                        BigDecimal fexpeapprovecurramount = resultSet.getBigDecimal("fexpeapprovecurramount");
                        List amountList = (List)updateExpenseMap.get(fsourcebillid);
                        if (amountList == null || amountList.size() <= 0) continue;
                        Object[] amountObject = (Object[])amountList.get(0);
                        String billstatus = (String)amountObject[6];
                        BigDecimal nonpayamount = (BigDecimal)amountObject[0];
                        BigDecimal availableamount = (BigDecimal)amountObject[3];
                        if (!"E".equals(billstatus)) continue;
                        amountObject[0] = nonpayamount.add(fexpeapprovecurramount);
                        amountObject[3] = availableamount.subtract(fexpeapprovecurramount);
                    }
                    return null;
                }
            });
            sql = String.format("select a.fwbsrcbillid,sum(a.fexpnonpayamount) fexpnonpayamount from t_er_pubreimexpdet a inner join t_er_pubreimbill b on a.fid = b.fid where b.fbillstatus in ('G', 'I') and a.fwbsrcbillid in (%s) group by a.fwbsrcbillid;", params);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])fidSet.toArray(), (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long fsourcebillid = resultSet.getLong("fwbsrcbillid");
                        BigDecimal fexpnonpayamount = resultSet.getBigDecimal("fexpnonpayamount");
                        List amountList = (List)updateExpenseMap.get(fsourcebillid);
                        if (amountList == null || amountList.size() <= 0) continue;
                        Object[] amountObject = (Object[])amountList.get(0);
                        String billstatus = (String)amountObject[6];
                        BigDecimal payAmount = (BigDecimal)amountObject[1];
                        BigDecimal notPayAmount = (BigDecimal)amountObject[2];
                        BigDecimal availableamount = (BigDecimal)amountObject[3];
                        if (!"E".equals(billstatus) && !"I".equals(billstatus)) continue;
                        amountObject[1] = payAmount.add(fexpnonpayamount);
                        if (!"E".equals(billstatus)) continue;
                        amountObject[2] = notPayAmount.subtract(fexpnonpayamount);
                        amountObject[3] = availableamount.subtract(fexpnonpayamount);
                    }
                    return null;
                }
            });
            sql = String.format("select a.fwbsrcbillid,sum(a.fexpnonpayamount) fexpnonpayamount from t_er_pubreimexpdet a inner join t_er_pubreimbill b on a.fid = b.fid where b.fbillstatus in ('B','C','E','F') and a.fwbsrcbillid in (%s) group by a.fwbsrcbillid;", params);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])fidSet.toArray(), (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long fsourcebillid = resultSet.getLong("fwbsrcbillid");
                        BigDecimal fexpnonpayamount = resultSet.getBigDecimal("fexpnonpayamount");
                        List amountList = (List)updateExpenseMap.get(fsourcebillid);
                        if (amountList == null || amountList.size() <= 0) continue;
                        Object[] amountObject = (Object[])amountList.get(0);
                        String billstatus = (String)amountObject[6];
                        BigDecimal nonpayamount = (BigDecimal)amountObject[0];
                        BigDecimal availableamount = (BigDecimal)amountObject[3];
                        if (!"E".equals(billstatus)) continue;
                        amountObject[0] = nonpayamount.add(fexpnonpayamount);
                        amountObject[3] = availableamount.subtract(fexpnonpayamount);
                    }
                    return null;
                }
            });
            sql = String.format("select a.fsourcebillid,sum(a.fexpeapprovecurramount) fexpeapprovecurramount from t_er_dailyloandetail a inner join t_er_dailyloanbill b on a.fid = b.fid where b.fbillstatus in ('G', 'I') and a.fsourcebillid in (%s) group by a.fsourcebillid;", params);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])fidSet.toArray(), (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long fsourcebillid = resultSet.getLong("fsourcebillid");
                        BigDecimal fexpeapprovecurramount = resultSet.getBigDecimal("fexpeapprovecurramount");
                        List amountList = (List)updateExpenseMap.get(fsourcebillid);
                        if (amountList == null || amountList.size() <= 0) continue;
                        Object[] amountObject = (Object[])amountList.get(0);
                        String billstatus = (String)amountObject[6];
                        BigDecimal payAmount = (BigDecimal)amountObject[1];
                        BigDecimal notPayAmount = (BigDecimal)amountObject[2];
                        BigDecimal availableamount = (BigDecimal)amountObject[3];
                        if (!"E".equals(billstatus) && !"I".equals(billstatus)) continue;
                        amountObject[1] = payAmount.add(fexpeapprovecurramount);
                        if (!"E".equals(billstatus)) continue;
                        amountObject[2] = notPayAmount.subtract(fexpeapprovecurramount);
                        amountObject[3] = availableamount.subtract(fexpeapprovecurramount);
                    }
                    return null;
                }
            });
            sql = String.format("select a.fsourcebillid,sum(a.fexpeapprovecurramount) fexpeapprovecurramount from t_er_dailyloandetail a inner join t_er_dailyloanbill b on a.fid = b.fid where b.fbillstatus in ('B','C','E','F') and a.fsourcebillid in (%s) group by a.fsourcebillid;", params);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])fidSet.toArray(), (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long fsourcebillid = resultSet.getLong("fsourcebillid");
                        BigDecimal fexpeapprovecurramount = resultSet.getBigDecimal("fexpeapprovecurramount");
                        List amountList = (List)updateExpenseMap.get(fsourcebillid);
                        if (amountList == null || amountList.size() <= 0) continue;
                        Object[] amountObject = (Object[])amountList.get(0);
                        String billstatus = (String)amountObject[6];
                        BigDecimal nonpayamount = (BigDecimal)amountObject[0];
                        BigDecimal availableamount = (BigDecimal)amountObject[3];
                        if (!"E".equals(billstatus)) continue;
                        amountObject[0] = nonpayamount.add(fexpeapprovecurramount);
                        amountObject[3] = availableamount.subtract(fexpeapprovecurramount);
                    }
                    return null;
                }
            });
            sql = String.format("select a.fsourcebillid,sum(a.fexpeapprovecurramount) fexpeapprovecurramount from t_er_costestimateentry a inner join t_er_costestimatebill b on a.fid = b.fid where b.fbillstatus in ('B','C','E','I') and a.fsourcebillid in (%s) group by a.fsourcebillid;", params);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])fidSet.toArray(), (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long fsourcebillid = resultSet.getLong("fsourcebillid");
                        BigDecimal fexpeapprovecurramount = resultSet.getBigDecimal("fexpeapprovecurramount");
                        List amountList = (List)updateExpenseMap.get(fsourcebillid);
                        if (amountList == null || amountList.size() <= 0) continue;
                        Object[] amountObject = (Object[])amountList.get(0);
                        String billstatus = (String)amountObject[6];
                        BigDecimal notPayAmount = (BigDecimal)amountObject[2];
                        BigDecimal availableamount = (BigDecimal)amountObject[3];
                        BigDecimal costimateamount = (BigDecimal)amountObject[4];
                        if (!"E".equals(billstatus)) continue;
                        amountObject[2] = notPayAmount.subtract(fexpeapprovecurramount);
                        amountObject[3] = availableamount.subtract(fexpeapprovecurramount);
                        amountObject[4] = costimateamount.add(fexpeapprovecurramount);
                    }
                    return null;
                }
            });
        }
        if (updateExpenseMap != null && updateExpenseMap.size() > 0) {
            for (Map.Entry entry : updateExpenseMap.entrySet()) {
                List objectList = (List)entry.getValue();
                if (objectList == null || objectList.size() <= 0) continue;
                Object[] theObjects = (Object[])objectList.get(0);
                Object[] objects = new Object[]{theObjects[0], theObjects[1], theObjects[2], theObjects[3], theObjects[4], theObjects[5]};
                updateList.add(objects);
            }
        }
        if (updateList.isEmpty()) {
            result.setLog("don't have updata applyprojectbills");
            return result;
        }
        ArrayList<Object[]> updateObjs = new ArrayList<Object[]>(1);
        for (Object[] objects : updateList) {
            updateObjs.add(objects);
            if (updateObjs.size() < 5000) continue;
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_applyprojectbill_s set fnonpayamount = ?, fpayamount = ?,fnotpayamount = ?,favailableamount = ?,fcostimateamount = ? where fid = ? ", updateObjs);
            updateObjs.clear();
        }
        if (!updateObjs.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_applyprojectbill_s set fnonpayamount = ?, fpayamount = ?,fnotpayamount = ?,favailableamount = ? ,fcostimateamount = ? where fid = ? ", updateObjs);
        }
        result.setLog("update t_er_applyprojectbill_s " + updateList.size() + " record...");
        Long applyProjectEnd = System.currentTimeMillis();
        result.setLog("UpgradeApplyProjectPayAmountServiceImpl begin,cost time:" + (applyProjectEnd - start));
        return result;
    }
}

