/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.LinkedList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.er.business.utils.AmountUtils;
import org.apache.commons.lang3.ObjectUtils;

public class UpgradeApproveTaxServiceImpl
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            DBRoute er = DBRoute.of((String)"er");
            DB.query((DBRoute)er, (String)"select sharebill.fid,fsumsharerate,FCurrencyID,wait.FDetailID,wait.fexchangerate,wait.fquotetype,wait.fapprovetax,wait.fthisapproveamount from t_er_expensesharebill sharebill left join t_er_expensesharewait wait on sharebill.fid = wait.fid", resultSet -> {
                while (resultSet.next()) {
                    try {
                        this.handleThisApproveTax(resultSet, result);
                    }
                    catch (Exception e) {
                        result.setSuccess(false);
                        result.setErrorInfo("error:" + e);
                    }
                }
                return null;
            });
            result.setLog(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u5206\u644a\u5355\uff1a\u672c\u6b21\u5f85\u644a\u6838\u5b9a\u7a0e\u989d\u5df2\u5347\u7ea7\u5b8c\u6210\u3002", (String)"UpgradeApproveTaxServiceImpl_1", (String)"fi-er-mservice", (Object[])new Object[0]), new Object[0]));
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo("error:" + e);
        }
        return result;
    }

    private void handleThisApproveTax(ResultSet object, UpgradeResult result) throws Exception {
        BigDecimal changeRate;
        BigDecimal thisApproveAmount;
        Long id = object.getLong("fid");
        if (id == null) {
            return;
        }
        Long currencyId = object.getLong("FCurrencyID");
        if (currencyId == null || currencyId == 0L) {
            result.setLog(id + " currency is null");
            currencyId = 1L;
        }
        int precision = AmountUtils.getCurrencyPrecision((Object)currencyId);
        BigDecimal sumShareRate = object.getBigDecimal("fsumsharerate");
        if (sumShareRate == null) {
            result.setLog(id + " sumShareRate is null");
            throw new Exception(id + " sumShareRate is null");
        }
        LinkedList<Object[]> args = new LinkedList<Object[]>();
        Long pkValue = object.getLong("FDetailID");
        String quotetypeWait = object.getString("fquotetype");
        BigDecimal approveTax = object.getBigDecimal("fapprovetax");
        if (approveTax == null) {
            approveTax = BigDecimal.ZERO;
            result.setLog("approveTax is null");
        }
        if ((thisApproveAmount = object.getBigDecimal("fthisapproveamount")) == null) {
            thisApproveAmount = BigDecimal.ZERO;
            result.setLog("thisApproveAmount is null");
        }
        if ((changeRate = object.getBigDecimal("fexchangerate")) == null) {
            changeRate = BigDecimal.ONE;
            result.setLog("changeRate is null");
        }
        BigDecimal thisApprove = approveTax.multiply(sumShareRate.divide(new BigDecimal(100), 4, 4));
        BigDecimal thisApproveNoTax = thisApproveAmount.subtract(thisApprove);
        String detailQuoteType = (String)ObjectUtils.defaultIfNull((Object)quotetypeWait, (Object)"0");
        BigDecimal thisCurPrice = AmountUtils.getCurrencyAmount((BigDecimal)thisApproveNoTax, (BigDecimal)changeRate, (int)precision, (String)detailQuoteType);
        args.add(new Object[]{thisApprove, thisApproveNoTax, thisCurPrice, pkValue});
        if (!args.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"UPDATE T_ER_EXPENSESHAREWAIT SET fthisapprovetax = ?,fthisapprovenotax = ?,fthiscurprice = ? WHERE FDETAILID = ?;", args);
        }
    }
}

