/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.lang3.StringUtils;

public class UpgradeCheckingpaybillAmountImpl
implements IUpgradeService {
    private static final int BATCH_UPDATE_COUNT = 5;
    private static Log logger = LogFactory.getLog(UpgradeCheckingpaybillAmountImpl.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog("UpgradeCheckingpaybillAmountImpl begin");
        Long start = System.currentTimeMillis();
        final HashMap orderMap = new HashMap(100);
        Object[] objectp = new Object[]{new Date(), TripCommonUtil.addDayByDate((Date)new Date(), (int)-30)};
        final HashSet idSet = new HashSet(8);
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)"select t1.FEntryID,t2.fid,t2.fbillno,t1.fcheckingbillnum,t1.foperationtype,t1.fcheckingbillid,t1.fserviceitem from t_er_checkingpayentry t1  left join t_er_checkingpay t2 on t1.fid = t2.fid   where t1.fserviceitem ='TICKET' and  t2.fcreatetime <= ?  and t2.fcreatetime >= ? ", (Object[])objectp, (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Long id = resultSet.getLong("fid");
                    idSet.add(id);
                    Long fentryid = resultSet.getLong("fentryid");
                    String fcheckingbillnum = resultSet.getString("fcheckingbillnum");
                    if (null == orderMap.get(id)) {
                        HashMap<String, Long> detailMap = new HashMap<String, Long>(8);
                        detailMap.put(fcheckingbillnum, fentryid);
                        orderMap.put(id, detailMap);
                        continue;
                    }
                    ((Map)orderMap.get(id)).put(fcheckingbillnum, fentryid);
                }
                return null;
            }
        });
        if (orderMap.isEmpty()) {
            Long applyProjectEnd = System.currentTimeMillis();
            result.setLog("UpgradeCheckingpaybillAmountImpl split table end,cost time:" + (applyProjectEnd - start));
            return result;
        }
        CountDownLatch countDownLatch = null;
        ThreadPool threadPool = null;
        try {
            threadPool = ThreadPools.newFixedThreadPool((String)("UpgradeCheckingpaybillAmountImpl" + System.currentTimeMillis()), (int)10);
            logger.info("UpgradeCheckingpaybillAmountImpl id.size():{}", (Object)idSet.size());
            int times = idSet.size() / 5 + (idSet.size() % 5 == 0 ? 0 : 1);
            CountDownLatch finalCountDownLatch = countDownLatch = new CountDownLatch(times);
            int i = 0;
            int j = 0;
            while (j < times) {
                int m = i;
                ++j;
                threadPool.execute(() -> {
                    try {
                        Object[] objects;
                        BigDecimal value;
                        Long key;
                        LinkedList<Object[]> updateBillList;
                        Set ids = idSet.stream().skip(m).limit(5L).collect(Collectors.toSet());
                        final LinkedList updateDetailList = new LinkedList();
                        final HashMap planetotalamount = new HashMap(8);
                        final HashMap rplanetotalamount = new HashMap(8);
                        final HashMap hoteltotalamount = new HashMap(8);
                        final HashMap traintotalamount = new HashMap(8);
                        final HashMap rtraintotalamount = new HashMap(8);
                        final HashMap vehicletotalamount = new HashMap(8);
                        final HashMap mealtotalamount = new HashMap(8);
                        final HashMap servicetotalamount = new HashMap(8);
                        DB.query((DBRoute)DBRoute.of((String)"er"), (String)("select fid,fpaybillid,fordernum,fticketprice,fairportprice,ffuelprice,fendorsementamount,frefundamount,fotheramount,fservicefee,ftotalamount,fassuranceAmount from t_er_planecheckingbill where fpaybillid in (" + StringUtils.join(ids, (String)",") + ");"), (ResultSetHandler)new ResultSetHandler(){

                            public Object handle(ResultSet resultSet) throws Exception {
                                while (resultSet.next()) {
                                    Long fpaybillid = resultSet.getLong("fpaybillid");
                                    String fcheckingbillnum = resultSet.getString("fordernum");
                                    BigDecimal fticketprice = resultSet.getBigDecimal("fticketprice");
                                    BigDecimal ftotalamount = resultSet.getBigDecimal("ftotalamount");
                                    BigDecimal fairportprice = resultSet.getBigDecimal("fairportprice");
                                    BigDecimal ffuelprice = resultSet.getBigDecimal("ffuelprice");
                                    BigDecimal fendorsementamount = resultSet.getBigDecimal("fendorsementamount");
                                    BigDecimal frefundamount = resultSet.getBigDecimal("frefundamount");
                                    BigDecimal fotheramount = resultSet.getBigDecimal("fotheramount");
                                    BigDecimal fservicefee = resultSet.getBigDecimal("fservicefee");
                                    BigDecimal fassuranceAmount = resultSet.getBigDecimal("fassuranceAmount");
                                    Map orderdetailMap = (Map)orderMap.get(fpaybillid);
                                    if (orderdetailMap != null) {
                                        Long fpayentryid = (Long)orderdetailMap.get(fcheckingbillnum);
                                        Object[] objects = new Object[]{fticketprice, fairportprice, ffuelprice, fendorsementamount, frefundamount, fotheramount, fassuranceAmount, "2", fpayentryid};
                                        updateDetailList.add(objects);
                                    }
                                    BigDecimal planetotal = fticketprice.add(ffuelprice);
                                    planetotalamount.merge(fpaybillid, planetotal, BigDecimal::add);
                                    BigDecimal rplanetotal = fendorsementamount.add(frefundamount);
                                    rplanetotalamount.merge(fpaybillid, rplanetotal, BigDecimal::add);
                                    servicetotalamount.merge(fpaybillid, fservicefee, BigDecimal::add);
                                }
                                return null;
                            }
                        });
                        if (!planetotalamount.isEmpty()) {
                            updateBillList = new LinkedList<Object[]>();
                            for (Map.Entry next : planetotalamount.entrySet()) {
                                key = (Long)next.getKey();
                                value = (BigDecimal)next.getValue();
                                objects = new Object[]{value, key};
                                updateBillList.add(objects);
                            }
                            if (!updateBillList.isEmpty()) {
                                DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_checkingpay set fplanetotalamount = ? where  FID = ? ", updateBillList);
                            }
                        }
                        if (!rplanetotalamount.isEmpty()) {
                            updateBillList = new LinkedList();
                            for (Map.Entry next : rplanetotalamount.entrySet()) {
                                key = (Long)next.getKey();
                                value = (BigDecimal)next.getValue();
                                objects = new Object[]{value, key};
                                updateBillList.add(objects);
                            }
                            if (!updateBillList.isEmpty()) {
                                DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_checkingpay set frplanetotalamount = ? where  FID = ? ", updateBillList);
                            }
                        }
                        DB.query((DBRoute)DBRoute.of((String)"er"), (String)("select t2.fid,t2.fpaybillid,t2.fordernum,t2.fservicefee,t2.ftotalamount, t1.fticketprice,t1.frefundamount from t_er_traincheckingbill_a t1 LEFT JOIN t_er_traincheckingbill t2 on t1.fid = t2.fid where t2.fpaybillid in (" + StringUtils.join(ids, (String)",") + ");"), (ResultSetHandler)new ResultSetHandler(){

                            public Object handle(ResultSet resultSet) throws Exception {
                                while (resultSet.next()) {
                                    Long fpaybillid = resultSet.getLong("fpaybillid");
                                    String fcheckingbillnum = resultSet.getString("fordernum");
                                    BigDecimal fticketprice = resultSet.getBigDecimal("fticketprice");
                                    BigDecimal ftotalamount = resultSet.getBigDecimal("ftotalamount");
                                    BigDecimal frefundamount = resultSet.getBigDecimal("frefundamount");
                                    BigDecimal fservicefee = resultSet.getBigDecimal("fservicefee");
                                    Map orderdetailMap = (Map)orderMap.get(fpaybillid);
                                    if (orderdetailMap != null) {
                                        Long fpayentryid = (Long)orderdetailMap.get(fcheckingbillnum);
                                        Object[] objects = new Object[]{fticketprice, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, frefundamount, BigDecimal.ZERO, BigDecimal.ZERO, "4", fpayentryid};
                                        updateDetailList.add(objects);
                                    }
                                    traintotalamount.merge(fpaybillid, fticketprice, BigDecimal::add);
                                    rtraintotalamount.merge(fpaybillid, frefundamount, BigDecimal::add);
                                    servicetotalamount.merge(fpaybillid, fservicefee, BigDecimal::add);
                                }
                                return null;
                            }
                        });
                        if (!traintotalamount.isEmpty()) {
                            updateBillList = new LinkedList();
                            for (Map.Entry next : traintotalamount.entrySet()) {
                                key = (Long)next.getKey();
                                value = (BigDecimal)next.getValue();
                                objects = new Object[]{value, key};
                                updateBillList.add(objects);
                            }
                            if (!updateBillList.isEmpty()) {
                                DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_checkingpay set ftraintotalamount = ? where  FID = ? ", updateBillList);
                            }
                        }
                        if (!rtraintotalamount.isEmpty()) {
                            updateBillList = new LinkedList();
                            for (Map.Entry next : rtraintotalamount.entrySet()) {
                                key = (Long)next.getKey();
                                value = (BigDecimal)next.getValue();
                                objects = new Object[]{value, key};
                                updateBillList.add(objects);
                            }
                            if (!updateBillList.isEmpty()) {
                                DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_checkingpay set frtraintotalamount = ? where  FID = ? ", updateBillList);
                            }
                        }
                        DB.query((DBRoute)DBRoute.of((String)"er"), (String)("select fid,fpaybillid,fordernum,fservicefee,ftotalamount from t_er_hotelcheckingbill where fpaybillid in  (" + StringUtils.join(ids, (String)",") + ");"), (ResultSetHandler)new ResultSetHandler(){

                            public Object handle(ResultSet resultSet) throws Exception {
                                while (resultSet.next()) {
                                    Long fpaybillid = resultSet.getLong("fpaybillid");
                                    Map orderdetailMap = (Map)orderMap.get(fpaybillid);
                                    String fcheckingbillnum = resultSet.getString("fordernum");
                                    BigDecimal fservicefee = resultSet.getBigDecimal("fservicefee");
                                    BigDecimal ftotalamount = resultSet.getBigDecimal("ftotalamount");
                                    if (orderdetailMap != null) {
                                        Long fpayentryid = (Long)orderdetailMap.get(fcheckingbillnum);
                                        Object[] objects = new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "1", fpayentryid};
                                        updateDetailList.add(objects);
                                    }
                                    hoteltotalamount.merge(fpaybillid, ftotalamount.subtract(fservicefee), BigDecimal::add);
                                    servicetotalamount.merge(fpaybillid, fservicefee, BigDecimal::add);
                                }
                                return null;
                            }
                        });
                        if (!hoteltotalamount.isEmpty()) {
                            updateBillList = new LinkedList();
                            for (Map.Entry next : hoteltotalamount.entrySet()) {
                                key = (Long)next.getKey();
                                value = (BigDecimal)next.getValue();
                                objects = new Object[]{value, key};
                                updateBillList.add(objects);
                            }
                            if (!updateBillList.isEmpty()) {
                                DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_checkingpay set fhoteltotalamount = ? where  FID = ? ", updateBillList);
                            }
                        }
                        DB.query((DBRoute)DBRoute.of((String)"er"), (String)("select fpaybillid,fordernum,fservicefee,ftotalamount from t_er_vehiclecheckingbill where fpaybillid in  (" + StringUtils.join(ids, (String)",") + ");"), (ResultSetHandler)new ResultSetHandler(){

                            public Object handle(ResultSet resultSet) throws Exception {
                                while (resultSet.next()) {
                                    Long fpaybillid = resultSet.getLong("fpaybillid");
                                    Map orderdetailMap = (Map)orderMap.get(fpaybillid);
                                    String fcheckingbillnum = resultSet.getString("fordernum");
                                    BigDecimal fservicefee = resultSet.getBigDecimal("fservicefee");
                                    BigDecimal ftotalamount = resultSet.getBigDecimal("ftotalamount");
                                    if (orderdetailMap != null) {
                                        Long fpayentryid = (Long)orderdetailMap.get(fcheckingbillnum);
                                        Object[] objects = new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "3", fpayentryid};
                                        updateDetailList.add(objects);
                                    }
                                    vehicletotalamount.merge(fpaybillid, ftotalamount.subtract(fservicefee), BigDecimal::add);
                                    servicetotalamount.merge(fpaybillid, fservicefee, BigDecimal::add);
                                }
                                return null;
                            }
                        });
                        if (!vehicletotalamount.isEmpty()) {
                            updateBillList = new LinkedList();
                            for (Map.Entry next : vehicletotalamount.entrySet()) {
                                key = (Long)next.getKey();
                                value = (BigDecimal)next.getValue();
                                objects = new Object[]{value, key};
                                updateBillList.add(objects);
                            }
                            if (!updateBillList.isEmpty()) {
                                DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_checkingpay set fvehicletotalamount = ? where  FID = ? ", updateBillList);
                            }
                        }
                        DB.query((DBRoute)DBRoute.of((String)"er"), (String)("select fpaybillid,fordernum,fservicefee,ftotalamount from t_er_mealcheckingbill where fpaybillid in  (" + StringUtils.join(ids, (String)",") + ");"), (ResultSetHandler)new ResultSetHandler(){

                            public Object handle(ResultSet resultSet) throws Exception {
                                while (resultSet.next()) {
                                    Long fpaybillid = resultSet.getLong("fpaybillid");
                                    Map orderdetailMap = (Map)orderMap.get(fpaybillid);
                                    String fcheckingbillnum = resultSet.getString("fordernum");
                                    BigDecimal fservicefee = resultSet.getBigDecimal("fservicefee");
                                    BigDecimal ftotalamount = resultSet.getBigDecimal("ftotalamount");
                                    if (orderdetailMap != null) {
                                        Long fpayentryid = (Long)orderdetailMap.get(fcheckingbillnum);
                                        Object[] objects = new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "5", fpayentryid};
                                        updateDetailList.add(objects);
                                    }
                                    mealtotalamount.merge(fpaybillid, ftotalamount.subtract(fservicefee), BigDecimal::add);
                                    servicetotalamount.merge(fpaybillid, fservicefee, BigDecimal::add);
                                }
                                return null;
                            }
                        });
                        if (!mealtotalamount.isEmpty()) {
                            updateBillList = new LinkedList();
                            for (Map.Entry next : mealtotalamount.entrySet()) {
                                key = (Long)next.getKey();
                                value = (BigDecimal)next.getValue();
                                objects = new Object[]{value, key};
                                updateBillList.add(objects);
                            }
                            if (!updateBillList.isEmpty()) {
                                DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_checkingpay set fmealtotalamount = ? where  FID = ? ", updateBillList);
                            }
                        }
                        if (!servicetotalamount.isEmpty()) {
                            updateBillList = new LinkedList();
                            for (Map.Entry next : servicetotalamount.entrySet()) {
                                key = (Long)next.getKey();
                                value = (BigDecimal)next.getValue();
                                objects = new Object[]{value, key};
                                updateBillList.add(objects);
                            }
                            if (!updateBillList.isEmpty()) {
                                DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_checkingpay set fservicetotalamount = ? where  FID = ? ", updateBillList);
                            }
                        }
                        if (!updateDetailList.isEmpty()) {
                            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_checkingpayentry set fticketprice = ?, fairportprice = ?, ffuelprice = ?, fendorsementamount = ?, frefundamount = ?, fotheramount = ?,fassuranceAmount = ?,foperationtype = ? where  FEntryID = ? ", updateDetailList);
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    finalCountDownLatch.countDown();
                });
                i += 5;
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            result.setLog("error " + exception.getMessage());
        }
        Long applyProjectEnd = System.currentTimeMillis();
        result.setLog("UpgradeCheckingpaybillAmountImpl end,cost time:" + (applyProjectEnd - start));
        return result;
    }
}

