/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;

public class UpgradeEntrustReimburseScope
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog("UpgradeEntrustReimburseScope begin");
        Long start = System.currentTimeMillis();
        int count = this.updateScope();
        Long invoiceInfoEnd = System.currentTimeMillis();
        result.setLog("UpgradeEntrustReimburseScope end,data " + count + ",cost time:" + (invoiceInfoEnd - start));
        return result;
    }

    private int updateScope() {
        String sql = "SELECT A.FID,B.FNAME FROM T_ER_BILLTYPE A LEFT JOIN T_ER_BILLTYPE_L B ON A.FID=B.FID";
        final HashMap billtypeMap = new HashMap();
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    billtypeMap.put(resultSet.getString("fname"), resultSet.getLong("fid"));
                }
                return null;
            }
        });
        if (billtypeMap.isEmpty()) {
            return 0;
        }
        String selectScopesql = "SELECT FID,FRENTRUSTEDSCOPE FROM T_ER_ENTRUSTREIMBURSE";
        final ArrayList insertParamsList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)selectScopesql, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet resultSet) throws Exception {
                ArrayList<Long> fidList = new ArrayList<Long>();
                ArrayList<Long> basedataIdList = new ArrayList<Long>();
                while (resultSet.next()) {
                    ArrayList rentrustedscopeLst = Lists.newArrayList((Object[])resultSet.getString("frentrustedscope").split(";"));
                    for (String billtype : rentrustedscopeLst) {
                        Long baseDataId = (Long)billtypeMap.get(billtype);
                        if (baseDataId == null) continue;
                        fidList.add(resultSet.getLong("fid"));
                        basedataIdList.add(baseDataId);
                    }
                }
                long[] PKids = DBServiceHelper.genLongIds((String)"t_er_entrustreimbursescop", (int)fidList.size());
                for (int i = 0; i < fidList.size(); ++i) {
                    insertParamsList.add(new Object[]{PKids[i], fidList.get(i), basedataIdList.get(i)});
                }
                return null;
            }
        });
        if (insertParamsList.size() == 0) {
            return 0;
        }
        String insertsql = "INSERT INTO T_ER_ENTRUSTREIMBURSESCOP (FPKID,FID,FBASEDATAID) VALUES(?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)insertsql, insertParamsList);
        return insertParamsList.size();
    }
}

