/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;

public class UpgradeInvoiceAttachmentV1
implements IUpgradeService {
    private static final int BATCH_SIZE = 2000;
    private static final String ATTACH_INFO_TABLE_NAME = "t_er_invoiceattachinfo";
    private static final String INSERT_ATTACH_ENTRY_SQL = "insert into t_er_invoiceattachinfo(fid, fentryid, fattachno, fattachname, foriginalname, fattachtype, fattachurl, fgathertime, fattachremark) values (?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static Log logger = LogFactory.getLog(UpgradeInvoiceAttachmentV1.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean enableXh = KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud();
        if (!enableXh) {
            result.setLog("!enableXh");
            return result;
        }
        logger.info("start upgrade UpgradeInvoiceAttachmentV1");
        long startTime = System.nanoTime();
        HashMap<String, String> tableIds = new HashMap<String, String>(){
            {
                this.put("t_er_dailyreimbursebill", "t_er_dailyreimbursebill");
                this.put("t_er_reimbursebill", "t_er_reimbursebill");
                this.put("t_er_pubreimbill", "t_er_pubreimbill");
                this.put("t_er_contractbill", "t_er_contractbill_S");
            }
        };
        String fmt = "select a.fid from %s as a inner join %s as b on a.fid = b.fid where a.fbillstatus not in ('H', 'I') and b.finvokeinvoicecloud = '1' and a.fid not in (select c.fid from t_er_invoiceattachinfo as c)";
        for (Map.Entry entry : tableIds.entrySet()) {
            String a = (String)entry.getKey();
            String b = (String)entry.getValue();
            String select = String.format(fmt, a, b);
            ArrayList billIds = new ArrayList(2000);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)select, resultSet -> {
                while (resultSet.next()) {
                    billIds.add(String.valueOf(resultSet.getLong("fid")));
                    if (billIds.size() < 2000) continue;
                    this.handleBills(billIds);
                }
                if (billIds.size() > 0) {
                    this.handleBills(billIds);
                }
                return null;
            });
        }
        String log = String.format("end upgrade UpgradeInvoiceAttachmentV1 cost time %d", System.nanoTime() - startTime);
        logger.info(log);
        result.setLog(log);
        return result;
    }

    private void handleBills(List<String> billIds) {
        String params = billIds.stream().collect(Collectors.joining("','"));
        String fmt = "select fexpense_id,fattach_no,fattach_url,fattach_name,foriginal_name,fremark,fattach_type,fcreate_time from t_rim_attach a inner join t_rim_attach_relation b on ''||a.fid = b.fattach_id where fexpense_id in ('%s');";
        String selectAttach = String.format(fmt, params);
        long startTime = System.nanoTime();
        logger.info("UpgradeInvoiceAttachmentV1 -> handleBills ids: " + params);
        ArrayList newRecords = new ArrayList(2000);
        DB.query((DBRoute)DBRoute.of((String)"taxc"), (String)selectAttach, resultSet1 -> {
            while (resultSet1.next()) {
                Long fid = resultSet1.getLong("fexpense_id");
                String attachNo = resultSet1.getString("fattach_no");
                String attachName = resultSet1.getString("fattach_name");
                String foriginal_name = resultSet1.getString("foriginal_name");
                String fattach_type = resultSet1.getString("fattach_type");
                String fattach_url = resultSet1.getString("fattach_url");
                Date fcreate_time = resultSet1.getDate("fcreate_time");
                String fremark = resultSet1.getString("fremark");
                logger.info("UpgradeInvoiceAttachmentV1 -> handleBills billid\uff1a" + fid + ", attachNo\uff1a" + attachNo);
                newRecords.add(new Object[]{fid, 0, attachNo, attachName, foriginal_name, fattach_type, fattach_url, fcreate_time, fremark});
                if (newRecords.size() < 2000) continue;
                this.insertNewRecords(newRecords);
            }
            if (newRecords.size() > 0) {
                this.insertNewRecords(newRecords);
            }
            return null;
        });
        billIds.clear();
        logger.info(String.format("UpgradeInvoiceAttachmentV1 -> handleBills cost time : %d", System.nanoTime() - startTime));
    }

    private void insertNewRecords(List<Object[]> newRecords) {
        long[] ids = DB.genLongIds((String)ATTACH_INFO_TABLE_NAME, (int)newRecords.size());
        for (int j = 0; j < ids.length; ++j) {
            newRecords.get((int)j)[1] = ids[j];
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)INSERT_ATTACH_ENTRY_SQL, newRecords);
        newRecords.clear();
    }
}

