/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class UpgradeLongNumber
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u66f4\u65b0\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff0cdbKey\uff1asys\u3002", (String)"UpgradeLongNumber_0", (String)"fi-er-mservice", (Object[])new Object[0]));
        final HashMap allChild = Maps.newHashMap();
        String selectSql = "SELECT FID,FPARENTID,FNUMBER,FLONGNUMBER FROM T_ER_TAXCLASSCODE";
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)selectSql, (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Node node = new Node(resultSet.getLong("FID"), resultSet.getLong("FPARENTID"), resultSet.getString("FNUMBER"), resultSet.getString("FLONGNUMBER"));
                    long parentid = node.getParentid();
                    List childs = (List)allChild.get(parentid);
                    if (childs == null) {
                        childs = Lists.newArrayList();
                        allChild.put(parentid, childs);
                    }
                    childs.add(node);
                }
                return null;
            }
        });
        Node rootNode = new Node(0L, 0L, "0", "0");
        this.putTree(rootNode, allChild);
        this.setLongNumber(rootNode);
        LinkedList<Object[]> param = new LinkedList<Object[]>();
        this.changeSql(rootNode, param);
        String updateSql = "UPDATE T_ER_TAXCLASSCODE SET FLONGNUMBER = ? WHERE FID = ? ";
        if (!param.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, param);
        }
        return result;
    }

    public void changeSql(Node rootNode, List<Object[]> param) {
        List<Node> childs = rootNode.getChild();
        if (childs == null || childs.isEmpty()) {
            return;
        }
        for (Node node : childs) {
            this.changeSql(node, param);
            param.add(new Object[]{node.getLongNumber(), node.getId()});
        }
    }

    public void setLongNumber(Node rootNode) {
        List<Node> childs = rootNode.getChild();
        if (childs == null || childs.isEmpty()) {
            return;
        }
        for (Node node : childs) {
            if (!"0".equals(rootNode.longNumber)) {
                node.longNumber = rootNode.longNumber + "." + node.number;
            }
            this.setLongNumber(node);
        }
    }

    public void putTree(Node rootNode, Map<Long, List<Node>> allChild) {
        long id = rootNode.getId();
        List<Node> childs = allChild.get(id);
        if (childs == null) {
            return;
        }
        rootNode.addAllChild(childs);
        for (Node node : childs) {
            this.putTree(node, allChild);
        }
    }

    public static class Node {
        private List<Node> child;
        private long id;
        private long parentid;
        private String number;
        private String longNumber;

        public Node(long id, long parentid, String number, String longNumber) {
            this.id = id;
            this.parentid = parentid;
            this.number = number;
            this.longNumber = longNumber;
            this.child = Lists.newArrayListWithExpectedSize((int)1);
        }

        public boolean addChild(Node node) {
            return this.child.add(node);
        }

        public boolean addAllChild(List<Node> nodes) {
            return this.child.addAll(nodes);
        }

        public List<Node> getChild() {
            return this.child;
        }

        public long getId() {
            return this.id;
        }

        public long getParentid() {
            return this.parentid;
        }

        public String getNumber() {
            return this.number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }
    }
}

