/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import org.apache.commons.lang.StringUtils;

public class UpgradePubreimContractNonPayAmountServiceImpl
implements IUpgradeService {
    private static final int MAX_SIZE = 5000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog("UpgradePubreimContractNonPayAmountServiceImpl begin");
        Long start = System.currentTimeMillis();
        final HashSet fidSet = new HashSet();
        final HashMap updateExpenseMap = new HashMap();
        LinkedList updateList = new LinkedList();
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)"select t.fid,t.fcontractsid,t.fcontractcurrwriteoff,t.fcontractwriteoff,t.fentryid,t.fcontractcode from t_er_pubreimcontract t where t.fid in (select fid from t_er_pubreimbill where fbillstatus in ('B','C','E','F') and frameworkcontract = '0') order by t.fentryid", (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    List updateExpAmountList;
                    Long billid = resultSet.getLong("fid");
                    Long fcontractsid = resultSet.getLong("fcontractsid");
                    Long fentryid = resultSet.getLong("fentryid");
                    BigDecimal fcontractcurrwriteoff = resultSet.getBigDecimal("fcontractcurrwriteoff");
                    BigDecimal fcontractwriteoff = resultSet.getBigDecimal("fcontractwriteoff");
                    String fcontractcode = resultSet.getString("fcontractcode");
                    String key = billid + "&" + fcontractsid + "&" + fcontractcode;
                    fidSet.add(billid);
                    if (updateExpenseMap.containsKey(key)) {
                        updateExpAmountList = (List)updateExpenseMap.get(key);
                        if (updateExpAmountList == null || updateExpAmountList.size() <= 0) continue;
                        Object[] updateObject = (Object[])updateExpAmountList.get(0);
                        updateObject[0] = ((BigDecimal)updateObject[0]).add(fcontractcurrwriteoff);
                        updateObject[1] = ((BigDecimal)updateObject[1]).add(fcontractwriteoff);
                        continue;
                    }
                    updateExpAmountList = new LinkedList<Object[]>();
                    updateExpAmountList.add(new Object[]{fcontractcurrwriteoff, fcontractwriteoff, billid, fcontractsid, fentryid});
                    updateExpenseMap.put(key, updateExpAmountList);
                }
                return null;
            }
        });
        final HashMap updateWriteOffMap = new HashMap();
        if (!fidSet.isEmpty()) {
            String params = Stream.generate(() -> "?").limit(fidSet.size()).collect(Collectors.joining(","));
            String string = String.format("select t.fid,t.fsourcebillid,t.floanbillnov1,t.fcurraccloanamount,t.faccloanamount,t.fentryid,t.floancontractno from t_er_pubreimwrioffdet t where t.fid in (%s) and fsrcbilltype = 'er_prepaybill';", params);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)string, (Object[])fidSet.toArray(), (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        LinkedList<Object[]> updateWriOffList = new LinkedList<Object[]>();
                        Long billid = resultSet.getLong("fid");
                        Long fentryid = resultSet.getLong("fentryid");
                        String sourcebillid = resultSet.getString("fsourcebillid");
                        BigDecimal fcurraccloanamount = resultSet.getBigDecimal("fcurraccloanamount");
                        BigDecimal faccloanamount = resultSet.getBigDecimal("faccloanamount");
                        String billNo = resultSet.getString("floanbillnov1");
                        String floancontractno = resultSet.getString("floancontractno");
                        updateWriOffList.add(new Object[]{billid, sourcebillid, fcurraccloanamount, faccloanamount, billNo, floancontractno});
                        updateWriteOffMap.put(billid + "&" + fentryid + "&" + sourcebillid, updateWriOffList);
                    }
                    return null;
                }
            });
        }
        if (updateExpenseMap != null && updateExpenseMap.size() > 0) {
            for (Map.Entry entry : updateExpenseMap.entrySet()) {
                List objectList = (List)entry.getValue();
                String key = this.getFid((String)entry.getKey());
                if (updateWriteOffMap != null && updateWriteOffMap.size() > 0) {
                    for (Map.Entry writeOffEntry : updateWriteOffMap.entrySet()) {
                        List writeOffObjectList = (List)writeOffEntry.getValue();
                        String writeOffKey = this.getFid((String)writeOffEntry.getKey());
                        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)writeOffKey) || !writeOffKey.equals(key) || writeOffObjectList == null || writeOffObjectList.size() <= 0 || objectList == null || objectList.size() <= 0) continue;
                        Object[] writeOffObject = (Object[])writeOffObjectList.get(0);
                        Object[] object = (Object[])objectList.get(0);
                        String loancontractno = (String)writeOffObject[5];
                        if (!StringUtils.isEmpty((String)loancontractno)) {
                            String[] strArr = ((String)entry.getKey()).split("&");
                            if (strArr == null || strArr.length <= 2 || !loancontractno.equals(strArr[2])) continue;
                            BigDecimal fcontractcurrwriteoff = (BigDecimal)object[0];
                            BigDecimal fcontractwriteoff = (BigDecimal)object[1];
                            BigDecimal curraccloanamount = (BigDecimal)writeOffObject[2];
                            BigDecimal accloanamount = (BigDecimal)writeOffObject[3];
                            object[0] = fcontractcurrwriteoff.subtract(curraccloanamount);
                            object[1] = fcontractwriteoff.subtract(accloanamount);
                            continue;
                        }
                        if (!this.isExistBill((String)writeOffObject[4], (Long)object[3])) continue;
                        BigDecimal fcontractcurrwriteoff = (BigDecimal)object[0];
                        BigDecimal fcontractwriteoff = (BigDecimal)object[1];
                        BigDecimal curraccloanamount = (BigDecimal)writeOffObject[2];
                        BigDecimal accloanamount = (BigDecimal)writeOffObject[3];
                        object[0] = fcontractcurrwriteoff.subtract(curraccloanamount);
                        object[1] = fcontractwriteoff.subtract(accloanamount);
                    }
                }
                if (objectList == null || objectList.size() <= 0) continue;
                updateList.add(objectList.get(0));
            }
        }
        if (updateList.isEmpty()) {
            result.setLog("don't have updata bills");
            return result;
        }
        ArrayList<Object[]> updateObjs = new ArrayList<Object[]>(1);
        for (Object[] objects : updateList) {
            updateObjs.add(new Object[]{objects[2], objects[3]});
            if (updateObjs.size() < 5000) continue;
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_pubreimcontract set fcontractnonpayamount = 0 ,foricontractnonpayamount = 0 where fid = ? and fcontractsid = ?", updateObjs);
            updateObjs.clear();
        }
        if (!updateObjs.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_pubreimcontract set fcontractnonpayamount = 0 ,foricontractnonpayamount = 0 where fid = ? and fcontractsid = ?", updateObjs);
        }
        updateObjs.clear();
        for (Object[] objects : updateList) {
            updateObjs.add(objects);
            if (updateObjs.size() < 5000) continue;
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_pubreimcontract set fcontractnonpayamount = ? ,foricontractnonpayamount = ? where fid = ? and fcontractsid = ? and fentryid = ?", updateObjs);
            updateObjs.clear();
        }
        if (!updateObjs.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_pubreimcontract set fcontractnonpayamount = ? ,foricontractnonpayamount = ? where fid = ? and fcontractsid = ? and fentryid = ?", updateObjs);
        }
        result.setLog("update t_er_pubreimcontract " + updateList.size() + " record...");
        Long l = System.currentTimeMillis();
        result.setLog("UpgradePubreimContractNonPayAmountServiceImpl end,cost time:" + (l - start));
        return result;
    }

    private boolean isExistBill(String billNo, Long billId) {
        final boolean[] isExist = new boolean[]{false};
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)("select t.fid from t_er_prepaybillentry t where t.fid in (select fid from t_er_prepaybill where fbillno = '" + billNo + "') and fsourcebillid = " + billId), (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    isExist[0] = true;
                    if (!isExist[0]) continue;
                    break;
                }
                return null;
            }
        });
        if (!isExist[0]) {
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)("select t.fid from t_er_prepaycontract t where t.fid in (select fid from t_er_prepaybill where fbillno = '" + billNo + "') and fcontractsid = " + billId), (ResultSetHandler)new ResultSetHandler(){

                public Object handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        isExist[0] = true;
                        if (!isExist[0]) continue;
                        break;
                    }
                    return null;
                }
            });
        }
        return isExist[0];
    }

    private String getFid(String key) {
        String[] strArr;
        String fid = "";
        if (!StringUtils.isEmpty((String)key) && (strArr = key.split("&")) != null && strArr.length > 0) {
            fid = strArr[0];
        }
        return fid;
    }
}

