/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.common.utils.Er;
import org.apache.commons.lang3.StringUtils;

public class UpgradeRepayMentHistorytData
implements IUpgradeService {
    private static final String ALGO = UpgradeRepayMentHistorytData.class.getName();

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        DataSet ds;
        Object rowId;
        DBRoute dbRoute = DBRoute.of((String)"fi");
        UpgradeResult result = new UpgradeResult();
        result.setLog("start update repmentBill history data");
        StringBuilder sb = new StringBuilder();
        sb.append(" select t2.FEntryID entryId ");
        sb.append(" from t_er_repaymentbill t1 ");
        sb.append(" inner join t_er_repaymententry t2 on t1.fid=t2.fid ");
        sb.append(" where t2.fsourcebillno=' '");
        LinkedList<Object> entryIdList = new LinkedList<Object>();
        try (DataSet ds2 = DB.queryDataSet((String)ALGO, (DBRoute)dbRoute, (String)sb.toString());){
            for (Row row : ds2) {
                entryIdList.add(row.get("entryId"));
            }
        }
        if (entryIdList.size() == 0) {
            result.setLog("don't have update history data");
            return result;
        }
        Long[] entryId = new Long[entryIdList.size()];
        entryIdList.toArray(entryId);
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)"er_repaymentbill", (String)"repaymententry", (Long[])entryId);
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() == 0) {
            result.setLog("don't hava up relation updata fail");
            return result;
        }
        HashSet<Long> loanBillIds = new HashSet<Long>();
        HashSet<Long> reqBillIds = new HashSet<Long>();
        LinkedList<Object[]> updateParamsList = new LinkedList<Object[]>();
        for (BFRowLinkUpNode upNode : bfRowLinkUpNodes) {
            Map sNodes = upNode.getSNodes();
            rowId = upNode.getRowId();
            Long downEntryId = rowId.getEntryId();
            Collection values = sNodes.values();
            if (values.isEmpty()) {
                result.setLog("don't hava up relation updata fail");
                continue;
            }
            for (BFRowLinkUpNode node : values) {
                Object[] updateObjectParam = new Object[5];
                BFRowId up = node.getRowId();
                Long billId = up.getBillId();
                TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)up.getMainTableId());
                updateObjectParam[0] = tableDefine.getEntityNumber();
                updateObjectParam[1] = billId;
                updateObjectParam[3] = up.getEntryId();
                updateObjectParam[4] = downEntryId;
                if (updateObjectParam[0] == null || updateObjectParam[1] == null || updateObjectParam[3] == null || updateObjectParam[4] == null) continue;
                updateParamsList.add(updateObjectParam);
                if (StringUtils.equals((CharSequence)"er_tripreqbill", (CharSequence)tableDefine.getEntityNumber())) {
                    reqBillIds.add(billId);
                    continue;
                }
                loanBillIds.add(billId);
            }
        }
        HashMap<Long, String> loanBillIdToNumber = new HashMap<Long, String>(loanBillIds.size());
        HashMap<Long, String> reqBillIdToNumber = new HashMap<Long, String>(reqBillIds.size());
        if (!reqBillIds.isEmpty()) {
            sb = new StringBuilder();
            sb.append("select fid,fbillno from T_ER_ReqBill where fid in (").append(Er.join(reqBillIds, (String)",")).append(")");
            ds = DB.queryDataSet((String)ALGO, (DBRoute)dbRoute, (String)sb.toString());
            rowId = null;
            try {
                for (Row row : ds) {
                    reqBillIdToNumber.put(row.getLong("fid"), row.getString("fbillno"));
                }
            }
            catch (Throwable downEntryId) {
                rowId = downEntryId;
                throw downEntryId;
            }
            finally {
                if (ds != null) {
                    if (rowId != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable downEntryId) {
                            ((Throwable)rowId).addSuppressed(downEntryId);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        if (!loanBillIds.isEmpty()) {
            sb = new StringBuilder();
            sb.append("select fid,fbillno from t_er_dailyloanbill where fid in (").append(Er.join(loanBillIds, (String)",")).append(")");
            ds = DB.queryDataSet((String)ALGO, (DBRoute)dbRoute, (String)sb.toString());
            rowId = null;
            try {
                for (Row row : ds) {
                    loanBillIdToNumber.put(row.getLong("fid"), row.getString("fbillno"));
                }
            }
            catch (Throwable downEntryId) {
                rowId = downEntryId;
                throw downEntryId;
            }
            finally {
                if (ds != null) {
                    if (rowId != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable downEntryId) {
                            ((Throwable)rowId).addSuppressed(downEntryId);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        LinkedList<Object[]> paramList = new LinkedList<Object[]>();
        for (int i = 0; i < updateParamsList.size(); ++i) {
            Object[] param = (Object[])updateParamsList.get(i);
            String billNumber = (String)loanBillIdToNumber.get(param[1]);
            if (billNumber == null) {
                billNumber = (String)reqBillIdToNumber.get(param[1]);
            }
            if (billNumber == null) continue;
            param[2] = billNumber;
            paramList.add(param);
        }
        if (paramList.isEmpty()) {
            result.setLog("don't have updata bills");
            return result;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_repaymententry set fsrcbilltype=?,fsourcebillid=?, fsourcebillno=?,fsourceentryid=? where fentryid=?", paramList);
        result.setLog("updata success");
        return result;
    }
}

