/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade.permission;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mservice.upgrade.permission.PermissionUpgradeServiceImpl;

public class ErBillAndBaseDataPermissionUpgrade
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(ErBillAndBaseDataPermissionUpgrade.class);
    private static PermissionUpgradeServiceImpl permission = new PermissionUpgradeServiceImpl();
    private String[] existAppIDs = new String[]{"kdem", "em"};
    private static String[] checkingBills = new String[]{"er_hotelcheckingbill", "er_planecheckingbill", "er_traincheckingbill", "er_vehiclecheckingbill"};
    private static String[] newPermissionNumbers = new String[]{"QXX0222", "QXX0032", "QXX0105", "QXX0099", "QXX0315", "QXX0397", "QXX-ER-007", "QXX-ER-009"};
    private static String[] er_checkingpaybill = new String[]{"QXX0014", "QXX0032"};
    private static String[] er_reimburselevel = new String[]{"QXX0012"};
    private static String[] er_reimbursesetting = new String[]{"QXX0007", "QXX0006"};
    private static String[] er_amountfreed = new String[]{"QXX0011", "QXX0012"};
    private static String[] er_tripexpenseitem = new String[]{"QXX0011", "QXX0012"};
    private static String[] er_reimbursetips = new String[]{"QXX0011", "QXX0012"};
    private static String[] er_bd_kdinvoicecloudcfg = new String[]{"QXX0005", "QXX0004", "QXX0020", "QXX0002", "QXX0008"};
    private static String[] er_bd_kdinvoicecloudcfgct = new String[]{"QXX0005", "QXX0004", "QXX0020", "QXX0002", "QXX0008", "QXX0011", "QXX0012"};
    private static String[] er_taxclasscode = new String[]{"QXX0008", "QXX0005"};
    private static String[] er_rel_expense_ratetype = new String[]{"QXX0011", "QXX0012"};
    private static String[] er_rel_tripitem_ratetype = new String[]{"QXX0011", "QXX0012"};
    private static String[] er_image_tpl = new String[]{"QXX0011", "QXX0012"};
    private static String[] er_tripcontrolsettings = new String[]{"QXX0011", "QXX0012"};
    private static String[] er_tripreqbill = new String[]{"QXX-ER-001", "QXX0315", "QXX0021", "QXX0007", "QXX-ER-013", "QXX0014", "QXX0032", "QXX0105", "QXX0099", "QXX0148", "QXX0033", "QXX-ER-017", "QXX-ER-016"};
    private static String[] er_tripreimbursebill = new String[]{"QXX0021", "QXX0007", "QXX0020", "QXX-ER-013", "QXX0014", "QXX0032", "QXX0105", "QXX0099", "QXX0033", "QXX0315"};
    private static String[] er_dailyapplybill = new String[]{"QXX0021", "QXX0007", "QXX0014"};
    private static String[] er_dailyreimbursebill = new String[]{"QXX0020", "QXX0032", "QXX0105", "QXX0099", "QXX0315", "QXX0014", "QXX0021", "QXX0007", "QXX0407", "QXX0245", "QXX0322"};
    private static String[] er_publicreimbursebill = new String[]{"QXX0020", "QXX0315", "QXX0021", "QXX0322", "QXX0007", "QXX-ER-013", "QXX0014", "QXX0032", "QXX0099", "QXX0105", "QXX0033", "QXX-ER-011", "QXX-ER-010"};
    private static String[] er_dailyloanbill = new String[]{"QXX-ER-001", "QXX0315", "QXX0021", "QXX0007", "QXX0020", "QXX-ER-013", "QXX0014", "QXX0032", "QXX0105", "QXX0099", "QXX0033", "QXX-ER-017", "QXX-ER-016"};
    private static String[] er_repaymentbill = new String[]{"QXX0021", "QXX0007", "QXX0030", "QXX0014", "QXX0105", "QXX0099", "QXX0315", "QXX0006"};
    private static String[] er_expensesharebill = new String[]{"QXX0021", "QXX0007", "QXX0222", "QXX0014", "QXX0010", "QXX0105", "QXX0099", "QXX0004", "QXX0009", "QXX0315"};

    public void setExistAppIDs(String[] existAppIDs) {
        this.existAppIDs = existAppIDs;
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setLog("update begin");
        this.checkingBillsProcessPermission();
        result.setLog("update end");
        return result;
    }

    private void checkingBillsProcessPermission() {
        ProcessPermissionUpgrade processCheckBill = new ProcessPermissionUpgrade("QXX0001", newPermissionNumbers, checkingBills, this.existAppIDs);
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_reimbursesetting);
        processCheckBill.setUpdateBills(new String[]{"er_reimbursesetting"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_checkingpaybill);
        processCheckBill.setUpdateBills(new String[]{"er_checkingpaybill"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_reimburselevel);
        processCheckBill.setUpdateBills(new String[]{"er_reimburselevel"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_tripexpenseitem);
        processCheckBill.setUpdateBills(new String[]{"er_tripexpenseitem"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_amountfreed);
        processCheckBill.setUpdateBills(new String[]{"er_amountfreed"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_reimbursetips);
        processCheckBill.setUpdateBills(new String[]{"er_reimbursetips"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_bd_kdinvoicecloudcfg);
        processCheckBill.setUpdateBills(new String[]{"er_bd_kdinvoicecloudcfg"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_bd_kdinvoicecloudcfgct);
        processCheckBill.setUpdateBills(new String[]{"er_bd_kdinvoicecloudcfgct"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_taxclasscode);
        processCheckBill.setUpdateBills(new String[]{"er_taxclasscode"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_rel_expense_ratetype);
        processCheckBill.setUpdateBills(new String[]{"er_rel_expense_ratetype"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_rel_tripitem_ratetype);
        processCheckBill.setUpdateBills(new String[]{"er_rel_tripitem_ratetype"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_image_tpl);
        processCheckBill.setUpdateBills(new String[]{"er_image_tpl"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_tripcontrolsettings);
        processCheckBill.setUpdateBills(new String[]{"er_tripcontrolsettings"});
        processCheckBill.ProcessPermission();
        processCheckBill.setExistAppIDs(new String[]{"em", "kdem", "dhc"});
        processCheckBill.setNewPermItemNumber(er_tripreqbill);
        processCheckBill.setUpdateBills(new String[]{"er_tripreqbill"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_tripreimbursebill);
        processCheckBill.setUpdateBills(new String[]{"er_tripreimbursebill"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_dailyapplybill);
        processCheckBill.setUpdateBills(new String[]{"er_dailyapplybill"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_dailyreimbursebill);
        processCheckBill.setUpdateBills(new String[]{"er_dailyreimbursebill"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_publicreimbursebill);
        processCheckBill.setUpdateBills(new String[]{"er_publicreimbursebill"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_dailyloanbill);
        processCheckBill.setUpdateBills(new String[]{"er_dailyloanbill"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_repaymentbill);
        processCheckBill.setUpdateBills(new String[]{"er_repaymentbill"});
        processCheckBill.ProcessPermission();
        processCheckBill.setNewPermItemNumber(er_expensesharebill);
        processCheckBill.setUpdateBills(new String[]{"er_expensesharebill"});
        processCheckBill.ProcessPermission();
    }

    private static class ProcessPermissionUpgrade {
        private String exitPermItemNumber;
        private String[] newPermItemNumber;
        private String[] updateBills;
        private String[] existAppIDs;

        public void setExistAppIDs(String[] existAppIDs) {
            this.existAppIDs = existAppIDs;
        }

        public ProcessPermissionUpgrade(String exitPermItemNumber, String[] newPermItemNumber, String[] updateBills, String[] existAppIDs) {
            this.exitPermItemNumber = exitPermItemNumber;
            this.newPermItemNumber = newPermItemNumber;
            this.updateBills = updateBills;
            this.existAppIDs = existAppIDs;
        }

        public void setNewPermItemNumber(String[] newPermItemNumber) {
            this.newPermItemNumber = newPermItemNumber;
        }

        public void setUpdateBills(String[] updateBills) {
            this.updateBills = updateBills;
        }

        public void ProcessPermission() {
            DynamicObject prePermItem = QueryServiceHelper.queryOne((String)"perm_permitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.exitPermItemNumber)});
            String prePermItemPK = String.valueOf(prePermItem.get("id"));
            DynamicObject[] newPermItem = BusinessDataServiceHelper.load((String)"perm_permitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)this.newPermItemNumber)});
            List<String> newPermItemPks = Arrays.asList(newPermItem).stream().map(v -> v.getPkValue().toString()).collect(Collectors.toList());
            for (int i = 0; i < this.existAppIDs.length; ++i) {
                String appId = this.existAppIDs[i];
                String id = AppMetadataCache.getAppInfo((String)appId).getId();
                for (String billNumber : this.updateBills) {
                    permission.addPermItemsByExistPermItem(prePermItemPK, billNumber, id, billNumber, id, newPermItemPks);
                }
            }
        }
    }
}

