/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.voucher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.fi.invoice.IViewInvoicePlugin;
import kd.bos.ext.fi.invoice.param.InvoiceResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.mservice.voucher.ShowInvoiceOrAttachmentUtil;

public class ErViewInvoicePlugin
implements IViewInvoicePlugin {
    private Log log = LogFactory.getLog(ErViewInvoicePlugin.class);

    public List<InvoiceResult> view(Map<String, List<Long>> map) {
        this.log.info("\u603b\u8d26\u51ed\u8bc1\u9875\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u5165\u53c2\uff1a {}", (Object)SerializationUtils.toJsonString(map));
        ArrayList<InvoiceResult> results = new ArrayList<InvoiceResult>(2);
        boolean aws = !KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud();
        String sql = "id, billno, company, costcompany, invoiceentry.serialno ";
        for (Map.Entry<String, List<Long>> entry : map.entrySet()) {
            String billType = entry.getKey();
            if (!(ErEntityTypeUtils.isPublicReimburseBill((String)billType) || ErEntityTypeUtils.isTripReimburseBill((String)billType) || ErEntityTypeUtils.isCheckingpayBill((String)billType) || ErEntityTypeUtils.isDailyReimburseBill((String)billType))) {
                this.log.info("\u5355\u636e\u7c7b\u578b: {}\u4e0d\u5904\u7406", (Object)entry.getKey());
                continue;
            }
            QFilter qFilter = new QFilter("id", "in", entry.getValue());
            DynamicObject[] dyns = BusinessDataServiceHelper.load((String)entry.getKey(), (String)sql, (QFilter[])new QFilter[]{qFilter});
            Set existIds = Arrays.stream(dyns).map(m -> m.getLong("id")).collect(Collectors.toSet());
            HashSet ids = new HashSet(entry.getValue());
            ids.removeAll(existIds);
            for (Long id : ids) {
                this.log.warn("\u672a\u67e5\u8be2\u5230\u5355\u636e\u4fe1\u606f");
                InvoiceResult result = ShowInvoiceOrAttachmentUtil.buildFailResult(entry.getKey(), id, ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5355\u636e\u4fe1\u606f\u3002", (String)"ErViewInvoicePlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
                results.add(result);
            }
            for (DynamicObject d : dyns) {
                InvoiceResult result = ShowInvoiceOrAttachmentUtil.getShowInvoiceParameter(aws, d);
                results.add(result);
            }
        }
        if (results.size() > 0) {
            InvoiceResult result = (InvoiceResult)results.get(0);
            this.log.info("entityId: {}, billid: {}, success: {}, errorMsg: {}", new Object[]{result.getEntityId(), result.getBillId(), result.isSuccess(), result.getErrorMsg()});
            if (result.getFormShowParameter() != null && result.getFormShowParameter().getCustomParams() != null) {
                this.log.info("\u603b\u8d26\u51ed\u8bc1\u9875\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u51fa\u53c2\uff1a {}", (Object)SerializationUtils.toJsonString((Object)result.getFormShowParameter().getCustomParams()));
            }
        }
        return results;
    }
}

