/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.ext.formplugin.budget;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class XKBgBalanceListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(XKBgBalanceListPlugin.class);
    private static final Map<String, String> PAYER_TYPE_SUFIX_MAP;
    private static final Map<String, String> CQ_XK_BILL_MAP;
    private static final String tableKey = "budgetdata";
    private static final String msgKey = "errormsg";
    private static final String mockJsonStr = "{\"status\":0,\"Model\":{\"FCtrlRuleTreeView\":[{\"FCtrlRuleTreeNode\":{\"FIsNeedCtrl\":true,\"FSCHEME\":{\"FID\":\"235435\",\"FNUMBER\":\"\",\"FNAME\":\"\u5206\u7ec4\u6c47\u603b\"},\"FRULE\":{\"FID\":\"235459\",\"FNUMBER\":\"\",\"FNAME\":\"\u5206\u7ec4\u6c47\u603b3\u4e2a\"},\"FLEVEL\":{\"FID\":\"Rule\",\"FNUMBER\":\"\",\"FNAME\":\"\u672c\u7ea7\"},\"FUNITORGID\":0,\"FISSUMORG\":false},\"FBillHead\":{\"FBillNo\":\"ETR20230218000001\",\"FErrorMsg\":\"\u5355\u636e\u7f16\u53f7\u3010ETR20230218000001\u3011,\u9884\u7b97\u63a7\u5236\u89c4\u5219\u3010\u5206\u7ec4\u6c47\u603b3\u4e2a\u3011,\u9884\u7b97\u65b9\u6848\u3010\u5206\u7ec4\u6c47\u603b\u3011,\u9884\u7b97\u7ec4\u7ec7\u3010BM_oracle20200410\u3011,\u63a7\u5236\u7ef4\u5ea6\u3010\u7533\u8bf7\u90e8\u95e8(\u6d4b\u8bd5\u4e00\u90e8),\u8d39\u7528\u627f\u62c5\u90e8\u95e8.\u4e0a\u7ea7\u90e8\u95e8(\u6d4b\u8bd5\u90e8),\u5730\u533a(\u534e\u5357\u533a),\u7533\u8bf7\u90e8\u95e8.\u90e8\u95e8\u5c5e\u6027(\u7ba1\u7406\u90e8\u95e8),\u8d39\u7528\u9879\u76ee.\u5206\u7ec4(A),\u8d39\u7528\u9879\u76ee(\u8d39\u75281),\u7533\u8bf7\u4eba(\u5f20\u5434)\u3011,\u9884\u7b97\u63a7\u5236\u671f\u95f4\u30102\u6708\u3011,\u9879\u76ee\u6570\u636e\u7c7b\u578b\u3010\u8d44\u91d1\u9884\u7b97\u989d\u3011,\u63a7\u5236\u5e01\u79cd\u3010\u4eba\u6c11\u5e01\u3011,\u9884\u7b97\u63a7\u5236\u5e74\u5ea6\u30102023\u5e74\u3011,\u9884\u7b97\u6570\uff083,200\uff09,\u5df2\u53d1\u751f\uff08800\uff09,\u504f\u5dee\u503c\uff080.00\uff09,\u53ef\u7528\u6570\uff082,400\uff09,\u5f53\u524d\u5355\u636e\u6570\uff08300\uff09,\u5269\u4f59\u3010\u8d44\u91d1\u9884\u7b97\u989d\u3011\uff082,100\uff09,\u9884\u7b97\u6267\u884c\u8fdb\u5ea6%\uff0834.375%\uff09,\u9884\u7b97\u671f\u95f4\uff082\uff09\u671f,\u9884\u7b97\u5468\u671f\u7c7b\u578b\u3010\u6708\u3011,\u9884\u7b97\u671f\u95f4\u8d77\u6b62\u65e5\u671f\u30102023-02-01 00:00:00\u52302023-02-28 00:00:00\u3011,\u5b9e\u9645\u6267\u884c\uff08800\uff09,\u6267\u884c\u51b2\u56de\uff080\uff09\\r\\n\u5355\u636e\u7f16\u53f7\u3010ETR20230218000001\u3011,\u9884\u7b97\u63a7\u5236\u89c4\u5219\u3010\u5206\u7ec4\u6c47\u603b3\u4e2a\u3011,\u9884\u7b97\u65b9\u6848\u3010\u5206\u7ec4\u6c47\u603b\u3011,\u9884\u7b97\u7ec4\u7ec7\u3010BM_oracle20200410\u3011,\u63a7\u5236\u7ef4\u5ea6\u3010\u7533\u8bf7\u90e8\u95e8(\u6d4b\u8bd5\u4e00\u90e8),\u8d39\u7528\u627f\u62c5\u90e8\u95e8.\u4e0a\u7ea7\u90e8\u95e8(\u6d4b\u8bd5\u90e8),\u5730\u533a(\u534e\u5357\u533a),\u7533\u8bf7\u90e8\u95e8.\u90e8\u95e8\u5c5e\u6027(\u7ba1\u7406\u90e8\u95e8),\u8d39\u7528\u9879\u76ee.\u5206\u7ec4(A),\u8d39\u7528\u9879\u76ee(\u8d39\u75281),\u7533\u8bf7\u4eba(\u5f20\u5434)\u3011,\u9884\u7b97\u63a7\u5236\u671f\u95f4\u30102\u6708\u3011,\u9879\u76ee\u6570\u636e\u7c7b\u578b\u3010\u8d39\u7528\u9884\u7b97\u989d\u3011,\u63a7\u5236\u5e01\u79cd\u3010\u4eba\u6c11\u5e01\u3011,\u9884\u7b97\u63a7\u5236\u5e74\u5ea6\u30102023\u5e74\u3011,\u9884\u7b97\u6570\uff088,000\uff09,\u5df2\u53d1\u751f\uff08800\uff09,\u504f\u5dee\u503c\uff080.00\uff09,\u53ef\u7528\u6570\uff087,200\uff09,\u5f53\u524d\u5355\u636e\u6570\uff08300\uff09,\u5269\u4f59\u3010\u8d39\u7528\u9884\u7b97\u989d\u3011\uff086,900\uff09,\u9884\u7b97\u6267\u884c\u8fdb\u5ea6%\uff0813.75%\uff09,\u9884\u7b97\u671f\u95f4\uff082\uff09\u671f,\u9884\u7b97\u5468\u671f\u7c7b\u578b\u3010\u6708\u3011,\u9884\u7b97\u671f\u95f4\u8d77\u6b62\u65e5\u671f\u30102023-02-01 00:00:00\u52302023-02-28 00:00:00\u3011,\u5b9e\u9645\u6267\u884c\uff08800\uff09,\u6267\u884c\u51b2\u56de\uff080\uff09\\r\\n\",\"FBWBCURRENCYID\":\"0\",\"FYEARPERIOD\":\"2023\u5e74\u7b2c2\u671f\",\"FPERIOD\":\"3\",\"FCURRENCYID\":\"1\"},\"FEntity\":[{\"FLEVEL\":\"DETAIL\",\"FBudgetOrgId\":{\"FID\":\"100029\",\"FNUMBER\":\"100\",\"FNAME\":\"BM_oracle20200410\"},\"FBudgetOrgName\":\"BM_oracle20200410\",\"FORGTYPE\":\"ORG\",\"FDATATYPEID\":{\"FID\":\"13\",\"FNUMBER\":\"\",\"FNAME\":\"\"},\"FBUSINESSTYPEID\":{\"FID\":\"2\",\"FNUMBER\":\"\",\"FNAME\":\"\"},\"FDimensionId1\":\"\u6d4b\u8bd5\u4e00\u90e8\",\"FFilterKey1\":\"100041\",\"FDimensionId2\":\"\u6d4b\u8bd5\u90e8\",\"FFilterKey2\":\"100040\",\"FDimensionId5\":\"A\",\"FFilterKey5\":\"112280\",\"FDimensionId7\":\"\u5f20\u5434\",\"FFilterKey7\":\"209194\",\"FDimensionId8\":\"\",\"FFilterKey8\":\"\",\"FBUDGETVALUE\":3200.0,\"FREALUSEDVALUE\":800.0,\"FUSABLEVALUE\":2400.0,\"FCurrentValue\":300.0,\"FBalanceValue\":2100.0,\"FSCHEMEID\":235435,\"FRULEID\":235459,\"FStartYearPeriod\":2023002,\"FEndYearPeriod\":2023002,\"FYearEntry\":2023,\"FPeriodEntry\":2,\"FIsOrgSumCtrl\":false,\"FLASTCUMVALUE\":800.0},{\"FLEVEL\":\"SUBTOTAL\",\"FDataTypeName\":\"\u5c0f\u8ba1\",\"FBUDGETVALUE\":3200.0,\"FREALUSEDVALUE\":800.0,\"FUSABLEVALUE\":2400.0,\"FCurrentValue\":300.0,\"FADJUSTVALUE\":300.0,\"FBalanceValue\":2100.0,\"FBudgetOrgId\":100029,\"FDATATYPEID\":13,\"FBUSINESSTYPEID\":2,\"FSCHEMEID\":235435,\"FRULEID\":235459,\"FStartYearPeriod\":2023002,\"FEndYearPeriod\":2023002,\"FIsOrgSumCtrl\":false,\"FLASTCUMVALUE\":800.0,\"FFilterKey1\":\"100041\",\"FFilterKey2\":\"100040\",\"FFilterKey3\":\"\",\"FFilterKey4\":\"\",\"FFilterKey5\":\"112280\",\"FFilterKey6\":\"\",\"FFilterKey7\":\"209194\",\"FFilterKey8\":\"\"},{\"FLEVEL\":\"DETAIL\",\"FBudgetOrgId\":{\"FID\":\"100029\",\"FNUMBER\":\"100\",\"FNAME\":\"BM_oracle20200410\"},\"FBudgetOrgName\":\"BM_oracle20200410\",\"FORGTYPE\":\"ORG\",\"FDATATYPEID\":{\"FID\":\"12\",\"FNUMBER\":\"\",\"FNAME\":\"\"},\"FBUSINESSTYPEID\":{\"FID\":\"1\",\"FNUMBER\":\"\",\"FNAME\":\"\"},\"FDimensionId1\":\"\u6d4b\u8bd5\u4e00\u90e8\",\"FFilterKey1\":\"100041\",\"FDimensionId2\":\"\u6d4b\u8bd5\u90e8\",\"FFilterKey2\":\"100040\",\"FDimensionId5\":\"A\",\"FFilterKey5\":\"112280\",\"FDimensionId7\":\"\u5f20\u5434\",\"FFilterKey7\":\"209194\",\"FDimensionId8\":\"\",\"FFilterKey8\":\"\",\"FBUDGETVALUE\":8000.0,\"FREALUSEDVALUE\":800.0,\"FUSABLEVALUE\":7200.0,\"FCurrentValue\":300.0,\"FBalanceValue\":6900.0,\"FSCHEMEID\":235435,\"FRULEID\":235459,\"FStartYearPeriod\":2023002,\"FEndYearPeriod\":2023002,\"FYearEntry\":2023,\"FPeriodEntry\":2,\"FIsOrgSumCtrl\":false,\"FLASTCUMVALUE\":3200.0},{\"FLEVEL\":\"SUBTOTAL\",\"FDataTypeName\":\"\u5c0f\u8ba1\",\"FBUDGETVALUE\":8000.0,\"FREALUSEDVALUE\":800.0,\"FUSABLEVALUE\":7200.0,\"FCurrentValue\":300.0,\"FADJUSTVALUE\":300.0,\"FBalanceValue\":6900.0,\"FBudgetOrgId\":100029,\"FDATATYPEID\":12,\"FBUSINESSTYPEID\":1,\"FSCHEMEID\":235435,\"FRULEID\":235459,\"FStartYearPeriod\":2023002,\"FEndYearPeriod\":2023002,\"FIsOrgSumCtrl\":false,\"FLASTCUMVALUE\":3200.0,\"FFilterKey1\":\"100041\",\"FFilterKey2\":\"100040\",\"FFilterKey3\":\"\",\"FFilterKey4\":\"\",\"FFilterKey5\":\"112280\",\"FFilterKey6\":\"\",\"FFilterKey7\":\"209194\",\"FFilterKey8\":\"\"},{\"FLEVEL\":\"TOTAL\",\"FBudgetOrgName\":\"\u5408\u8ba1\",\"FBUDGETVALUE\":11200.0,\"FREALUSEDVALUE\":1600.0,\"FUSABLEVALUE\":9600.0,\"FCurrentValue\":600.0,\"FADJUSTVALUE\":600.0,\"FBalanceValue\":9000.0,\"FBudgetOrgId\":100029,\"FSCHEMEID\":235435,\"FRULEID\":235459,\"FStartYearPeriod\":2023002,\"FEndYearPeriod\":2023002,\"FIsOrgSumCtrl\":false,\"FLASTCUMVALUE\":4000.0,\"FFilterKey1\":\"100041\",\"FFilterKey2\":\"100040\",\"FFilterKey3\":\"\",\"FFilterKey4\":\"\",\"FFilterKey5\":\"112280\",\"FFilterKey6\":\"\",\"FFilterKey7\":\"209194\",\"FFilterKey8\":\"\"}],\"FBudgetOrgIds\":[100029]},{\"FCtrlRuleTreeNode\":{\"FIsNeedCtrl\":true,\"FSCHEME\":{\"FID\":\"235435\",\"FNUMBER\":\"\",\"FNAME\":\"\u5206\u7ec4\u6c47\u603b\"},\"FRULE\":{\"FID\":\"235441\",\"FNUMBER\":\"\",\"FNAME\":\"\u5206\u7ec4\u6c47\u603b\"},\"FLEVEL\":{\"FID\":\"Rule\",\"FNUMBER\":\"\",\"FNAME\":\"\u672c\u7ea7\"},\"FUNITORGID\":0,\"FISSUMORG\":false},\"FBillHead\":{\"FBillNo\":\"ETR20230218000001\",\"FErrorMsg\":\"\u5355\u636e\u7f16\u53f7\u3010ETR20230218000001\u3011,\u9884\u7b97\u63a7\u5236\u89c4\u5219\u3010\u5206\u7ec4\u6c47\u603b\u3011,\u9884\u7b97\u65b9\u6848\u3010\u5206\u7ec4\u6c47\u603b\u3011,\u9884\u7b97\u7ec4\u7ec7\u3010BM_oracle20200410\u3011,\u63a7\u5236\u7ef4\u5ea6\u3010\u7533\u8bf7\u90e8\u95e8(\u6d4b\u8bd5\u4e00\u90e8),\u8d39\u7528\u627f\u62c5\u90e8\u95e8.\u4e0a\u7ea7\u90e8\u95e8(\u6d4b\u8bd5\u90e8),\u5730\u533a(\u534e\u5357\u533a),\u7533\u8bf7\u90e8\u95e8.\u90e8\u95e8\u5c5e\u6027(\u7ba1\u7406\u90e8\u95e8),\u8d39\u7528\u9879\u76ee.\u5206\u7ec4(A),\u8d39\u7528\u9879\u76ee(\u8d39\u75282),\u7533\u8bf7\u4eba(\u5f20\u5434)\u3011,\u9884\u7b97\u63a7\u5236\u671f\u95f4\u30102\u6708\u3011,\u9879\u76ee\u6570\u636e\u7c7b\u578b\u3010\u8d44\u91d1\u9884\u7b97\u989d\u3011,\u63a7\u5236\u5e01\u79cd\u3010\u4eba\u6c11\u5e01\u3011,\u9884\u7b97\u63a7\u5236\u5e74\u5ea6\u30102023\u5e74\u3011,\u9884\u7b97\u6570\uff081,600\uff09,\u5df2\u53d1\u751f\uff08500\uff09,\u504f\u5dee\u503c\uff080.00\uff09,\u53ef\u7528\u6570\uff081,100\uff09,\u5f53\u524d\u5355\u636e\u6570\uff08800\uff09,\u5269\u4f59\u3010\u8d44\u91d1\u9884\u7b97\u989d\u3011\uff08300\uff09,\u9884\u7b97\u6267\u884c\u8fdb\u5ea6%\uff0881.25%\uff09,\u9884\u7b97\u671f\u95f4\uff082\uff09\u671f,\u9884\u7b97\u5468\u671f\u7c7b\u578b\u3010\u6708\u3011,\u9884\u7b97\u671f\u95f4\u8d77\u6b62\u65e5\u671f\u30102023-02-01 00:00:00\u52302023-02-28 00:00:00\u3011,\u5b9e\u9645\u6267\u884c\uff08500\uff09,\u6267\u884c\u51b2\u56de\uff080\uff09\\r\\n\u5355\u636e\u7f16\u53f7\u3010ETR20230218000001\u3011,\u9884\u7b97\u63a7\u5236\u89c4\u5219\u3010\u5206\u7ec4\u6c47\u603b\u3011,\u9884\u7b97\u65b9\u6848\u3010\u5206\u7ec4\u6c47\u603b\u3011,\u9884\u7b97\u7ec4\u7ec7\u3010BM_oracle20200410\u3011,\u63a7\u5236\u7ef4\u5ea6\u3010\u7533\u8bf7\u90e8\u95e8(\u6d4b\u8bd5\u4e00\u90e8),\u8d39\u7528\u627f\u62c5\u90e8\u95e8.\u4e0a\u7ea7\u90e8\u95e8(\u6d4b\u8bd5\u90e8),\u5730\u533a(\u534e\u5357\u533a),\u7533\u8bf7\u90e8\u95e8.\u90e8\u95e8\u5c5e\u6027(\u7ba1\u7406\u90e8\u95e8),\u8d39\u7528\u9879\u76ee.\u5206\u7ec4(A),\u8d39\u7528\u9879\u76ee(\u8d39\u75282),\u7533\u8bf7\u4eba(\u5f20\u5434)\u3011,\u9884\u7b97\u63a7\u5236\u671f\u95f4\u30102\u6708\u3011,\u9879\u76ee\u6570\u636e\u7c7b\u578b\u3010\u8d39\u7528\u9884\u7b97\u989d\u3011,\u63a7\u5236\u5e01\u79cd\u3010\u4eba\u6c11\u5e01\u3011,\u9884\u7b97\u63a7\u5236\u5e74\u5ea6\u30102023\u5e74\u3011,\u9884\u7b97\u6570\uff084,000\uff09,\u5df2\u53d1\u751f\uff08500\uff09,\u504f\u5dee\u503c\uff080.00\uff09,\u53ef\u7528\u6570\uff083,500\uff09,\u5f53\u524d\u5355\u636e\u6570\uff08800\uff09,\u5269\u4f59\u3010\u8d39\u7528\u9884\u7b97\u989d\u3011\uff082,700\uff09,\u9884\u7b97\u6267\u884c\u8fdb\u5ea6%\uff0832.5%\uff09,\u9884\u7b97\u671f\u95f4\uff082\uff09\u671f,\u9884\u7b97\u5468\u671f\u7c7b\u578b\u3010\u6708\u3011,\u9884\u7b97\u671f\u95f4\u8d77\u6b62\u65e5\u671f\u30102023-02-01 00:00:00\u52302023-02-28 00:00:00\u3011,\u5b9e\u9645\u6267\u884c\uff08500\uff09,\u6267\u884c\u51b2\u56de\uff080\uff09\\r\\n\u5355\u636e\u7f16\u53f7\u3010ETR20230218000001\u3011,\u9884\u7b97\u63a7\u5236\u89c4\u5219\u3010\u5206\u7ec4\u6c47\u603b\u3011,\u9884\u7b97\u65b9\u6848\u3010\u5206\u7ec4\u6c47\u603b\u3011,\u9884\u7b97\u7ec4\u7ec7\u3010BM_oracle20200410\u3011,\u63a7\u5236\u7ef4\u5ea6\u3010\u7533\u8bf7\u90e8\u95e8(\u6d4b\u8bd5\u4e00\u90e8),\u8d39\u7528\u627f\u62c5\u90e8\u95e8.\u4e0a\u7ea7\u90e8\u95e8(\u6d4b\u8bd5\u90e8),\u5730\u533a(\u534e\u5357\u533a),\u7533\u8bf7\u90e8\u95e8.\u90e8\u95e8\u5c5e\u6027(\u7ba1\u7406\u90e8\u95e8),\u8d39\u7528\u9879\u76ee.\u5206\u7ec4(A),\u8d39\u7528\u9879\u76ee(\u8d39\u75281),\u7533\u8bf7\u4eba(\u5f20\u5434)\u3011,\u9884\u7b97\u63a7\u5236\u671f\u95f4\u30102\u6708\u3011,\u9879\u76ee\u6570\u636e\u7c7b\u578b\u3010\u8d44\u91d1\u9884\u7b97\u989d\u3011,\u63a7\u5236\u5e01\u79cd\u3010\u4eba\u6c11\u5e01\u3011,\u9884\u7b97\u63a7\u5236\u5e74\u5ea6\u30102023\u5e74\u3011,\u9884\u7b97\u6570\uff081,600\uff09,\u5df2\u53d1\u751f\uff08300\uff09,\u504f\u5dee\u503c\uff080.00\uff09,\u53ef\u7528\u6570\uff081,300\uff09,\u5f53\u524d\u5355\u636e\u6570\uff08800\uff09,\u5269\u4f59\u3010\u8d44\u91d1\u9884\u7b97\u989d\u3011\uff08500\uff09,\u9884\u7b97\u6267\u884c\u8fdb\u5ea6%\uff0868.75%\uff09,\u9884\u7b97\u671f\u95f4\uff082\uff09\u671f,\u9884\u7b97\u5468\u671f\u7c7b\u578b\u3010\u6708\u3011,\u9884\u7b97\u671f\u95f4\u8d77\u6b62\u65e5\u671f\u30102023-02-01 00:00:00\u52302023-02-28 00:00:00\u3011,\u5b9e\u9645\u6267\u884c\uff08300\uff09,\u6267\u884c\u51b2\u56de\uff080\uff09\\r\\n\u5355\u636e\u7f16\u53f7\u3010ETR20230218000001\u3011,\u9884\u7b97\u63a7\u5236\u89c4\u5219\u3010\u5206\u7ec4\u6c47\u603b\u3011,\u9884\u7b97\u65b9\u6848\u3010\u5206\u7ec4\u6c47\u603b\u3011,\u9884\u7b97\u7ec4\u7ec7\u3010BM_oracle20200410\u3011,\u63a7\u5236\u7ef4\u5ea6\u3010\u7533\u8bf7\u90e8\u95e8(\u6d4b\u8bd5\u4e00\u90e8),\u8d39\u7528\u627f\u62c5\u90e8\u95e8.\u4e0a\u7ea7\u90e8\u95e8(\u6d4b\u8bd5\u90e8),\u5730\u533a(\u534e\u5357\u533a),\u7533\u8bf7\u90e8\u95e8.\u90e8\u95e8\u5c5e\u6027(\u7ba1\u7406\u90e8\u95e8),\u8d39\u7528\u9879\u76ee.\u5206\u7ec4(A),\u8d39\u7528\u9879\u76ee(\u8d39\u75281),\u7533\u8bf7\u4eba(\u5f20\u5434)\u3011,\u9884\u7b97\u63a7\u5236\u671f\u95f4\u30102\u6708\u3011,\u9879\u76ee\u6570\u636e\u7c7b\u578b\u3010\u8d39\u7528\u9884\u7b97\u989d\u3011,\u63a7\u5236\u5e01\u79cd\u3010\u4eba\u6c11\u5e01\u3011,\u9884\u7b97\u63a7\u5236\u5e74\u5ea6\u30102023\u5e74\u3011,\u9884\u7b97\u6570\uff084,000\uff09,\u5df2\u53d1\u751f\uff08300\uff09,\u504f\u5dee\u503c\uff080.00\uff09,\u53ef\u7528\u6570\uff083,700\uff09,\u5f53\u524d\u5355\u636e\u6570\uff08800\uff09,\u5269\u4f59\u3010\u8d39\u7528\u9884\u7b97\u989d\u3011\uff082,900\uff09,\u9884\u7b97\u6267\u884c\u8fdb\u5ea6%\uff0827.5%\uff09,\u9884\u7b97\u671f\u95f4\uff082\uff09\u671f,\u9884\u7b97\u5468\u671f\u7c7b\u578b\u3010\u6708\u3011,\u9884\u7b97\u671f\u95f4\u8d77\u6b62\u65e5\u671f\u30102023-02-01 00:00:00\u52302023-02-28 00:00:00\u3011,\u5b9e\u9645\u6267\u884c\uff08300\uff09,\u6267\u884c\u51b2\u56de\uff080\uff09\\r\\n\",\"FBWBCURRENCYID\":\"0\",\"FYEARPERIOD\":\"2023\u5e74\u7b2c2\u671f\",\"FPERIOD\":\"3\",\"FCURRENCYID\":\"1\"},\"FEntity\":[{\"FLEVEL\":\"DETAIL\",\"FBudgetOrgId\":{\"FID\":\"100029\",\"FNUMBER\":\"100\",\"FNAME\":\"BM_oracle20200410\"},\"FBudgetOrgName\":\"BM_oracle20200410\",\"FORGTYPE\":\"ORG\",\"FDATATYPEID\":{\"FID\":\"13\",\"FNUMBER\":\"\",\"FNAME\":\"\"},\"FBUSINESSTYPEID\":{\"FID\":\"2\",\"FNUMBER\":\"\",\"FNAME\":\"\"},\"FDimensionId1\":\"\u6d4b\u8bd5\u4e00\u90e8\",\"FFilterKey1\":\"100041\",\"FDimensionId2\":\"\u6d4b\u8bd5\u90e8\",\"FFilterKey2\":\"100040\",\"FDimensionId5\":\"A\",\"FFilterKey5\":\"112280\",\"FDimensionId6\":\"\u8d39\u75282\",\"FFilterKey6\":\"119402\",\"FDimensionId7\":\"\u5f20\u5434\",\"FFilterKey7\":\"209194\",\"FDimensionId8\":\"\",\"FFilterKey8\":\"\",\"FBUDGETVALUE\":1600.0,\"FREALUSEDVALUE\":500.0,\"FUSABLEVALUE\":1100.0,\"FCurrentValue\":800.0,\"FBalanceValue\":300.0,\"FSCHEMEID\":235435,\"FRULEID\":235441,\"FStartYearPeriod\":2023002,\"FEndYearPeriod\":2023002,\"FYearEntry\":2023,\"FPeriodEntry\":2,\"FIsOrgSumCtrl\":false,\"FLASTCUMVALUE\":300.0},{\"FLEVEL\":\"DETAIL\",\"FBudgetOrgId\":{\"FID\":\"100029\",\"FNUMBER\":\"100\",\"FNAME\":\"BM_oracle20200410\"},\"FBudgetOrgName\":\"BM_oracle20200410\",\"FORGTYPE\":\"ORG\",\"FDATATYPEID\":{\"FID\":\"13\",\"FNUMBER\":\"\",\"FNAME\":\"\"},\"FBUSINESSTYPEID\":{\"FID\":\"2\",\"FNUMBER\":\"\",\"FNAME\":\"\"},\"FDimensionId1\":\"\u6d4b\u8bd5\u4e00\u90e8\",\"FFilterKey1\":\"100041\",\"FDimensionId2\":\"\u6d4b\u8bd5\u90e8\",\"FFilterKey2\":\"100040\",\"FDimensionId5\":\"A\",\"FFilterKey5\":\"112280\",\"FDimensionId6\":\"\u8d39\u75281\",\"FFilterKey6\":\"119401\",\"FDimensionId7\":\"\u5f20\u5434\",\"FFilterKey7\":\"209194\",\"FDimensionId8\":\"\",\"FFilterKey8\":\"\",\"FBUDGETVALUE\":1600.0,\"FREALUSEDVALUE\":300.0,\"FUSABLEVALUE\":1300.0,\"FCurrentValue\":800.0,\"FBalanceValue\":500.0,\"FSCHEMEID\":235435,\"FRULEID\":235441,\"FStartYearPeriod\":2023002,\"FEndYearPeriod\":2023002,\"FYearEntry\":2023,\"FPeriodEntry\":2,\"FIsOrgSumCtrl\":false,\"FLASTCUMVALUE\":500.0},{\"FLEVEL\":\"SUBTOTAL\",\"FDataTypeName\":\"\u5c0f\u8ba1\",\"FBUDGETVALUE\":3200.0,\"FREALUSEDVALUE\":800.0,\"FUSABLEVALUE\":2400.0,\"FCurrentValue\":1600.0,\"FADJUSTVALUE\":1600.0,\"FBalanceValue\":800.0,\"FBudgetOrgId\":100029,\"FDATATYPEID\":13,\"FBUSINESSTYPEID\":2,\"FSCHEMEID\":235435,\"FRULEID\":235441,\"FStartYearPeriod\":2023002,\"FEndYearPeriod\":2023002,\"FIsOrgSumCtrl\":false,\"FLASTCUMVALUE\":800.0,\"FFilterKey1\":\"100041\",\"FFilterKey2\":\"100040\",\"FFilterKey3\":\"\",\"FFilterKey4\":\"\",\"FFilterKey5\":\"112280\",\"FFilterKey6\":\"119402,119401\",\"FFilterKey7\":\"209194\",\"FFilterKey8\":\"\"},{\"FLEVEL\":\"DETAIL\",\"FBudgetOrgId\":{\"FID\":\"100029\",\"FNUMBER\":\"100\",\"FNAME\":\"BM_oracle20200410\"},\"FBudgetOrgName\":\"BM_oracle20200410\",\"FORGTYPE\":\"ORG\",\"FDATATYPEID\":{\"FID\":\"12\",\"FNUMBER\":\"\",\"FNAME\":\"\"},\"FBUSINESSTYPEID\":{\"FID\":\"1\",\"FNUMBER\":\"\",\"FNAME\":\"\"},\"FDimensionId1\":\"\u6d4b\u8bd5\u4e00\u90e8\",\"FFilterKey1\":\"100041\",\"FDimensionId2\":\"\u6d4b\u8bd5\u90e8\",\"FFilterKey2\":\"100040\",\"FDimensionId5\":\"A\",\"FFilterKey5\":\"112280\",\"FDimensionId6\":\"\u8d39\u75282\",\"FFilterKey6\":\"119402\",\"FDimensionId7\":\"\u5f20\u5434\",\"FFilterKey7\":\"209194\",\"FDimensionId8\":\"\",\"FFilterKey8\":\"\",\"FBUDGETVALUE\":4000.0,\"FREALUSEDVALUE\":500.0,\"FUSABLEVALUE\":3500.0,\"FCurrentValue\":800.0,\"FBalanceValue\":2700.0,\"FSCHEMEID\":235435,\"FRULEID\":235441,\"FStartYearPeriod\":2023002,\"FEndYearPeriod\":2023002,\"FYearEntry\":2023,\"FPeriodEntry\":2,\"FIsOrgSumCtrl\":false,\"FLASTCUMVALUE\":1500.0},{\"FLEVEL\":\"DETAIL\",\"FBudgetOrgId\":{\"FID\":\"100029\",\"FNUMBER\":\"100\",\"FNAME\":\"BM_oracle20200410\"},\"FBudgetOrgName\":\"BM_oracle20200410\",\"FORGTYPE\":\"ORG\",\"FDATATYPEID\":{\"FID\":\"12\",\"FNUMBER\":\"\",\"FNAME\":\"\"},\"FBUSINESSTYPEID\":{\"FID\":\"1\",\"FNUMBER\":\"\",\"FNAME\":\"\"},\"FDimensionId1\":\"\u6d4b\u8bd5\u4e00\u90e8\",\"FFilterKey1\":\"100041\",\"FDimensionId2\":\"\u6d4b\u8bd5\u90e8\",\"FFilterKey2\":\"100040\",\"FDimensionId5\":\"A\",\"FFilterKey5\":\"112280\",\"FDimensionId6\":\"\u8d39\u75281\",\"FFilterKey6\":\"119401\",\"FDimensionId7\":\"\u5f20\u5434\",\"FFilterKey7\":\"209194\",\"FDimensionId8\":\"\",\"FFilterKey8\":\"\",\"FBUDGETVALUE\":4000.0,\"FREALUSEDVALUE\":300.0,\"FUSABLEVALUE\":3700.0,\"FCurrentValue\":800.0,\"FBalanceValue\":2900.0,\"FSCHEMEID\":235435,\"FRULEID\":235441,\"FStartYearPeriod\":2023002,\"FEndYearPeriod\":2023002,\"FYearEntry\":2023,\"FPeriodEntry\":2,\"FIsOrgSumCtrl\":false,\"FLASTCUMVALUE\":1700.0},{\"FLEVEL\":\"SUBTOTAL\",\"FDataTypeName\":\"\u5c0f\u8ba1\",\"FBUDGETVALUE\":8000.0,\"FREALUSEDVALUE\":800.0,\"FUSABLEVALUE\":7200.0,\"FCurrentValue\":1600.0,\"FADJUSTVALUE\":1600.0,\"FBalanceValue\":5600.0,\"FBudgetOrgId\":100029,\"FDATATYPEID\":12,\"FBUSINESSTYPEID\":1,\"FSCHEMEID\":235435,\"FRULEID\":235441,\"FStartYearPeriod\":2023002,\"FEndYearPeriod\":2023002,\"FIsOrgSumCtrl\":false,\"FLASTCUMVALUE\":3200.0,\"FFilterKey1\":\"100041\",\"FFilterKey2\":\"100040\",\"FFilterKey3\":\"\",\"FFilterKey4\":\"\",\"FFilterKey5\":\"112280\",\"FFilterKey6\":\"119402,119401\",\"FFilterKey7\":\"209194\",\"FFilterKey8\":\"\"},{\"FLEVEL\":\"TOTAL\",\"FBudgetOrgName\":\"\u5408\u8ba1\",\"FBUDGETVALUE\":11200.0,\"FREALUSEDVALUE\":1600.0,\"FUSABLEVALUE\":9600.0,\"FCurrentValue\":3200.0,\"FADJUSTVALUE\":3200.0,\"FBalanceValue\":6400.0,\"FBudgetOrgId\":100029,\"FSCHEMEID\":235435,\"FRULEID\":235441,\"FStartYearPeriod\":2023002,\"FEndYearPeriod\":2023002,\"FIsOrgSumCtrl\":false,\"FLASTCUMVALUE\":4000.0,\"FFilterKey1\":\"100041\",\"FFilterKey2\":\"100040\",\"FFilterKey3\":\"\",\"FFilterKey4\":\"\",\"FFilterKey5\":\"112280\",\"FFilterKey6\":\"119402,119401\",\"FFilterKey7\":\"209194\",\"FFilterKey8\":\"\"}],\"FBudgetOrgIds\":[100029]}],\"FCtrlDimension\":[{\"FRULE\":{\"FID\":\"235459\",\"FNUMBER\":\"\",\"FNAME\":\"\u5206\u7ec4\u6c47\u603b3\u4e2a\"},\"FDimensionId1\":{\"FID\":\"101\",\"FNUMBER\":\"YSWD02_SYS\",\"FNAME\":\"\u90e8\u95e8\"},\"FDimensionId2\":{\"FID\":\"207420\",\"FNUMBER\":\"BBWD0013\",\"FNAME\":\"\u4e0a\u7ea7\u90e8\u95e8\"},\"FDimensionId3\":{\"FID\":\"100058\",\"FNUMBER\":\"001\",\"FNAME\":\"\u5730\u533a\"},\"FDimensionId4\":{\"FID\":\"149273\",\"FNUMBER\":\"BBWD0008\",\"FNAME\":\"\u90e8\u95e8\u5c5e\u6027\"},\"FDimensionId5\":{\"FID\":\"108\",\"FNUMBER\":\"YSWD08_SYS\",\"FNAME\":\"\u8d39\u7528\u9879\u76ee\u5206\u7ec4\"},\"FDimensionId6\":{\"FID\":\"102\",\"FNUMBER\":\"YSWD03_SYS\",\"FNAME\":\"\u8d39\u7528\u9879\u76ee\"},\"FDimensionId7\":{\"FID\":\"106\",\"FNUMBER\":\"YSWD04_SYS\",\"FNAME\":\"\u5458\u5de5\"}},{\"FRULE\":{\"FID\":\"235441\",\"FNUMBER\":\"\",\"FNAME\":\"\u5206\u7ec4\u6c47\u603b\"},\"FDimensionId1\":{\"FID\":\"101\",\"FNUMBER\":\"YSWD02_SYS\",\"FNAME\":\"\u90e8\u95e8\"},\"FDimensionId2\":{\"FID\":\"207420\",\"FNUMBER\":\"BBWD0013\",\"FNAME\":\"\u4e0a\u7ea7\u90e8\u95e8\"},\"FDimensionId3\":{\"FID\":\"100058\",\"FNUMBER\":\"001\",\"FNAME\":\"\u5730\u533a\"},\"FDimensionId4\":{\"FID\":\"149273\",\"FNUMBER\":\"BBWD0008\",\"FNAME\":\"\u90e8\u95e8\u5c5e\u6027\"},\"FDimensionId5\":{\"FID\":\"108\",\"FNUMBER\":\"YSWD08_SYS\",\"FNAME\":\"\u8d39\u7528\u9879\u76ee\u5206\u7ec4\"},\"FDimensionId6\":{\"FID\":\"102\",\"FNUMBER\":\"YSWD03_SYS\",\"FNAME\":\"\u8d39\u7528\u9879\u76ee\"},\"FDimensionId7\":{\"FID\":\"106\",\"FNUMBER\":\"YSWD04_SYS\",\"FNAME\":\"\u5458\u5de5\"}}]}}";

    private Map<String, String> queryStartSchema() {
        DynamicObject setting = BusinessDataServiceHelper.loadSingleFromCache((String)"er_isc_setting", (String)"id,entryentity.key,entryentity.value", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"setting")});
        Map<String, String> map = setting.getDynamicObjectCollection("entryentity").stream().filter(row -> {
            String key = row.getString("key");
            return key != null && key.startsWith("er_") && key.endsWith("_xk_save");
        }).collect(Collectors.toMap(row -> row.getString("key"), row -> row.getString("value")));
        logger.info("\u9884\u7b97\u67e5\u8be2\u542f\u52a8\u65b9\u6848\u914d\u7f6e" + JSONObject.toJSONString(map));
        return map;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        String initialized = this.getView().getPageCache().get("initialized");
        if (initialized != null) {
            return;
        }
        this.getView().getPageCache().put("initialized", "true");
        String entryName = this.getView().getParentView().getModel().getDataEntityType().getName();
        List<String> startSchemaNumbers = this.getStartSchemaNumbers(entryName);
        if (startSchemaNumbers.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5355\u636e\u201c%s\u201d\u4fdd\u5b58\u7684\u542f\u52a8\u65b9\u6848\u7f16\u7801\u3002\u9884\u7b97\u67e5\u8be2\u5931\u8d25\u3002", (String)"XKBgBalanceListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), entryName));
        } else {
            logger.info("\u83b7\u53d6\u7684\u542f\u52a8\u65b9\u6848" + JSONObject.toJSONString(startSchemaNumbers));
            List<String> results = this.queryBuget(entryName, startSchemaNumbers);
            final List resultList = results.stream().map(result -> {
                logger.info("\u67e5\u8be2\u9884\u7b97\u8fd4\u56de\u7ed3\u679c " + result);
                String content = result.trim();
                content = content.substring(1, content.length() - 1);
                return (Map)JSONObject.parse((String)content);
            }).collect(Collectors.toList());
            args.setListDataProvider((IListDataProvider)new ListDataProvider(){

                public DynamicObjectCollection getData(int arg0, int arg1) {
                    DynamicObjectCollection records = super.getData(arg0, arg1);
                    ArrayList<String> errMsgList = new ArrayList<String>(3);
                    for (int i = 0; i < resultList.size(); ++i) {
                        Map bgMap = (Map)((Map)resultList.get(i)).get("result");
                        if (bgMap.getOrDefault("status", 1) == 1) {
                            String errMsg = (String)bgMap.get("message");
                            if (errMsg == null) continue;
                            errMsgList.add(errMsg);
                            continue;
                        }
                        Map model = (Map)bgMap.get("Model");
                        List ctrlRuleTreeViewList = (List)model.get("FCtrlRuleTreeView");
                        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"er_xkbugetview");
                        records = new DynamicObjectCollection((DynamicObjectType)dt, null);
                        for (Map ctrlNode : ctrlRuleTreeViewList) {
                            XKBgBalanceListPlugin.this.handleErrMsg(ctrlNode, errMsgList);
                            XKBgBalanceListPlugin.this.bulidRecord(records, ctrlNode);
                        }
                    }
                    this.getQueryResult().setCollection(records);
                    this.getQueryResult().setDataCount(records.size());
                    if (!errMsgList.isEmpty()) {
                        String errMsg = errMsgList.stream().collect(Collectors.joining(";"));
                        XKBgBalanceListPlugin.this.getView().showTipNotification(errMsg);
                    }
                    return records;
                }
            });
        }
    }

    private void handleErrMsg(Map<String, Object> nodeData, List<String> errMsgList) {
        String msg;
        Map treeNode = (Map)nodeData.get("FCtrlRuleTreeNode");
        Map ruleMap = (Map)treeNode.get("FRULE");
        if (treeNode != null && ruleMap != null && treeNode.get("FMessage") != null && StringUtils.isNotEmpty((CharSequence)(msg = (String)treeNode.get("FMessage")))) {
            String ruleName = (String)ruleMap.get("FNAME");
            String ruleId = (String)ruleMap.get("FID");
            errMsgList.add(String.format(ResManager.loadKDString((String)"\u63a7\u5236\u89c4\u5219\uff1a%1$s id\uff1a%2$s \u9519\u8bef\u4fe1\u606f %3$s", (String)"XKBgBalanceListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), ruleName, ruleId, msg));
        }
    }

    private void bulidRecord(DynamicObjectCollection records, Map<String, Object> nodeData) {
        Map treeNode = (Map)nodeData.get("FCtrlRuleTreeNode");
        Map shemeMap = (Map)treeNode.get("FSCHEME");
        Map ruleMap = (Map)treeNode.get("FRULE");
        Map billHeadMap = (Map)nodeData.get("FBillHead");
        List entryList = (List)nodeData.get("FEntity");
        if (entryList == null) {
            return;
        }
        List rows = entryList.stream().filter(item -> StringUtils.equalsAny((CharSequence)((String)item.get("FLEVEL")), (CharSequence[])new CharSequence[]{"DETAIL", "TOTAL"})).collect(Collectors.toList());
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"er_xkbugetview");
        for (Map rowMap : rows) {
            DynamicObject record = new DynamicObject((DynamicObjectType)dt, true);
            if (StringUtils.equals((CharSequence)((String)rowMap.get("FLEVEL")), (CharSequence)"DETAIL")) {
                record.set("billno", billHeadMap.get("FBillNo"));
                record.set("schemeid", shemeMap.get("FID"));
                record.set("schemenumber", shemeMap.get("FNUMBER"));
                record.set("schemename", shemeMap.get("FNAME"));
                record.set("ruleid", ruleMap.get("FID"));
                record.set("rulenumber", ruleMap.get("FNUMBER"));
                record.set("rulename", ruleMap.get("FNAME"));
                record.set("period", billHeadMap.get("FPERIOD"));
                record.set("currencyid", billHeadMap.get("FCURRENCYID"));
                record.set("bwbcurrencyid", billHeadMap.get("FBWBCURRENCYID"));
                record.set("yearperiod", billHeadMap.get("FYEARPERIOD"));
                record.set("erromsg", billHeadMap.get("FErrorMsg"));
                record.set("isneedctrl", treeNode.get("FIsNeedCtrl"));
                Map bugetOrg = (Map)rowMap.get("FBudgetOrgId");
                record.set("budgetorgname", rowMap.get("FBudgetOrgName"));
                record.set("budgetorgid", bugetOrg.get("FID"));
                record.set("budgetorgnumber", bugetOrg.get("FNUMBER"));
                record.set("orgtype", rowMap.get("FORGTYPE"));
                record.set("dimensionid1", (Object)rowMap.getOrDefault("FDimensionId1", ""));
                record.set("dimensionid2", (Object)rowMap.getOrDefault("FDimensionId2", ""));
                record.set("dimensionid3", (Object)rowMap.getOrDefault("FDimensionId3", ""));
                record.set("dimensionid4", (Object)rowMap.getOrDefault("FDimensionId4", ""));
                record.set("dimensionid5", (Object)rowMap.getOrDefault("FDimensionId5", ""));
                record.set("dimensionid6", (Object)rowMap.getOrDefault("FDimensionId6", ""));
                record.set("dimensionid7", (Object)rowMap.getOrDefault("FDimensionId7", ""));
                record.set("dimensionid8", (Object)rowMap.getOrDefault("FDimensionId8", ""));
                record.set("yearentry", rowMap.get("FYearEntr"));
                record.set("isorgsumctrl", rowMap.get("FIsOrgSumCtrl"));
                record.set("lastcumvalue", rowMap.get("FLASTCUMVALUE"));
            } else {
                record.set("schemename", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"XKBgBalanceListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            record.set("startyearperiod", rowMap.get("FStartYearPeriod"));
            record.set("endyearperiod", rowMap.get("FEndYearPeriod"));
            record.set("budgetvalue", rowMap.get("FBUDGETVALUE"));
            record.set("realusedvalue", rowMap.get("FREALUSEDVALUE"));
            record.set("usablevalue", rowMap.get("FUSABLEVALUE"));
            record.set("currentvalue", rowMap.get("FCurrentValue"));
            record.set("balancevalue", rowMap.get("FBalanceValue"));
            records.add((Object)record);
        }
    }

    protected List<String> getStartSchemaNumbers(String EntryName) {
        Map<String, String> startSchemaMap = this.queryStartSchema();
        ArrayList<String> schemaNumberList = new ArrayList<String>(2);
        String startSuffix = String.join((CharSequence)"", EntryName, "_");
        String endSuffix = "_xk_save";
        switch (EntryName) {
            case "er_tripreqbill": {
                schemaNumberList.add(startSchemaMap.get("er_tripreqbill_payeer_xk_save"));
                break;
            }
            case "er_dailyreimbursebill": {
                schemaNumberList.add(startSchemaMap.get("er_dailyreimbursebill_payeer_xk_save"));
                break;
            }
            case "er_publicreimbursebill": 
            case "er_dailyloanbill": {
                String billpayertype;
                IDataModel pModel = this.getView().getParentView().getModel();
                DynamicObjectCollection colls = pModel.getDataEntity(true).getDynamicObjectCollection("accountentry");
                if (colls == null || colls.size() <= 0 || (billpayertype = ((DynamicObject)colls.get(0)).getString("payertype")) == null) break;
                schemaNumberList.add(startSchemaMap.get(String.join((CharSequence)"", startSuffix, PAYER_TYPE_SUFIX_MAP.get(billpayertype), endSuffix)));
                break;
            }
            case "er_tripreimbursebill": {
                schemaNumberList.add(startSchemaMap.get("er_tripreimbursebill_cash_xk_save"));
                schemaNumberList.add(startSchemaMap.get("er_tripreimbursebill_monthly_xk_save"));
                break;
            }
            default: {
                return Collections.EMPTY_LIST;
            }
        }
        return schemaNumberList.stream().filter(item -> item != null).collect(Collectors.toList());
    }

    private List<String> queryBuget(String entryName, List<String> startSchemaNumbers) {
        ArrayList<String> result = new ArrayList<String>();
        IDataModel pModel = this.getView().getParentView().getModel();
        Map<String, Object> filterParam = Stream.of(new Object[][]{{"id", pModel.getValue("id")}}).collect(Collectors.toMap(item -> (String)item[0], item -> item[1]));
        Map<String, Object> queryParam = Stream.of({"BillNo", pModel.getValue("billno")}, {"FormID", CQ_XK_BILL_MAP.get(entryName)}, {"ContianSubmitBill", true}, {"ContianSaveReport", false}, {"OnlyShowEffectCtrlRule", false}).collect(Collectors.toMap(item -> (String)item[0], item -> item[1]));
        if (!StringUtils.equals((CharSequence)entryName, (CharSequence)"er_tripreimbursebill")) {
            if (this.synBill(startSchemaNumbers.get(0), filterParam)) {
                result.add(this.queryBuget(queryParam));
            }
        } else {
            if (pModel.getDataEntity().getBigDecimal("encashamount").compareTo(BigDecimal.ZERO) != 0 && this.synBill(startSchemaNumbers.get(0), filterParam)) {
                result.add(this.queryBuget(queryParam));
            }
            if (pModel.getDataEntity().getBigDecimal("monthsettleamount").compareTo(BigDecimal.ZERO) != 0 && this.synBill(startSchemaNumbers.get(1), filterParam)) {
                result.add(this.queryBuget(queryParam));
            }
        }
        return result;
    }

    private String queryBuget(Map<String, Object> queryParam) {
        logger.info(String.format("\u5f00\u59cb\u67e5\u8be2\u9884\u7b97 \u53c2\u6570\u4e3a %s", JSON.toJSONString(queryParam)));
        Object caller = null;
        String result = (String)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscApicService", (String)"invokeScriptApi2", (Object[])new Object[]{"XK-Buget-Query", queryParam, caller});
        return result;
    }

    private boolean synBill(String startSchemaNumber, Map<String, Object> filterParam) {
        logger.info(String.format("\u5f00\u59cb\u540c\u6b65\u5355\u636e \u542f\u52a8\u65b9\u6848\u4e3a %s, \u8fc7\u6ee4\u53c2\u6570\u4e3a %s", startSchemaNumber, JSON.toJSONString(filterParam)));
        Map response = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"syncExecute", (Object[])new Object[]{startSchemaNumber, filterParam});
        if (response == null) {
            return false;
        }
        String executionState = (String)response.get("execution_state");
        return StringUtils.equals((CharSequence)"S", (CharSequence)executionState);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    static {
        Set set = Stream.of("er_publicreimbursebill", "er_repaymentbill", "er_dailyreimbursebill", "er_dailyloanbill", "er_tripreqbill", "er_tripreimbursebill").collect(Collectors.toSet());
        Map<String, String> mapTwo = Stream.of({"bd_supplier", "supplier"}, {"bd_customer", "customer"}, {"er_payeer", "payeer"}).collect(Collectors.toMap(item -> item[0], item -> item[1]));
        PAYER_TYPE_SUFIX_MAP = Collections.unmodifiableMap(mapTwo);
        CQ_XK_BILL_MAP = Collections.unmodifiableMap(Stream.of({"er_tripreimbursebill", "ER_ExpReimbursement_Travel"}, {"er_dailyreimbursebill", "ER_ExpReimbursement"}, {"er_publicreimbursebill", "ER_ExpReimbursement"}, {"er_dailyloanbill", "ER_ExpenseRequest"}, {"er_tripreqbill", "ER_ExpenseRequest_Travel"}).collect(Collectors.toMap(item -> item[0], item -> item[1])));
    }
}

