/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin;

import java.time.Year;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.common.constant.ErExpenseItemConstant;

public class YearForwardFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit forwardtype;
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        int thisyear = Year.now().getValue();
        Object choosedateyear = customParams.get("choosedateyear");
        if (choosedateyear == null || choosedateyear.toString().trim().length() == 0) {
            choosedateyear = thisyear - 1;
        }
        ComboEdit choosedateyearCombo = (ComboEdit)this.getControl("choosedateyear");
        ArrayList<ComboItem> comboItemLst = new ArrayList<ComboItem>(5);
        for (int i = 1; i <= 5; ++i) {
            ComboItem item = new ComboItem();
            String year = thisyear - i + "";
            item.setCaption(new LocaleString(year));
            item.setValue(year);
            comboItemLst.add(item);
        }
        choosedateyearCombo.setComboItems(comboItemLst);
        IDataModel model = this.getModel();
        model.setValue("choosedateyear", (Object)(choosedateyear + ""));
        model.setValue("thisyear", (Object)(thisyear + ""));
        if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue().equals(customParams.get("ctrlMethod")) && (forwardtype = (ComboEdit)this.getControl("forwardtype")) != null) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u7ed3\u8f6c\u5230\u6307\u5b9a\u671f\u95f4", (String)"YearForwardFormPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0])));
            item.setValue("2");
            forwardtype.setComboItems(Collections.singletonList(item));
            model.setValue("forwardtype", (Object)"2");
            view.setVisible(Boolean.valueOf(true), new String[]{"assignedmonth"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("forwardtype".equalsIgnoreCase(name)) {
            String forwardType = (String)this.getModel().getValue("forwardtype");
            boolean isAssignPeriod = forwardType.equals("2");
            IFormView view = this.getView();
            if (isAssignPeriod) {
                Map customParams = view.getFormShowParameter().getCustomParams();
                String ctrlMethod = (String)customParams.get("ctrlMethod");
                view.setVisible(Boolean.valueOf(!ctrlMethod.equals("E")), new String[]{"assignedmonth"});
                view.setVisible(Boolean.valueOf(ctrlMethod.equals("E")), new String[]{"assignedquarter"});
            } else {
                view.setVisible(Boolean.valueOf(false), new String[]{"assignedmonth", "assignedquarter"});
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        IFormView view = this.getView();
        if ("btnok".equalsIgnoreCase(key)) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            IDataModel model = this.getModel();
            String forwardType = (String)model.getValue("forwardtype");
            boolean isAssignPeriod = forwardType.equals("2");
            ret.put("isAssignPeriod", isAssignPeriod);
            ret.put("choosedateyear", model.getValue("choosedateyear"));
            if (isAssignPeriod) {
                Map customParams = view.getFormShowParameter().getCustomParams();
                String ctrlMethod = (String)customParams.get("ctrlMethod");
                Object assignedPeriod = ctrlMethod.equals("E") ? model.getValue("assignedquarter") : model.getValue("assignedmonth");
                ret.put("assignedPeriod", assignedPeriod);
            }
            view.returnDataToParent(ret);
        }
        view.close();
    }
}

