/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.amount.control;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;

public class FeeStandardAddPlugin
extends AbstractFormPlugin {
    private static final String STARDARDTYPE = "stardardtype";
    private static final String EXPENSEITEM = "expenseitem";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
        if (createorg == null) {
            return;
        }
        Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId((Long)((Long)createorg.getPkValue()), (Boolean)true);
        if (this.getModel().getProperty("costcompany") != null) {
            this.getModel().setValue("costcompany", (Object)accountOrgId);
            this.changeCurrency();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit expense = (BasedataEdit)this.getControl(EXPENSEITEM);
        if (expense != null) {
            expense.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                    ListShowParameter cardF7Param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    cardF7Param.getListFilterParameter().getQFilters().add(new QFilter("isreimburseamountctl", "=", (Object)"3"));
                }
            });
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"er_standard_dimension", (String)"number", (QFilter[])new QFilter[0]);
        List<String> collect = objectDynamicObjectMap.values().stream().map(it -> it.get("number")).collect(Collectors.toList());
        this.getView().setVisible(Boolean.valueOf(false), collect.toArray(new String[collect.size()]));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"fieldsetpanelap"});
        DynamicObject stardardtypeItem = this.getModel().getDataEntity().getDynamicObject(STARDARDTYPE);
        if (Objects.nonNull(stardardtypeItem)) {
            this.dealStardardTypeVisible(stardardtypeItem, false);
        }
        this.changeOtherStand((Boolean)this.getModel().getValue("otherstand"));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"summarycontrol", "relatedstandard"});
        if (((Boolean)this.getModel().getValue("summarycontrol")).booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency", "ctlnumber", "ctlperiod", "actualreimexpense"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        switch (propName) {
            case "stardardtype": {
                this.clearValidValue();
                this.dealStardardTypeVisible((DynamicObject)newValue, true);
                break;
            }
            case "costcompany": {
                this.changeCurrency();
                DynamicObject costcompany = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (costcompany == null) break;
                this.checkExpenseItemValid((Long)costcompany.getPkValue());
                break;
            }
            case "otherstand": {
                boolean otherstand = Boolean.TRUE.equals(newValue);
                this.changeOtherStand(otherstand);
            }
        }
    }

    private void changeOtherStand(boolean otherstand) {
        ((FieldEdit)this.getControl("otherstandamount")).setMustInput(otherstand);
        this.getView().setVisible(Boolean.valueOf(otherstand), new String[]{"otherstandamount"});
        if (!otherstand) {
            this.getModel().setValue("otherstandamount", (Object)0);
        }
    }

    private void checkExpenseItemValid(Long newCostCompanyPk) {
        if (newCostCompanyPk == null) {
            return;
        }
        Object expenseitem = this.getModel().getValue(EXPENSEITEM);
        if (expenseitem == null) {
            return;
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)newCostCompanyPk);
        DynamicObject single = BusinessDataServiceHelper.loadSingleFromCache((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{baseDataFilter, QFilter.of((String)"id = ?", (Object[])new Object[]{((DynamicObject)expenseitem).getPkValue()})});
        if (single == null) {
            this.getModel().setValue(EXPENSEITEM, null);
        }
    }

    private void changeCurrency() {
        this.getModel().setValue("currency", (Object)BaseCurrencyServiceHelper.getBaseCurrencyId((Object)this.getModel().getValue("createorg"), (Object)this.getModel().getValue("costcompany")));
    }

    private void dealStardardTypeVisible(DynamicObject dynamicObject, boolean setDefaultValue) {
        if (dynamicObject == null) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"fieldsetpanelap"});
        DynamicObjectCollection objectCollection = dynamicObject.getDynamicObjectCollection("dimension");
        if (objectCollection.size() == 0) {
            return;
        }
        List<String> dimensionNumber = objectCollection.stream().map(it -> it.getDynamicObject("fbasedataid")).map(it -> it.getString("number")).collect(Collectors.toList());
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"fieldsetpanelap"});
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"er_standard_dimension", (String)"number", (QFilter[])new QFilter[0]);
        List<String> collect = objectDynamicObjectMap.values().stream().map(it -> it.get("number")).filter(it -> !dimensionNumber.contains(it)).collect(Collectors.toList());
        String[] showFields = new String[dimensionNumber.size()];
        dimensionNumber.toArray(showFields);
        this.getView().setVisible(Boolean.valueOf(true), showFields);
        this.getView().setVisible(Boolean.valueOf(false), collect.toArray(new String[collect.size()]));
        for (String field : showFields) {
            FieldEdit fieldEdit = (FieldEdit)this.getControl(field);
            if (fieldEdit == null) continue;
            fieldEdit.setMustInput(true);
        }
        if (setDefaultValue) {
            this.setDefaultValue(showFields);
        }
    }

    private void setDefaultValue(String[] showFields) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getView().getEntityId());
        for (String field : showFields) {
            DynamicProperty property = dataEntityType.getProperty(field);
            if (!(property instanceof FieldProp)) continue;
            Object defValue = ((FieldProp)property).getDefValue();
            this.getModel().setValue(field, defValue);
        }
    }

    private void clearValidValue() {
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"er_standard_dimension", (String)"number", (QFilter[])new QFilter[0]);
        Set objectSet = objectDynamicObjectMap.values().stream().map(it -> String.valueOf(it.get("number"))).collect(Collectors.toSet());
        for (String ite : objectSet) {
            if (this.getModel().getProperty(ite) == null) continue;
            this.getModel().setValue(ite, null);
        }
    }
}

