/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.amount.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.business.amount.control.feestandard.FeeStandardHelper;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleInfo;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.amount.control.AbstractFeeStandardControlFormPlugin;
import kd.fi.er.formplugin.daily.web.iface.ICurrencyCalculator;
import org.apache.commons.lang3.StringUtils;

public class FeeStandardControlFormPlugin
extends AbstractFeeStandardControlFormPlugin
implements ICloseCallBack,
ICurrencyCalculator {
    private static final String CLOSECONFIRM = "close";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("viewfeestand".equals(evt.getItemKey())) {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)1);
            paramMap.put("formId", "er_myfeestandard_sel");
            paramMap.put("needCallBack", true);
            ShowPageUtils.showWebModel((Map)paramMap, (AbstractFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if ("er_myfeestandard_sel".equals(closedCallBackEvent.getActionId()) && (returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectRows = (ListSelectedRowCollection)returnData;
            this.fastFillBill(selectRows.getPrimaryKeyValues());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.commonAfterCreateNewData();
        if (this.getOpenFeeStand().booleanValue()) {
            this.checkDimensionFields();
        }
    }

    private void checkDimensionFields() {
        ArrayList notExistField = Lists.newArrayListWithExpectedSize((int)4);
        List<String> curDimensions = this.getCurDimensions();
        for (String field : curDimensions) {
            if (this.getControl(field) != null) continue;
            notExistField.add(field);
        }
        if (!notExistField.isEmpty()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7684\u5206\u5f55\u5b57\u6bb5\u4e0e\u6807\u51c6\u7c7b\u578b\u7684\u4e1a\u52a1\u7ef4\u5ea6\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u201c%1s\u201d\u3002", (String)"FeeStandard_closetips", (String)"fi-er-formplugin", (Object[])new Object[0]), StringUtils.join((Iterable)notExistField, (String)"\u3001")), MessageBoxOptions.OK, new ConfirmCallBackListener(CLOSECONFIRM, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (CLOSECONFIRM.equals(messageBoxClosedEvent.getCallBackId())) {
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.commonAfterBindData();
        this.pageRules();
        BillSettingRuleUtil.setFormTitleForPC((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldNameForPC((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldHidden((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldMustInput((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldLock((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.initreimburselevel();
        this.refreshFeeStand();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BillSettingRuleUtil.setFieldLockByExprWhenPropertyChange((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView(), (String)propName, (int)rowIndex);
        if ("reimbursetype".equals(propName)) {
            this.changeBizItem(e);
        }
        if ("company".equals(propName)) {
            this.setOpenFeeStandNull();
            this.getModel().setValue("openfeestand", (Object)this.getOpenFeeStand());
            if (this.getOpenFeeStand().booleanValue()) {
                this.initreimburselevel();
                this.fireRefreshFeeStandard();
            } else {
                this.clearFeeStand();
                this.feeStandPageRules();
            }
            this.viewfeestandPageRules();
            BillSettingRuleUtil.setFieldLockByExprWhenPropertyChange((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView(), (String)propName, (int)rowIndex);
        } else if ("applier".equals(propName)) {
            this.initreimburselevel();
        } else if ("treatway".equals(propName)) {
            this.treatWayPageRule();
        } else if ("reimburselevel_bill".equals(propName)) {
            int entryRowCount = this.getModel().getEntryRowCount("expenseentryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("reimburselevel", e.getChangeSet()[0].getNewValue(), i);
            }
        } else if ("wineway".equals(propName) && (e.getChangeSet()[0].getNewValue() == null || StringUtils.isBlank((CharSequence)e.getChangeSet()[0].getNewValue().toString()))) {
            this.getModel().setValue("wineway", (Object)"3");
        } else if ("feestandcurrency".equals(propName)) {
            Object propNewValue = e.getChangeSet()[0].getNewValue();
            if (propNewValue != null) {
                this.refreshExchangeRate(this.getModel(), (DynamicObject)propNewValue, "feeexchangerate", "feequotetype", rowIndex);
            }
        } else if ("entrycurrency".equals(propName)) {
            Object propNewValue = e.getChangeSet()[0].getNewValue();
            if (propNewValue != null && !FeeStandardHelper.headCurrencyControl()) {
                this.getModel().setValue("feestandcurrency", propNewValue, rowIndex);
            }
        } else if ("feeexchangerate".equals(propName) || "controlamt".equals(propName) || "othercontrolamt".equals(propName)) {
            BigDecimal feeExchangeRate = (BigDecimal)this.getModel().getValue("feeexchangerate", e.getChangeSet()[0].getRowIndex());
            if (BigDecimal.ZERO.compareTo(feeExchangeRate) == 0) {
                this.getModel().setValue("feeexchangerate", (Object)BigDecimal.ONE, e.getChangeSet()[0].getRowIndex());
            }
            BigDecimal controlAmt = (BigDecimal)this.getModel().getValue("controlamt", e.getChangeSet()[0].getRowIndex());
            AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)controlAmt, (String)"curcontrolamt", (String)"feeexchangerate", (String)"feequotetype", (int)rowIndex);
            BigDecimal otherControlAmt = (BigDecimal)this.getModel().getValue("othercontrolamt", e.getChangeSet()[0].getRowIndex());
            AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)otherControlAmt, (String)"curothercontrolamt", (String)"feeexchangerate", (String)"feequotetype", (int)rowIndex);
        } else if ("otherfeeamount".equals(propName)) {
            BigDecimal otherFeeAmount = (BigDecimal)this.getModel().getValue("otherfeeamount", e.getChangeSet()[0].getRowIndex());
            AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)otherFeeAmount, (String)"curotherfeeamount", (String)"feeexchangerate", (String)"feequotetype", (int)rowIndex);
        }
        if (this.getOpenFeeStand().booleanValue()) {
            this.calcControlAmt(propName, rowIndex);
            if ("currency".equals(propName) || "expenseitem".equals(propName) || "feestandcurrency".equals(propName) || this.matchDimensions(propName, this.getCurDimensions())) {
                if (rowIndex != -1 && FeeStandardControlFormPlugin.headProp(this.getModel(), propName)) {
                    this.fireRefreshFeeStandard();
                } else {
                    this.fireRefreshFeeStandard(rowIndex);
                }
            } else if ("controlamt".equals(propName) || "curcontrolamt".equals(propName) || "othercontrolamt".equals(propName) || "curothercontrolamt".equals(propName) || "expeapproveamount".equals(propName) || "expeapprovecurramount".equals(propName) || "otherfeeamount".equals(propName) || "curotherfeeamount".equals(propName) || "otherstandamount".equals(propName) || "wineway".equals(propName)) {
                this.calcIsOverStd(rowIndex);
            } else if ("feestandid".equals(propName)) {
                this.calcOtherStandAmt(rowIndex);
                this.feeStandPageRules();
                this.headCurrencyControlPageRules();
            }
            if ("redml".equals(propName) || "whiteml".equals(propName)) {
                this.calcOtherStandAmt(rowIndex);
            }
        }
    }

    private void changeBizItem(PropertyChangedArgs e) {
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (("asset".equals(oldValue) || "asset".equals(newValue)) && newValue != null) {
            this.getModel().setValue("bizitem", (Object)FeeStandardHelper.queryBizItem((String)newValue.toString()));
        }
    }

    private void pageRules() {
        this.treatWayPageRule();
        this.feeStandPageRules();
        this.bizItemPanelPageRules();
        this.viewfeestandPageRules();
        this.headCurrencyControlPageRules();
    }

    private void headCurrencyControlPageRules() {
        if (FeeStandardHelper.headCurrencyControl()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"othercontrolamt", "otherfeeamount", "controlamt"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"feestandcurrency", "feeexchangerate", "curothercontrolamt", "curotherfeeamount", "curcontrolamt"});
        }
    }

    private void viewfeestandPageRules() {
        this.getView().setVisible(this.getOpenFeeStand(), new String[]{"viewfeestand"});
    }

    private void feeStandPageRules() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("expenseentryentity");
        boolean existOtherStand = false;
        for (DynamicObject entry : entryEntity) {
            DynamicObject feeStand = entry.getDynamicObject("feestandid");
            if (feeStand == null || !feeStand.getBoolean("otherstand")) continue;
            existOtherStand = true;
            break;
        }
        this.getView().setVisible(Boolean.valueOf(existOtherStand), new String[]{"otherstandarddesc", "wineway", "redml", "whiteml", FeeStandardHelper.getOtherControlAmtKey(), FeeStandardHelper.getOtherFeeAmtKey()});
    }

    private void treatWayPageRule() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("expenseentryentity");
        boolean existDays = "meetting".equals(this.getBizItem() == null ? "" : this.getBizItem().get("number"));
        boolean existGoods = false;
        for (DynamicObject entry : entryEntity) {
            Object treatway = entry.get("treatway");
            if (!existDays && "2".equals(treatway)) {
                existDays = true;
            }
            if (!existGoods && "3".equals(treatway)) {
                existGoods = true;
            }
            if (!existGoods || !existDays) continue;
            break;
        }
        this.getView().setVisible(Boolean.valueOf(existGoods), new String[]{"goodsnum"});
        if (!this.bizItemPanelVisible()) {
            this.getView().setVisible(Boolean.valueOf(existDays), new String[]{"daysnum"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"daysnum"});
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        this.commonCallBack(e);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.setDefaultReimburselevel(e);
        this.setDefaultFeeStandCurrency(e);
        BillSettingRuleUtil.setFieldLock((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }
}

