/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.amount.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;

public class FeeStandardFilterListPlugin
extends AbstractListPlugin {
    private static final String BIZITEM = "bizitem.number";
    private static final Log logger = LogFactory.getLog(FeeStandardFilterListPlugin.class);

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        List commonFilterColumns = e.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            List bizitemList;
            String fieldName = filterColumn.getFieldName();
            if (!BIZITEM.equals(fieldName)) continue;
            Collection bizitems = BusinessDataServiceHelper.loadFromCache((String)"er_standard_type", (QFilter[])new QFilter[]{new QFilter("number", "not in", (Object)new String[]{"asset", "expense", "otherexpenses"})}).values();
            Collection otherbizitems = BusinessDataServiceHelper.loadFromCache((String)"er_standard_type", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{"asset", "expense"})}).values();
            if (!otherbizitems.isEmpty() && (bizitemList = otherbizitems.stream().collect(Collectors.toList())) != null && bizitemList.size() > 0) {
                List bizitemIdList = bizitemList.stream().map(v -> String.valueOf(v.getPkValue())).collect(Collectors.toList());
                List comboItems = ((CommonBaseDataFilterColumn)filterColumn).getComboItems();
                if (comboItems != null && comboItems.size() > 0) {
                    ArrayList<ComboItem> newComboItems = new ArrayList<ComboItem>();
                    for (ComboItem comboItem : comboItems) {
                        if (bizitemIdList.contains(comboItem.getValue())) continue;
                        newComboItems.add(comboItem);
                    }
                    if (!newComboItems.isEmpty()) {
                        ((CommonBaseDataFilterColumn)filterColumn).setComboItems(newComboItems);
                    }
                }
            }
            if (bizitems.isEmpty() || (bizitemList = bizitems.stream().collect(Collectors.toList())) == null || bizitemList.size() <= 0) continue;
            filterColumn.setDefaultValues(bizitemList.stream().map(v -> String.valueOf(v.getPkValue())).collect(Collectors.toList()));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "quicknew": {
                FormModel fm = new FormModel("er_quickreimpc", ResManager.loadKDString((String)"\u9009\u62e9\u4e1a\u52a1\u4e8b\u9879", (String)"FeeStandardFilterListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "1");
                fm.setShowType(ShowType.MainNewTabPage);
                HashMap<String, String> customParam = new HashMap<String, String>();
                customParam.put("group", ((ListView)this.getView()).getListModel().getEntityId());
                fm.setCustomParam(customParam);
                ShowPageUtils.showPage((FormModel)fm, (AbstractFormPlugin)this);
                break;
            }
            case "quicknew_en": {
                this.quickNew("entertainment_bill");
                break;
            }
            case "quicknew_meet": {
                this.quickNew("meetting_bill");
                break;
            }
            case "quicknew_en_entry": {
                this.quickNew("entertainment");
                break;
            }
            case "quicknew_meet_entry": {
                this.quickNew("meetting");
                break;
            }
        }
    }

    private void quickNew(String bizitem) {
        FormModel formModel = new FormModel(((ListView)this.getView()).getListModel().getEntityId(), null, "2");
        formModel.setShowType(ShowType.MainNewTabPage);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bizitem", bizitem);
        formModel.setCustomParam(params);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }
}

