/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.amount.control;

import java.math.BigDecimal;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class NewTripReimAmountControlPCFormPlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(NewTripReimAmountControlPCFormPlugin.class);
    protected static final String[] reimburseControlRelativeFields = new String[]{"org", "company", "applier", "headhappendate", "headexpenseitem", "travelexpenseitem", "entrycurrency", "travelcostdept", "travelhappendate", "travelquotactldept", "trip2travelers"};

    public void registerListener(EventObject e) {
        this.addTravelersF7BeforeFilter();
        this.addEntryRowClick();
    }

    private void addEntryRowClick() {
        EntryGrid expenseEntry = (EntryGrid)this.getControl("entryentity");
        if (expenseEntry == null) {
            return;
        }
        expenseEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                NewTripReimAmountControlPCFormPlugin.this.showHeadBalanceAmount();
            }
        });
    }

    private void addTravelersF7BeforeFilter() {
        MulBasedataEdit applierF7 = (MulBasedataEdit)this.getControl("trip2travelers");
        applierF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String isreimburseamountctl;
            int tripRowCount = this.getModel().getEntryRowCount("tripentry");
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            if (tripRowCount < 1 || entryRowCount < 1) {
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (entryCurrentRowIndex < 0) {
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject travelexpenseitem = (DynamicObject)this.getModel().getValue("travelexpenseitem", entryCurrentRowIndex, 0);
            if (travelexpenseitem != null && "1".equals(isreimburseamountctl = travelexpenseitem.getString("isreimburseamountctl"))) {
                listShowParameter.setMultiSelect(false);
            }
        });
    }

    public void afterBindData(EventObject e) {
        QuotaCtrlUtil.setHappenDateSelectedRange((IDataModel)this.getModel(), (DateEdit[])new DateEdit[]{(DateEdit)this.getControl("headhappendate"), (DateEdit)this.getControl("travelhappendate")});
        this.setExpBalanceFieldVisible();
        this.showExpenseBalanceAmount();
        this.showHeadBalanceAmount();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowindex = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "travelexpenseitem": {
                if (newValue == null) {
                    return;
                }
                DynamicObject travelexpenseitem = (DynamicObject)newValue;
                String isreimburseamountctl = travelexpenseitem.getString("isreimburseamountctl");
                if (!"1".equals(isreimburseamountctl)) break;
                int tripRowIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
                DynamicObjectCollection trip2travelers = (DynamicObjectCollection)this.getModel().getValue("trip2travelers", rowindex, tripRowIndex);
                if (trip2travelers.size() <= 1) break;
                DynamicObject applierOb = (DynamicObject)this.getModel().getValue("applier");
                Long pkid = (Long)applierOb.getPkValue();
                Long[] applierIds = new Long[]{pkid};
                this.getModel().setValue("trip2travelers", (Object)applierIds, rowindex, tripRowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u51fa\u5dee\u4eba\u7684\u4e2a\u4eba\u989d\u5ea6\u63a7\u5236\uff0c\u51fa\u5dee\u4eba\u5df2\u91cd\u7f6e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u4e2a\u51fa\u5dee\u4eba\u3002", (String)"NewTripReimAmountControlPCFormPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
            case "ismultiexpitem": {
                this.setExpBalanceFieldVisible();
                break;
            }
            case "company": {
                this.getPageCache().remove("empCltBill");
                this.getPageCache().remove("deptCltBill");
                this.getPageCache().remove("getIsEnableContrl");
                this.setExpBalanceFieldVisible();
                break;
            }
        }
        if (Arrays.asList(reimburseControlRelativeFields).contains(propName) || StringUtils.equals((CharSequence)ReimburseControlUtils.getPersonReimCtlCompanyField(), (CharSequence)propName)) {
            this.showExpenseBalanceAmount();
            this.showHeadBalanceAmount();
        }
    }

    private void showExpenseBalanceAmount() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection tripentries = dataEntity.getDynamicObjectCollection("tripentry");
        if (tripentries == null || tripentries.isEmpty()) {
            return;
        }
        boolean ischange = this.getModel().getDataChanged();
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (billstatus != null && !Arrays.asList("A", "D", "B", "C").contains(billstatus)) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        if (!this.getIsEnableContrl().booleanValue()) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        DynamicObject amountControlCompanyDO = ReimburseControlUtils.getReimburseControlCompany((DynamicObject)this.getModel().getDataEntity(true));
        if (amountControlCompanyDO == null) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        Long companyId = ErCommonUtils.getPk((Object)company);
        List<String> empCltList = this.getEmpCltBill();
        List<String> deptCltList = this.getDeptCltBill();
        if (!empCltList.contains("2") && !deptCltList.contains("2")) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        String personCtrlCurrency = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"personctlcurrency");
        String deptCtrlCurrency = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"deptctlcurrency");
        for (int i = 0; i < tripentries.size(); ++i) {
            DynamicObject entryentity = (DynamicObject)tripentries.get(i);
            DynamicObjectCollection travelEntries = entryentity.getDynamicObjectCollection("entryentity");
            if (travelEntries == null || travelEntries.isEmpty()) continue;
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            Long currencyId = currency == null ? Long.valueOf(0L) : (Long)currency.getPkValue();
            for (int j = 0; j < travelEntries.size(); ++j) {
                DynamicObject travelEntry = (DynamicObject)travelEntries.get(j);
                if (!this.validTravelRow(travelEntry)) {
                    model.setValue("travelbalanceamount", (Object)"--", j, i);
                    continue;
                }
                QuotaAmountBO reimAmountBO = new QuotaAmountBO();
                reimAmountBO.setCompanyId((Long)amountControlCompanyDO.getPkValue());
                reimAmountBO.setEmpCtlBill(empCltList);
                reimAmountBO.setDeptCtlBill(deptCltList);
                DynamicObject travelexpenseitem = travelEntry.getDynamicObject("travelexpenseitem");
                reimAmountBO.setExpenseItemId((Long)travelexpenseitem.getPkValue());
                reimAmountBO.setCtrlCount(Integer.valueOf(travelexpenseitem.getInt("reimburseamountctlcount")));
                reimAmountBO.setCtrlMethod(travelexpenseitem.getString("reimburseamountctlmethod"));
                reimAmountBO.setCtrlType(travelexpenseitem.getString("reimctltype"));
                String isreimburseamountctl = travelexpenseitem.getString("isreimburseamountctl");
                reimAmountBO.setCtrlMode(isreimburseamountctl);
                Long oriCurrencyId = (Long)travelEntry.getDynamicObject("entrycurrency").getPkValue();
                if ("1".equals(isreimburseamountctl)) {
                    reimAmountBO.setUserOrDeptId((Long)((DynamicObject)travelEntry.getDynamicObjectCollection("trip2travelers").get(0)).get("fbasedataid.id"));
                    QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)personCtrlCurrency, (Long)oriCurrencyId, (Long)currencyId);
                } else if ("2".equals(isreimburseamountctl)) {
                    reimAmountBO.setUserOrDeptId((Long)travelEntry.getDynamicObject("travelquotactldept").getPkValue());
                    QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)deptCtrlCurrency, (Long)oriCurrencyId, (Long)currencyId);
                }
                Date date = travelEntry.getDate("travelhappendate");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                reimAmountBO.setHappenDate(YearMonth.of(calendar.get(1), calendar.get(2) + 1));
                boolean isAduit = false;
                if (Arrays.asList("B", "C").contains(billstatus)) {
                    isAduit = true;
                }
                ArrayList<Long> excludeReimbureBillIds = new ArrayList<Long>();
                if (isAduit) {
                    excludeReimbureBillIds.add((Long)model.getDataEntity().getPkValue());
                    log.info("\u662f\u5ba1\u6838\u72b6\u6001, \u6392\u9664\u7684\u5355\u636e\u4e3a: " + excludeReimbureBillIds);
                }
                reimAmountBO.setNotInIds(excludeReimbureBillIds);
                QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBO);
                BigDecimal balanceAmount = quotaCtrlMode.getBalanceAmount(reimAmountBO);
                if ("2".equals(reimAmountBO.getCtrlType()) && balanceAmount == null) {
                    model.setValue("travelbalanceamount", (Object)"--", j, i);
                    continue;
                }
                if (balanceAmount == null) {
                    balanceAmount = BigDecimal.ZERO;
                }
                String balanceAmountStr = ErCommonUtils.getMoneyStringWithSymbol((BigDecimal)balanceAmount, (CurrencyBO)new CurrencyBO(reimAmountBO.getCurrencyId()));
                model.setValue("travelbalanceamount", (Object)balanceAmountStr, j, i);
            }
        }
        this.getModel().setDataChanged(ischange);
    }

    private boolean validTravelRow(DynamicObject travelEntity) {
        boolean on;
        DynamicObject travelexpenseitem = travelEntity.getDynamicObject("travelexpenseitem");
        boolean bl = on = travelexpenseitem != null && travelEntity.getDynamicObject("entrycurrency") != null && travelEntity.getDate("travelhappendate") != null;
        if (!on) {
            return false;
        }
        String isreimburseamountctl = travelexpenseitem.getString("isreimburseamountctl");
        if ("1".equals(isreimburseamountctl)) {
            DynamicObjectCollection travelers = travelEntity.getDynamicObjectCollection("trip2travelers");
            if (travelers == null || travelers.size() != 1) {
                return false;
            }
            Long trip2travelers = (Long)((DynamicObject)travelers.get(0)).get("fbasedataid.id");
            if (trip2travelers == null) {
                return false;
            }
        } else if ("2".equals(isreimburseamountctl)) {
            DynamicObject travelquotactldept = travelEntity.getDynamicObject("travelquotactldept");
            if (travelquotactldept == null) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void setBalanceAmountDefaultValue() {
        boolean ischange = this.getModel().getDataChanged();
        DynamicObjectCollection tripEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        if (tripEntrys != null && tripEntrys.size() > 0) {
            for (int i = 0; i < tripEntrys.size(); ++i) {
                DynamicObject tripEntry = (DynamicObject)tripEntrys.get(i);
                DynamicObjectCollection entryEntrys = tripEntry.getDynamicObjectCollection("entryentity");
                if (entryEntrys == null || entryEntrys.size() <= 0) continue;
                for (int j = 0; j < entryEntrys.size(); ++j) {
                    this.getModel().setValue("travelbalanceamount", (Object)"--", j, i);
                }
            }
        }
        this.getModel().setDataChanged(ischange);
    }

    private void showHeadBalanceAmount() {
        int entryRowCouont = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCouont > 0) {
            int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String balanceamount = (String)this.getModel().getValue("travelbalanceamount", currentIndex, 0);
            Label lab_headbalanceamount = (Label)this.getView().getControl("lab_headbalanceamount");
            if (lab_headbalanceamount == null) {
                return;
            }
            lab_headbalanceamount.setText("");
            if (StringUtils.isBlank((CharSequence)balanceamount) || "--".equals(balanceamount)) {
                return;
            }
            lab_headbalanceamount.setText(String.format(ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d %s", (String)"NewTripReimAmountControlPCFormPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), balanceamount));
            this.getView().setVisible(Boolean.TRUE, new String[]{"lab_headbalanceamount", "flex_balanceamount"});
        }
    }

    private List<String> getEmpCltBill() {
        String pageEmpCltBill = this.getPageCache().get("empCltBill");
        if (StringUtils.isNotBlank((CharSequence)pageEmpCltBill)) {
            List<String> empCltList = Arrays.asList(pageEmpCltBill.split(","));
            return empCltList;
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            return new ArrayList<String>();
        }
        String empCltBill = (String)ErCommonUtils.getEMParameter((long)((Long)company.getPkValue()), (String)"empquotaapplicablebill");
        this.getPageCache().put("empCltBill", empCltBill);
        return Arrays.asList(empCltBill.split(","));
    }

    private List<String> getDeptCltBill() {
        String pageDeptCltBill = this.getPageCache().get("deptCltBill");
        if (StringUtils.isNotBlank((CharSequence)pageDeptCltBill)) {
            List<String> deptCltList = Arrays.asList(pageDeptCltBill.split(","));
            return deptCltList;
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            return new ArrayList<String>();
        }
        String deptCltBill = (String)ErCommonUtils.getEMParameter((long)((Long)company.getPkValue()), (String)"deptquotaapplicablebill");
        this.getPageCache().put("deptCltBill", deptCltBill);
        return Arrays.asList(deptCltBill.split(","));
    }

    private Boolean getIsEnableContrl() {
        String isEnableContrl = this.getPageCache().get("getIsEnableContrl");
        if (StringUtils.isNotBlank((CharSequence)isEnableContrl)) {
            return Boolean.valueOf(isEnableContrl);
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            return Boolean.FALSE;
        }
        boolean isEnable = SystemParamterUtil.isEnableReimburseControlByCompany((Long)((Long)company.getPkValue()));
        this.getPageCache().put("getIsEnableContrl", String.valueOf(isEnable));
        return isEnable;
    }

    private void setExpBalanceFieldVisible() {
        Boolean ismulit = (Boolean)this.getModel().getValue("ismultiexpitem");
        Boolean isEnableContrl = this.getIsEnableContrl();
        boolean isContainsTripReim = this.getEmpCltBill().contains("2") || this.getDeptCltBill().contains("2");
        String billstatus = (String)this.getModel().getValue("billstatus");
        boolean isEnableStatus = Arrays.asList("A", "D", "B", "C").contains(billstatus);
        if (isEnableContrl.booleanValue() && isContainsTripReim && isEnableStatus) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"travelbalanceamount"});
            if (ismulit.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"travelhappendate"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"travelhappendate"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"travelbalanceamount", "travelhappendate"});
        }
    }
}

