/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.amount.control;

import java.math.BigDecimal;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;

public class TripReimAmountControlPCEntryFormPlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(TripReimAmountControlPCEntryFormPlugin.class);
    protected static final String[] reimburseControlRelativeFields = new String[]{"tripexpenseitem", "triphappendate", "tripcurrency", "travelers", "entrycostdept"};

    private boolean isTripReimBill() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return false;
        }
        return ErEntityTypeUtils.isTripReimburseBill((String)parentView.getEntityId());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (!this.isTripReimBill()) {
            return;
        }
        this.addTravelersF7BeforeFilter();
    }

    private void addTravelersF7BeforeFilter() {
        MulBasedataEdit applierF7 = (MulBasedataEdit)this.getControl("travelers");
        if (applierF7 != null) {
            applierF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                String isreimburseamountctl;
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject tripexpenseitem = (DynamicObject)this.getEntryValue("tripexpenseitem");
                if (tripexpenseitem != null && "1".equals(isreimburseamountctl = tripexpenseitem.getString("isreimburseamountctl"))) {
                    listShowParameter.setMultiSelect(false);
                }
            });
        }
    }

    public void afterBindData(EventObject e) {
        if (!this.isTripReimBill()) {
            return;
        }
        IDataModel parentModel = this.getView().getParentView().getModel();
        QuotaCtrlUtil.setHappenDateSelectedRange((IDataModel)parentModel, (DateEdit[])new DateEdit[]{(DateEdit)this.getControl("triphappendate")});
        this.showExpenseBalanceAmount();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        if (!this.isTripReimBill()) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName = e.getProperty().getName()) {
            case "tripexpenseitem": {
                DynamicObjectCollection travelers;
                if (propValue == null) {
                    return;
                }
                DynamicObject tripexpenseitem = (DynamicObject)propValue;
                String isreimburseamountctl = tripexpenseitem.getString("isreimburseamountctl");
                if (!"1".equals(isreimburseamountctl) || (travelers = (DynamicObjectCollection)this.getEntryValue("travelers")).size() <= 1) break;
                DynamicObject applierOb = (DynamicObject)this.getView().getParentView().getModel().getValue("applier");
                Long pkid = (Long)applierOb.getPkValue();
                Long[] applierIds = new Long[]{pkid};
                this.getModel().setValue("travelers", (Object)applierIds, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u51fa\u5dee\u4eba\u7684\u4e2a\u4eba\u989d\u5ea6\u63a7\u5236\uff0c\u51fa\u5dee\u4eba\u5df2\u91cd\u7f6e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u4e2a\u51fa\u5dee\u4eba\u3002", (String)"TripReimAmountControlPCEntryFormPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
            case "triphappendate": {
                IDataModel parentModel = this.getView().getParentView().getModel();
                break;
            }
        }
        if (Arrays.asList(reimburseControlRelativeFields).contains(propName)) {
            this.showExpenseBalanceAmount();
        }
    }

    private void showExpenseBalanceAmount() {
        Long currencyId;
        if (this.getEntryValue("tripcurrency") == null) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        DynamicObject company = (DynamicObject)this.getHeadValue("company");
        if (company == null) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        String billstatus = (String)this.getHeadValue("billstatus");
        if (billstatus != null && !Arrays.asList("A", "D", "B", "C").contains(billstatus)) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        Date triphappendate = (Date)this.getEntryValue("triphappendate");
        if (triphappendate == null) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        DynamicObject expenseitem = (DynamicObject)this.getEntryValue("tripexpenseitem");
        if (expenseitem == null) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        String isreimburseamountctl = expenseitem.getString("isreimburseamountctl");
        if ("0".equals(isreimburseamountctl) || "3".equals(isreimburseamountctl)) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        if ("1".equals(isreimburseamountctl)) {
            DynamicObjectCollection travelers = (DynamicObjectCollection)this.getEntryValue("travelers");
            if (travelers == null || travelers.size() != 1) {
                this.setBalanceAmountDefaultValue();
                return;
            }
            Long trip2travelers = (Long)((DynamicObject)travelers.get(0)).get("fbasedataid.id");
            if (trip2travelers == null) {
                this.setBalanceAmountDefaultValue();
                return;
            }
        }
        if (!SystemParamterUtil.isEnableReimburseControlByCompany((Long)ErCommonUtils.getPk((Object)company))) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        DynamicObject amountControlCompanyDO = ReimburseControlUtils.getReimburseControlCompany((DynamicObject)this.getView().getParentView().getModel().getDataEntity(true));
        if (amountControlCompanyDO == null) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        List empCltList = SystemParamterUtil.getEmpCltBillList((Long)ErCommonUtils.getPk((Object)company));
        List deptCltList = SystemParamterUtil.getDeptCltBillList((Long)ErCommonUtils.getPk((Object)company));
        if (!empCltList.contains("2") && !deptCltList.contains("2")) {
            this.setBalanceAmountDefaultValue();
            return;
        }
        QuotaAmountBO reimAmountBO = new QuotaAmountBO();
        reimAmountBO.setCompanyId((Long)amountControlCompanyDO.getPkValue());
        reimAmountBO.setEmpCtlBill(empCltList);
        reimAmountBO.setDeptCtlBill(deptCltList);
        reimAmountBO.setExpenseItemId((Long)expenseitem.getPkValue());
        reimAmountBO.setCtrlCount(Integer.valueOf(expenseitem.getInt("reimburseamountctlcount")));
        reimAmountBO.setCtrlMethod(expenseitem.getString("reimburseamountctlmethod"));
        reimAmountBO.setCtrlType(expenseitem.getString("reimctltype"));
        reimAmountBO.setCtrlMode(isreimburseamountctl);
        DynamicObject tripcurrency = (DynamicObject)this.getEntryValue("tripcurrency");
        Long tripcurrencyId = tripcurrency == null ? Long.valueOf(0L) : (Long)tripcurrency.getPkValue();
        DynamicObject currency = (DynamicObject)this.getHeadValue("currency");
        Long l = currencyId = currency == null ? Long.valueOf(0L) : (Long)currency.getPkValue();
        if ("1".equals(isreimburseamountctl)) {
            DynamicObjectCollection travelers = (DynamicObjectCollection)this.getEntryValue("travelers");
            Long travelerId = (Long)((DynamicObject)travelers.get(0)).get("fbasedataid.id");
            reimAmountBO.setUserOrDeptId(travelerId);
            String personCtrlCurrency = SystemParamterUtil.getPersonCtlCurrency((Long)ErCommonUtils.getPk((Object)company));
            QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)personCtrlCurrency, (Long)tripcurrencyId, (Long)currencyId);
        } else if ("2".equals(isreimburseamountctl)) {
            DynamicObject costDept = (DynamicObject)this.getEntryValue("entrycostdept");
            Long quotaCtrlDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)expenseitem, (DynamicObject)costDept, (IDataModel)this.getView().getParentView().getModel());
            reimAmountBO.setUserOrDeptId(quotaCtrlDeptId);
            String deptCtrlCurrency = SystemParamterUtil.getDeptCtlCurrency((Long)ErCommonUtils.getPk((Object)company));
            QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)deptCtrlCurrency, (Long)tripcurrencyId, (Long)currencyId);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(triphappendate);
        reimAmountBO.setHappenDate(YearMonth.of(calendar.get(1), calendar.get(2) + 1));
        boolean isAduit = false;
        if (Arrays.asList("B", "C").contains(billstatus)) {
            isAduit = true;
        }
        ArrayList<Long> excludeReimbureBillIds = new ArrayList<Long>();
        if (isAduit) {
            excludeReimbureBillIds.add((Long)this.getView().getParentView().getModel().getDataEntity().getPkValue());
            log.info("\u662f\u5ba1\u6838\u72b6\u6001, \u6392\u9664\u7684\u5355\u636e\u4e3a: " + excludeReimbureBillIds);
        }
        reimAmountBO.setNotInIds(excludeReimbureBillIds);
        QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBO);
        BigDecimal balanceAmount = quotaCtrlMode.getBalanceAmount(reimAmountBO);
        if ("2".equals(reimAmountBO.getCtrlType()) && balanceAmount == null) {
            this.setBalanceAmountDefaultValue();
        }
        if (balanceAmount == null) {
            balanceAmount = BigDecimal.ZERO;
        }
        String balanceAmountStr = ErCommonUtils.getMoneyStringWithSymbol((BigDecimal)balanceAmount, (CurrencyBO)new CurrencyBO(reimAmountBO.getCurrencyId()));
        boolean ischange = this.getModel().getDataChanged();
        this.getModel().setValue("tripbalanceamount", (Object)balanceAmountStr);
        if (this.getView() instanceof IMobileView) {
            this.getView().updateView("tripbalanceamount", 0);
        } else {
            this.getView().updateView("tripbalanceamount");
        }
        this.getModel().setDataChanged(ischange);
    }

    private void setBalanceAmountDefaultValue() {
        boolean ischange = this.getModel().getDataChanged();
        this.getModel().setValue("tripbalanceamount", (Object)"--");
        if (this.getView() instanceof IMobileView) {
            this.getView().updateView("tripbalanceamount", 0);
        } else {
            this.getView().updateView("tripbalanceamount");
        }
        this.getModel().setDataChanged(ischange);
    }

    private Object getEntryValue(String propName) {
        IFormView view = this.getView();
        if (view instanceof IMobileView) {
            return this.getModel().getValue(propName, 0);
        }
        return this.getModel().getValue(propName);
    }

    private Object getHeadValue(String propName) {
        return this.getView().getParentView().getModel().getValue(propName);
    }
}

