/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.amount.control.mob;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleInfo;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.amount.control.AbstractFeeStandardControlFormPlugin;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.web.iface.ICurrencyCalculator;

public class FeeStandardControlFormPluginFirstPageMob
extends AbstractFeeStandardControlFormPlugin
implements ICurrencyCalculator {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"viewfeestand"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        if ("viewfeestand".equals(((Control)evt.getSource()).getKey())) {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)1);
            paramMap.put("formId", "er_myfeestand_mbsel");
            paramMap.put("needCallBack", true);
            ShowPageUtils.showMobileForm((Map)paramMap, (AbstractFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if ("er_myfeestand_mbsel".equals(closedCallBackEvent.getActionId()) && (returnData = closedCallBackEvent.getReturnData()) instanceof Object[]) {
            Object[] feeStandPks = (Object[])returnData;
            boolean triggerPageRule = false;
            if (this.getModel().getEntryRowCount("expenseentryentity") == 0) {
                triggerPageRule = true;
            }
            this.fastFillBill(feeStandPks);
            if (triggerPageRule) {
                CommonViewControlUtil.expensePageRules(this.getModel(), this.getView());
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.commonAfterCreateNewData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.commonAfterBindData();
        BillSettingRuleUtil.setFormTitleForMob((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldNameForMob((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldMustInput((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldLock((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldHidden((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        this.bizItemPanelPageRules();
        this.viewfeestandPageRules();
    }

    private void viewfeestandPageRules() {
        this.getView().setVisible(this.getOpenFeeStand(), new String[]{"viewfeestand", "bizitemtitle"});
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.refreshFeeStand();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BillSettingRuleUtil.setFieldLockByExprWhenPropertyChange((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView(), (String)propName, (int)rowIndex);
        if ("company".equals(propName)) {
            this.setOpenFeeStandNull();
            this.getModel().setValue("openfeestand", (Object)this.getOpenFeeStand());
            if (this.getOpenFeeStand().booleanValue()) {
                this.initreimburselevel();
                this.fireRefreshFeeStandard();
            } else {
                this.clearFeeStand();
            }
            this.viewfeestandPageRules();
            BillSettingRuleUtil.setFieldLockByExprWhenPropertyChange((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView(), (String)propName, (int)rowIndex);
        } else if ("applier".equals(propName)) {
            this.initreimburselevel();
        } else if ("reimburselevel_bill".equals(propName)) {
            int entryRowCount = this.getModel().getEntryRowCount("expenseentryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("reimburselevel", e.getChangeSet()[0].getNewValue(), i);
            }
        } else if ("feestandcurrency".equals(propName)) {
            Object propNewValue = e.getChangeSet()[0].getNewValue();
            if (propNewValue != null) {
                this.refreshExchangeRate(this.getModel(), (DynamicObject)propNewValue, "feeexchangerate", "feequotetype", rowIndex);
            }
        } else if ("entrycurrency".equals(propName)) {
            Object propNewValue = e.getChangeSet()[0].getNewValue();
            if (propNewValue != null) {
                this.refreshExchangeRate(this.getModel(), (DynamicObject)propNewValue, "exchangerate", "expquotetype", rowIndex);
            }
        } else if ("feeexchangerate".equals(propName) || "controlamt".equals(propName) || "othercontrolamt".equals(propName)) {
            BigDecimal controlAmt = (BigDecimal)this.getModel().getValue("controlamt", e.getChangeSet()[0].getRowIndex());
            AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)controlAmt, (String)"curcontrolamt", (String)"feeexchangerate", (String)"feequotetype", (int)rowIndex);
            BigDecimal otherControlAmt = (BigDecimal)this.getModel().getValue("othercontrolamt", e.getChangeSet()[0].getRowIndex());
            AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)otherControlAmt, (String)"curothercontrolamt", (String)"feeexchangerate", (String)"feequotetype", (int)rowIndex);
        }
        if (this.getOpenFeeStand().booleanValue()) {
            this.calcControlAmt(propName, rowIndex);
            if ("controlamt".equals(propName) || "curcontrolamt".equals(propName) || "othercontrolamt".equals(propName) || "curothercontrolamt".equals(propName) || "expeapproveamount".equals(propName) || "expeapprovecurramount".equals(propName) || "otherfeeamount".equals(propName) || "curotherfeeamount".equals(propName) || "otherstandamount".equals(propName) || "wineway".equals(propName)) {
                this.calcIsOverStd(rowIndex);
            } else if ("reimburselevel".equals(propName) || "currency".equals(propName) || this.matchDimensions(propName, this.getCurDimensions())) {
                if (rowIndex != -1 && FeeStandardControlFormPluginFirstPageMob.headProp(this.getModel(), propName)) {
                    this.fireRefreshFeeStandard();
                } else {
                    this.fireRefreshFeeStandard(rowIndex);
                }
            } else if ("feestandid".equals(propName)) {
                this.calcOtherStandAmt(rowIndex);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.setDefaultReimburselevel(e);
        this.setDefaultFeeStandCurrency(e);
        this.setEntryCostOrg(e);
    }

    private void setEntryCostOrg(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        IDataModel model = this.getModel();
        String entryName = e.getEntryProp().getName();
        if ("expenseentryentity".equals(entryName) && (rowDataEntities = e.getRowDataEntities()).length > 0) {
            DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
            DynamicObject costDept = (DynamicObject)model.getValue("costdept");
            DynamicObject costCenter = (DynamicObject)model.getValue("std_costcenter");
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                model.beginInit();
                String centerKey = "std_entrycostcenter";
                if (model.getProperty(centerKey) == null) {
                    centerKey = "entrycostcenter";
                }
                model.setValue("entrycostcompany", costCompany == null ? null : costCompany.getPkValue(), rowIndex);
                model.setValue("entrycostdept", costDept == null ? null : costDept.getPkValue(), rowIndex);
                model.setValue(centerKey, costCenter == null ? null : costCenter.getPkValue(), rowIndex);
                model.endInit();
                this.getView().updateView("entrycostcompany", rowIndex);
                this.getView().updateView("entrycostdept", rowIndex);
                this.getView().updateView(centerKey, rowIndex);
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        this.commonCallBack(e);
    }
}

