/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.billingpool;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.billingpool.IBillingPoolPlugin;
import kd.fi.er.formplugin.billingpool.ViewVoucherUtil;
import org.apache.commons.lang3.StringUtils;

public class BillingPoolListPlugin
extends StandardTreeListPlugin
implements TreeNodeClickListener,
IBillingPoolPlugin {
    private static final String KEY_TREEBUTTONPANEL = "flexpanel_treebtn";
    private static final String UNAUDIT = "tblunaudit";
    private static final String ADDGENERIC = "addgeneric";
    private static final String LAYOUT_BILLING_POOL = "er_common_billingpool";
    private static final String DB_BILLTYPE = "bos_billtype";
    private static final String DB_BILLINGPOOL_TYPE = "er_bd_billingpool_type";
    private static final String NOT_NULL = "is not null";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.itemClick((ItemClickEvent)evt);
        switch (itemKey = evt.getItemKey()) {
            case "tblunaudit": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                if (!CollectionUtils.isEmpty((Collection)selectedRows) && selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6279\u91cf\u53cd\u5ba1\u6838\u3002", (String)"BillPoolListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
                if (CollectionUtils.isEmpty((Collection)selectedRows) || selectedRows.size() != 1) break;
                Object pk = selectedRows.get(0).getPrimaryKeyValue();
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"er_billingpool");
                this.unAudit(bill, this.getView(), evt);
                break;
            }
            case "addgeneric": {
                String nodeId = this.getTreeModel().getCurrentNodeId().toString();
                if (!StringUtils.isBlank((CharSequence)nodeId) && !this.getTreeModel().getRoot().getId().equals(nodeId)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d26\u5355\u7c7b\u578b\u3002", (String)"BillPoolPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        BillShowParameter showParameter = new BillShowParameter();
        DynamicObject layout = null;
        String formId = "er_billingpool";
        Map customParam = showParameter.getCustomParams();
        switch (key) {
            case "addother": 
            case "addgeneric": {
                String nodeId = this.getTreeModel().getCurrentNodeId().toString();
                TreeNode root = this.getTreeModel().getRoot();
                Set<Long> ids = BillingPoolListPlugin.findDescendantIds(root, nodeId);
                customParam.put("billpooltype", ids.stream().findFirst().orElse(null));
            }
            case "addtransportat": {
                formId = LAYOUT_BILLING_POOL;
                customParam.put("actionType", key);
            }
            case "addvat": 
            case "addvehicle": 
            case "addproforma": {
                layout = this.getLayoutSolution(key.replace("add", "").toUpperCase());
                break;
            }
            default: {
                return;
            }
        }
        if (null != layout) {
            showParameter.setBillTypeId(ErCommonUtils.getPk((Object)layout).toString());
        }
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        Object pkValue = currentRow.getPrimaryKeyValue();
        String fieldName = args.getFieldName();
        if (fieldName.equals("billno")) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(LAYOUT_BILLING_POOL);
            parameter.setPkId(currentRow.getPrimaryKeyValue());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)parameter);
            args.setCancel(true);
        } else if (fieldName.equals("voucherno")) {
            QFilter filter = new QFilter("id", "=", pkValue);
            DynamicObjectCollection voucherInfo = QueryServiceHelper.query((String)"er_billingpool", (String)"voucherentity.voucherid voucherid", (QFilter[])filter.toArray());
            Set<Long> voucherIds = voucherInfo.stream().map(v -> v.getLong("voucherid")).collect(Collectors.toSet());
            ViewVoucherUtil.showBizVoucherPage(this.getView(), voucherIds);
            args.setCancel(true);
        } else if (fieldName.equals("relbill")) {
            this.trackDown(this.getView(), pkValue);
            args.setCancel(true);
        }
    }

    private void trackDown(IFormView view, Object billId) {
        String entityId;
        QFilter filter = new QFilter("id", "=", billId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"er_billingpool", (String)"voucherentity.relbillid relbillid, voucherentity.entityid entityid", (QFilter[])filter.toArray());
        HashMap<String, Set> map = new HashMap<String, Set>(1);
        for (DynamicObject row : collection) {
            entityId = row.getString("entityid");
            Long relBillId = row.getLong("relbillid");
            if (entityId == null || entityId.length() == 0 || relBillId == null || relBillId == 0L) continue;
            Set billIds = map.getOrDefault(entityId, new HashSet(1));
            billIds.add(relBillId);
            map.put(entityId, billIds);
        }
        for (Map.Entry entry : map.entrySet()) {
            BillShowParameter parameter;
            Set ids;
            entityId = (String)entry.getKey();
            String metaDataId = MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Form);
            if (metaDataId == null || metaDataId.length() <= 0 || (ids = (Set)entry.getValue()).size() <= 0) continue;
            if (ids.size() == 1) {
                parameter = new BillShowParameter();
                parameter.setPkId(ids.iterator().next());
                parameter.setFormId(entityId);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setStatus(OperationStatus.VIEW);
                parameter.setHasRight(true);
                view.showForm((FormShowParameter)parameter);
                continue;
            }
            parameter = new ListShowParameter();
            parameter.setBillFormId(entityId);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setShowFilter(false);
            parameter.setShowQuickFilter(false);
            for (Long pkid : ids) {
                parameter.addLinkQueryPkId((Object)pkid);
            }
            view.showForm((FormShowParameter)parameter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List columnList = args.getCommonFilterColumns();
        Optional<FilterColumn> costCompany = columnList.stream().filter(filterColumn -> filterColumn.getFieldName().equals("costcompany.id")).findFirst();
        costCompany.ifPresent(item -> {
            CommonFilterColumn companyItemFilter = (CommonFilterColumn)item;
            List comboItems = companyItemFilter.getComboItems();
            if (CollectionUtils.isNotEmpty((Collection)comboItems)) {
                long orgId = RequestContext.get().getOrgId();
                List values = comboItems.stream().map(ComboItem::getValue).collect(Collectors.toList());
                if (orgId != 0L && values.contains(String.valueOf(orgId))) {
                    item.setDefaultValue(String.valueOf(orgId));
                } else {
                    item.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
                }
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        String init_form;
        List filters = e.getQFilters();
        if (CollectionUtils.isNotEmpty((Collection)filters)) {
            Optional<QFilter> invoiceNoFilter = filters.stream().filter(item -> "invoiceno".equals(item.getProperty())).findFirst();
            Optional<QFilter> invoiceCodeFilter = filters.stream().filter(item -> "invoicecode".equals(item.getProperty())).findFirst();
            invoiceNoFilter.ifPresent(item -> {
                if (QEmptyValue.value.equals(item.getValue())) {
                    item.or(new QFilter("invoiceno", "=", (Object)"-"));
                }
                if (NOT_NULL.equals(item.getCP())) {
                    item.and(new QFilter("invoiceno", "!=", (Object)"-"));
                }
            });
            invoiceCodeFilter.ifPresent(item -> {
                if (QEmptyValue.value.equals(item.getValue())) {
                    item.or(new QFilter("invoicecode", "=", (Object)"-"));
                }
                if (NOT_NULL.equals(item.getCP())) {
                    item.and(new QFilter("invoicecode", "!=", (Object)"-"));
                }
            });
        }
        if ("er_billingpoolinit".equals(init_form = ((IListView)this.getView()).getBillFormId())) {
            filters.add(new QFilter("invoicefrom", "=", (Object)"6"));
        }
        super.setFilter(e);
        String nodeId = this.getTreeModel().getCurrentNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        if (this.getTreeModel().getRoot().getId().equals(nodeId)) {
            return;
        }
        Set<Long> ids = BillingPoolListPlugin.findDescendantIds(root, nodeId);
        e.getQFilters().add(new QFilter("billpooltype.id", "in", ids));
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_TREEBUTTONPANEL});
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)e.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        if (currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            e.setChildNodes(currNode.getChildren());
        } else {
            e.setChildNodes(null);
        }
    }

    private void initTree() {
        ITreeModel tree = this.getTreeModel();
        TreeNode rootNode = tree.getRoot();
        String name = ResManager.loadKDString((String)"\u8d26\u5355\u7c7b\u578b", (String)"BillingPoolListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
        rootNode.setText(name);
        String rootId = rootNode.getId();
        QFilter qFilter = new QFilter("enable", "=", (Object)true);
        Map nodes = BusinessDataServiceHelper.loadFromCache((String)DB_BILLINGPOOL_TYPE, (String)"id,number,name,isinvoice", (QFilter[])new QFilter[]{qFilter});
        TreeNode[] currentNode = new TreeNode[1];
        if (null != nodes && !nodes.isEmpty()) {
            List<TreeNode> nodeList = nodes.values().stream().map(item -> {
                TreeNode node = new TreeNode(rootId, ErCommonUtils.getPk((Object)item).toString(), item.getString("name"), false);
                node.setIsOpened(true);
                if (item.getBoolean("isinvoice") && null == currentNode[0]) {
                    currentNode[0] = node;
                }
                return node;
            }).collect(Collectors.toList());
            this.buildTree(nodeList, rootNode);
        }
        tree.setRoot(rootNode);
        if (null != currentNode[0]) {
            TreeNode node = currentNode[0];
            tree.setCurrentNodeId((Object)node.getId());
            this.getTreeListView().getTreeView().focusNode(node);
        }
    }

    private DynamicObject getLayoutSolution(String action) {
        QFilter qFilter = new QFilter("billformid", "=", (Object)"er_billingpool");
        qFilter.and(new QFilter("enable", "=", (Object)true));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        Map layouts = BusinessDataServiceHelper.loadFromCache((String)DB_BILLTYPE, (QFilter[])new QFilter[]{qFilter});
        if (null != layouts && !layouts.isEmpty()) {
            return layouts.values().stream().filter(item -> item.getString("number").endsWith(action)).findFirst().orElse(null);
        }
        return null;
    }

    public void buildTree(List<TreeNode> nodes, TreeNode rootNode) {
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(nodes.size());
        for (TreeNode node : nodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : nodes) {
            if (StringUtils.equals((CharSequence)rootNode.getId(), (CharSequence)node.getParentid())) {
                rootNode.addChild(node);
                continue;
            }
            TreeNode parent = (TreeNode)nodeMap.get(node.getParentid());
            parent.addChild(node);
        }
    }

    public static Set<Long> findDescendantIds(TreeNode root, String targetId) {
        TreeNode currentNode;
        HashSet<Long> descendantIds = new HashSet<Long>(5);
        ArrayDeque<TreeNode> stack = new ArrayDeque<TreeNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            currentNode = (TreeNode)stack.pop();
            if (currentNode.getId().equals(targetId)) {
                stack.clear();
                stack.push(currentNode);
                break;
            }
            if (currentNode.getChildren() == null) continue;
            for (TreeNode child : currentNode.getChildren()) {
                stack.push(child);
            }
        }
        while (!stack.isEmpty()) {
            currentNode = (TreeNode)stack.pop();
            descendantIds.add(Long.parseLong(currentNode.getId()));
            if (currentNode.getChildren() == null) continue;
            for (TreeNode child : currentNode.getChildren()) {
                stack.push(child);
            }
        }
        return descendantIds;
    }
}

