/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.billingpool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.billingpool.model.BillingPoolConfigModel;
import kd.fi.er.business.billingpool.util.BillingPoolConfigUtils;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.model.invoice.InvoiceItemVO;
import kd.fi.er.common.model.invoice.InvoiceVO;
import org.apache.commons.lang3.StringUtils;

public class BillingPoolSelectPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(BillingPoolSelectPlugin.class);
    private static final String TAX_RATE = "basealltaxrate";
    private static final String checkResult = "validatemessage";
    private static final String checkStatus = "ie_validatest";
    private static final String isModified = "invoiceischange";
    private static final String idCard = "customeridnumber";
    private static final String passenger = "passengername";
    private static final String seatGrade = "seatgrade";
    private static final String flightOrTrainNum = "flighttrainnums";
    private static final String startProvince = "istartprovince";
    private static final String destProvince = "idestprovince";
    private static final String startCity = "istartcity";
    private static final String destCity = "idestcity";
    private static final String isOffset = "offset_invoice";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter filter = new QFilter("billstatus", "in", Arrays.asList("E", "J"));
        filter.and("oribalanceamount", ">", (Object)0);
        RequestContext reqContext = RequestContext.get();
        Long currentUserId = reqContext.getCurrUserId();
        QFilter userFilter = new QFilter("applier.id", "=", (Object)currentUserId);
        userFilter.or("projectower.fbasedataid.id", "=", (Object)currentUserId);
        filter.and(userFilter);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams && null != customParams.get("costcompany")) {
            List poolConfigs;
            String pk = customParams.get("costcompany").toString();
            if (customParams.containsKey("billingpoolIds")) {
                filter.and("id", "not in", customParams.get("billingpoolIds"));
            }
            if (!(poolConfigs = BillingPoolConfigUtils.queryPoolConfigs((Long)Long.valueOf(pk))).isEmpty()) {
                BillingPoolConfigModel configModel = (BillingPoolConfigModel)poolConfigs.get(0);
                if (configModel.canImport() || configModel.canManualAdd()) {
                    if (configModel.equalWl() && customParams.containsKey("billpayerid")) {
                        QFilter wlFilter = new QFilter("sellerorg.id", "=", customParams.get("billpayerid"));
                        wlFilter.or(QFilter.isNull((String)"sellerorg.id"));
                        filter.and(wlFilter);
                    }
                    if (configModel.equalCostCompany()) {
                        filter.and("costcompany", "=", (Object)Long.parseLong(pk));
                    }
                }
                if (configModel.canManualAdd()) {
                    LocalDate now = LocalDate.now();
                    int currentYear = now.getYear();
                    LocalDate firstDayOfYear = LocalDate.of(currentYear, 1, 1);
                    ArrayList<QFilter> dateFilters = new ArrayList<QFilter>();
                    if ("STRICT_CONTROL".equals(configModel.getCtlType())) {
                        int periodDay = configModel.getPeriod();
                        LocalDate startPeriod = now.minusDays(periodDay);
                        dateFilters.add(new QFilter("invoicedate", ">=", (Object)startPeriod));
                        if (configModel.isCrossYear()) {
                            LocalDate upToMonth;
                            int month = configModel.getUpToMonth();
                            if (month == 12) {
                                month = 0;
                                ++currentYear;
                            }
                            if ((upToMonth = LocalDate.of(currentYear, month + 1, 1)).isBefore(now)) {
                                dateFilters.add(new QFilter("invoicedate", ">=", (Object)firstDayOfYear));
                            }
                        } else {
                            dateFilters.add(new QFilter("invoicedate", ">=", (Object)firstDayOfYear));
                        }
                    }
                    Optional dateFilter = dateFilters.stream().reduce((pre, nex) -> pre.and(nex));
                    dateFilter.ifPresent(item -> filter.and(item.or(QFilter.isNull((String)"invoicedate"))));
                }
            }
        } else {
            filter.and("billstatus", "=", (Object)"Z1");
        }
        e.addCustomQFilter(filter);
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control ctl;
        String key;
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (source instanceof Control && StringUtils.equals((CharSequence)(key = (ctl = (Control)source).getKey()), (CharSequence)"btnok")) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            Object[] billIds = (Long[])selectedRows.stream().map(b -> (Long)b.getPrimaryKeyValue()).toArray(Long[]::new);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"er_billingpool");
            DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)entityType);
            this.getView().returnDataToParent((Object)this.convertToJson(bills));
            this.getView().close();
        }
    }

    private JSONObject convertToJson(DynamicObject[] bills) {
        ArrayList<InvoiceVO> invoices = null;
        if (null != bills && bills.length > 0) {
            invoices = new ArrayList(bills.length);
            for (DynamicObject bill : bills) {
                InvoiceVO invoice = new InvoiceVO();
                DynamicObject seller = bill.getDynamicObject("sellerorg");
                if (null != seller) {
                    invoice.setSalerName(seller.getString("name"));
                }
                invoice.setInvoiceMoney(bill.getString("invoicenotaxamount"));
                invoice.setInvoiceAmount(bill.getBigDecimal("invoicenotaxamount"));
                invoice.setProxyMark(bill.getString("proxymark"));
                invoice.setDownloadUrl(bill.getString("invaddr"));
                invoice.setRemark(bill.getString("remark_invoice"));
                invoice.setAuthenticateFlag(Integer.valueOf(1));
                invoice.setCheckStatus(bill.getString(checkStatus));
                invoice.setSalerTaxNo(bill.getString("salertaxno_h"));
                DynamicObject invoicetype = bill.getDynamicObject("invoicetype");
                if (null != invoicetype) {
                    invoice.setInvoiceType(invoicetype.getString("number"));
                }
                invoice.setInvoiceNo(bill.getString("invoiceno"));
                boolean isTaxPaymentCert = StringUtils.equals((CharSequence)invoice.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_19.getValue());
                if (isTaxPaymentCert) {
                    invoice.setTaxPaidProofNo(invoice.getInvoiceNo());
                }
                invoice.setBuyerAddressPhone(bill.getString("invoicebuyeraddressphone"));
                invoice.setSalerAccount(bill.getString("selleropenbank"));
                invoice.setAmount(bill.getBigDecimal("totalamount"));
                invoice.setBuyerTaxNo(bill.getString("buyertaxno"));
                invoice.setValidateMessage(bill.getString(checkResult));
                invoice.setInvoiceDate(bill.getDate("invoicedate"));
                DynamicObject buyerorg = bill.getDynamicObject("buyerorg");
                if (null != buyerorg) {
                    invoice.setBuyerName(buyerorg.getString("name"));
                }
                invoice.setInvoiceCode(bill.getString("invoicecode"));
                String serialNo = bill.getString("serialNo");
                invoice.setSerialNo(serialNo);
                invoice.setTotalAmount(bill.getBigDecimal("totalamount"));
                invoice.setSalerAddressPhone(bill.getString("invoiceselleraddressphone"));
                invoice.setBuyerAccount(bill.getString("buyeropenbank"));
                invoice.setTaxDetails(bill.getString("taxdetails"));
                invoice.setTaxAmount(bill.getBigDecimal("taxamount_invoice"));
                invoice.setInvoiceStatus("1");
                invoice.setPassengerName(bill.getString(passenger));
                invoice.setAirportConstructionFee(bill.getBigDecimal("airconstfee"));
                invoice.setFuelSurcharge(bill.getBigDecimal("invoicefuelsurcharge"));
                invoice.setOtherTotalTaxAmount(bill.getBigDecimal("othertotaltaxamount"));
                invoice.setDueDate(bill.getString("expirypaydate"));
                invoice.setBillingPoolId(Long.valueOf(bill.getLong("id")));
                invoice.setOriBalanceAmount(bill.getBigDecimal("oribalanceamount"));
                invoice.setTimeGetOn(bill.getString("timegeton"));
                invoice.setTimeGetOff(bill.getString("timegetoff"));
                boolean isMultiReimburse = bill.getBoolean("ismutilreimburse");
                invoice.setMutiReimburse(isMultiReimburse);
                DynamicObjectCollection relations = bill.getDynamicObjectCollection("voucherentity");
                if (isMultiReimburse && CollectionUtils.isNotEmpty((Collection)relations)) {
                    invoice.setCanCloseMultiReimburse(true);
                }
                invoice.setInvoiceFrom(bill.getString("invoicefrom"));
                boolean modified = bill.getBoolean(isModified);
                invoice.setIsRevise("1");
                if (modified) {
                    invoice.setIsRevise("2");
                }
                invoice.setCardNumber(bill.getString(idCard));
                invoice.setSeatGrade(bill.getString(seatGrade));
                String num = bill.getString(flightOrTrainNum);
                invoice.setFlightNum(num);
                invoice.setTrainNum(num);
                InvoiceVO.StationPosition departure = new InvoiceVO.StationPosition();
                departure.setProvince(bill.getString(startProvince));
                departure.setCity(bill.getString(startCity));
                InvoiceVO.StationPosition destination = new InvoiceVO.StationPosition();
                destination.setProvince(bill.getString(destProvince));
                destination.setCity(bill.getString(destCity));
                invoice.setDeparturePosition(departure);
                invoice.setDestinationPosition(destination);
                String startStation = bill.getString("invoicefromcity");
                String endStation = bill.getString("invoicefromcity");
                if (StringUtils.isNotBlank((CharSequence)startStation) && StringUtils.isNotBlank((CharSequence)endStation)) {
                    String trip = String.format("%s-%s", startStation, endStation);
                    invoice.setTrip(trip);
                }
                invoice.setDeductionFlag(bill.getBoolean(isOffset) ? "1" : "0");
                invoice.setInsurancePremium(bill.getBigDecimal("insurancepremium"));
                invoice.setExpenseStatus("30");
                DynamicObject taxRate = bill.getDynamicObject(TAX_RATE);
                if (null != taxRate) {
                    invoice.setTaxRate(taxRate.getBigDecimal("taxrate"));
                }
                String from = bill.getString("invoicefromcity");
                String to = bill.getString("invoicetocity");
                String trip = String.format("%s-%s", from, to);
                if ((trip = trip.replace("null", "")).length() > 1) {
                    invoice.setTrip(trip);
                }
                invoice.setPlace(bill.getString("invoicecity"));
                invoice.setXbrlUrl(bill.getString("isxbrl"));
                invoice.setType(bill.getString("isred"));
                invoice.setEndorsement(bill.getString("endorsement"));
                DynamicObject projecttype = bill.getDynamicObject("projecttype");
                if (null != projecttype) {
                    invoice.setBusinessType(projecttype.getString("name"));
                }
                invoice.setBlockChain(bill.getString("blockchain"));
                invoice.setCustomerIdentityNum(idCard);
                invoice.setBillCreateTime(bill.getDate("billcreatetime"));
                DynamicObject currency = bill.getDynamicObject("invoicecurrency");
                if (null != currency) {
                    invoice.setCurrencyName(currency.getString("name"));
                    invoice.setCurrencyId(ErCommonUtils.getPk((Object)currency));
                }
                DynamicObject country = bill.getDynamicObject("country");
                invoice.setCountryId(ErCommonUtils.getPk((Object)country));
                invoice.setCountry(bill.getString("countrystr"));
                DynamicObjectCollection items = bill.getDynamicObjectCollection("entryentity");
                if (CollectionUtils.isNotEmpty((Collection)items)) {
                    ArrayList<InvoiceItemVO> details = new ArrayList<InvoiceItemVO>();
                    for (DynamicObject item : items) {
                        InvoiceItemVO detail = new InvoiceItemVO();
                        detail.setGoodsName(item.getString("goodsname"));
                        detail.setGoodsCode(item.getString("goodscode"));
                        DynamicObject unit = item.getDynamicObject("unit");
                        if (null != unit) {
                            detail.setUnit(unit.getString("name"));
                        }
                        if (null != (taxRate = item.getDynamicObject("invoiceitembasetaxrate"))) {
                            detail.setTaxRate(taxRate.getBigDecimal("taxrate"));
                        }
                        detail.setNum(item.getBigDecimal("num"));
                        detail.setDetailAmount(item.getBigDecimal("excludeamount"));
                        detail.setSpecModel(item.getString("specmodel"));
                        detail.setTaxAmount(item.getBigDecimal("invoiceitemtaxamount"));
                        detail.setVehPlate(bill.getString("vehplate"));
                        detail.setUnitPrice(item.getBigDecimal("unitprice"));
                        details.add(detail);
                    }
                    invoice.setItems(details);
                }
                invoices.add(invoice);
            }
        } else {
            invoices = new ArrayList<InvoiceVO>();
        }
        JSONObject returnData = new JSONObject();
        JSONArray invoiceData = JSON.parseArray((String)JSON.toJSONString(invoices));
        returnData.put("invoiceData", (Object)invoiceData);
        return returnData;
    }
}

