/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.ErChangeAccountConvertUtils;
import kd.fi.er.business.utils.ErStdConfig;
import org.apache.commons.lang3.StringUtils;

public class ErBillPayByHeadToCasBillConvertPlugin
extends AbstractConvertPlugIn {
    private static String CAS_BILL_ENTRY = "entry";

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("ispaybyhead");
        e.addSrcField("id");
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        List pkLists = selectedRows.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList());
        String selectProperties = "id,company,ispaybyhead";
        QFilter filter = new QFilter("id", "in", pkLists);
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)this.getSrcMainType().getName(), (String)selectProperties, (QFilter[])new QFilter[]{filter});
        if (sourceBills != null && sourceBills.length > 0) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)sourceBills.length);
            for (DynamicObject bill : sourceBills) {
                if (bill.getDynamicObjectType().getProperty("ispaybyhead") == null || !bill.getBoolean("ispaybyhead") || !PayeeServiceHelper.storageLimits((DynamicObject)bill)) continue;
                list.add(bill.getPkValue());
            }
            if (!list.isEmpty() && !ErStdConfig.getBoolean((String)"storagelimit.pushallow")) {
                e.setCustFilterDesc(ResManager.loadKDString((String)"\u9690\u85cf\u6536\u6b3e\u4fe1\u606f\u5355\u636e\u6682\u4e0d\u652f\u6301\u4e0b\u63a8\u4ed8\u6b3e/\u4ee3\u53d1\u3002", (String)"ErBillPayByHeadToCasBillConvert_notallowpush", (String)"fi-er-formplugin", (Object[])new Object[0]));
                e.setCustFilterExpression(String.format(" id not in (%s) ", StringUtils.join((Iterable)list, (String)",")));
                QFilter qFilter = new QFilter("billstatus", "not in", (Object)list);
                e.getCustQFilters().add(qFilter);
                return;
            }
        }
        ErChangeAccountConvertUtils.pushValidator((AbstractConvertPlugIn)this, (BeforeBuildRowConditionEventArgs)e);
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            List srcRows = (List)dataEntity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            Boolean isPayByHead = (Boolean)((DynamicProperty)e.getFldProperties().get("ispaybyhead")).getValue((Object)srcRow);
            if (!isPayByHead.booleanValue()) continue;
            DynamicObjectCollection tarBillEntryCollection = dataEntity.getDataEntity().getDynamicObjectCollection(CAS_BILL_ENTRY);
            this.fillTarEntryDefValueByFirstEntry(tarBillEntryCollection);
        }
    }

    private void fillTarEntryDefValueByFirstEntry(DynamicObjectCollection tarBillEntryCollection) {
        if (tarBillEntryCollection != null && tarBillEntryCollection.size() > 0) {
            DynamicObject firstEntry = (DynamicObject)tarBillEntryCollection.get(0);
            for (int i = 1; i < tarBillEntryCollection.size(); ++i) {
                DynamicObject entry = (DynamicObject)tarBillEntryCollection.get(i);
                DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
                for (IDataEntityProperty property : properties) {
                    String propertyName = property.getName();
                    Object value = entry.get(propertyName);
                    if (value != null && (!(value instanceof String) || !StringUtils.isEmpty((CharSequence)String.valueOf(value))) && (!(value instanceof Long) || ((Long)value).compareTo(0L) != 0)) continue;
                    entry.set(propertyName, firstEntry.get(propertyName));
                }
            }
        }
    }
}

