/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.tripbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.TripExpenseItemServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.botp.tripbill.AbstractTripBillToReimburseBotpPlugin;
import org.apache.commons.lang3.StringUtils;

public class AbstractTripDefaultToReimburseConvertPlugin
extends AbstractTripBillToReimburseBotpPlugin {
    private static final Log logger = LogFactory.getLog(AbstractTripDefaultToReimburseConvertPlugin.class);
    private Map<Object, DynamicObject> srcBillDyObjMap = new HashMap<Object, DynamicObject>();
    private Map<String, Long> vehicleMap = new HashMap<String, Long>();
    private Map<Long, Long> tripAreaMap = new HashMap<Long, Long>();
    private Map<Object, DynamicObject> tripExpItemMaps = null;
    private List<DynamicObject> defaultList = null;
    private Long companyId = null;
    private boolean needCarryVehicle;
    private boolean configOffset;

    @Override
    protected void initDefaultTargetEntryData(DynamicObject targetBill, Map<String, DynamicProperty> srcfldPro, List<DynamicObject> convertSourceBillRows, Map<String, Object> targetBillIdMap) {
        Long time = System.currentTimeMillis();
        this.companyId = ErCommonUtils.getPk((Object)targetBill.getDynamicObject("company"));
        List tripExpenseItems = CoreBaseBillServiceHelper.getTripExpenseItems((Long)this.companyId);
        this.tripExpItemMaps = tripExpenseItems.stream().filter(e -> e != null).collect(Collectors.toMap(DataEntityBase::getPkValue, e -> e));
        this.defaultList = tripExpenseItems.stream().filter(item -> item.getBoolean("isdefault") == Boolean.TRUE.booleanValue()).collect(Collectors.toList());
        String needCarryVehicle_str = (String)ErCommonUtils.getEMParameter((long)this.companyId, (String)"needcarryvehicle");
        this.needCarryVehicle = needCarryVehicle_str != null && needCarryVehicle_str.equals("1");
        this.configOffset = SystemParamterUtil.manuallyaddexpenseoffset((Long)this.companyId) && InvoiceOffsetUtils.deductibleOfTaxPayer((DynamicObject)targetBill);
        HashSet<Object> srcBillIds = new HashSet<Object>(convertSourceBillRows.size());
        for (int i = 0; i < convertSourceBillRows.size(); ++i) {
            Object srcBillId = srcfldPro.get("id").getValue((Object)convertSourceBillRows.get(i));
            srcBillIds.add(srcBillId);
        }
        String select = "id,tripentry.id,tripentry.vehicle,tripentry.vehicles,tripentry.travelers,tripentry.mulwayto";
        DynamicObject[] srcBills = BusinessDataServiceHelper.load((String)this.getSrcMainType().getName(), (String)select, (QFilter[])new QFilter("id", "in", srcBillIds).toArray());
        this.srcBillDyObjMap = Stream.of(srcBills).collect(Collectors.toMap(v -> v.get("id"), v -> v));
        HashSet<String> vehicleSet = new HashSet<String>();
        for (DynamicObject srcBill : srcBills) {
            DynamicObjectCollection sourceTripEntrys = srcBill.getDynamicObjectCollection("tripentry");
            for (int i = 0; i < sourceTripEntrys.size(); ++i) {
                DynamicObject sourceTripEntry = (DynamicObject)sourceTripEntrys.get(i);
                String vehicles = sourceTripEntry.getString("vehicles");
                vehicleSet.addAll(Arrays.asList(vehicles.split(",")));
            }
        }
        DynamicObjectCollection targetTripEntrys = targetBill.getDynamicObjectCollection("tripentry");
        HashSet<Long> toCityIds = new HashSet<Long>();
        for (DynamicObject targetTripEntry : targetTripEntrys) {
            String vehicle = targetTripEntry.getString("vehicle");
            vehicleSet.add(vehicle);
            DynamicObject to = targetTripEntry.getDynamicObject("to");
            if (null == to) continue;
            Long toCityId = (Long)to.getPkValue();
            toCityIds.add(toCityId);
        }
        this.vehicleMap = TripExpenseItemServiceHelper.getSingleTripExpItemByCompanyAndVehicle((Long)this.companyId, vehicleSet);
        this.tripAreaMap = this.batchGetTripAreaByCityIdAndCompanyId(toCityIds);
        for (int i = 0; i < convertSourceBillRows.size(); ++i) {
            Object srcBillId = srcfldPro.get("id").getValue((Object)convertSourceBillRows.get(i));
            DynamicObject sourceBillDynamicObject = this.srcBillDyObjMap.get(srcBillId);
            Map<String, List<DynamicObject>> tripExpenseItemMap = this.getTripExpenseItemInfosMap(this.companyId, sourceBillDynamicObject);
            Long tripentrysourceid = (Long)srcfldPro.get("tripentry.id").getValue((Object)convertSourceBillRows.get(i));
            this.initDefaultTargetEntryData(tripExpenseItemMap, targetBill, tripentrysourceid, i);
        }
        logger.info("AbstractTripDefaultToReimburseConvertPlugin.initDefaultTargetEntryData \u51fa\u5dee\u7533\u8bf7\u5355\u4e0b\u63a8\u8017\u8d39 {}", (Object)(System.currentTimeMillis() - time));
    }

    private Map<Long, Long> batchGetTripAreaByCityIdAndCompanyId(Set<Long> toCityIds) {
        QFilter filter = new QFilter("entryentity.city.id", "in", toCityIds);
        filter.and(new QFilter("enable", "=", (Object)true));
        QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_triparea", (Long)this.companyId);
        if (null != baseFilter) {
            filter.and(baseFilter);
        }
        DynamicObjectCollection tripAreas = QueryServiceHelper.query((String)"er_triparea", (String)"id,entryentity.city.id cityid", (QFilter[])new QFilter[]{filter});
        HashMap<Long, Long> ret = new HashMap<Long, Long>();
        for (DynamicObject tripArea : tripAreas) {
            Long cityId = tripArea.getLong("cityid");
            if (ret.get(cityId) != null) continue;
            ret.put(cityId, tripArea.getLong("id"));
        }
        return ret;
    }

    protected Map<String, List<DynamicObject>> getTripExpenseItemInfosMap(Long companyId, DynamicObject sourceBillDynamicObject) {
        HashMap<String, List<DynamicObject>> tripExpenseItemMap = new HashMap<String, List<DynamicObject>>();
        DynamicObjectCollection sourceTripEntrys = sourceBillDynamicObject.getDynamicObjectCollection("tripentry");
        for (int i = 0; i < sourceTripEntrys.size(); ++i) {
            DynamicObject sourceTripEntry = (DynamicObject)sourceTripEntrys.get(i);
            String vehicles = sourceTripEntry.getString("vehicles");
            String sourceTripEntryId = String.valueOf(sourceTripEntry.getPkValue());
            if (tripExpenseItemMap.get(sourceTripEntryId) != null) continue;
            List<String> collect = Arrays.stream(vehicles.split(",")).filter(e -> StringUtils.isNotBlank((CharSequence)e)).collect(Collectors.toList());
            List<DynamicObject> tripExpenseItemInfos = this.getDefaultExpenseItems(companyId, collect);
            tripExpenseItemMap.put(sourceTripEntryId, tripExpenseItemInfos);
        }
        return tripExpenseItemMap;
    }

    private List<DynamicObject> getDefaultExpenseItems(Long companyId, List<String> vehicles) {
        ArrayList<DynamicObject> _defaultList = new ArrayList<DynamicObject>(this.defaultList);
        if (this.needCarryVehicle) {
            for (int i = 0; i < vehicles.size(); ++i) {
                String vehicle = vehicles.get(i);
                Long vehicleItem = this.vehicleMap.get(vehicle);
                DynamicObject vehicleExpenseItem = this.tripExpItemMaps.get(vehicleItem);
                if (vehicleExpenseItem == null) continue;
                _defaultList.remove(vehicleExpenseItem);
                _defaultList.add(0, vehicleExpenseItem);
            }
        }
        return _defaultList;
    }

    private void initDefaultTargetEntryData(Map<String, List<DynamicObject>> tripExpenseItemMap, DynamicObject targetBill, Long tripentrysourceid, int index) {
        Long toCityId;
        Long tripAreaId;
        DynamicObjectCollection targetTripEntrys = targetBill.getDynamicObjectCollection("tripentry");
        DynamicObject targetTripEntry = (DynamicObject)targetTripEntrys.get(index);
        DynamicObject to = targetTripEntry.getDynamicObject("to");
        if (null != to && (tripAreaId = this.tripAreaMap.get(toCityId = (Long)to.getPkValue())) != null) {
            targetTripEntry.set("tripentryarea_id", (Object)tripAreaId);
        }
        Long currencyId = ErCommonUtils.getPk((Object)targetBill.get("currency"));
        String vehicle = targetTripEntry.getString("vehicle");
        Long currentTripEntryTripItemId = this.vehicleMap.get(vehicle);
        Date startDate = (Date)targetTripEntry.get("startdate");
        Date endDate = (Date)targetTripEntry.get("enddate");
        Long tirpCurrencyId = ErCommonUtils.getPk((Object)targetTripEntry.get("tripcurrency"));
        DynamicObjectCollection entryentitys = targetTripEntry.getDynamicObjectCollection("entryentity");
        List<DynamicObject> tripExpenseItemInfos = tripExpenseItemMap.get(String.valueOf(tripentrysourceid));
        if (tripExpenseItemInfos == null) {
            return;
        }
        Integer entrySeq = 0;
        for (DynamicObject tripExpenseItemInfo : tripExpenseItemInfos) {
            DynamicObject entry = entryentitys.addNew();
            entry.set("expenseitem_id", tripExpenseItemInfo.getPkValue());
            entry.set("exchangerate", (Object)targetTripEntry.getBigDecimal("tripexchangerate"));
            entry.set("entrycurrency", (Object)targetTripEntry.getDynamicObject("tripcurrency"));
            entry.set("detailquotetype", (Object)((String)targetTripEntry.get("tripquotetype")));
            if (tirpCurrencyId != null && tirpCurrencyId.compareTo(currencyId) != 0) {
                entry.set("isMulticurrency", (Object)Boolean.TRUE);
            }
            entry.set("pic", tripExpenseItemInfo.get("expenseitemicon"));
            entry.set("offset", (Object)(this.configOffset && tripExpenseItemInfo.getBoolean("isoffset") ? 1 : 0));
            entry.set("taxrate", tripExpenseItemInfo.get("taxrate"));
            entrySeq = entrySeq + 1;
            entry.set("seq", (Object)entrySeq);
            entry.set("daycount", targetTripEntry.get("tripday"));
            BigDecimal calDaycount = CommonServiceHelper.getLiveDaysByDate((Date)startDate, (Date)endDate);
            if (tripExpenseItemInfo.getString("attribute").equals("1")) {
                calDaycount = CommonServiceHelper.getSubsidyDaysByDate((Date)startDate, (Date)endDate, (Long)this.companyId);
            }
            entry.set("caldaycount", (Object)calDaycount);
            entry.set("trip2startdate", (Object)startDate);
            entry.set("trip2enddate", (Object)endDate);
            if (Objects.equals(tripExpenseItemInfo.getPkValue(), currentTripEntryTripItemId)) {
                entry.set("isdefault", (Object)Boolean.TRUE);
            }
            entry.set("itemfrom", (Object)ItemFrom.Manual.getValue());
            entry.set("settlementtype", (Object)"1");
        }
    }
}

