/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.tripbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.TripExpenseItemServiceHelper;
import kd.fi.er.business.servicehelper.TripReimburseServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripBusinessRelatDailyBusinessUtil;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.trip.dailybiz.TripReimCreateOrderEntrysUtil;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.botp.tripbill.AbstractTripBillToReimburseBotpPlugin;
import org.apache.commons.lang3.StringUtils;

public class TripReqBillToGridStyleReimburseConvertPlugin
extends AbstractTripBillToReimburseBotpPlugin {
    private static final Log logger = LogFactory.getLog(TripReqBillToGridStyleReimburseConvertPlugin.class);

    @Override
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("from");
        e.addSrcField("to");
        e.addSrcField("startdate");
        e.addSrcField("enddate");
        e.addSrcField("tripcurrency");
        e.addSrcField("tripexchangerate");
        e.addSrcField("travelers");
        e.addSrcField("tripreimbursetype");
    }

    @Override
    protected void initDefaultTargetEntryData(DynamicObject targetBill, Map<String, DynamicProperty> srcfldPro, List<DynamicObject> convertSourceBillRows, Map<String, Object> targetBillIdMap) {
        DynamicObject targetTripEntry;
        DynamicObjectCollection targetTripEntrys = targetBill.getDynamicObjectCollection("tripentry");
        if (targetTripEntrys.size() < 1) {
            targetTripEntry = targetTripEntrys.addNew();
            targetTripEntry.set("seq", (Object)1);
        } else {
            if (targetTripEntrys.size() > 1) {
                while (targetTripEntrys.size() > 1) {
                    targetTripEntrys.remove(targetTripEntrys.size() - 1);
                }
            }
            targetTripEntry = (DynamicObject)targetTripEntrys.get(0);
        }
        HashSet<Object> tripExpenseItemSet = new HashSet<Object>();
        DynamicObjectCollection entryentitys = targetTripEntry.getDynamicObjectCollection("entryentity");
        Long companyId = (Long)targetBill.getDynamicObject("company").getPkValue();
        Long currencyId = ErCommonUtils.getPk((Object)targetBill.get("currency"));
        this.initTargetEntryDataByOriBill(targetBill, companyId, currencyId, entryentitys, srcfldPro, convertSourceBillRows, tripExpenseItemSet, targetBillIdMap);
        Object userId = targetBill.getDynamicObject("applier").getPkValue();
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getOpType().name(), (CharSequence)"push")) {
            List tripExpenseItems = CoreBaseBillServiceHelper.getDefaultTripExpenseItems((Long)companyId);
            this.initTargetEntryDataByDefaultTripExp(targetBill, userId, companyId, currencyId, entryentitys, tripExpenseItems, tripExpenseItemSet, targetBillIdMap);
        }
        this.genOrderEntrys(targetBill, targetTripEntry, companyId, srcfldPro, convertSourceBillRows);
        entryentitys = targetTripEntry.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryentitys.size(); ++i) {
            ((DynamicObject)entryentitys.get(i)).set("seq", (Object)(i + 1));
        }
    }

    private void initTargetEntryDataByOriBill(DynamicObject targetBill, Long companyId, Long currencyId, DynamicObjectCollection entryentitys, Map<String, DynamicProperty> srcfldPro, List<DynamicObject> convertSourceBillRows, Set<Object> tripExpenseItemSet, Map<String, Object> targetBillIdMap) {
        boolean configOffset = SystemParamterUtil.manuallyaddexpenseoffset((Long)companyId);
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer((DynamicObject)targetBill);
        configOffset = configOffset && isOrgOffset;
        Map<String, DynamicObject> tripExpItemFromVehicle = this.getTripExpenseItemByVehicles(companyId, srcfldPro, convertSourceBillRows);
        DynamicObject sourceBillDynamicObject = null;
        int srcTripEntryIndex = 0;
        int peekSize = 0;
        Integer entrySeq = 1;
        int writeOffEntryIndex = 0;
        HashSet<Long> ids = new HashSet<Long>(1);
        Map<Object, DynamicObject> srcBillMap = this.getAllSrcBill(srcfldPro, convertSourceBillRows);
        ArrayList<DynamicObject> entryListTemp = new ArrayList<DynamicObject>();
        String needCarryVehicle = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"needcarryvehicle");
        boolean needCarry = needCarryVehicle != null && needCarryVehicle.equals("1");
        for (int i = 0; i < convertSourceBillRows.size(); ++i) {
            long[] writeOffEntryIdArray;
            if (peekSize == 0) {
                sourceBillDynamicObject = srcBillMap.get(srcfldPro.get("id").getValue((Object)convertSourceBillRows.get(i)));
                peekSize = sourceBillDynamicObject.getDynamicObjectCollection("tripentry").size();
                srcTripEntryIndex = 0;
            }
            --peekSize;
            Map<String, DynamicObjectCollection> multFieldData = this.getSrcMulSelectFieldData(sourceBillDynamicObject, srcTripEntryIndex++, i);
            Object from = srcfldPro.get("from").getValue((Object)convertSourceBillRows.get(i));
            Object to = srcfldPro.get("to").getValue((Object)convertSourceBillRows.get(i));
            Date startDate = (Date)srcfldPro.get("startdate").getValue((Object)convertSourceBillRows.get(i));
            Date endDate = (Date)srcfldPro.get("enddate").getValue((Object)convertSourceBillRows.get(i));
            Object entryCurrency = srcfldPro.get("tripcurrency").getValue((Object)convertSourceBillRows.get(i));
            Object entryExChangerate = srcfldPro.get("tripexchangerate").getValue((Object)convertSourceBillRows.get(i));
            Object tripquotetype = srcfldPro.get("tripquotetype").getValue((Object)convertSourceBillRows.get(i));
            if (needCarry) {
                String vehicles = String.valueOf(srcfldPro.get("vehicles").getValue((Object)convertSourceBillRows.get(i)));
                List collect = Arrays.stream(vehicles.split(",")).filter(e -> StringUtils.isNotBlank((CharSequence)e)).collect(Collectors.toList());
                for (int j = 0; j < collect.size(); ++j) {
                    String vehicle = (String)collect.get(j);
                    DynamicObject tripexpenseItem = tripExpItemFromVehicle.get(String.valueOf(vehicle));
                    DynamicObject entry = entryentitys.addNew();
                    entryListTemp.add(entry);
                    int tripDay = (Integer)srcfldPro.get("tripday").getValue((Object)convertSourceBillRows.get(i));
                    if (tripexpenseItem != null) {
                        Object pic = tripexpenseItem.get("expenseitemicon");
                        BigDecimal calDaycount = CommonServiceHelper.getLiveDaysByDate((Date)startDate, (Date)endDate);
                        if (tripexpenseItem.getString("attribute").equals("1")) {
                            calDaycount = CommonServiceHelper.getSubsidyDaysByDate((Date)startDate, (Date)endDate, (Long)companyId);
                        }
                        tripExpenseItemSet.add(tripexpenseItem.getPkValue());
                        entry.set("expenseitem_id", tripexpenseItem.getPkValue());
                        entry.set("pic", pic);
                        entry.set("offset", (Object)(configOffset && tripexpenseItem.getBoolean("isoffset") ? 1 : 0));
                        entry.set("taxrate", tripexpenseItem.get("taxrate"));
                        entry.set("caldaycount", (Object)calDaycount);
                    }
                    entry.set("exchangerate", entryExChangerate);
                    entry.set("entrycurrency_id", entryCurrency);
                    entry.set("detailquotetype", tripquotetype);
                    entry.set("isdefault", (Object)Boolean.TRUE);
                    entry.set("trip2startdate", (Object)startDate);
                    entry.set("trip2enddate", (Object)endDate);
                    entry.set("trip2from_id", (Object)ErCommonUtils.getPk((Object)from));
                    entry.set("trip2to_id", (Object)ErCommonUtils.getPk((Object)to));
                    ErTripStdServiceImp stdService = new ErTripStdServiceImp();
                    DynamicObject tripArea = stdService.getTripAreaByCityIdAndCompanyId(ErCommonUtils.getPk((Object)to), companyId);
                    entry.set("triparea", (Object)tripArea);
                    entry.set("daycount", (Object)tripDay);
                    entry.set("itemfrom", (Object)ItemFrom.Manual.getValue());
                    entry.set("settlementtype", (Object)"1");
                    if (entryCurrency != null && ErCommonUtils.getPk((Object)entryCurrency).compareTo(currencyId) != 0) {
                        entry.set("isMulticurrency", (Object)Boolean.TRUE);
                    }
                    this.convertMulSelectField(multFieldData, i, "travelers", "trip2travelers", entry);
                    this.convertMulSelectField(multFieldData, i, "mulwayto", "trip2mulwayto", entry);
                    Integer n = entrySeq;
                    Integer n2 = entrySeq = Integer.valueOf(entrySeq + 1);
                    entry.set("seq", (Object)n);
                }
            }
            if ((writeOffEntryIdArray = (long[])targetBillIdMap.get("writeOffEntryId")) == null || writeOffEntryIdArray.length == 0) continue;
            DynamicObjectCollection writeOffTripRelate = targetBill.getDynamicObjectCollection("writeofftriprelate");
            DynamicObject relateRow = writeOffTripRelate.addNew();
            if (needCarry) {
                for (int j = 0; j < entryListTemp.size(); ++j) {
                    DynamicObject entry = (DynamicObject)entryListTemp.get(j);
                    entry.set("id", (Object)DBServiceHelper.genGlobalLongId());
                    entry.getDataEntityState().setPushChanged(true);
                    relateRow.set("expenseid", entry.getPkValue());
                }
            }
            relateRow.set("id", (Object)DBServiceHelper.genGlobalLongId());
            if (!ids.contains(convertSourceBillRows.get(i).getLong("id"))) {
                writeOffEntryIndex = !ids.isEmpty() ? writeOffEntryIndex + 1 : writeOffEntryIndex;
                ids.add(convertSourceBillRows.get(i).getLong("id"));
            }
            relateRow.set("writeoffentryid", (Object)writeOffEntryIdArray[writeOffEntryIndex]);
            relateRow.getDataEntityState().setPushChanged(true);
        }
    }

    private Map<Object, DynamicObject> getAllSrcBill(Map<String, DynamicProperty> srcfldPro, List<DynamicObject> convertSourceBillRows) {
        Object[] sourceBills = convertSourceBillRows.stream().map(l -> ((DynamicProperty)srcfldPro.get("id")).getValue(l)).distinct().collect(Collectors.toList()).toArray();
        DynamicObject[] srcBills = BusinessDataServiceHelper.load((Object[])sourceBills, (DynamicObjectType)this.getSrcMainType());
        Map<Object, DynamicObject> result = srcBills.length > 0 ? Arrays.asList(srcBills).stream().filter(bill -> bill != null).collect(Collectors.toMap(k -> k.getPkValue(), v -> v, (a, b) -> a)) : new HashMap<Object, DynamicObject>();
        return result;
    }

    private void initTargetEntryDataByDefaultTripExp(DynamicObject targetBill, Object userId, Long companyId, Long currencyId, DynamicObjectCollection entryentitys, List<DynamicObject> tripExpenseItems, Set<Object> tripExpenseItemSet, Map<String, Object> targetBillIdMap) {
        Integer entrySeq = entryentitys.size();
        ArrayList<Object> mulTraversList = new ArrayList<Object>(1);
        mulTraversList.add(userId);
        boolean configOffset = SystemParamterUtil.manuallyaddexpenseoffset((Long)companyId);
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer((DynamicObject)targetBill);
        configOffset = configOffset && isOrgOffset;
        DynamicObjectCollection writeOffTripRelate = targetBill.getDynamicObjectCollection("writeofftriprelate");
        for (DynamicObject tripexpenseItem : tripExpenseItems) {
            if (!tripExpenseItemSet.add(tripexpenseItem.getPkValue())) continue;
            DynamicObject entry = entryentitys.addNew();
            entry.set("expenseitem_id", tripexpenseItem.getPkValue());
            entry.set("offset", (Object)(configOffset && tripexpenseItem.getBoolean("isoffset") ? 1 : 0));
            entry.set("taxrate", tripexpenseItem.get("taxrate"));
            entry.set("entrycurrency_id", (Object)currencyId);
            entry.set("exchangerate", (Object)BigDecimal.valueOf(1L));
            entry.set("detailquotetype", (Object)"0");
            Integer n = entrySeq;
            Integer n2 = entrySeq = Integer.valueOf(entrySeq + 1);
            entry.set("seq", (Object)n);
            entry.set("itemfrom", (Object)ItemFrom.Manual.getValue());
            entry.set("settlementtype", (Object)"1");
            this.initMulTravlersForDefaultEntry(entry, mulTraversList);
            long[] writeOffEntryIdArray = (long[])targetBillIdMap.get("writeOffEntryId");
            if (writeOffEntryIdArray == null || writeOffEntryIdArray.length == 0) continue;
            DynamicObject relateRow = writeOffTripRelate.addNew();
            DBServiceHelper.genGlobalLongId();
            entry.set("id", (Object)DBServiceHelper.genGlobalLongId());
            entry.getDataEntityState().setPushChanged(true);
            relateRow.set("writeoffentryid", (Object)writeOffEntryIdArray[0]);
            relateRow.set("expenseid", entry.getPkValue());
            relateRow.getDataEntityState().setPushChanged(true);
        }
    }

    private void initMulTravlersForDefaultEntry(DynamicObject entry, List<Object> mulTraversList) {
        DynamicObjectCollection tripTravlerColl = entry.getDynamicObjectCollection("trip2travelers");
        for (Object pkValue : mulTraversList) {
            DynamicObject tripTravler = tripTravlerColl.addNew();
            tripTravler.set("fbasedataid_id", pkValue);
        }
    }

    private Map<String, DynamicObject> getTripExpenseItemByVehicles(Long companyId, Map<String, DynamicProperty> srcfldPro, List<DynamicObject> convertSourceBillRows) {
        ArrayList<String> vhList = new ArrayList();
        for (int i = 0; i < convertSourceBillRows.size(); ++i) {
            String vehicles = String.valueOf(srcfldPro.get("vehicles").getValue((Object)convertSourceBillRows.get(i)));
            List collect = Arrays.stream(vehicles.split(",")).filter(e -> StringUtils.isNotBlank((CharSequence)e)).collect(Collectors.toList());
            vhList.addAll(collect);
        }
        vhList = vhList.stream().distinct().collect(Collectors.toList());
        Map<String, DynamicObject> resultMap = this.getTripExpenseItemByVehicles(companyId, vhList);
        return resultMap;
    }

    private Map<String, DynamicObject> getTripExpenseItemByVehicles(Long companyId, List<String> vhList) {
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(vhList.size());
        if (vhList == null || vhList.isEmpty()) {
            return resultMap;
        }
        HashMap<Long, String> tripExpItemVhMap = new HashMap<Long, String>(vhList.size());
        for (String vh : vhList) {
            Long tripItemId = TripExpenseItemServiceHelper.getSingleTripExpItemByCompanyAndVehicle((Long)companyId, (String)vh);
            if (tripItemId == null) continue;
            tripExpItemVhMap.put(tripItemId, vh);
        }
        QFilter qf = new QFilter("id", "in", tripExpItemVhMap.keySet());
        List tripExpenseItemList = CoreBaseBillServiceHelper.loadTripItems((QFilter[])new QFilter[]{qf});
        for (DynamicObject item : tripExpenseItemList) {
            Long pkValue = (Long)item.getPkValue();
            resultMap.put((String)tripExpItemVhMap.get(pkValue), item);
        }
        return resultMap;
    }

    private void convertMulSelectField(Map<String, DynamicObjectCollection> multFieldData, int convertRowIndex, String srcMulFieldKey, String tarMulFieldKey, DynamicObject targetEntry) {
        DynamicObjectCollection srcFieldRows = multFieldData.get(srcMulFieldKey + convertRowIndex);
        DynamicObjectCollection tarFieldRows = targetEntry.getDynamicObjectCollection(tarMulFieldKey);
        tarFieldRows.clear();
        MulBasedataProp srcgetFieldProp = (MulBasedataProp)this.getSrcMainType().findProperty(srcMulFieldKey);
        MulBasedataProp targetFieldProp = (MulBasedataProp)this.getTgtMainType().findProperty(tarMulFieldKey);
        for (DynamicObject srcRow : srcFieldRows) {
            DynamicObject targetFieldRow = new DynamicObject(targetFieldProp.getDynamicCollectionItemPropertyType());
            targetFieldProp.getRefIdProp().setValue((Object)targetFieldRow, srcgetFieldProp.getRefIdProp().getValue((Object)srcRow));
            tarFieldRows.add((Object)targetFieldRow);
        }
    }

    private Map<String, DynamicObjectCollection> getSrcMulSelectFieldData(DynamicObject sourceBillObject, int srcTripEntryRowIndex, int convertDataRowIndex) {
        DynamicObjectCollection sourceBillTripentrys = sourceBillObject.getDynamicObjectCollection("tripentry");
        HashMap<String, DynamicObjectCollection> srcEntryRowResult = new HashMap<String, DynamicObjectCollection>();
        if (srcTripEntryRowIndex < sourceBillTripentrys.size()) {
            DynamicObject srcEntry = (DynamicObject)sourceBillTripentrys.get(srcTripEntryRowIndex);
            srcEntryRowResult.put("travelers" + convertDataRowIndex, srcEntry.getDynamicObjectCollection("travelers"));
            srcEntryRowResult.put("mulwayto" + convertDataRowIndex, srcEntry.getDynamicObjectCollection("mulwayto"));
        }
        return srcEntryRowResult;
    }

    private void genOrderEntrys(DynamicObject targetBill, DynamicObject targetTripEntry, Long companyId, Map<String, DynamicProperty> srcfldPro, List<DynamicObject> convertSourceBillRows) {
        ArrayList<Long> reqBillIds = new ArrayList<Long>(convertSourceBillRows.size());
        ArrayList<String> reqBillNos = new ArrayList<String>(convertSourceBillRows.size());
        for (int i = 0; i < convertSourceBillRows.size(); ++i) {
            Long reqbillId = (Long)srcfldPro.get("id").getValue((Object)convertSourceBillRows.get(i));
            String reqbillNo = (String)srcfldPro.get("billno").getValue((Object)convertSourceBillRows.get(i));
            reqBillIds.add(reqbillId);
            reqBillNos.add(reqbillNo);
        }
        List notReimbursedOrderList = TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByReq(reqBillIds, reqBillNos, (Long)companyId);
        if (notReimbursedOrderList.isEmpty()) {
            return;
        }
        boolean isShowInvoiceEntry = SystemParamterUtil.getIsShowInvoiceEntry((long)companyId);
        HashSet travelerIdSet = new HashSet(4);
        notReimbursedOrderList.stream().forEach(tripOrder -> {
            Long sourcetravelerId = TripBusinessRelatDailyBusinessUtil.getOrderTravelerId((DynamicObject)tripOrder);
            travelerIdSet.add(sourcetravelerId);
        });
        TripReimCreateOrderEntrysUtil.initOrderEntrys((DynamicObject)targetBill, (DynamicObject)targetTripEntry, travelerIdSet, (List)notReimbursedOrderList, (boolean)isShowInvoiceEntry, null, null, null);
        Map<String, DynamicObject> waitHandleOrderMap = notReimbursedOrderList.stream().collect(Collectors.toMap(v -> v.getString("ordernum"), v -> v));
        DynamicObjectCollection entryentitys = targetTripEntry.getDynamicObjectCollection("entryentity");
        String orgType = ErCommonUtils.getTripAreaOrgType();
        DynamicObject areaUseOrg = targetBill.getDynamicObject(orgType);
        String value = SystemParamterUtil.getTripReimburseType((Long)companyId);
        for (DynamicObject entry : entryentitys) {
            DynamicObject order;
            String ordernum = entry.getString("ordernum");
            if (!StringUtils.isNotEmpty((CharSequence)ordernum) || null == (order = waitHandleOrderMap.get(ordernum = ordernum.split(",")[0]))) continue;
            String tripId = order.getString("tripid");
            for (int i = 0; i < convertSourceBillRows.size(); ++i) {
                String sourcetripentryid = String.valueOf(srcfldPro.get("tripentry.id").getValue((Object)convertSourceBillRows.get(i)));
                if (!StringUtils.equals((CharSequence)tripId, (CharSequence)sourcetripentryid)) continue;
                Object from = srcfldPro.get("from").getValue((Object)convertSourceBillRows.get(i));
                Object to = srcfldPro.get("to").getValue((Object)convertSourceBillRows.get(i));
                Date startDate = (Date)srcfldPro.get("startdate").getValue((Object)convertSourceBillRows.get(i));
                Date endDate = (Date)srcfldPro.get("enddate").getValue((Object)convertSourceBillRows.get(i));
                int tripDay = (Integer)srcfldPro.get("tripday").getValue((Object)convertSourceBillRows.get(i));
                if (!"er_hotelbill".equals(entry.getString("orderformid"))) {
                    entry.set("trip2startdate", (Object)startDate);
                    entry.set("trip2enddate", (Object)endDate);
                }
                if ("er_vehiclebill".equals(entry.getString("orderformid"))) {
                    entry.set("trip2from_id", (Object)ErCommonUtils.getPk((Object)from));
                    entry.set("trip2to_id", (Object)ErCommonUtils.getPk((Object)to));
                    ErTripStdServiceImp stdService = new ErTripStdServiceImp();
                    DynamicObject tripArea = stdService.getTripAreaByCityIdAndCompanyId(ErCommonUtils.getPk((Object)to), ErCommonUtils.getPk((Object)areaUseOrg));
                    entry.set("triparea_id", (Object)ErCommonUtils.getPk((Object)tripArea));
                }
                entry.set("daycount", (Object)tripDay);
                break;
            }
            if (value == null || !"grid".equals(value.toString())) continue;
            Map<String, String> paramMap = this.constructParamMap(order, entry);
            paramMap.put("formId", "er_tripreimbill_grid");
            Long expenseitemId = ErCommonUtils.getPk((Object)entry.get("expenseitem"));
            if (expenseitemId != null) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)expenseitemId, (String)"er_tripexpenseitem");
                String operationtype = dynamicObject.getString("operationtype");
                logger.info("Line 459 \u5f53\u524d\u5dee\u65c5\u9879\u76ee\u670d\u52a1\u7c7b\u578b" + operationtype + "\u5f53\u524d\u5dee\u65c5\u9879\u76ee:" + dynamicObject.get("longnumber"));
                if (operationtype.contains("7")) {
                    entry.set("trip2startdate", (Object)"");
                    entry.set("trip2enddate", (Object)"");
                    entry.set("trip2to_id", (Object)0L);
                    entry.set("trip2from_id", (Object)0L);
                    entry.set("triparea_id", (Object)0L);
                    continue;
                }
            }
            if ("er_vehiclebill".equals(entry.getString("orderformid"))) continue;
            TripReimCreateOrderEntrysUtil.dealOrderBillDetailMsg(paramMap, (DynamicObject)entry);
            ErTripStdServiceImp stdService = new ErTripStdServiceImp();
            DynamicObject tripArea = stdService.getTripAreaByCityIdAndCompanyId(ErCommonUtils.getPk((Object)entry.get("trip2to")), ErCommonUtils.getPk((Object)areaUseOrg));
            entry.set("triparea_id", (Object)ErCommonUtils.getPk((Object)tripArea));
        }
        HashSet<Long> currencySet = new HashSet<Long>();
        Long headCurrencyId = ErCommonUtils.getPk((Object)targetBill.getDynamicObject("currency"));
        if (null != headCurrencyId) {
            currencySet.add(headCurrencyId);
        }
        DynamicObjectCollection entryentity = targetTripEntry.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            Long curryid;
            try {
                curryid = entry.getLong("entrycurrency");
            }
            catch (Exception e) {
                curryid = ErCommonUtils.getPk((Object)entry.get("entrycurrency"));
            }
            if (null == curryid) continue;
            currencySet.add(curryid);
        }
        if (currencySet.size() > 1) {
            targetBill.set("iscurrency", (Object)Boolean.TRUE);
        }
        TripReimburseServiceHelper.updateBillHeadAmount((DynamicObject)targetBill);
    }

    private Map<String, String> constructParamMap(DynamicObject order, DynamicObject entry) {
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        String orderformid = entry.getString("orderformid");
        paramMap.put("orderFormId", orderformid);
        switch (orderformid) {
            case "er_planebill": {
                paramMap.put("startDate", order.getString("takeofftime"));
                paramMap.put("endDate", order.getString("landingtime"));
                paramMap.put("sourceCity", order.getString("fromcityname"));
                paramMap.put("targetCity", order.getString("tocityname"));
                break;
            }
            case "er_hotelbill": {
                paramMap.put("targetCity", order.getString("cityname"));
                paramMap.put("startDate", order.getString("checkindate").substring(5, 10));
                paramMap.put("endDate", order.getString("checkoutdate").substring(5, 10));
                break;
            }
            case "er_trainbill": {
                paramMap.put("sourceCity", order.getString("departcity"));
                paramMap.put("targetCity", order.getString("arrivecity"));
                paramMap.put("startDate", order.getString("departtime"));
                paramMap.put("endDate", order.getString("arrivetime"));
                break;
            }
            case "er_mealbill": {
                paramMap.put("targetCity", order.getString("mealcityname"));
                paramMap.put("startDate", order.getString("mealtime"));
                paramMap.put("endDate", order.getString("mealtime"));
            }
        }
        return paramMap;
    }
}

