/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.up;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.utils.ErCommonUtils;

public class ErDailyAppleSelectBillPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String ENTRY_NAME = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
        AbstractGrid entryentity = (AbstractGrid)this.getControl(ENTRY_NAME);
        if (entryentity != null) {
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
    }

    protected void selectSameRow(RowClickEvent event) {
        EntryGrid entryGrid = (EntryGrid)event.getSource();
        int clickRowIndex = event.getRow();
        int currIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_NAME);
        if (currIndex == 0) {
            return;
        }
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_NAME);
        Set selectedRow = Arrays.stream(entryGrid.getSelectRows()).boxed().collect(Collectors.toSet());
        String billno = ((DynamicObject)entry.get(currIndex)).getString("billno");
        boolean isSelected = selectedRow.contains(clickRowIndex);
        for (int i = 0; i < entry.size(); ++i) {
            if (!((DynamicObject)entry.get(i)).getString("billno").equals(billno)) continue;
            if (isSelected) {
                selectedRow.add(i);
                continue;
            }
            selectedRow.remove(i);
        }
        entryGrid.selectRows(selectedRow.stream().mapToInt(Integer::intValue).toArray(), currIndex);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        model.setValue("writeofftype", customParams.get("writeofftype"));
        model.setValue("costorgusemode", customParams.get("costorgusemode"));
        Object billList = customParams.get("billlist");
        List bills = (List)billList;
        if (bills == null || bills.isEmpty()) {
            return;
        }
        int[] rowIndexs = model.batchCreateNewEntryRow(ENTRY_NAME, bills.size());
        Iterator iterator = bills.iterator();
        for (int rowIndex : rowIndexs) {
            Map row = (Map)iterator.next();
            for (Map.Entry entry : row.entrySet()) {
                if (model.getProperty((String)entry.getKey()) == null) continue;
                model.setValue((String)entry.getKey(), entry.getValue(), rowIndex);
            }
        }
        if (this.getView().getParentView() != null && this.getView().getParentView().getModel().getDataEntity().getDataEntityType().getProperties().containsKey((Object)"currency")) {
            Long currency = ErCommonUtils.getPk((Object)this.getView().getParentView().getModel().getValue("currency"));
            model.setValue("currency", (Object)currency);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_ok": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_NAME);
                int[] rowIndexs = entryGrid.getSelectRows();
                if (rowIndexs != null && rowIndexs.length > 0) {
                    this.getView().returnDataToParent(this.getAllSelectRows(rowIndexs));
                }
                this.getView().close();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
            }
        }
    }

    private Map<String, ListSelectedRowCollection> getAllSelectRows(int[] rowIndexs) {
        IDataModel model = this.getModel();
        HashMap<String, ListSelectedRowCollection> returnData = new HashMap<String, ListSelectedRowCollection>();
        int index = 0;
        for (int i : rowIndexs) {
            String formType = (String)model.getValue("formtype", i);
            ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData.get(formType);
            if (listSelectedRowCollection == null) {
                listSelectedRowCollection = new ListSelectedRowCollection();
                returnData.put(formType, listSelectedRowCollection);
            }
            ListSelectedRow listSelectedRow = new ListSelectedRow(model.getValue("billid", i), Boolean.valueOf(true));
            listSelectedRow.setBillNo((String)model.getValue("billno", i));
            listSelectedRow.setEntryEntityKey((String)model.getValue("entrykey", i));
            listSelectedRow.setEntryPrimaryKeyValue(model.getValue("entryid", i));
            listSelectedRow.setPageIndex(0);
            listSelectedRow.setRowKey(index++);
            listSelectedRow.setFormID(formType);
            listSelectedRowCollection.add((Object)listSelectedRow);
        }
        return returnData;
    }
}

