/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.up;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.Pair;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.trip.dailybiz.DailyReimCreateOrderEntrysUtil;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEnhancedConvertReportUtil;
import kd.fi.er.business.utils.ReimburseUpAppQfilterUtil;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.Recorder;
import kd.fi.er.formplugin.botp.up.ErAbstractBotpUpPlugin;
import kd.fi.er.formplugin.botp.up.service.BotpDrawServiceStdImpl;
import kd.fi.er.formplugin.botp.up.service.ValidBillArg;

public class ErDailyReimburseBotpUpPlugin
extends ErAbstractBotpUpPlugin
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(ErDailyReimburseBotpUpPlugin.class);

    public void registerListener(EventObject e) {
        AbstractGrid withholdingentry;
        AbstractGrid clearLoanEntry;
        super.registerListener(e);
        AbstractGrid writeoffapplyEntry = (AbstractGrid)this.getControl("writeoffapply");
        if (writeoffapplyEntry != null) {
            writeoffapplyEntry.addRowClickListener((RowClickEventListener)this);
            writeoffapplyEntry.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((clearLoanEntry = (AbstractGrid)this.getControl("writeoffmoney")) != null) {
            clearLoanEntry.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((withholdingentry = (AbstractGrid)this.getControl("withholdingentry")) != null) {
            withholdingentry.addHyperClickListener((HyperLinkClickListener)this);
        }
        this.addItemClickListeners(new String[]{"advcontoolbarap3"});
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof NewEntry) {
            NewEntry newEntry = (NewEntry)source;
            String operateKey = newEntry.getOperateKey();
            if ("addapplycheck".equalsIgnoreCase(operateKey)) {
                args.setCancel(true);
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("er_apply_draw");
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_apply_draw"));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                List bills = (List)this.getBillList(true);
                Iterator iterator = bills.iterator();
                for (int i = 0; i < bills.size(); ++i) {
                    Map row = (Map)iterator.next();
                    row.put("entrykey", "expenseentryentity");
                }
                formShowParameter.setCustomParam("billlist", (Object)bills);
                formShowParameter.setCustomParam("writeofftype", (Object)this.getWriteType());
                formShowParameter.setCustomParam("costorgusemode", this.getModel().getValue("costorgusemode"));
                this.getView().showForm(formShowParameter);
            }
        } else if (source instanceof DeleteEntry) {
            this.handleDeleteEvt(args, source);
            String operateKey = ((DeleteEntry)source).getOperateKey();
            if ("deleteapplyentry".equalsIgnoreCase(operateKey)) {
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("writeoffapply");
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("writeoffapply", entryCurrentRowIndex);
                if (entryRowEntity != null) {
                    args.setCancel(true);
                    Object sourceApplyBillId2 = entryRowEntity.get("sourceapplybillid");
                    this.getModel().deleteEntryRow("writeoffapply", entryCurrentRowIndex);
                    Map findTargetBills = BFTrackerServiceHelper.findTargetBills((String)"er_dailyapplybill", (Long[])new Long[]{Long.valueOf((String)sourceApplyBillId2)});
                    HashSet hashSet = (HashSet)findTargetBills.get("er_dailyloanbill");
                    if (hashSet != null) {
                        for (Object sourceApplyBillId2 : hashSet) {
                            this.deleteEntryBySourceBillId("writeoffmoney", "sourcebillid", sourceApplyBillId2);
                        }
                    }
                    this.recalculateAmount();
                }
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("chooseorder".equals(itemKey)) {
            int[] selectRows = this.getAssetSelectedRows();
            if (selectRows == null || selectRows.length < 1) {
                evt.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u8d39\u7528\u660e\u7ec6\u3002", (String)"ErDailyReimburseBotpUpPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (selectRows != null && selectRows.length > 1) {
                evt.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u8d39\u7528\u660e\u7ec6\u3002", (String)"ErDailyReimburseBotpUpPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("chooseorder".equals(key)) {
            this.openChooseOrder();
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("deleteapplyentry".equalsIgnoreCase(args.getOperateKey())) {
            // empty if block
        }
    }

    private void deleteEntryBySourceBillId(String entryName, String sourcebillName, Object sourcebillid) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryName);
        ArrayList deleteIndex = Lists.newArrayList();
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!sourcebillid.toString().equals(((DynamicObject)entryEntity.get(i)).get(sourcebillName))) continue;
            deleteIndex.add(i);
        }
        if (!deleteIndex.isEmpty()) {
            this.getModel().deleteEntryRows(entryName, deleteIndex.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    protected void openChooseOrder() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(this.getFormId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, showParameter.getFormId()));
        Map customParam = showParameter.getCustomParams();
        customParam.put("existOrderNums", this.getExistOrderNums());
        customParam.put("applier", ErCommonUtils.getPk((Object)this.getModel().getValue("applier")));
        customParam.put("creator", ErCommonUtils.getPk((Object)this.getModel().getValue("creator")));
        Object value = ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")), (String)"onlychoosetriporder");
        customParam.put("reqbillIds", this.getApplybillIds(value));
        customParam.put("onlychoosetriporder", value);
        customParam.put("companyId", ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
        this.getView().showForm(showParameter);
    }

    protected Object getBillList() {
        return this.getBillList(false);
    }

    protected Object getBillList(boolean includeApplierAndProjectOwer) {
        Long currency;
        String filterType;
        BotpDrawServiceStdImpl drawService = new BotpDrawServiceStdImpl(this.getModel(), this.getView());
        String selectFieds = "id as billid,billno,applier,org,company,description,bizdate,expenseentryentity.expenseitem as expenseitem,expenseentryentity.entrycurrency as entrycurrency,expenseentryentity.exchangerate as exchangerate,expenseentryentity.orgiexpebalanceamount as orgiexpebalanceamount,expenseentryentity.expebalanceamount as expebalanceamount,expenseentryentity.id as entryid,expenseentryentity.entrycostdept as costdept,expenseentryentity.std_entrycostcenter as costcenter,expenseentryentity.entrycostcompany as costcompany";
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"E");
        qFilter.and(new QFilter("expenseentryentity.orgiexpebalanceamount", ">", (Object)BigDecimal.ZERO));
        switch (filterType = ErCommonUtils.getEMParameter((long)this.getCompany(), (String)"relatapplybillfilterrange").toString()) {
            case "0": {
                if (includeApplierAndProjectOwer) {
                    qFilter.and(new QFilter("applier", "=", this.getApplier()).or("projectower.FBASEDATAID_id", "in", Collections.singletonList(this.getApplier())));
                } else {
                    qFilter.and(new QFilter("applier", "=", this.getApplier()));
                }
                qFilter.and(new QFilter("company", "=", (Object)this.getCompany()));
                break;
            }
            case "1": {
                qFilter.and(new QFilter("org", "=", (Object)this.getDept()));
                break;
            }
            case "2": {
                qFilter.and(new QFilter("company", "=", (Object)this.getCompany()));
                break;
            }
            case "4": {
                if (includeApplierAndProjectOwer) {
                    qFilter.and(new QFilter("applier", "=", this.getApplier()).or("projectower.FBASEDATAID_id", "in", Collections.singletonList(this.getApplier())));
                    break;
                }
                qFilter.and(new QFilter("applier", "=", this.getApplier()));
            }
        }
        qFilter.and(new QFilter("currency", "=", (Object)ErCommonUtils.getPk((Object)this.getModel().getValue("currency"))));
        if (this.getModel().getDataEntity().getDynamicObjectType().getProperties().containsKey((Object)"currency") && (currency = ErCommonUtils.getPk((Object)this.getView().getModel().getValue("currency"))) != null) {
            qFilter.and(new QFilter("currency", "=", (Object)currency));
        }
        QFilter reimbursetypeQfilter = null;
        if (this.getView().getModel().getProperty("reimbursetype") != null) {
            String reimbursetype = (String)this.getModel().getValue("reimbursetype");
            reimbursetypeQfilter = "expense".equals(reimbursetype) || " ".equals(reimbursetype) || "asset".equals(reimbursetype) || reimbursetype == null ? new QFilter("reimbursetype", "=", (Object)"expense").or("reimbursetype", "=", (Object)" ").or("reimbursetype", "=", (Object)"otherexpenses").or("reimbursetype", "=", null) : new QFilter("reimbursetype", "=", this.getModel().getValue("reimbursetype"));
            qFilter = ReimburseUpAppQfilterUtil.setBizitemFilter((IDataModel)this.getModel(), (QFilter)qFilter, (QFilter)reimbursetypeQfilter);
            qFilter.and(reimbursetypeQfilter);
        }
        log.info("---apply qFilter---", (Object)(qFilter != null ? qFilter.toString() : ""));
        ValidBillArg arg = new ValidBillArg("er_dailyapplybill", selectFieds, new QFilter[]{qFilter});
        return drawService.getValidBills(this.getExistPks(), arg);
    }

    protected String getFormId() {
        return "er_travel_up_order";
    }

    protected Set<String> getExistOrderNums() {
        HashSet<String> ordernums = new HashSet<String>(12);
        this.getEntryOrderNums(this.getView(), ordernums);
        return ordernums;
    }

    protected void getEntryOrderNums(IFormView view, Set<String> ordernums) {
        DynamicObjectCollection orderEntry = view.getModel().getEntryEntity("orderentry");
        orderEntry.stream().forEach(m -> {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)m.getString("ordernumber"))) {
                ordernums.add(m.getString("ordernumber"));
            }
        });
    }

    protected Set<Long> getApplybillIds(Object value) {
        HashSet<Long> applybillIds = new HashSet<Long>(2);
        if ("1".equals(value)) {
            this.getModel().getEntryEntity("writeoffapply").forEach(e -> e.getDynamicObjectCollection("writeoffapply_lk").forEach(m -> applybillIds.add(m.getLong("writeoffapply_lk_sbillid"))));
        }
        return applybillIds;
    }

    private Map<Long, List<Long>> getExistPks() {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("writeoffapply");
        if (entryEntity == null || entryEntity.size() < 1) {
            return result;
        }
        for (DynamicObject row : entryEntity) {
            long sourcebillid = row.getLong("sourceapplybillid");
            ArrayList<Long> entryIds = (ArrayList<Long>)result.get(sourcebillid);
            if (entryIds == null) {
                entryIds = new ArrayList<Long>();
                result.put(sourcebillid, entryIds);
            }
            entryIds.add(row.getLong("sourceapplyentryid"));
        }
        return result;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        BotpDrawServiceStdImpl drawService = new BotpDrawServiceStdImpl(this.getModel(), this.getView());
        int expenseIndex = -1;
        if (actionId.equals("er_apply_draw")) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData != null) {
                ArrayList<DynamicObject> dataEntitysDyn = new ArrayList<DynamicObject>();
                ArrayList<ConvertOperationResult> convertResults = new ArrayList<ConvertOperationResult>(10);
                Recorder existFail = new Recorder((Object)new Pair((Object)false, (Object)new DrawArgs()));
                for (Map.Entry<String, ListSelectedRowCollection> entry : returnData.entrySet()) {
                    List<DynamicObject> drawResult = drawService.draw(entry, convertResults, (Recorder<Pair<Boolean, DrawArgs>>)existFail);
                    dataEntitysDyn.addAll(drawResult);
                }
                if (((Boolean)((Pair)existFail.getRecord()).getKey()).booleanValue()) {
                    ErEnhancedConvertReportUtil.showEnhancedConvertReport(convertResults, (DrawArgs)((DrawArgs)((Pair)existFail.getRecord()).getValue()), (IFormView)this.getView());
                }
                if (!dataEntitysDyn.isEmpty()) {
                    drawService.paint(dataEntitysDyn);
                }
                if (this.getModel().getProperty("withholdingentry") != null && this.getModel().getEntryRowCount("withholdingentry") > 0) {
                    this.getView().updateView("withholdingentry");
                    AdvContainer whadvconap = (AdvContainer)this.getView().getControl("whadvconap");
                    if (whadvconap != null) {
                        whadvconap.setCollapse(false);
                    }
                }
            }
            this.getView().updateView("expenseentryentity");
            if (this.getModel().getProperty("writeoffmoney") != null && this.getModel().getDataEntity(true).getDynamicObjectCollection("writeoffmoney").size() > 0) {
                AdvContainer advContainer = (AdvContainer)this.getView().getControl("advconap");
                advContainer.setCollapse(false);
            }
        }
        if (this.getFormId().equals(closedCallBackEvent.getActionId())) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            if (map == null || map.size() == 0) {
                return;
            }
            List list = (List)map.get("entryentity");
            Long companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
            companyId = companyId == null ? Long.valueOf(0L) : companyId;
            Set ordernums = list.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            List orders = TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByOrderId(ordernums, (Long)companyId, (Boolean)false);
            if (orders.size() == 0) {
                log.info("\u672a\u62a5\u9500\u8ba2\u5355\u6570\u4e3a0return---------");
                return;
            }
            IFormView iFormView = this.getView();
            IDataModel model2 = this.getModel();
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            String formId = iFormView.getFormShowParameter().getFormId();
            expenseIndex = model2.getEntryCurrentRowIndex("expenseentryentity");
            if (expenseIndex == -1) {
                log.info("\u672a\u53d6\u5230\u5f53\u524d\u9009\u4e2d\u8d39\u7528\u660e\u7ec6\u884cindex return---------");
                return;
            }
            DynamicObject expenseEntry = (DynamicObject)dynamicObject.getDynamicObjectCollection("expenseentryentity").get(expenseIndex);
            DynamicObjectCollection orderEntries = dynamicObject.getDynamicObjectCollection("orderentry");
            DailyReimCreateOrderEntrysUtil.initOrderEntrys((DynamicObject)dynamicObject, (DynamicObject)expenseEntry, (DynamicObjectCollection)orderEntries, (List)orders, (boolean)true, null, null, (String)formId, null);
        }
        if ((model = this.getModel()).getProperty("orderentry") != null && model.getEntryRowCount("orderentry") > 0) {
            IFormView view = this.getView();
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection expenseEntrys = dataEntity.getDynamicObjectCollection("expenseentryentity");
            for (DynamicObject dynamicObject : expenseEntrys) {
                if (!dynamicObject.getBoolean("isexistmonthly")) continue;
                String odernumStr = DailyReimCreateOrderEntrysUtil.getAllOrderNumStr((DynamicObjectCollection)model.getEntryEntity("orderentry"), (Long)dynamicObject.getLong("id"));
                dynamicObject.set("ordernum", (Object)odernumStr);
            }
            BigDecimal monthsettleamount = dataEntity.getBigDecimal("monthsettleamount");
            model.setValue("monthsettleamount", (Object)0);
            model.setValue("monthsettleamount", (Object)monthsettleamount);
            view.updateView("orderentry");
            view.updateView("expenseentryentity");
            int n = model.getEntryRowCount("orderentry");
            AdvContainer advContainer = (AdvContainer)this.getView().getControl("order_advconap");
            EntryGrid entryGrid = (EntryGrid)this.getControl("expenseentryentity");
            if (n > 0) {
                if (advContainer != null) {
                    advContainer.setCollapse(false);
                }
                if (null != entryGrid && expenseIndex >= 0) {
                    entryGrid.selectRows(new int[]{expenseIndex}, expenseIndex);
                }
            }
        }
    }

    private int[] getAssetSelectedRows() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("expenseentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        return selectRows;
    }

    @Override
    protected Map<Long, List<Long>> getFilterBill() {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("writeoffmoney");
        if (entryEntity == null || entryEntity.size() < 1) {
            return result;
        }
        for (DynamicObject row : entryEntity) {
            long sourcebillid = row.getLong("sourcebillid");
            ArrayList<Long> entryIds = (ArrayList<Long>)result.get(sourcebillid);
            if (entryIds == null) {
                entryIds = new ArrayList<Long>();
                result.put(sourcebillid, entryIds);
            }
            entryIds.add(row.getLong("sourceentryid"));
        }
        return result;
    }

    @Override
    protected void updateEntriesView() {
        this.getView().updateView("expenseentryentity");
        this.getView().updateView("withholdingentry");
        int entryRowCount = this.getModel().getEntryRowCount("withholdingentry");
        AdvContainer whadvconap = (AdvContainer)this.getView().getControl("whadvconap");
        if (entryRowCount > 0 && whadvconap != null) {
            whadvconap.setCollapse(false);
        }
    }

    @Override
    protected String getOperateKey() {
        return "newaccentry";
    }

    @Override
    protected void recalculateAmount() {
        DynamicObjectCollection expense;
        IDataModel dataModel = this.getModel();
        boolean modify = true;
        if (modify && (expense = dataModel.getDataEntity(true).getDynamicObjectCollection("expenseentryentity")) != null && expense.size() > 0) {
            BigDecimal approveCurrAmountOld = (BigDecimal)dataModel.getValue("expeapprovecurramount", 0);
            dataModel.beginInit();
            dataModel.setValue("expeapprovecurramount", (Object)0, 0);
            dataModel.endInit();
            dataModel.setValue("expeapprovecurramount", (Object)approveCurrAmountOld, 0);
        }
        IBillView billView = (IBillView)this.getView();
        billView.updateView("advconap");
        billView.updateView("advconap21");
    }

    @Override
    protected String getRuleId(String entityName) {
        if ("er_dailyloanbill".equals(entityName)) {
            return "508550209765139456";
        }
        return "509107801872743424";
    }

    @Override
    protected boolean getWriteType() {
        return WriteOffTypeEnum.CURR_WO.getValue().equals(this.getPageCache().get("writeOffType"));
    }

    @Override
    protected Long getCostCompany() {
        DynamicObject costCompany = (DynamicObject)this.getModel().getValue("costcompany");
        return costCompany == null ? 0L : costCompany.getLong("id");
    }

    @Override
    protected Long getCompany() {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        return company == null ? 0L : company.getLong("id");
    }

    @Override
    protected Long getDept() {
        DynamicObject dept = (DynamicObject)this.getModel().getValue("org");
        return dept == null ? 0L : dept.getLong("id");
    }

    @Override
    protected Object getApplier() {
        DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
        return applier == null ? null : applier.getPkValue();
    }

    @Override
    protected String getDetailType() {
        return "";
    }

    @Override
    protected DynamicObject mergeResult(List<DynamicObject> dataEntitysDyn) {
        DynamicObject result = dataEntitysDyn.get(0);
        HashSet<String> contains = new HashSet<String>();
        DynamicObjectCollection clearLoanEntry = result.getDynamicObjectCollection("writeoffmoney");
        for (DynamicObject clearRow : clearLoanEntry) {
            contains.add(clearRow.getString("sourceentryid") + clearRow.getString("sourcebillid"));
        }
        for (int i = 1; i < dataEntitysDyn.size(); ++i) {
            DynamicObject temp = dataEntitysDyn.get(i);
            DynamicObjectCollection tempClearLoanEntry = temp.getDynamicObjectCollection("writeoffmoney");
            for (DynamicObject tempClearRow : tempClearLoanEntry) {
                String conStr = tempClearRow.getString("sourceentryid") + tempClearRow.getString("sourcebillid");
                if (contains.contains(conStr)) continue;
                clearLoanEntry.add((Object)tempClearRow);
            }
        }
        return result;
    }

    @Override
    protected String getDelelteOperateKey() {
        return "deleteaccentry";
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String openBillId = null;
        String openBillType = null;
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if ("loanbillnov1".equals(hyperLinkClickEvent.getFieldName())) {
            openBillId = (String)this.getModel().getValue("sourcebillid", rowIndex);
            openBillType = (String)this.getModel().getValue("srcbilltype", rowIndex);
        } else if ("applybillno".equals(hyperLinkClickEvent.getFieldName())) {
            openBillId = (String)this.getModel().getValue("sourceapplybillid", rowIndex);
        } else if ("withholdingbillno".equals(hyperLinkClickEvent.getFieldName())) {
            openBillId = Long.toString((Long)this.getModel().getValue("whsrcbillid", rowIndex));
            openBillType = (String)this.getModel().getValue("whsrcbilltype", rowIndex);
        }
        if (openBillId != null && !openBillId.isEmpty()) {
            if (StringUtils.isEmpty((CharSequence)openBillType)) {
                openBillType = this.getOpenBillType(openBillId);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u8f6c\u6362\u89c4\u5219\u914d\u7f6e\u6709\u8bef\uff1a\u4e1a\u52a1\u8f6c\u6362\u89c4\u5219\u4e2d\u672a\u914d\u7f6e\u4e0a\u6e38\u5355\u636eID\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ErDailyReimburseBotpUpPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        if (openBillType != null && !openBillType.isEmpty()) {
            this.openLinkedForm(openBillId, openBillType);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "costcompany": {
                this.clearLoanEntry();
            }
        }
    }

    private void clearLoanEntry() {
        RefObject<int[]> refObject;
        String publicupbillrange;
        RefObject<int[]> refObject2;
        Long companyId = this.getCompany();
        String loaRangeType = SystemParamterUtil.getLoanDrawRange((Long)companyId);
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("writeoffmoney");
        if (StringUtils.equals((CharSequence)loaRangeType, (CharSequence)"1") && (refObject2 = this.getIndexs(collection, Arrays.asList("er_dailyloanbill", "er_tripreqbill"))).getValue() != null && ((int[])refObject2.getValue()).length > 0) {
            this.getModel().deleteEntryRows("writeoffmoney", (int[])refObject2.getValue());
        }
        if (("1".equals(publicupbillrange = SystemParamterUtil.getPublicupbillrange((Long)companyId)) || "4".equals(publicupbillrange)) && (refObject = this.getIndexs(collection, Collections.singletonList("er_prepaybill"))).getValue() != null && ((int[])refObject.getValue()).length > 0) {
            this.getModel().deleteEntryRows("writeoffmoney", (int[])refObject.getValue());
        }
    }

    private RefObject<int[]> getIndexs(DynamicObjectCollection collection, List list) {
        RefObject refObject = new RefObject();
        ArrayList<Integer> arr = new ArrayList<Integer>(5);
        for (int i = 0; i < collection.size(); ++i) {
            if (!list.contains(((DynamicObject)collection.get(i)).get("srcbilltype"))) continue;
            arr.add(i);
        }
        if (arr.size() > 0) {
            int[] a = new int[arr.size()];
            int index = 0;
            for (Integer i : arr) {
                a[index++] = i;
            }
            refObject.setValue((Object)a);
        }
        return refObject;
    }
}

