/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.budget;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;
import org.apache.commons.lang3.StringUtils;

public class BillShowBudget
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(BillShowBudget.class);

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Long companyId = null;
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company != null) {
            companyId = (Long)company.getPkValue();
        }
        if (companyId == null) {
            companyId = RequestContext.get().getOrgId();
        }
        String formId = view.getEntityId();
        boolean isShowBudget = BudgetCommonUtil.isShowBudget(formId, companyId);
        String budgeMsgValue = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"budgeMsgControl");
        this.setBudgetMsgControl(budgeMsgValue);
        String showBudgetStatus = "A,B,C,D";
        String billStatus = (String)model.getValue("billstatus");
        boolean isBudgetStatus = Boolean.FALSE;
        if (billStatus != null && showBudgetStatus.contains(billStatus)) {
            isBudgetStatus = Boolean.TRUE;
        }
        if (!isShowBudget) {
            view.setVisible(Boolean.FALSE, new String[]{"viewbudget"});
            view.setVisible(Boolean.FALSE, new String[]{"budgetamount"});
            view.setVisible(Boolean.FALSE, new String[]{"budgetmsg"});
            view.setVisible(Boolean.FALSE, new String[]{"flex_budget"});
            view.setVisible(Boolean.FALSE, new String[]{"lab_budgetbalance"});
            view.setVisible(Boolean.FALSE, new String[]{"entrybudgetamount"});
            view.setVisible(Boolean.FALSE, new String[]{"entrybudgetmsg"});
        }
        if (!isBudgetStatus) {
            view.setVisible(Boolean.FALSE, new String[]{"budgetamount"});
            view.setVisible(Boolean.FALSE, new String[]{"budgetmsg"});
            view.setVisible(Boolean.FALSE, new String[]{"flex_budget"});
            view.setVisible(Boolean.FALSE, new String[]{"lab_budgetbalance"});
            view.setVisible(Boolean.FALSE, new String[]{"entrybudgetamount"});
            view.setVisible(Boolean.FALSE, new String[]{"entrybudgetmsg"});
        }
        if (BudgetCommonUtil.getIsQueryEASBudgetFlag(this.getPageCache())) {
            view.setVisible(Boolean.TRUE, new String[]{"budgetamount"});
        }
        BudgetCommonUtil.setIsQueryBudgetFlag(this.getPageCache(), false);
        if (ErEntityTypeUtils.isRepaymentBill((String)formId)) {
            return;
        }
        if (isShowBudget && isBudgetStatus) {
            this.controlBudgeIsVisible(view, budgeMsgValue);
            BudgetCommonUtil.setIsQueryBudgetFlag(this.getPageCache(), true);
            if (BudgetCommonUtil.isTripReimGrid(view)) {
                model.setValue("showbudgetposition", (Object)SystemParamterUtil.getShowBudgetPosition((Long)companyId));
                if ("0".equals(model.getValue("showbudgetposition"))) {
                    view.setVisible(Boolean.FALSE, new String[]{"lab_budgetbalance"});
                } else {
                    view.setVisible(Boolean.FALSE, new String[]{"entrybudgetamount"});
                    view.setVisible(Boolean.FALSE, new String[]{"entrybudgetmsg"});
                }
            }
            if (model.getProperty("showbudgetposition") != null) {
                logger.info("\u8c03\u7528\u9884\u7b97\u63a5\u53e3\u524dshowbudgetposition:" + model.getValue("showbudgetposition"));
            }
            if (BudgetCommonUtil.isTripReimGrid(view) && "1".equals(model.getValue("showbudgetposition")) || StringUtils.equals((CharSequence)"er_tripreim_grid_mb", (CharSequence)view.getFormShowParameter().getFormId())) {
                BudgetCommonUtil.buildBudgetAmountFieldByHead(view);
            } else {
                BudgetCommonUtil.buildBudgetAmountField(view);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ("company".equalsIgnoreCase(propName)) {
            this.refreshIsQueryBudget();
            return;
        }
        if (!BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache())) {
            return;
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ((BudgetCommonUtil.isTripReimGrid(view) || StringUtils.equals((CharSequence)"er_tripreim_grid_mb", (CharSequence)view.getFormShowParameter().getFormId())) && "1".equals((String)model.getValue("showbudgetposition"))) {
            this.buildHeadBgLable(propName, view);
            return;
        }
        boolean isPc = !(view instanceof IMobileView);
        boolean isDailyBill = false;
        if (model.getProperty("expenseitem") != null && "expenseentryentity".equalsIgnoreCase(model.getProperty("expenseitem").getParent().getName())) {
            isDailyBill = true;
        }
        switch (propName) {
            case "bizdate": 
            case "signdate": 
            case "fiperiod": 
            case "costcompany": {
                if (BudgetCommonUtil.isTripReimGrid(view)) {
                    DynamicObjectCollection expenseEntryEntity;
                    DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)model.getDataEntity(true).get("tripentry");
                    if (dynamicObjects.size() <= 0 || (expenseEntryEntity = ((DynamicObject)dynamicObjects.get(0)).getDynamicObjectCollection("entryentity")).size() <= 0) break;
                    for (int i = 0; i < expenseEntryEntity.size(); ++i) {
                        BudgetCommonUtil.buildBudgetAmountField(view, i);
                    }
                    break;
                }
                BudgetCommonUtil.buildBudgetAmountField(view);
                break;
            }
            case "costdept": {
                String costDeptShowType = CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView());
                if (!"1".equals(costDeptShowType)) break;
                BudgetCommonUtil.buildBudgetAmountField(view);
                break;
            }
            case "entrycostdept": 
            case "entrycostcompany": {
                DynamicObject entryCostCompany = (DynamicObject)model.getValue("entrycostcompany", rowIndex);
                if (isDailyBill && model.getValue("expenseitem", rowIndex) == null || entryCostCompany == null || ((Long)entryCostCompany.getPkValue()).compareTo(0L) == 0) break;
                if (isDailyBill && isPc) {
                    BudgetCommonUtil.buildBudgetAmountField(view, rowIndex);
                    break;
                }
                BudgetCommonUtil.buildBudgetAmountField(view);
                break;
            }
            case "expenseitem": 
            case "std_project": 
            case "happendate": 
            case "std_entrycostcenter": {
                if ("std_entrycostcenter".equals(propName) && model.getValue(propName, rowIndex) == null || !isDailyBill && !BudgetCommonUtil.isTripReimGrid(view)) break;
                if (isPc) {
                    int rowindex = e.getChangeSet()[0].getRowIndex();
                    BudgetCommonUtil.buildBudgetAmountField(view, rowindex);
                    break;
                }
                BudgetCommonUtil.buildBudgetAmountField(view);
                break;
            }
            case "travelexpenseitem": 
            case "travelcostdept": 
            case "travelcostcompany": {
                if (!BudgetCommonUtil.isTripReimGrid(view) || model.getValue("travelexpenseitem", rowIndex) == null) break;
                int rowindex = e.getChangeSet()[0].getRowIndex();
                BudgetCommonUtil.buildBudgetAmountField(view, rowindex);
            }
        }
    }

    private void buildHeadBgLable(String propName, IFormView view) {
        String extBudgetProp = ErStdConfig.getBudgetPropExt();
        String splitStr = ",";
        StringBuilder props = new StringBuilder();
        props.append(extBudgetProp).append(splitStr).append("bizdate").append(splitStr).append("costdept").append(splitStr).append("headexpenseitem").append(splitStr).append("headproject");
        if (props.toString().contains(propName)) {
            BudgetCommonUtil.buildBudgetAmountFieldByHead(view);
        }
    }

    protected void refreshIsQueryBudget() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Long company = 0L;
        if (model.getValue("company") != null) {
            company = (Long)((DynamicObject)model.getValue("company")).getPkValue();
        }
        if (company == null || company.compareTo(0L) == 0) {
            company = RequestContext.get().getOrgId();
        }
        String formId = this.getView().getEntityId();
        boolean isShowBudget = BudgetCommonUtil.isShowBudget(formId, company);
        String budgeMsgValue = (String)ErCommonUtils.getEMParameter((long)company, (String)"budgeMsgControl");
        view.setVisible(Boolean.valueOf(isShowBudget), new String[]{"viewbudget"});
        if (!isShowBudget) {
            view.setVisible(Boolean.FALSE, new String[]{"viewbudget"});
            view.setVisible(Boolean.FALSE, new String[]{"budgetamount"});
            view.setVisible(Boolean.FALSE, new String[]{"budgetmsg"});
            view.setVisible(Boolean.FALSE, new String[]{"flex_budget"});
            view.setVisible(Boolean.FALSE, new String[]{"lab_budgetbalance"});
            view.setVisible(Boolean.FALSE, new String[]{"entrybudgetamount"});
            view.setVisible(Boolean.FALSE, new String[]{"entrybudgetmsg"});
        } else if ("0".equals(budgeMsgValue)) {
            view.setVisible(Boolean.TRUE, new String[]{"budgetamount"});
            view.setVisible(Boolean.TRUE, new String[]{"entrybudgetamount"});
            view.setVisible(Boolean.FALSE, new String[]{"budgetmsg"});
            view.setVisible(Boolean.FALSE, new String[]{"entrybudgetmsg"});
        } else if ("1".equals(budgeMsgValue)) {
            view.setVisible(Boolean.TRUE, new String[]{"budgetmsg"});
            view.setVisible(Boolean.TRUE, new String[]{"entrybudgetmsg"});
            view.setVisible(Boolean.FALSE, new String[]{"budgetamount"});
            view.setVisible(Boolean.FALSE, new String[]{"entrybudgetamount"});
        }
        view.setVisible(Boolean.valueOf(isShowBudget), new String[]{"flex_budget"});
        view.setVisible(Boolean.valueOf(isShowBudget), new String[]{"lab_budgetbalance"});
        BudgetCommonUtil.setIsQueryBudgetFlag(this.getPageCache(), isShowBudget);
        boolean dataChange = model.getDataChanged();
        model.setValue("isquerybudget", (Object)isShowBudget);
        model.setDataChanged(dataChange);
    }

    private void controlBudgeIsVisible(IFormView view, String budgeMsgValue) {
        if (StringUtils.isEmpty((CharSequence)budgeMsgValue)) {
            this.dynamicDisplay(view, "budgetamount", "budgetmsg", "entrybudgetmsg", Boolean.TRUE, Boolean.FALSE);
            return;
        }
        switch (budgeMsgValue) {
            case "0": {
                this.dynamicDisplay(view, "budgetamount", "budgetmsg", "entrybudgetmsg", Boolean.TRUE, Boolean.FALSE);
                break;
            }
            case "1": {
                view.setVisible(Boolean.TRUE, new String[]{"budgetmsg"});
                this.dynamicDisplay(view, "entrybudgetmsg", "budgetamount", "entrybudgetamount", Boolean.FALSE, Boolean.TRUE);
            }
        }
    }

    private void setBudgetMsgControl(String value) {
        IDataModel model = this.getModel();
        String formId = this.getView().getEntityId();
        if (StringUtils.isEmpty((CharSequence)formId) || !ErEntityTypeUtils.isTripReimburseBill((String)formId) && !ErEntityTypeUtils.isTripReqBill((String)formId)) {
            return;
        }
        model.setValue("budgetmsgcontrol", (Object)value);
    }

    private void dynamicDisplay(IFormView view, String budgetAmountField, String budgetMsgField, String entryBudgetMsgField, Boolean aTrue, Boolean aFalse) {
        Control tripentry;
        boolean isPc;
        view.setVisible(Boolean.TRUE, new String[]{budgetAmountField});
        view.setVisible(Boolean.FALSE, new String[]{budgetMsgField});
        view.setVisible(Boolean.FALSE, new String[]{entryBudgetMsgField});
        boolean bl = isPc = !(view instanceof IMobileView);
        if (!BudgetCommonUtil.isTripReimGrid(view) && isPc && (tripentry = view.getControl("tripentry")) instanceof CardEntry) {
            CardEntry cardEntry = (CardEntry)tripentry;
            for (int i = 0; i < this.getModel().getEntryRowCount("tripentry"); ++i) {
                cardEntry.setChildVisible(aTrue.booleanValue(), i, new String[]{"cardentryflexpanelap4"});
                cardEntry.setChildVisible(aFalse.booleanValue(), i, new String[]{"budgetmsgcardentry"});
            }
        }
    }
}

