/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.web.tripstandard.util.TripStandardUtils;
import org.apache.commons.lang3.StringUtils;

public class ErMyTripStandardPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(ErMyTripStandardPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        if (e.getSource() instanceof FormShowParameter && ((FormShowParameter)e.getSource()).getStatus().equals((Object)OperationStatus.ADDNEW)) {
            Long companyId = TripStandardUtils.getCurrentUserCompanyId();
            if (companyId == null) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"CoreBaseBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isOpenHighSeason = SystemParamterUtil.isEnableHighSeasonTripStandard((Long)companyId);
            if (!isOpenHighSeason) {
                ((FormShowParameter)e.getSource()).setStatus(OperationStatus.VIEW);
            }
        }
    }

    public void registerListener(EventObject e) {
        this.initAccmodation();
    }

    public void afterCreateNewData(EventObject e) {
        this.initAccmodation();
    }

    protected void initAccmodation() {
        Long userID = Long.valueOf(RequestContext.get().getUserId());
        Long companyId = TripStandardUtils.getCurrentUserCompanyId();
        boolean isOpenHighSeason = SystemParamterUtil.isEnableHighSeasonTripStandard((Long)companyId);
        this.getModel().setValue("highseasontripstd", (Object)isOpenHighSeason);
        log.info(String.format("\u5f53\u524d\u7528\u6237\u4e3a\uff1a%d, \u5f53\u524d\u7528\u6237\u975e\u517c\u804c\u90e8\u95e8\u6240\u5728\u516c\u53f8\u4e3a\uff1a%d,\u6240\u5728\u7ec4\u7ec7:%d", userID, companyId, RequestContext.get().getOrgId()));
        if (companyId == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u201c%1$s\u201d\u6240\u5728\u7ec4\u7ec7\u201c%2$s\u201d\u672a\u67e5\u8be2\u5176\u6240\u5728\u7684\u516c\u53f8\uff0c\u8bf7\u8bbe\u7f6e\u516c\u53f8\u3002", (String)"ErMyTripStandardPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), userID, RequestContext.get().getOrgId()));
            return;
        }
        String airStd = this.getVehicleStdByUserIDAndVehicleType(userID, "air", companyId);
        this.getLable("lab_planestd").setText(StringUtils.isEmpty((CharSequence)airStd) ? ResManager.loadKDString((String)"\u6682\u672a\u8bbe\u7f6e\u6807\u51c6", (String)"ErMyTripStandardPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]) : airStd);
        String trainStd = this.getVehicleStdByUserIDAndVehicleType(userID, "train", companyId);
        this.getLable("lab_trainstd").setText(StringUtils.isEmpty((CharSequence)trainStd) ? ResManager.loadKDString((String)"\u6682\u672a\u8bbe\u7f6e\u6807\u51c6", (String)"ErMyTripStandardPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]) : trainStd);
        String shipStd = this.getVehicleStdByUserIDAndVehicleType(userID, "ship", companyId);
        this.getLable("lab_shipstd").setText(StringUtils.isEmpty((CharSequence)shipStd) ? ResManager.loadKDString((String)"\u6682\u672a\u8bbe\u7f6e\u6807\u51c6", (String)"ErMyTripStandardPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]) : shipStd);
        ErTripStdServiceImp tripStdService = new ErTripStdServiceImp();
        final DynamicObject[] accmodationStds = tripStdService.getAccmodationStdByUserId(userID, companyId);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                if (accmodationStds != null && accmodationStds.length > 0) {
                    log.info("\u5f53\u524d\u7528\u6237\u7684\u4f4f\u5bbf/\u8865\u52a9\u6807\u6ce8:" + SerializationUtils.toJsonString((Object)accmodationStds));
                    setFilterEvent.getQFilters().add(new QFilter("id", "in", Arrays.stream(accmodationStds).map(acc -> acc.getPkValue()).collect(Collectors.toList())));
                    setFilterEvent.setOrderBy("number");
                } else {
                    log.info("\u5f53\u524d\u7528\u6237\u672a\u67e5\u8be2\u5230\u53ef\u7528\u7684\u4f4f\u5bbf/\u8865\u52a9\u6807\u51c6");
                    setFilterEvent.getQFilters().add(QFilter.of((String)"id is null", (Object[])new Object[0]));
                }
            }
        });
    }

    protected String getVehicleStdByUserIDAndVehicleType(Long userId, String vehicleType, Long companyId) {
        ErTripStdServiceImp tripStdService = new ErTripStdServiceImp();
        DynamicObject vehicleStd = tripStdService.getVehicleStdByUserIdAndVehicleType(userId, vehicleType, companyId);
        if (vehicleStd == null) {
            log.info(String.format("\u672a\u67e5\u8be2\u5230\u60a8(id=%d)\u5df2\u5ba1\u6838\u7684%s\u5dee\u65c5\u6807\u51c6\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", userId, vehicleType));
            return "";
        }
        return ErMyTripStandardPlugin.unionArrays(Arrays.asList(vehicleStd.getString("cabinstr").split(",")), "\u3001 ");
    }

    protected static String unionArrays(List<String> strs, String split) {
        StringBuilder sb = new StringBuilder();
        if (strs == null || strs.size() == 0) {
            return "";
        }
        if (strs.size() == 1) {
            return strs.get(0);
        }
        strs.forEach(s -> {
            sb.append((String)s);
            sb.append(split);
        });
        return sb.subSequence(0, sb.lastIndexOf(split)).toString();
    }

    protected Label getLable(String key) {
        return (Label)this.getView().getControl(key);
    }
}

