/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.botp;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.daily.botp.AbstractToReimburseBotpPlugin;
import org.apache.commons.lang3.ObjectUtils;

public abstract class CheckingBillToReimBotpPlugin
extends AbstractToReimburseBotpPlugin {
    private static Log logger = LogFactory.getLog(CheckingBillToReimBotpPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("currency");
        e.addSrcField("company");
        e.addSrcField("server");
        e.addSrcField("formid");
        e.addSrcField("id");
        e.addSrcField("totalamount");
        e.addSrcField("orderstatus");
        e.addSrcField("allorderbase");
        e.addSrcField("settlemain");
        e.addSrcField("settledept");
        e.addSrcField("happenddate");
        e.addSrcField("bizdate");
    }

    @Override
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            Long userId = CommonServiceHelper.getCurrentUserID();
            Map userMap = CoreBaseBillServiceHelper.createNewData((Long)userId);
            logger.info("\u7ed3\u7b97\u5355\u4e0b\u63a8\u62a5\u9500\u5355 ============> \u5f53\u524d\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)userMap.toString());
            DynamicObject dept = (DynamicObject)userMap.get("org");
            if (dept != null) {
                Long deptId = (Long)dept.getPkValue();
                targetBill.set("org_id", (Object)deptId);
                Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
                logger.info("\u7528\u9910\u7ed3\u7b97\u5355\u4e0b\u63a8\u62a5\u9500\u5355 ============> \u5f53\u524d\u7528\u6237\u4fe1\u606f\u7533\u8bf7\u4eba\u516c\u53f8\uff1a{}", (Object)JSON.toJSONString((Object)company));
                if (company != null) {
                    targetBill.set("company_id", company.get("id"));
                    DynamicObject currencyObject = BaseCurrencyServiceHelper.getBaseCurrencyObject(company.get("id"), (Object)billDataEntity.getValue("costcompany_id"));
                    if (currencyObject != null) {
                        targetBill.set("currency", (Object)currencyObject);
                        targetBill.set("currency_id", currencyObject.getPkValue());
                    }
                }
            }
            targetBill.set("tel", userMap.get("tel"));
            targetBill.set("applier_id", userMap.get("applier"));
            targetBill.set("applierpositionstr", userMap.get("applierpositionstr"));
            targetBill.set("bizdate", (Object)TimeServiceHelper.getCurrentSystemTime());
            targetBill.set("creator_id", (Object)CommonServiceHelper.getCurrentUserID());
            targetBill.set("billstatus", (Object)"A");
        }
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        super.afterCreateLink(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        if (null == billDataEntitys || billDataEntitys.length == 0) {
            logger.info("\u7ed3\u7b97\u5355\u4e0b\u63a8\u62a5\u9500\u5355 ============> \u76ee\u6807\u5355\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            DynamicObject currency = targetBill.getDynamicObject("currency");
            if (null == currency) {
                logger.info("\u7ed3\u7b97\u5355\u4e0b\u63a8\u62a5\u9500\u5355 ============> \u76ee\u6807\u5355\u5e01\u79cd\u6570\u636e\u4e3a\u7a7a");
                continue;
            }
            Long currencyId = Long.parseLong(currency.getPkValue().toString());
            int curPrecision = AmountUtils.getCurrencyPrecision((Object)currency.getPkValue());
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            if (null == srcRows) {
                logger.info("\u7ed3\u7b97\u5355\u4e0b\u63a8\u62a5\u9500\u5355 ============> \u539f\u5355\u884c\u6570\u636e\u4e3a\u7a7a");
                continue;
            }
            DynamicObjectCollection expenseentryentitys = targetBill.getDynamicObjectCollection("expenseentryentity");
            if (null == expenseentryentitys || expenseentryentitys.isEmpty()) {
                logger.info("\u7ed3\u7b97\u5355\u4e0b\u63a8\u62a5\u9500\u5355 ============> \u76ee\u6807\u5355\u8d39\u7528\u660e\u7ec6\u4e3a\u7a7a");
                continue;
            }
            Long companyId = targetBill.getLong("company_id");
            Long costcompanyId = targetBill.getLong("costcompany_id");
            DynamicObject costCompany = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costcompanyId)});
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            Date happenddate = (Date)((DynamicProperty)e.getFldProperties().get("happenddate")).getValue((Object)srcRow);
            String description = this.generateDescription(costCompany, happenddate);
            billDataEntity.setValue("description", (Object)description);
            for (int i = 0; i < expenseentryentitys.size(); ++i) {
                DynamicObject expenseentryentity = (DynamicObject)expenseentryentitys.get(i);
                DynamicObject entrycurrency = expenseentryentity.getDynamicObject("entrycurrency");
                if (null == entrycurrency) {
                    logger.info("\u7528\u9910\u7ed3\u7b97\u5355\u4e0b\u63a8\u62a5\u9500\u5355 ============> \u76ee\u6807\u5355\u8d39\u7528\u660e\u7ec6\u5e01\u79cd\u6570\u636e\u4e3a\u7a7a");
                    continue;
                }
                if (!currencyId.toString().equals(entrycurrency.getPkValue().toString())) {
                    targetBill.set("iscurrency", (Object)1);
                }
                Long entryCurrencyId = Long.parseLong(entrycurrency.getPkValue().toString());
                Long entryCostCompanyId = ErCommonUtils.getPk((Object)expenseentryentity.getDynamicObject("entrycostcompany"));
                Long entryCostDeptId = ErCommonUtils.getPk((Object)expenseentryentity.getDynamicObject("entrycostdept"));
                logger.info("\u7528\u8f66\u7ed3\u7b97\u5355\u4e0b\u63a8\u5bf9\u516c\u62a5\u9500\u5355 ============> \u8d39\u7528\u627f\u62c5\u516c\u53f8\uff1a{}\uff0c\u8d39\u7528\u627f\u62c5\u90e8\u95e8\uff1a{}", (Object)entryCostCompanyId, (Object)entryCostDeptId);
                Map exchangeMap = CommonServiceHelper.getExchangeRateFromSysParams((Object)companyId, (Object)entryCostCompanyId, (Long)entryCurrencyId, (Long)currencyId, (Object)targetBill.get("bizdate"));
                String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                expenseentryentity.set("expquotetype", (Object)quoteType);
                expenseentryentity.set("exchangerate", (Object)exchangeRate);
                BigDecimal expeAmount = expenseentryentity.getBigDecimal("expenseamount");
                int precision = entrycurrency.getInt("amtprecision");
                BigDecimal expeCurrAmount = AmountUtils.getCurrencyAmount((BigDecimal)expeAmount, (BigDecimal)exchangeRate, (int)curPrecision, (String)quoteType);
                expenseentryentity.set("currexpenseamount", (Object)expeCurrAmount);
                expenseentryentity.set("orientryamount", (Object)expeAmount.subtract(expenseentryentity.getBigDecimal("taxamount")));
                BigDecimal expeApproveAmount = expenseentryentity.getBigDecimal("expeapproveamount");
                BigDecimal expeApproveCurrAmount = AmountUtils.getCurrencyAmount((BigDecimal)expeApproveAmount, (BigDecimal)exchangeRate, (int)curPrecision, (String)quoteType);
                expenseentryentity.set("expeapprovecurramount", (Object)expeApproveCurrAmount);
                BigDecimal approveTax = expenseentryentity.getBigDecimal("approvetax");
                BigDecimal price = expeApproveAmount.subtract(approveTax);
                BigDecimal curprice = AmountUtils.getCurrencyAmount((BigDecimal)price, (BigDecimal)exchangeRate, (int)curPrecision, (String)quoteType);
                expenseentryentity.set("price", (Object)price);
                expenseentryentity.set("curprice", (Object)curprice);
            }
            BigDecimal sumApproveAmount = AmountChangeUtil.sumAmountBy((Collection)expenseentryentitys, (String)"expeapproveamount");
            BigDecimal sumApproveCurrAmount = AmountChangeUtil.sumAmountBy((Collection)expenseentryentitys, (String)"expeapprovecurramount");
            targetBill.set("approveamount", (Object)sumApproveCurrAmount);
            targetBill.set("payamount", (Object)sumApproveCurrAmount);
            targetBill.set("notpayamount", (Object)sumApproveCurrAmount);
            targetBill.set("reimburseamount", (Object)expenseentryentitys.stream().map(v -> v.getBigDecimal("currexpenseamount")).reduce(BigDecimal.ZERO, BigDecimal::add));
            targetBill.set("payedamount", (Object)BigDecimal.ZERO);
            DynamicObjectCollection accountentrys = targetBill.getDynamicObjectCollection("accountentry");
            if (null == accountentrys) continue;
            accountentrys.clear();
            EntryType accountentryType = (EntryType)this.getTgtMainType().getAllEntities().get("accountentry");
            DynamicObject accountentry = new DynamicObject((DynamicObjectType)accountentryType);
            accountentry.set("accountcurrency_id", (Object)currencyId);
            Map accountExchangeMap = CommonServiceHelper.getExchangeRateFromSysParams((Object)companyId, (Object)costcompanyId, (Long)currencyId, (Long)currencyId, (Object)targetBill.get("bizdate"));
            String accountquoteType = (String)ObjectUtils.defaultIfNull((Object)((String)accountExchangeMap.get("quoteType")), (Object)"0");
            BigDecimal accountexchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)accountExchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
            accountentry.set("accquotetype", (Object)accountquoteType);
            accountentry.set("accexchangerate", (Object)accountexchangeRate);
            accountentry.set("orireceiveamount", (Object)sumApproveAmount);
            accountentry.set("receiveamount", (Object)sumApproveCurrAmount);
            accountentry.set("oriaccnotpayamount", (Object)sumApproveAmount);
            accountentry.set("accnotpayamount", (Object)sumApproveCurrAmount);
            QFilter qFilter = new QFilter("number", "=", ((DynamicProperty)e.getFldProperties().get("server")).getValue((Object)srcRow));
            DynamicObject supplier = QueryServiceHelper.queryOne((String)"er_biz_info", (String)"provider.id,provider.name", (QFilter[])new QFilter[]{qFilter});
            if (supplier != null && 0L != supplier.getLong("provider.id")) {
                AccountInfo payerDefaultInfo = PublicReimbursePayerAcctUtils.getPayerDefaultInfo((String)"bd_supplier", (Long)supplier.getLong("provider.id"));
                accountentry.set("payername", (Object)supplier.getString("provider.name"));
                if (payerDefaultInfo != null) {
                    accountentry.set("payeraccount", (Object)payerDefaultInfo.getAccount());
                    accountentry.set("payeraccount02", (Object)PublicReimbursePayerAcctUtils.getHideMidPayerAccount((String)payerDefaultInfo.getAccount()));
                    accountentry.set("payeraccount01", (Object)PublicReimbursePayerAcctUtils.getHideTailPayerAccount((String)payerDefaultInfo.getAccount()));
                    accountentry.set("payeraccountname", (Object)payerDefaultInfo.getAccountName());
                    accountentry.set("payerbank", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)payerDefaultInfo.getBeBank(), (String)"bd_bebank"));
                }
            }
            if (supplier != null && targetEntityNumber.equals("er_publicreimbursebill")) {
                accountentry.set("payertype", (Object)"bd_supplier");
                accountentry.set("supplier", (Object)supplier.getLong("provider.id"));
                accountentry.set("supplier_id", (Object)supplier.getLong("provider.id"));
                targetBill.set("billpayerid_id", (Object)supplier.getLong("provider.id"));
            } else {
                accountentry.set("payertype", (Object)"other");
            }
            accountentrys.add((Object)accountentry);
        }
    }

    protected abstract String generateDescription(DynamicObject var1, Date var2);
}

