/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.formplugin.daily.botp.AbstractToReimburseBotpPlugin;
import org.apache.commons.lang3.StringUtils;

public class ContractToPubreimBotpPlugin
extends AbstractToReimburseBotpPlugin {
    private EntryType preEntryType;
    private List<DynamicObject> prepayBillExpenses = new ArrayList<DynamicObject>();
    private Map<String, String> projectNos = new HashMap<String, String>(5);
    private DynamicObject unitId;
    boolean frameworkcontract;
    private static final Log logger = LogFactory.getLog(ContractToPubreimBotpPlugin.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        QFilter preQf;
        String selectProperties;
        DynamicObject[] prepayBills;
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        List<Object> pkLists = selectedRows.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList());
        this.getProjectNo(pkLists);
        HashSet<Long> prepayBillIds = new HashSet<Long>();
        if (pkLists != null && pkLists.size() > 0) {
            Long[] pkArray = new Long[pkLists.size()];
            int index = 0;
            for (Object pk : pkLists) {
                pkArray[index] = (Long)pk;
                ++index;
            }
            Map sourceBillMap = BFTrackerServiceHelper.findTargetBills((String)"er_contractbill", (Long[])pkArray);
            for (Map.Entry entry : sourceBillMap.entrySet()) {
                if (!"er_prepaybill".equals(entry.getKey())) continue;
                Set ids = (Set)entry.getValue();
                prepayBillIds.addAll(ids);
            }
        }
        if (prepayBillIds != null && prepayBillIds.size() > 0 && (prepayBills = BusinessDataServiceHelper.load((String)"er_prepaybill", (String)(selectProperties = "id, billno, billstatus, applier, bizdate, description,billpayertype,billpayerid, expenseentryentity.entrycurrency, expenseentryentity.exchangerate, expenseentryentity.expenseamount, expenseentryentity.currexpenseamount,expenseentryentity.entrycostcompany,expenseentryentity.entrycostdept, expenseentryentity.happendate, expenseentryentity.expenseitem,expenseentryentity.expquotetype,expenseentryentity.expeapproveamount,expenseentryentity.expeapprovecurramount,expenseentryentity.orgiexpebalanceamount,expenseentryentity.expebalanceamount,expenseentryentity.entryprojectno,expenseentryentity.entrycontractno"), (QFilter[])new QFilter[]{preQf = this.createPreQFilter(prepayBillIds)})) != null && prepayBills.length > 0) {
            for (DynamicObject applyBill : prepayBills) {
                DynamicObjectCollection applyBillExpenses = applyBill.getDynamicObjectCollection("expenseentryentity");
                for (DynamicObject applyBillExpense : applyBillExpenses) {
                    BigDecimal balanceAmount = applyBillExpense.getBigDecimal("orgiexpebalanceamount");
                    if (balanceAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.prepayBillExpenses.add(applyBillExpense);
                }
            }
        }
    }

    private QFilter createPreQFilter(Set<Long> prepayBillIds) {
        if (this.unitId == null) {
            return new QFilter("1", "<>", (Object)1);
        }
        QFilter q = new QFilter("1", "=", (Object)1);
        q.and("billstatus", "=", (Object)"G");
        q.and("id", "in", prepayBillIds);
        q.and("billpayerid", "=", this.unitId.getPkValue());
        return q;
    }

    private void getProjectNo(List<Object> pkLists) {
        for (Object pk : pkLists) {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"er_contractbill", (String)"id,contractcode,partb,projectentryentity.projectbillno,frameworkcontract", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
            DynamicObject bill = bills[0];
            this.unitId = (DynamicObject)bill.get("partb");
            DynamicObjectCollection pros = bill.getDynamicObjectCollection("projectentryentity");
            if (pros.size() == 1) {
                this.projectNos.put(bill.getString("contractcode"), (String)((DynamicObject)pros.get(0)).get("projectbillno"));
            }
            this.frameworkcontract = bill.getBoolean("frameworkcontract");
        }
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        super.afterCreateLink(e);
        this.setExpenseProjectNos(e);
        this.setExpenseNotaxAmount(e);
        this.preEntryType = (EntryType)this.getTgtMainType().getAllEntities().get("writeoffmoney");
        ArrayList<Long> sourceIds = new ArrayList<Long>();
        HashMap<Long, DynamicObject> mapSourceIdToReimburseBills = new HashMap<Long, DynamicObject>();
        String key = this.frameworkcontract ? "expenseentryentity" : "contractentry";
        ExtendedDataEntity[] expenseRows = e.getTargetExtDataEntitySet().FindByEntityKey(key);
        if (this.frameworkcontract && (expenseRows == null || expenseRows.length == 0)) {
            expenseRows = e.getTargetExtDataEntitySet().FindByEntityKey("contractentry");
        }
        for (ExtendedDataEntity expenseRow : expenseRows) {
            Long sourceId;
            DynamicObjectCollection linkRows;
            expenseRow.setValue("sourcesign", (Object)1);
            DynamicObject bill = (DynamicObject)expenseRow.getDataEntity().getParent();
            String ispush = bill.getString("ispush");
            if ("true".equals(ispush)) {
                bill.set("detailtype", (Object)"biztype_contract");
            }
            if (this.frameworkcontract && "true".equals(ispush)) {
                linkRows = expenseRow.getDataEntity().getDynamicObjectCollection("expenseentryentity_lk");
                for (DynamicObject linkRow : linkRows) {
                    sourceId = linkRow.getLong("expenseentryentity_lk_sid");
                    if (sourceId == null || sourceId.compareTo(Long.valueOf("0")) == 0) continue;
                    sourceIds.add(sourceId);
                    mapSourceIdToReimburseBills.put(sourceId, bill);
                }
                continue;
            }
            linkRows = expenseRow.getDataEntity().getDynamicObjectCollection("contractentry_lk");
            for (DynamicObject linkRow : linkRows) {
                sourceId = linkRow.getLong("contractentry_lk_sid");
                if (sourceId == null || sourceId.compareTo(Long.valueOf("0")) == 0) continue;
                sourceIds.add(sourceId);
                mapSourceIdToReimburseBills.put(sourceId, bill);
            }
        }
        if (this.prepayBillExpenses == null || this.prepayBillExpenses.size() < 1 || expenseRows == null || expenseRows.length < 1) {
            return;
        }
        List sourceRows = null;
        sourceRows = !this.frameworkcontract ? BFTrackerServiceHelper.loadTargetRowIds((String)"er_contractbill", (String)"expenseentryentity", (Long[])sourceIds.toArray(new Long[sourceIds.size()])) : BFTrackerServiceHelper.loadTargetRowIds((String)"er_contractbill", (Long[])sourceIds.toArray(new Long[sourceIds.size()]), (OperateOption)OperateOption.create());
        Long sourceTableId = EntityMetadataCache.loadTableDefine((String)"er_prepaybill", (String)"expenseentryentity").getTableId();
        TreeMap<Long, DynamicObject> reimburseBillEntryRows = new TreeMap<Long, DynamicObject>();
        for (BFRow sourceRow : sourceRows) {
            Long entryId = sourceRow.getSId().getEntryId();
            DynamicObject reimburseBill = (DynamicObject)mapSourceIdToReimburseBills.get(entryId);
            if (reimburseBill == null) continue;
            Long sourceEntryId = sourceRow.getId().getEntryId();
            reimburseBillEntryRows.put(sourceEntryId, reimburseBill);
        }
        List sourceRowList = BFTrackerServiceHelper.loadTargetRowIds((String)"er_contractbill", (Long[])sourceIds.toArray(new Long[sourceIds.size()]), (OperateOption)OperateOption.create());
        List sourceEntryRowList = BFTrackerServiceHelper.loadTargetRowIds((String)"er_contractbill", (String)"expenseentryentity", (Long[])sourceIds.toArray(new Long[sourceIds.size()]));
        long starttime = System.currentTimeMillis();
        for (DynamicObject applyBillExpense : this.prepayBillExpenses) {
            BigDecimal balanceAmount;
            DynamicObject bill;
            Long applyBillExpenseId = (Long)applyBillExpense.getPkValue();
            DynamicObject reimburseBill = (DynamicObject)reimburseBillEntryRows.get(applyBillExpenseId);
            String entrycontractno = applyBillExpense.getString("entrycontractno");
            if (reimburseBill == null && !StringUtils.isEmpty((CharSequence)entrycontractno) && (bill = BusinessDataServiceHelper.loadSingle((String)"er_contractbill", (String)"id,contractcode,expenseentryentity.expenseitem,frameworkcontract", (QFilter[])new QFilter[]{new QFilter("contractcode", "=", (Object)entrycontractno)})) != null) {
                if (bill.getBoolean("frameworkcontract")) {
                    if (sourceRowList != null && sourceRowList.size() > 0) {
                        reimburseBill = (DynamicObject)reimburseBillEntryRows.get(((BFRow)sourceRowList.get(0)).getId().getEntryId());
                    }
                } else {
                    DynamicObjectCollection pros = bill.getDynamicObjectCollection("expenseentryentity");
                    if (pros != null && pros.size() > 0 && sourceEntryRowList != null && sourceEntryRowList.size() > 0) {
                        reimburseBill = (DynamicObject)reimburseBillEntryRows.get(((BFRow)sourceEntryRowList.get(0)).getId().getEntryId());
                    }
                }
            }
            if (reimburseBill == null || ((balanceAmount = applyBillExpense.getBigDecimal("orgiexpebalanceamount")) == null || balanceAmount.compareTo(BigDecimal.ZERO) <= 0) && this.frameworkcontract) continue;
            DynamicObjectCollection offRows = reimburseBill.getDynamicObjectCollection("writeoffmoney");
            boolean isExist = false;
            for (DynamicObject row : offRows) {
                Long sourceentryid = row.getLong("sourceentryid");
                Long applyBillExpensePk = (Long)applyBillExpense.getPkValue();
                if (sourceentryid == null || applyBillExpensePk == null || sourceentryid.compareTo(applyBillExpensePk) != 0) continue;
                isExist = true;
            }
            if (isExist) continue;
            DynamicObject offRow = this.createWriteOffLoanRow(applyBillExpense, sourceTableId);
            offRow.set("seq", (Object)(offRows.size() + 1));
            offRows.add((Object)offRow);
        }
        logger.info("----\u5bf9\u516c\u62a5\u9500\u5e26\u51fa\u5173\u8054\u5408\u540c\u9884\u4ed8\u904d\u5386\u9884\u4ed8\u5206\u5f55\u8fc7\u7a0b\u82b1\u8d39\u65f6\u95f4----" + (System.currentTimeMillis() - starttime) / 1000L);
    }

    private void setExpenseNotaxAmount(AfterCreateLinkEventArgs e) {
        ExtendedDataEntity[] expenseRows;
        for (ExtendedDataEntity row : expenseRows = e.getTargetExtDataEntitySet().FindByEntityKey("expenseentryentity")) {
            DynamicObject expense = row.getDataEntity();
            BigDecimal approveAmt = expense.getBigDecimal("expeapproveamount");
            BigDecimal rate = expense.getBigDecimal("taxrate");
            BigDecimal tax = approveAmt.multiply(rate.divide(rate.add(BigDecimal.valueOf(100L)), 8, RoundingMode.HALF_UP));
            BigDecimal noTaxAmt = approveAmt.subtract(tax);
            expense.set("orientryamount", (Object)noTaxAmt);
        }
    }

    private void setExpenseProjectNos(AfterCreateLinkEventArgs e) {
        ExtendedDataEntity[] expenseRows;
        for (ExtendedDataEntity row : expenseRows = e.getTargetExtDataEntitySet().FindByEntityKey("expenseentryentity")) {
            DynamicObject expense = row.getDataEntity();
            expense.set("entryprojectno", (Object)this.projectNos.get(expense.getString("entrycontractno")));
        }
    }

    private DynamicObject createWriteOffLoanRow(DynamicObject applyExpense, Long sTableId) {
        DynamicObject prepayBill = (DynamicObject)applyExpense.getParent();
        DynamicObject offRow = new DynamicObject((DynamicObjectType)this.preEntryType);
        String prepaybillno = prepayBill.getString("billno");
        String prepayperson = prepayBill.getDynamicObject("applier").getString("name");
        Date prepaybilldate = prepayBill.getDate("bizdate");
        String prepaydescription = prepayBill.getString("description");
        DynamicObject prepaycurrency = applyExpense.getDynamicObject("entrycurrency");
        BigDecimal prepayexchangerate = applyExpense.getBigDecimal("exchangerate");
        BigDecimal orgiexpebalanceamount = applyExpense.getBigDecimal("orgiexpebalanceamount");
        BigDecimal expebalanceamount = applyExpense.getBigDecimal("expebalanceamount");
        String expquotetype = applyExpense.getString("expquotetype");
        Object expCostCompany = applyExpense.get("entrycostcompany");
        offRow.set("loanbillnov1", (Object)prepaybillno);
        offRow.set("loanperson", (Object)prepayperson);
        offRow.set("loanapplydatev1", (Object)prepaybilldate);
        offRow.set("loandescriptionv1", (Object)prepaydescription);
        offRow.set("loancurrency", (Object)prepaycurrency);
        offRow.set("loanexchangerate", (Object)prepayexchangerate);
        offRow.set("loanamount", (Object)orgiexpebalanceamount);
        offRow.set("currloanamount", (Object)expebalanceamount);
        offRow.set("accloanamount", (Object)orgiexpebalanceamount);
        offRow.set("curraccloanamount", (Object)expebalanceamount);
        offRow.set("sourcebillid", prepayBill.getPkValue());
        offRow.set("srcofsrcentryid", applyExpense.getPkValue());
        offRow.set("sourceentrycostdept", applyExpense.get("entrycostdept"));
        offRow.set("sourceexpenseitem", applyExpense.get("expenseitem"));
        offRow.set("writeoffquotetype", (Object)expquotetype);
        offRow.set("srcbilltype", (Object)"er_prepaybill");
        offRow.set("sourceentrycostcompany", expCostCompany);
        offRow.set("sourceentryid", applyExpense.getPkValue());
        offRow.set("srcentrywltype", prepayBill.get("billpayertype"));
        offRow.set("srcentrywlunit", prepayBill.get("billpayerid"));
        offRow.set("loanprojectno", applyExpense.get("entryprojectno"));
        offRow.set("loancontractno", applyExpense.get("entrycontractno"));
        DynamicObjectCollection offLinkRows = offRow.getDynamicObjectCollection("writeoffmoney_lk");
        DynamicObject offLinkRow = new DynamicObject(offLinkRows.getDynamicObjectType());
        offLinkRow.set("seq", (Object)1);
        offLinkRow.set("writeoffmoney_lk_stableid", (Object)sTableId);
        offLinkRow.set("writeoffmoney_lk_sbillid", prepayBill.getPkValue());
        offLinkRow.set("writeoffmoney_lk_sid", applyExpense.getPkValue());
        offLinkRows.add((Object)offLinkRow);
        return offRow;
    }
}

