/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.botp;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ErRepayBillToCasRecBillBOTPPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(ErRepayBillToCasRecBillBOTPPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("company");
        e.addSrcField("org");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject src = (DynamicObject)srcRows.get(0);
            billDataEntity.setValue("sourcebillid", ((DynamicProperty)e.getFldProperties().get("id")).getValue((Object)src));
            billDataEntity.setValue("sourcebilltype", (Object)this.getSrcMainType().getName());
            long orgId = (Long)((DynamicProperty)e.getFldProperties().get("company")).getValue((Object)src);
            Long currency = ErRepayBillToCasRecBillBOTPPlugin.getStandardCurrency(orgId);
            if (null == currency) {
                String tip = ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\u7684\u672c\u4f4d\u5e01\u4e3a\u7a7a\uff01\uff01\uff01\uff01", (String)"ErRepayBillToCasRecBillBOTPPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
                logger.warn(String.format(tip, orgId));
                continue;
            }
            billDataEntity.setValue("basecurrency_id", (Object)currency);
        }
    }

    public static Long getStandardCurrency(long orgId) {
        DynamicObject systemStatusCtrol = ErRepayBillToCasRecBillBOTPPlugin.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null || 0L == systemStatusCtrol.getLong("standardcurrency.id")) {
            return null;
        }
        return systemStatusCtrol.getLong("standardcurrency.id");
    }

    public static DynamicObject getSystemStatusCtrol(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        DynamicObjectCollection cashMgitInitColl = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id", (QFilter[])filters);
        if (cashMgitInitColl.size() == 0) {
            return null;
        }
        filters = new QFilter[]{new QFilter("id", "=", (Object)((DynamicObject)cashMgitInitColl.get(0)).getLong("id"))};
        DynamicObject cashMgtInit = QueryServiceHelper.queryOne((String)"cas_cashmgtinit", (String)"standardcurrency.id", (QFilter[])filters);
        return cashMgtInit;
    }
}

